// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{Animation, AnimationTarget, SpringParams, ffi};
use glib::{
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwSpringAnimation")]
    pub struct SpringAnimation(Object<ffi::AdwSpringAnimation, ffi::AdwSpringAnimationClass>) @extends Animation;

    match fn {
        type_ => || ffi::adw_spring_animation_get_type(),
    }
}

impl SpringAnimation {
    #[doc(alias = "adw_spring_animation_new")]
    pub fn new(
        widget: &impl IsA<gtk::Widget>,
        from: f64,
        to: f64,
        spring_params: SpringParams,
        target: impl IsA<AnimationTarget>,
    ) -> SpringAnimation {
        skip_assert_initialized!();
        unsafe {
            Animation::from_glib_none(ffi::adw_spring_animation_new(
                widget.as_ref().to_glib_none().0,
                from,
                to,
                spring_params.into_glib_ptr(),
                target.upcast().into_glib_ptr(),
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`SpringAnimation`] objects.
    ///
    /// This method returns an instance of [`SpringAnimationBuilder`](crate::builders::SpringAnimationBuilder) which can be used to create [`SpringAnimation`] objects.
    pub fn builder() -> SpringAnimationBuilder {
        SpringAnimationBuilder::new()
    }

    #[cfg(feature = "v1_3")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_3")))]
    #[doc(alias = "adw_spring_animation_calculate_value")]
    pub fn calculate_value(&self, time: u32) -> f64 {
        unsafe { ffi::adw_spring_animation_calculate_value(self.to_glib_none().0, time) }
    }

    #[cfg(feature = "v1_3")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_3")))]
    #[doc(alias = "adw_spring_animation_calculate_velocity")]
    pub fn calculate_velocity(&self, time: u32) -> f64 {
        unsafe { ffi::adw_spring_animation_calculate_velocity(self.to_glib_none().0, time) }
    }

    #[doc(alias = "adw_spring_animation_get_clamp")]
    #[doc(alias = "get_clamp")]
    #[doc(alias = "clamp")]
    pub fn is_clamp(&self) -> bool {
        unsafe { from_glib(ffi::adw_spring_animation_get_clamp(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_spring_animation_get_epsilon")]
    #[doc(alias = "get_epsilon")]
    pub fn epsilon(&self) -> f64 {
        unsafe { ffi::adw_spring_animation_get_epsilon(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spring_animation_get_estimated_duration")]
    #[doc(alias = "get_estimated_duration")]
    #[doc(alias = "estimated-duration")]
    pub fn estimated_duration(&self) -> u32 {
        unsafe { ffi::adw_spring_animation_get_estimated_duration(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spring_animation_get_initial_velocity")]
    #[doc(alias = "get_initial_velocity")]
    #[doc(alias = "initial-velocity")]
    pub fn initial_velocity(&self) -> f64 {
        unsafe { ffi::adw_spring_animation_get_initial_velocity(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spring_animation_get_spring_params")]
    #[doc(alias = "get_spring_params")]
    #[doc(alias = "spring-params")]
    pub fn spring_params(&self) -> SpringParams {
        unsafe {
            from_glib_none(ffi::adw_spring_animation_get_spring_params(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_spring_animation_get_value_from")]
    #[doc(alias = "get_value_from")]
    #[doc(alias = "value-from")]
    pub fn value_from(&self) -> f64 {
        unsafe { ffi::adw_spring_animation_get_value_from(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spring_animation_get_value_to")]
    #[doc(alias = "get_value_to")]
    #[doc(alias = "value-to")]
    pub fn value_to(&self) -> f64 {
        unsafe { ffi::adw_spring_animation_get_value_to(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spring_animation_get_velocity")]
    #[doc(alias = "get_velocity")]
    pub fn velocity(&self) -> f64 {
        unsafe { ffi::adw_spring_animation_get_velocity(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spring_animation_set_clamp")]
    #[doc(alias = "clamp")]
    pub fn set_clamp(&self, clamp: bool) {
        unsafe {
            ffi::adw_spring_animation_set_clamp(self.to_glib_none().0, clamp.into_glib());
        }
    }

    #[doc(alias = "adw_spring_animation_set_epsilon")]
    #[doc(alias = "epsilon")]
    pub fn set_epsilon(&self, epsilon: f64) {
        unsafe {
            ffi::adw_spring_animation_set_epsilon(self.to_glib_none().0, epsilon);
        }
    }

    #[doc(alias = "adw_spring_animation_set_initial_velocity")]
    #[doc(alias = "initial-velocity")]
    pub fn set_initial_velocity(&self, velocity: f64) {
        unsafe {
            ffi::adw_spring_animation_set_initial_velocity(self.to_glib_none().0, velocity);
        }
    }

    #[doc(alias = "adw_spring_animation_set_spring_params")]
    #[doc(alias = "spring-params")]
    pub fn set_spring_params(&self, spring_params: &SpringParams) {
        unsafe {
            ffi::adw_spring_animation_set_spring_params(
                self.to_glib_none().0,
                spring_params.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_spring_animation_set_value_from")]
    #[doc(alias = "value-from")]
    pub fn set_value_from(&self, value: f64) {
        unsafe {
            ffi::adw_spring_animation_set_value_from(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "adw_spring_animation_set_value_to")]
    #[doc(alias = "value-to")]
    pub fn set_value_to(&self, value: f64) {
        unsafe {
            ffi::adw_spring_animation_set_value_to(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "clamp")]
    pub fn connect_clamp_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_clamp_trampoline<F: Fn(&SpringAnimation) + 'static>(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::clamp".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_clamp_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "epsilon")]
    pub fn connect_epsilon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_epsilon_trampoline<F: Fn(&SpringAnimation) + 'static>(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::epsilon".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_epsilon_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "estimated-duration")]
    pub fn connect_estimated_duration_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_estimated_duration_trampoline<
            F: Fn(&SpringAnimation) + 'static,
        >(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::estimated-duration".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_estimated_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "initial-velocity")]
    pub fn connect_initial_velocity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_initial_velocity_trampoline<
            F: Fn(&SpringAnimation) + 'static,
        >(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::initial-velocity".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_initial_velocity_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "spring-params")]
    pub fn connect_spring_params_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_spring_params_trampoline<F: Fn(&SpringAnimation) + 'static>(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::spring-params".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_spring_params_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "value-from")]
    pub fn connect_value_from_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_value_from_trampoline<F: Fn(&SpringAnimation) + 'static>(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::value-from".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_value_from_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "value-to")]
    pub fn connect_value_to_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_value_to_trampoline<F: Fn(&SpringAnimation) + 'static>(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::value-to".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_value_to_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "velocity")]
    pub fn connect_velocity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_velocity_trampoline<F: Fn(&SpringAnimation) + 'static>(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::velocity".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_velocity_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for SpringAnimation {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`SpringAnimation`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SpringAnimationBuilder {
    builder: glib::object::ObjectBuilder<'static, SpringAnimation>,
}

impl SpringAnimationBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn clamp(self, clamp: bool) -> Self {
        Self {
            builder: self.builder.property("clamp", clamp),
        }
    }

    pub fn epsilon(self, epsilon: f64) -> Self {
        Self {
            builder: self.builder.property("epsilon", epsilon),
        }
    }

    pub fn initial_velocity(self, initial_velocity: f64) -> Self {
        Self {
            builder: self.builder.property("initial-velocity", initial_velocity),
        }
    }

    pub fn spring_params(self, spring_params: &SpringParams) -> Self {
        Self {
            builder: self
                .builder
                .property("spring-params", spring_params.clone()),
        }
    }

    pub fn value_from(self, value_from: f64) -> Self {
        Self {
            builder: self.builder.property("value-from", value_from),
        }
    }

    pub fn value_to(self, value_to: f64) -> Self {
        Self {
            builder: self.builder.property("value-to", value_to),
        }
    }

    #[cfg(feature = "v1_3")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_3")))]
    pub fn follow_enable_animations_setting(self, follow_enable_animations_setting: bool) -> Self {
        Self {
            builder: self.builder.property(
                "follow-enable-animations-setting",
                follow_enable_animations_setting,
            ),
        }
    }

    pub fn target(self, target: &impl IsA<AnimationTarget>) -> Self {
        Self {
            builder: self.builder.property("target", target.clone().upcast()),
        }
    }

    pub fn widget(self, widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self.builder.property("widget", widget.clone().upcast()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`SpringAnimation`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> SpringAnimation {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
