// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ActionRow, PreferencesRow, ffi};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwSpinRow")]
    pub struct SpinRow(Object<ffi::AdwSpinRow, ffi::AdwSpinRowClass>) @extends ActionRow, PreferencesRow, gtk::ListBoxRow, gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget, gtk::Actionable, gtk::Editable;

    match fn {
        type_ => || ffi::adw_spin_row_get_type(),
    }
}

impl SpinRow {
    #[doc(alias = "adw_spin_row_new")]
    pub fn new(
        adjustment: Option<&impl IsA<gtk::Adjustment>>,
        climb_rate: f64,
        digits: u32,
    ) -> SpinRow {
        assert_initialized_main_thread!();
        unsafe {
            gtk::Widget::from_glib_none(ffi::adw_spin_row_new(
                adjustment.map(|p| p.as_ref()).to_glib_none().0,
                climb_rate,
                digits,
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "adw_spin_row_new_with_range")]
    #[doc(alias = "new_with_range")]
    pub fn with_range(min: f64, max: f64, step: f64) -> SpinRow {
        assert_initialized_main_thread!();
        unsafe {
            gtk::Widget::from_glib_none(ffi::adw_spin_row_new_with_range(min, max, step))
                .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`SpinRow`] objects.
    ///
    /// This method returns an instance of [`SpinRowBuilder`](crate::builders::SpinRowBuilder) which can be used to create [`SpinRow`] objects.
    pub fn builder() -> SpinRowBuilder {
        SpinRowBuilder::new()
    }

    #[doc(alias = "adw_spin_row_configure")]
    pub fn configure(
        &self,
        adjustment: Option<&impl IsA<gtk::Adjustment>>,
        climb_rate: f64,
        digits: u32,
    ) {
        unsafe {
            ffi::adw_spin_row_configure(
                self.to_glib_none().0,
                adjustment.map(|p| p.as_ref()).to_glib_none().0,
                climb_rate,
                digits,
            );
        }
    }

    #[doc(alias = "adw_spin_row_get_adjustment")]
    #[doc(alias = "get_adjustment")]
    pub fn adjustment(&self) -> gtk::Adjustment {
        unsafe { from_glib_none(ffi::adw_spin_row_get_adjustment(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_spin_row_get_climb_rate")]
    #[doc(alias = "get_climb_rate")]
    #[doc(alias = "climb-rate")]
    pub fn climb_rate(&self) -> f64 {
        unsafe { ffi::adw_spin_row_get_climb_rate(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spin_row_get_digits")]
    #[doc(alias = "get_digits")]
    pub fn digits(&self) -> u32 {
        unsafe { ffi::adw_spin_row_get_digits(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spin_row_get_numeric")]
    #[doc(alias = "get_numeric")]
    #[doc(alias = "numeric")]
    pub fn is_numeric(&self) -> bool {
        unsafe { from_glib(ffi::adw_spin_row_get_numeric(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_spin_row_get_snap_to_ticks")]
    #[doc(alias = "get_snap_to_ticks")]
    #[doc(alias = "snap-to-ticks")]
    pub fn snaps_to_ticks(&self) -> bool {
        unsafe { from_glib(ffi::adw_spin_row_get_snap_to_ticks(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_spin_row_get_update_policy")]
    #[doc(alias = "get_update_policy")]
    #[doc(alias = "update-policy")]
    pub fn update_policy(&self) -> gtk::SpinButtonUpdatePolicy {
        unsafe { from_glib(ffi::adw_spin_row_get_update_policy(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_spin_row_get_value")]
    #[doc(alias = "get_value")]
    pub fn value(&self) -> f64 {
        unsafe { ffi::adw_spin_row_get_value(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spin_row_get_wrap")]
    #[doc(alias = "get_wrap")]
    #[doc(alias = "wrap")]
    pub fn wraps(&self) -> bool {
        unsafe { from_glib(ffi::adw_spin_row_get_wrap(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_spin_row_set_adjustment")]
    #[doc(alias = "adjustment")]
    pub fn set_adjustment(&self, adjustment: Option<&impl IsA<gtk::Adjustment>>) {
        unsafe {
            ffi::adw_spin_row_set_adjustment(
                self.to_glib_none().0,
                adjustment.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_spin_row_set_climb_rate")]
    #[doc(alias = "climb-rate")]
    pub fn set_climb_rate(&self, climb_rate: f64) {
        unsafe {
            ffi::adw_spin_row_set_climb_rate(self.to_glib_none().0, climb_rate);
        }
    }

    #[doc(alias = "adw_spin_row_set_digits")]
    #[doc(alias = "digits")]
    pub fn set_digits(&self, digits: u32) {
        unsafe {
            ffi::adw_spin_row_set_digits(self.to_glib_none().0, digits);
        }
    }

    #[doc(alias = "adw_spin_row_set_numeric")]
    #[doc(alias = "numeric")]
    pub fn set_numeric(&self, numeric: bool) {
        unsafe {
            ffi::adw_spin_row_set_numeric(self.to_glib_none().0, numeric.into_glib());
        }
    }

    #[doc(alias = "adw_spin_row_set_range")]
    pub fn set_range(&self, min: f64, max: f64) {
        unsafe {
            ffi::adw_spin_row_set_range(self.to_glib_none().0, min, max);
        }
    }

    #[doc(alias = "adw_spin_row_set_snap_to_ticks")]
    #[doc(alias = "snap-to-ticks")]
    pub fn set_snap_to_ticks(&self, snap_to_ticks: bool) {
        unsafe {
            ffi::adw_spin_row_set_snap_to_ticks(self.to_glib_none().0, snap_to_ticks.into_glib());
        }
    }

    #[doc(alias = "adw_spin_row_set_update_policy")]
    #[doc(alias = "update-policy")]
    pub fn set_update_policy(&self, policy: gtk::SpinButtonUpdatePolicy) {
        unsafe {
            ffi::adw_spin_row_set_update_policy(self.to_glib_none().0, policy.into_glib());
        }
    }

    #[doc(alias = "adw_spin_row_set_value")]
    #[doc(alias = "value")]
    pub fn set_value(&self, value: f64) {
        unsafe {
            ffi::adw_spin_row_set_value(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "adw_spin_row_set_wrap")]
    #[doc(alias = "wrap")]
    pub fn set_wrap(&self, wrap: bool) {
        unsafe {
            ffi::adw_spin_row_set_wrap(self.to_glib_none().0, wrap.into_glib());
        }
    }

    #[doc(alias = "adw_spin_row_update")]
    pub fn update(&self) {
        unsafe {
            ffi::adw_spin_row_update(self.to_glib_none().0);
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "output")]
    pub fn connect_output<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn output_trampoline<F: Fn(&SpinRow) -> bool + 'static>(
            this: *mut ffi::AdwSpinRow,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this)).into_glib()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"output".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    output_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "wrapped")]
    pub fn connect_wrapped<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrapped_trampoline<F: Fn(&SpinRow) + 'static>(
            this: *mut ffi::AdwSpinRow,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"wrapped".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    wrapped_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "adjustment")]
    pub fn connect_adjustment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_adjustment_trampoline<F: Fn(&SpinRow) + 'static>(
            this: *mut ffi::AdwSpinRow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::adjustment".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_adjustment_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "climb-rate")]
    pub fn connect_climb_rate_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_climb_rate_trampoline<F: Fn(&SpinRow) + 'static>(
            this: *mut ffi::AdwSpinRow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::climb-rate".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_climb_rate_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "digits")]
    pub fn connect_digits_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_digits_trampoline<F: Fn(&SpinRow) + 'static>(
            this: *mut ffi::AdwSpinRow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::digits".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_digits_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "numeric")]
    pub fn connect_numeric_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_numeric_trampoline<F: Fn(&SpinRow) + 'static>(
            this: *mut ffi::AdwSpinRow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::numeric".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_numeric_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "snap-to-ticks")]
    pub fn connect_snap_to_ticks_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_snap_to_ticks_trampoline<F: Fn(&SpinRow) + 'static>(
            this: *mut ffi::AdwSpinRow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::snap-to-ticks".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_snap_to_ticks_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "update-policy")]
    pub fn connect_update_policy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_update_policy_trampoline<F: Fn(&SpinRow) + 'static>(
            this: *mut ffi::AdwSpinRow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::update-policy".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_update_policy_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "value")]
    pub fn connect_value_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_value_trampoline<F: Fn(&SpinRow) + 'static>(
            this: *mut ffi::AdwSpinRow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::value".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_value_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "wrap")]
    pub fn connect_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_trampoline<F: Fn(&SpinRow) + 'static>(
            this: *mut ffi::AdwSpinRow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::wrap".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_wrap_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v1_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
impl Default for SpinRow {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`SpinRow`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SpinRowBuilder {
    builder: glib::object::ObjectBuilder<'static, SpinRow>,
}

impl SpinRowBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn adjustment(self, adjustment: &impl IsA<gtk::Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("adjustment", adjustment.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn climb_rate(self, climb_rate: f64) -> Self {
        Self {
            builder: self.builder.property("climb-rate", climb_rate),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn digits(self, digits: u32) -> Self {
        Self {
            builder: self.builder.property("digits", digits),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn numeric(self, numeric: bool) -> Self {
        Self {
            builder: self.builder.property("numeric", numeric),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn snap_to_ticks(self, snap_to_ticks: bool) -> Self {
        Self {
            builder: self.builder.property("snap-to-ticks", snap_to_ticks),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn update_policy(self, update_policy: gtk::SpinButtonUpdatePolicy) -> Self {
        Self {
            builder: self.builder.property("update-policy", update_policy),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn value(self, value: f64) -> Self {
        Self {
            builder: self.builder.property("value", value),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn wrap(self, wrap: bool) -> Self {
        Self {
            builder: self.builder.property("wrap", wrap),
        }
    }

    pub fn activatable_widget(self, activatable_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("activatable-widget", activatable_widget.clone().upcast()),
        }
    }

    #[cfg_attr(feature = "v1_3", deprecated = "Since 1.3")]
    pub fn icon_name(self, icon_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("icon-name", icon_name.into()),
        }
    }

    pub fn subtitle(self, subtitle: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("subtitle", subtitle.into()),
        }
    }

    pub fn subtitle_lines(self, subtitle_lines: i32) -> Self {
        Self {
            builder: self.builder.property("subtitle-lines", subtitle_lines),
        }
    }

    #[cfg(feature = "v1_3")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_3")))]
    pub fn subtitle_selectable(self, subtitle_selectable: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("subtitle-selectable", subtitle_selectable),
        }
    }

    pub fn title_lines(self, title_lines: i32) -> Self {
        Self {
            builder: self.builder.property("title-lines", title_lines),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    pub fn title_selectable(self, title_selectable: bool) -> Self {
        Self {
            builder: self.builder.property("title-selectable", title_selectable),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn use_markup(self, use_markup: bool) -> Self {
        Self {
            builder: self.builder.property("use-markup", use_markup),
        }
    }

    pub fn use_underline(self, use_underline: bool) -> Self {
        Self {
            builder: self.builder.property("use-underline", use_underline),
        }
    }

    pub fn activatable(self, activatable: bool) -> Self {
        Self {
            builder: self.builder.property("activatable", activatable),
        }
    }

    pub fn child(self, child: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn selectable(self, selectable: bool) -> Self {
        Self {
            builder: self.builder.property("selectable", selectable),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    #[cfg(feature = "gtk_v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "gtk_v4_18")))]
    pub fn limit_events(self, limit_events: bool) -> Self {
        Self {
            builder: self.builder.property("limit-events", limit_events),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    pub fn action_name(self, action_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("action-name", action_name.into()),
        }
    }

    pub fn action_target(self, action_target: &glib::Variant) -> Self {
        Self {
            builder: self
                .builder
                .property("action-target", action_target.clone()),
        }
    }

    pub fn editable(self, editable: bool) -> Self {
        Self {
            builder: self.builder.property("editable", editable),
        }
    }

    pub fn enable_undo(self, enable_undo: bool) -> Self {
        Self {
            builder: self.builder.property("enable-undo", enable_undo),
        }
    }

    pub fn max_width_chars(self, max_width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("max-width-chars", max_width_chars),
        }
    }

    pub fn text(self, text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("text", text.into()),
        }
    }

    pub fn width_chars(self, width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("width-chars", width_chars),
        }
    }

    pub fn xalign(self, xalign: f32) -> Self {
        Self {
            builder: self.builder.property("xalign", xalign),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`SpinRow`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> SpinRow {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
