// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

use crate::{EventController, PropagationLimit, PropagationPhase, ffi};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkDropTarget")]
    pub struct DropTarget(Object<ffi::GtkDropTarget, ffi::GtkDropTargetClass>) @extends EventController;

    match fn {
        type_ => || ffi::gtk_drop_target_get_type(),
    }
}

impl DropTarget {
    #[doc(alias = "gtk_drop_target_new")]
    pub fn new(type_: glib::types::Type, actions: gdk::DragAction) -> DropTarget {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gtk_drop_target_new(
                type_.into_glib(),
                actions.into_glib(),
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`DropTarget`] objects.
    ///
    /// This method returns an instance of [`DropTargetBuilder`](crate::builders::DropTargetBuilder) which can be used to create [`DropTarget`] objects.
    pub fn builder() -> DropTargetBuilder {
        DropTargetBuilder::new()
    }

    #[doc(alias = "gtk_drop_target_get_actions")]
    #[doc(alias = "get_actions")]
    pub fn actions(&self) -> gdk::DragAction {
        unsafe { from_glib(ffi::gtk_drop_target_get_actions(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v4_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_4")))]
    #[doc(alias = "gtk_drop_target_get_current_drop")]
    #[doc(alias = "get_current_drop")]
    #[doc(alias = "current-drop")]
    pub fn current_drop(&self) -> Option<gdk::Drop> {
        unsafe { from_glib_none(ffi::gtk_drop_target_get_current_drop(self.to_glib_none().0)) }
    }

    #[cfg_attr(feature = "v4_4", deprecated = "Since 4.4")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_drop_target_get_drop")]
    #[doc(alias = "get_drop")]
    pub fn drop(&self) -> Option<gdk::Drop> {
        unsafe { from_glib_none(ffi::gtk_drop_target_get_drop(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_drop_target_get_formats")]
    #[doc(alias = "get_formats")]
    pub fn formats(&self) -> Option<gdk::ContentFormats> {
        unsafe { from_glib_none(ffi::gtk_drop_target_get_formats(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_drop_target_get_preload")]
    #[doc(alias = "get_preload")]
    #[doc(alias = "preload")]
    pub fn is_preload(&self) -> bool {
        unsafe { from_glib(ffi::gtk_drop_target_get_preload(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_drop_target_get_value")]
    #[doc(alias = "get_value")]
    pub fn value(&self) -> Option<glib::Value> {
        unsafe { from_glib_none(ffi::gtk_drop_target_get_value(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_drop_target_reject")]
    pub fn reject(&self) {
        unsafe {
            ffi::gtk_drop_target_reject(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_drop_target_set_actions")]
    #[doc(alias = "actions")]
    pub fn set_actions(&self, actions: gdk::DragAction) {
        unsafe {
            ffi::gtk_drop_target_set_actions(self.to_glib_none().0, actions.into_glib());
        }
    }

    #[doc(alias = "gtk_drop_target_set_preload")]
    #[doc(alias = "preload")]
    pub fn set_preload(&self, preload: bool) {
        unsafe {
            ffi::gtk_drop_target_set_preload(self.to_glib_none().0, preload.into_glib());
        }
    }

    #[doc(alias = "accept")]
    pub fn connect_accept<F: Fn(&Self, &gdk::Drop) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn accept_trampoline<F: Fn(&DropTarget, &gdk::Drop) -> bool + 'static>(
            this: *mut ffi::GtkDropTarget,
            drop: *mut gdk::ffi::GdkDrop,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), &from_glib_borrow(drop)).into_glib()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"accept".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    accept_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enter")]
    pub fn connect_enter<F: Fn(&Self, f64, f64) -> gdk::DragAction + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn enter_trampoline<
            F: Fn(&DropTarget, f64, f64) -> gdk::DragAction + 'static,
        >(
            this: *mut ffi::GtkDropTarget,
            x: std::ffi::c_double,
            y: std::ffi::c_double,
            f: glib::ffi::gpointer,
        ) -> gdk::ffi::GdkDragAction {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), x, y).into_glib()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"enter".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    enter_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "leave")]
    pub fn connect_leave<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn leave_trampoline<F: Fn(&DropTarget) + 'static>(
            this: *mut ffi::GtkDropTarget,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"leave".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    leave_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "motion")]
    pub fn connect_motion<F: Fn(&Self, f64, f64) -> gdk::DragAction + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn motion_trampoline<
            F: Fn(&DropTarget, f64, f64) -> gdk::DragAction + 'static,
        >(
            this: *mut ffi::GtkDropTarget,
            x: std::ffi::c_double,
            y: std::ffi::c_double,
            f: glib::ffi::gpointer,
        ) -> gdk::ffi::GdkDragAction {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), x, y).into_glib()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"motion".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    motion_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "actions")]
    pub fn connect_actions_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_actions_trampoline<F: Fn(&DropTarget) + 'static>(
            this: *mut ffi::GtkDropTarget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::actions".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_actions_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_4")))]
    #[doc(alias = "current-drop")]
    pub fn connect_current_drop_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_current_drop_trampoline<F: Fn(&DropTarget) + 'static>(
            this: *mut ffi::GtkDropTarget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::current-drop".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_current_drop_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg_attr(feature = "v4_4", deprecated = "Since 4.4")]
    #[doc(alias = "drop")]
    pub fn connect_drop_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_drop_trampoline<F: Fn(&DropTarget) + 'static>(
            this: *mut ffi::GtkDropTarget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::drop".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_drop_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "preload")]
    pub fn connect_preload_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_preload_trampoline<F: Fn(&DropTarget) + 'static>(
            this: *mut ffi::GtkDropTarget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::preload".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_preload_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "value")]
    pub fn connect_value_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_value_trampoline<F: Fn(&DropTarget) + 'static>(
            this: *mut ffi::GtkDropTarget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::value".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_value_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for DropTarget {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`DropTarget`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct DropTargetBuilder {
    builder: glib::object::ObjectBuilder<'static, DropTarget>,
}

impl DropTargetBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn actions(self, actions: gdk::DragAction) -> Self {
        Self {
            builder: self.builder.property("actions", actions),
        }
    }

    pub fn formats(self, formats: &gdk::ContentFormats) -> Self {
        Self {
            builder: self.builder.property("formats", formats.clone()),
        }
    }

    pub fn preload(self, preload: bool) -> Self {
        Self {
            builder: self.builder.property("preload", preload),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn propagation_limit(self, propagation_limit: PropagationLimit) -> Self {
        Self {
            builder: self
                .builder
                .property("propagation-limit", propagation_limit),
        }
    }

    pub fn propagation_phase(self, propagation_phase: PropagationPhase) -> Self {
        Self {
            builder: self
                .builder
                .property("propagation-phase", propagation_phase),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`DropTarget`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> DropTarget {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
