/*
 * Copyright (C) 2026 Pascal Nowack
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "config.h"

#include "grd-vk-physical-device.h"

struct _GrdVkPhysicalDevice
{
  GObject parent;

  VkPhysicalDevice vk_physical_device;
  const char *drm_render_node;

  /* Physical device features */
  GrdVkDeviceFeatures device_features;
};

G_DEFINE_TYPE (GrdVkPhysicalDevice, grd_vk_physical_device, G_TYPE_OBJECT)

VkPhysicalDevice
grd_vk_physical_device_get_physical_device (GrdVkPhysicalDevice *physical_device)
{
  return physical_device->vk_physical_device;
}

const char *
grd_vk_physical_device_get_drm_render_node (GrdVkPhysicalDevice *physical_device)
{
  return physical_device->drm_render_node;
}

GrdVkDeviceFeatures
grd_vk_physical_device_get_device_features (GrdVkPhysicalDevice *physical_device)
{
  return physical_device->device_features;
}

GrdVkPhysicalDevice *
grd_vk_physical_device_new (VkPhysicalDevice     vk_physical_device,
                            const char          *drm_render_node,
                            GrdVkDeviceFeatures  device_features)
{
  GrdVkPhysicalDevice *physical_device;

  physical_device = g_object_new (GRD_TYPE_VK_PHYSICAL_DEVICE, NULL);
  physical_device->vk_physical_device = vk_physical_device;
  physical_device->drm_render_node = drm_render_node;
  physical_device->device_features = device_features;

  return physical_device;
}

static void
grd_vk_physical_device_init (GrdVkPhysicalDevice *device)
{
}

static void
grd_vk_physical_device_class_init (GrdVkPhysicalDeviceClass *klass)
{
}
