/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.util.ui.PresentableEnum;
import com.jetbrains.python.PySyntaxCoreBundle;
import org.jetbrains.annotations.NotNull;

public class PyCodeStyleSettings
extends CustomCodeStyleSettings {
    public static final int DICT_ALIGNMENT_NONE = DictAlignment.NONE.asInt();
    public static final int DICT_ALIGNMENT_ON_VALUE = DictAlignment.ON_VALUE.asInt();
    public static final int DICT_ALIGNMENT_ON_COLON = DictAlignment.ON_COLON.asInt();
    public boolean SPACE_WITHIN_BRACES;
    public boolean SPACE_BEFORE_PY_COLON;
    public boolean SPACE_AFTER_PY_COLON;
    public boolean SPACE_BEFORE_LBRACKET;
    public boolean SPACE_AROUND_EQ_IN_NAMED_PARAMETER;
    public boolean SPACE_AROUND_EQ_IN_KEYWORD_ARGUMENT;
    public boolean SPACE_AROUND_POWER_OPERATOR;
    public boolean SPACE_BEFORE_BACKSLASH;
    public int BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS;
    public int BLANK_LINES_BEFORE_FIRST_METHOD;
    public boolean BLANK_LINE_AT_FILE_END;
    public boolean ALIGN_COLLECTIONS_AND_COMPREHENSIONS;
    public boolean ALIGN_MULTILINE_IMPORTS;
    public boolean NEW_LINE_AFTER_COLON;
    public boolean NEW_LINE_AFTER_COLON_MULTI_CLAUSE;
    public boolean SPACE_AFTER_NUMBER_SIGN;
    public boolean SPACE_BEFORE_NUMBER_SIGN;
    public int DICT_ALIGNMENT;
    @CommonCodeStyleSettings.WrapConstant
    public int DICT_WRAPPING;
    public boolean DICT_NEW_LINE_AFTER_LEFT_BRACE;
    public boolean DICT_NEW_LINE_BEFORE_RIGHT_BRACE;
    @CommonCodeStyleSettings.WrapConstant
    public int LIST_WRAPPING;
    public boolean LIST_NEW_LINE_AFTER_LEFT_BRACKET;
    public boolean LIST_NEW_LINE_BEFORE_RIGHT_BRACKET;
    @CommonCodeStyleSettings.WrapConstant
    public int SET_WRAPPING;
    public boolean SET_NEW_LINE_AFTER_LEFT_BRACE;
    public boolean SET_NEW_LINE_BEFORE_RIGHT_BRACE;
    @CommonCodeStyleSettings.WrapConstant
    public int TUPLE_WRAPPING;
    public boolean TUPLE_NEW_LINE_AFTER_LEFT_PARENTHESIS;
    public boolean TUPLE_NEW_LINE_BEFORE_RIGHT_PARENTHESIS;
    public int BLANK_LINES_AFTER_LOCAL_IMPORTS;
    public boolean USE_CONTINUATION_INDENT_FOR_PARAMETERS;
    public boolean USE_CONTINUATION_INDENT_FOR_ARGUMENTS;
    public boolean USE_CONTINUATION_INDENT_FOR_COLLECTION_AND_COMPREHENSIONS;
    public boolean OPTIMIZE_IMPORTS_SORT_IMPORTS;
    public boolean OPTIMIZE_IMPORTS_SORT_NAMES_IN_FROM_IMPORTS;
    public boolean OPTIMIZE_IMPORTS_SORT_BY_TYPE_FIRST;
    public boolean OPTIMIZE_IMPORTS_JOIN_FROM_IMPORTS_WITH_SAME_SOURCE;
    public boolean OPTIMIZE_IMPORTS_ALWAYS_SPLIT_FROM_IMPORTS;
    public boolean OPTIMIZE_IMPORTS_CASE_INSENSITIVE_ORDER;
    @CommonCodeStyleSettings.WrapConstant
    public int FROM_IMPORT_WRAPPING;
    public boolean FROM_IMPORT_NEW_LINE_AFTER_LEFT_PARENTHESIS;
    public boolean FROM_IMPORT_NEW_LINE_BEFORE_RIGHT_PARENTHESIS;
    public boolean FROM_IMPORT_PARENTHESES_FORCE_IF_MULTILINE;
    public boolean FROM_IMPORT_TRAILING_COMMA_IF_MULTILINE;
    public boolean HANG_CLOSING_BRACKETS;
    public boolean FORMAT_INJECTED_FRAGMENTS;
    public boolean ADD_INDENT_INSIDE_INJECTIONS;
    public boolean USE_TRAILING_COMMA_IN_COLLECTIONS;
    public boolean USE_TRAILING_COMMA_IN_PARAMETER_LIST;
    public boolean USE_TRAILING_COMMA_IN_ARGUMENTS_LIST;

    public PyCodeStyleSettings(@NotNull CodeStyleSettings container) {
        if (container == null) {
            PyCodeStyleSettings.$$$reportNull$$$0(0);
        }
        super("Python", container);
        this.SPACE_WITHIN_BRACES = false;
        this.SPACE_BEFORE_PY_COLON = false;
        this.SPACE_AFTER_PY_COLON = true;
        this.SPACE_BEFORE_LBRACKET = false;
        this.SPACE_AROUND_EQ_IN_NAMED_PARAMETER = false;
        this.SPACE_AROUND_EQ_IN_KEYWORD_ARGUMENT = false;
        this.SPACE_AROUND_POWER_OPERATOR = true;
        this.SPACE_BEFORE_BACKSLASH = true;
        this.BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS = 2;
        this.BLANK_LINES_BEFORE_FIRST_METHOD = 0;
        this.BLANK_LINE_AT_FILE_END = true;
        this.ALIGN_COLLECTIONS_AND_COMPREHENSIONS = true;
        this.ALIGN_MULTILINE_IMPORTS = true;
        this.NEW_LINE_AFTER_COLON = false;
        this.NEW_LINE_AFTER_COLON_MULTI_CLAUSE = true;
        this.SPACE_AFTER_NUMBER_SIGN = true;
        this.SPACE_BEFORE_NUMBER_SIGN = true;
        this.DICT_ALIGNMENT = DICT_ALIGNMENT_NONE;
        this.DICT_WRAPPING = 1;
        this.DICT_NEW_LINE_AFTER_LEFT_BRACE = false;
        this.DICT_NEW_LINE_BEFORE_RIGHT_BRACE = false;
        this.LIST_WRAPPING = 1;
        this.LIST_NEW_LINE_AFTER_LEFT_BRACKET = false;
        this.LIST_NEW_LINE_BEFORE_RIGHT_BRACKET = false;
        this.SET_WRAPPING = 1;
        this.SET_NEW_LINE_AFTER_LEFT_BRACE = false;
        this.SET_NEW_LINE_BEFORE_RIGHT_BRACE = false;
        this.TUPLE_WRAPPING = 1;
        this.TUPLE_NEW_LINE_AFTER_LEFT_PARENTHESIS = false;
        this.TUPLE_NEW_LINE_BEFORE_RIGHT_PARENTHESIS = false;
        this.BLANK_LINES_AFTER_LOCAL_IMPORTS = 0;
        this.USE_CONTINUATION_INDENT_FOR_PARAMETERS = true;
        this.USE_CONTINUATION_INDENT_FOR_ARGUMENTS = false;
        this.USE_CONTINUATION_INDENT_FOR_COLLECTION_AND_COMPREHENSIONS = false;
        this.OPTIMIZE_IMPORTS_SORT_IMPORTS = true;
        this.OPTIMIZE_IMPORTS_SORT_NAMES_IN_FROM_IMPORTS = false;
        this.OPTIMIZE_IMPORTS_SORT_BY_TYPE_FIRST = true;
        this.OPTIMIZE_IMPORTS_JOIN_FROM_IMPORTS_WITH_SAME_SOURCE = false;
        this.OPTIMIZE_IMPORTS_ALWAYS_SPLIT_FROM_IMPORTS = false;
        this.OPTIMIZE_IMPORTS_CASE_INSENSITIVE_ORDER = false;
        this.FROM_IMPORT_WRAPPING = 1;
        this.FROM_IMPORT_NEW_LINE_AFTER_LEFT_PARENTHESIS = false;
        this.FROM_IMPORT_NEW_LINE_BEFORE_RIGHT_PARENTHESIS = false;
        this.FROM_IMPORT_PARENTHESES_FORCE_IF_MULTILINE = false;
        this.FROM_IMPORT_TRAILING_COMMA_IF_MULTILINE = false;
        this.HANG_CLOSING_BRACKETS = false;
        this.FORMAT_INJECTED_FRAGMENTS = true;
        this.ADD_INDENT_INSIDE_INJECTIONS = false;
        this.USE_TRAILING_COMMA_IN_COLLECTIONS = false;
        this.USE_TRAILING_COMMA_IN_PARAMETER_LIST = false;
        this.USE_TRAILING_COMMA_IN_ARGUMENTS_LIST = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/python/formatter/PyCodeStyleSettings", "<init>"));
    }

    public static enum DictAlignment implements PresentableEnum
    {
        NONE("formatter.panel.dict.alignment.do.not.align"),
        ON_VALUE("formatter.panel.dict.alignment.align.on.value"),
        ON_COLON("formatter.panel.dict.alignment.align.on.colon");

        private final String key;

        private DictAlignment(String key) {
            this.key = key;
        }

        public int asInt() {
            return this.ordinal();
        }

        public String getPresentableText() {
            return PySyntaxCoreBundle.message(this.key, new Object[0]);
        }

        public String toString() {
            return this.getPresentableText();
        }
    }
}

