/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSURLPatternInit.h"

#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<URLPatternInit>> convertDictionary<URLPatternInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    URLPatternInit result;
    JSValue baseURLValue;
    if (isNullOrUndefined)
        baseURLValue = jsUndefined();
    else {
        baseURLValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "baseURL"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!baseURLValue.isUndefined()) {
        auto baseURLConversionResult = convert<IDLUSVString>(lexicalGlobalObject, baseURLValue);
        if (baseURLConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.baseURL = baseURLConversionResult.releaseReturnValue();
    }
    JSValue hashValue;
    if (isNullOrUndefined)
        hashValue = jsUndefined();
    else {
        hashValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hash"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!hashValue.isUndefined()) {
        auto hashConversionResult = convert<IDLUSVString>(lexicalGlobalObject, hashValue);
        if (hashConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.hash = hashConversionResult.releaseReturnValue();
    }
    JSValue hostnameValue;
    if (isNullOrUndefined)
        hostnameValue = jsUndefined();
    else {
        hostnameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hostname"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!hostnameValue.isUndefined()) {
        auto hostnameConversionResult = convert<IDLUSVString>(lexicalGlobalObject, hostnameValue);
        if (hostnameConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.hostname = hostnameConversionResult.releaseReturnValue();
    }
    JSValue passwordValue;
    if (isNullOrUndefined)
        passwordValue = jsUndefined();
    else {
        passwordValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "password"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!passwordValue.isUndefined()) {
        auto passwordConversionResult = convert<IDLUSVString>(lexicalGlobalObject, passwordValue);
        if (passwordConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.password = passwordConversionResult.releaseReturnValue();
    }
    JSValue pathnameValue;
    if (isNullOrUndefined)
        pathnameValue = jsUndefined();
    else {
        pathnameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pathname"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!pathnameValue.isUndefined()) {
        auto pathnameConversionResult = convert<IDLUSVString>(lexicalGlobalObject, pathnameValue);
        if (pathnameConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.pathname = pathnameConversionResult.releaseReturnValue();
    }
    JSValue portValue;
    if (isNullOrUndefined)
        portValue = jsUndefined();
    else {
        portValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "port"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!portValue.isUndefined()) {
        auto portConversionResult = convert<IDLUSVString>(lexicalGlobalObject, portValue);
        if (portConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.port = portConversionResult.releaseReturnValue();
    }
    JSValue protocolValue;
    if (isNullOrUndefined)
        protocolValue = jsUndefined();
    else {
        protocolValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "protocol"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!protocolValue.isUndefined()) {
        auto protocolConversionResult = convert<IDLUSVString>(lexicalGlobalObject, protocolValue);
        if (protocolConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.protocol = protocolConversionResult.releaseReturnValue();
    }
    JSValue searchValue;
    if (isNullOrUndefined)
        searchValue = jsUndefined();
    else {
        searchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "search"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!searchValue.isUndefined()) {
        auto searchConversionResult = convert<IDLUSVString>(lexicalGlobalObject, searchValue);
        if (searchConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.search = searchConversionResult.releaseReturnValue();
    }
    JSValue usernameValue;
    if (isNullOrUndefined)
        usernameValue = jsUndefined();
    else {
        usernameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "username"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!usernameValue.isUndefined()) {
        auto usernameConversionResult = convert<IDLUSVString>(lexicalGlobalObject, usernameValue);
        if (usernameConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.username = usernameConversionResult.releaseReturnValue();
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const URLPatternInit& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUSVString::isNullValue(dictionary.baseURL)) {
        auto baseURLValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.baseURL));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "baseURL"_s), baseURLValue);
    }
    if (!IDLUSVString::isNullValue(dictionary.hash)) {
        auto hashValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.hash));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "hash"_s), hashValue);
    }
    if (!IDLUSVString::isNullValue(dictionary.hostname)) {
        auto hostnameValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.hostname));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "hostname"_s), hostnameValue);
    }
    if (!IDLUSVString::isNullValue(dictionary.password)) {
        auto passwordValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.password));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "password"_s), passwordValue);
    }
    if (!IDLUSVString::isNullValue(dictionary.pathname)) {
        auto pathnameValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.pathname));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "pathname"_s), pathnameValue);
    }
    if (!IDLUSVString::isNullValue(dictionary.port)) {
        auto portValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.port));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "port"_s), portValue);
    }
    if (!IDLUSVString::isNullValue(dictionary.protocol)) {
        auto protocolValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.protocol));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "protocol"_s), protocolValue);
    }
    if (!IDLUSVString::isNullValue(dictionary.search)) {
        auto searchValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.search));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "search"_s), searchValue);
    }
    if (!IDLUSVString::isNullValue(dictionary.username)) {
        auto usernameValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.username));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "username"_s), usernameValue);
    }
    return result;
}

} // namespace WebCore

