/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRunningStatus.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RunningStatus enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("running"),
        MAKE_STATIC_STRING_IMPL("not-running"),
    };
    static_assert(static_cast<size_t>(RunningStatus::Running) == 0, "RunningStatus::Running is not 0 as expected");
    static_assert(static_cast<size_t>(RunningStatus::NotRunning) == 1, "RunningStatus::NotRunning is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, RunningStatus enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<RunningStatus> parseEnumerationFromString<RunningStatus>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, RunningStatus>, 2> mappings {
        std::pair<ComparableASCIILiteral, RunningStatus> { "not-running"_s, RunningStatus::NotRunning },
        std::pair<ComparableASCIILiteral, RunningStatus> { "running"_s, RunningStatus::Running },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<RunningStatus> parseEnumeration<RunningStatus>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<RunningStatus>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<RunningStatus>()
{
    return "\"running\", \"not-running\""_s;
}

} // namespace WebCore

