#line 1 "jsonpath_scan.c"
/*-------------------------------------------------------------------------
 *
 * jsonpath_scan.l
 *	Lexical parser for jsonpath datatype
 *
 * Splits jsonpath string into tokens represented as JsonPathString structs.
 * Decodes unicode and hex escaped strings.
 *
 * Copyright (c) 2019-2025, PostgreSQL Global Development Group
 *
 * IDENTIFICATION
 *	src/backend/utils/adt/jsonpath_scan.l
 *
 *-------------------------------------------------------------------------
 */

#include "postgres.h"

/*
 * NB: include jsonpath_gram.h only AFTER including jsonpath_internal.h,
 * because jsonpath_internal.h contains the declaration for JsonPathString.
 */
#include "jsonpath_internal.h"
#include "jsonpath_gram.h"

#include "mb/pg_wchar.h"
#include "nodes/miscnodes.h"
#include "nodes/pg_list.h"

#line 31 "jsonpath_scan.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define jsonpath_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer jsonpath_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define jsonpath_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer jsonpath_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define jsonpath_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer jsonpath_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define jsonpath_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string jsonpath_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define jsonpath_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes jsonpath_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define jsonpath_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer jsonpath_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define jsonpath_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer jsonpath_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define jsonpath_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state jsonpath_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define jsonpath_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer jsonpath_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define jsonpath_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state jsonpath_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define jsonpath_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state jsonpath_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define jsonpath_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack jsonpath_yyensure_buffer_stack
#endif

#ifdef yylex
#define jsonpath_yylex_ALREADY_DEFINED
#else
#define yylex jsonpath_yylex
#endif

#ifdef yyrestart
#define jsonpath_yyrestart_ALREADY_DEFINED
#else
#define yyrestart jsonpath_yyrestart
#endif

#ifdef yylex_init
#define jsonpath_yylex_init_ALREADY_DEFINED
#else
#define yylex_init jsonpath_yylex_init
#endif

#ifdef yylex_init_extra
#define jsonpath_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra jsonpath_yylex_init_extra
#endif

#ifdef yylex_destroy
#define jsonpath_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy jsonpath_yylex_destroy
#endif

#ifdef yyget_debug
#define jsonpath_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug jsonpath_yyget_debug
#endif

#ifdef yyset_debug
#define jsonpath_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug jsonpath_yyset_debug
#endif

#ifdef yyget_extra
#define jsonpath_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra jsonpath_yyget_extra
#endif

#ifdef yyset_extra
#define jsonpath_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra jsonpath_yyset_extra
#endif

#ifdef yyget_in
#define jsonpath_yyget_in_ALREADY_DEFINED
#else
#define yyget_in jsonpath_yyget_in
#endif

#ifdef yyset_in
#define jsonpath_yyset_in_ALREADY_DEFINED
#else
#define yyset_in jsonpath_yyset_in
#endif

#ifdef yyget_out
#define jsonpath_yyget_out_ALREADY_DEFINED
#else
#define yyget_out jsonpath_yyget_out
#endif

#ifdef yyset_out
#define jsonpath_yyset_out_ALREADY_DEFINED
#else
#define yyset_out jsonpath_yyset_out
#endif

#ifdef yyget_leng
#define jsonpath_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng jsonpath_yyget_leng
#endif

#ifdef yyget_text
#define jsonpath_yyget_text_ALREADY_DEFINED
#else
#define yyget_text jsonpath_yyget_text
#endif

#ifdef yyget_lineno
#define jsonpath_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno jsonpath_yyget_lineno
#endif

#ifdef yyset_lineno
#define jsonpath_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno jsonpath_yyset_lineno
#endif

#ifdef yyget_column
#define jsonpath_yyget_column_ALREADY_DEFINED
#else
#define yyget_column jsonpath_yyget_column
#endif

#ifdef yyset_column
#define jsonpath_yyset_column_ALREADY_DEFINED
#else
#define yyset_column jsonpath_yyset_column
#endif

#ifdef yywrap
#define jsonpath_yywrap_ALREADY_DEFINED
#else
#define yywrap jsonpath_yywrap
#endif

#ifdef yyget_lval
#define jsonpath_yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval jsonpath_yyget_lval
#endif

#ifdef yyset_lval
#define jsonpath_yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval jsonpath_yyset_lval
#endif

#ifdef yyalloc
#define jsonpath_yyalloc_ALREADY_DEFINED
#else
#define yyalloc jsonpath_yyalloc
#endif

#ifdef yyrealloc
#define jsonpath_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc jsonpath_yyrealloc
#endif

#ifdef yyfree
#define jsonpath_yyfree_ALREADY_DEFINED
#else
#define yyfree jsonpath_yyfree
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define jsonpath_yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef const struct yy_trans_info *yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 53
#define YY_END_OF_BUFFER 54
struct yy_trans_info
	{
	flex_int16_t yy_verify;
	flex_int16_t yy_nxt;
	};
static const struct yy_trans_info yy_transition[15882] =
    {
 {   0,   0 }, {   0,15626 }, {   0,   0 }, {   0,15624 }, {   1,2580 },
 {   2,2580 }, {   3,2580 }, {   4,2580 }, {   5,2580 }, {   6,2580 },
 {   7,2580 }, {   8,2580 }, {   9,2838 }, {  10,2838 }, {  11,2580 },
 {  12,2838 }, {  13,2838 }, {  14,2580 }, {  15,2580 }, {  16,2580 },
 {  17,2580 }, {  18,2580 }, {  19,2580 }, {  20,2580 }, {  21,2580 },
 {  22,2580 }, {  23,2580 }, {  24,2580 }, {  25,2580 }, {  26,2580 },
 {  27,2580 }, {  28,2580 }, {  29,2580 }, {  30,2580 }, {  31,2580 },
 {  32,2838 }, {  33,2642 }, {  34,2644 }, {  35,2672 }, {  36,2857 },
 {  37,2672 }, {  38,2854 }, {  39,2580 }, {  40,2672 }, {  41,2672 },
 {  42,3115 }, {  43,2672 }, {  44,2672 }, {  45,2672 }, {  46,3117 },

 {  47,3119 }, {  48,3176 }, {  49,3434 }, {  50,3434 }, {  51,3434 },
 {  52,3434 }, {  53,3434 }, {  54,3434 }, {  55,3434 }, {  56,3434 },
 {  57,3434 }, {  58,2672 }, {  59,2580 }, {  60,3124 }, {  61,3127 },
 {  62,3147 }, {  63,2672 }, {  64,2672 }, {  65,2580 }, {  66,2580 },
 {  67,2580 }, {  68,2580 }, {  69,2580 }, {  70,2580 }, {  71,2580 },
 {  72,2580 }, {  73,2580 }, {  74,2580 }, {  75,2580 }, {  76,2580 },
 {  77,2580 }, {  78,2580 }, {  79,2580 }, {  80,2580 }, {  81,2580 },
 {  82,2580 }, {  83,2580 }, {  84,2580 }, {  85,2580 }, {  86,2580 },
 {  87,2580 }, {  88,2580 }, {  89,2580 }, {  90,2580 }, {  91,2672 },
 {  92,3149 }, {  93,2672 }, {  94,2580 }, {  95,2580 }, {  96,2580 },

 {  97,2580 }, {  98,2580 }, {  99,2580 }, { 100,2580 }, { 101,2580 },
 { 102,2580 }, { 103,2580 }, { 104,2580 }, { 105,2580 }, { 106,2580 },
 { 107,2580 }, { 108,2580 }, { 109,2580 }, { 110,2580 }, { 111,2580 },
 { 112,2580 }, { 113,2580 }, { 114,2580 }, { 115,2580 }, { 116,2580 },
 { 117,2580 }, { 118,2580 }, { 119,2580 }, { 120,2580 }, { 121,2580 },
 { 122,2580 }, { 123,2672 }, { 124,3692 }, { 125,2672 }, { 126,2580 },
 { 127,2580 }, { 128,2580 }, { 129,2580 }, { 130,2580 }, { 131,2580 },
 { 132,2580 }, { 133,2580 }, { 134,2580 }, { 135,2580 }, { 136,2580 },
 { 137,2580 }, { 138,2580 }, { 139,2580 }, { 140,2580 }, { 141,2580 },
 { 142,2580 }, { 143,2580 }, { 144,2580 }, { 145,2580 }, { 146,2580 },

 { 147,2580 }, { 148,2580 }, { 149,2580 }, { 150,2580 }, { 151,2580 },
 { 152,2580 }, { 153,2580 }, { 154,2580 }, { 155,2580 }, { 156,2580 },
 { 157,2580 }, { 158,2580 }, { 159,2580 }, { 160,2580 }, { 161,2580 },
 { 162,2580 }, { 163,2580 }, { 164,2580 }, { 165,2580 }, { 166,2580 },
 { 167,2580 }, { 168,2580 }, { 169,2580 }, { 170,2580 }, { 171,2580 },
 { 172,2580 }, { 173,2580 }, { 174,2580 }, { 175,2580 }, { 176,2580 },
 { 177,2580 }, { 178,2580 }, { 179,2580 }, { 180,2580 }, { 181,2580 },
 { 182,2580 }, { 183,2580 }, { 184,2580 }, { 185,2580 }, { 186,2580 },
 { 187,2580 }, { 188,2580 }, { 189,2580 }, { 190,2580 }, { 191,2580 },
 { 192,2580 }, { 193,2580 }, { 194,2580 }, { 195,2580 }, { 196,2580 },

 { 197,2580 }, { 198,2580 }, { 199,2580 }, { 200,2580 }, { 201,2580 },
 { 202,2580 }, { 203,2580 }, { 204,2580 }, { 205,2580 }, { 206,2580 },
 { 207,2580 }, { 208,2580 }, { 209,2580 }, { 210,2580 }, { 211,2580 },
 { 212,2580 }, { 213,2580 }, { 214,2580 }, { 215,2580 }, { 216,2580 },
 { 217,2580 }, { 218,2580 }, { 219,2580 }, { 220,2580 }, { 221,2580 },
 { 222,2580 }, { 223,2580 }, { 224,2580 }, { 225,2580 }, { 226,2580 },
 { 227,2580 }, { 228,2580 }, { 229,2580 }, { 230,2580 }, { 231,2580 },
 { 232,2580 }, { 233,2580 }, { 234,2580 }, { 235,2580 }, { 236,2580 },
 { 237,2580 }, { 238,2580 }, { 239,2580 }, { 240,2580 }, { 241,2580 },
 { 242,2580 }, { 243,2580 }, { 244,2580 }, { 245,2580 }, { 246,2580 },

 { 247,2580 }, { 248,2580 }, { 249,2580 }, { 250,2580 }, { 251,2580 },
 { 252,2580 }, { 253,2580 }, { 254,2580 }, { 255,2580 }, { 256,2580 },
 {   0,   0 }, {   0,15366 }, {   1,2322 }, {   2,2322 }, {   3,2322 },
 {   4,2322 }, {   5,2322 }, {   6,2322 }, {   7,2322 }, {   8,2322 },
 {   9,2580 }, {  10,2580 }, {  11,2322 }, {  12,2580 }, {  13,2580 },
 {  14,2322 }, {  15,2322 }, {  16,2322 }, {  17,2322 }, {  18,2322 },
 {  19,2322 }, {  20,2322 }, {  21,2322 }, {  22,2322 }, {  23,2322 },
 {  24,2322 }, {  25,2322 }, {  26,2322 }, {  27,2322 }, {  28,2322 },
 {  29,2322 }, {  30,2322 }, {  31,2322 }, {  32,2580 }, {  33,2384 },
 {  34,2386 }, {  35,2414 }, {  36,2599 }, {  37,2414 }, {  38,2596 },

 {  39,2322 }, {  40,2414 }, {  41,2414 }, {  42,2857 }, {  43,2414 },
 {  44,2414 }, {  45,2414 }, {  46,2859 }, {  47,2861 }, {  48,2918 },
 {  49,3176 }, {  50,3176 }, {  51,3176 }, {  52,3176 }, {  53,3176 },
 {  54,3176 }, {  55,3176 }, {  56,3176 }, {  57,3176 }, {  58,2414 },
 {  59,2322 }, {  60,2866 }, {  61,2869 }, {  62,2889 }, {  63,2414 },
 {  64,2414 }, {  65,2322 }, {  66,2322 }, {  67,2322 }, {  68,2322 },
 {  69,2322 }, {  70,2322 }, {  71,2322 }, {  72,2322 }, {  73,2322 },
 {  74,2322 }, {  75,2322 }, {  76,2322 }, {  77,2322 }, {  78,2322 },
 {  79,2322 }, {  80,2322 }, {  81,2322 }, {  82,2322 }, {  83,2322 },
 {  84,2322 }, {  85,2322 }, {  86,2322 }, {  87,2322 }, {  88,2322 },

 {  89,2322 }, {  90,2322 }, {  91,2414 }, {  92,2891 }, {  93,2414 },
 {  94,2322 }, {  95,2322 }, {  96,2322 }, {  97,2322 }, {  98,2322 },
 {  99,2322 }, { 100,2322 }, { 101,2322 }, { 102,2322 }, { 103,2322 },
 { 104,2322 }, { 105,2322 }, { 106,2322 }, { 107,2322 }, { 108,2322 },
 { 109,2322 }, { 110,2322 }, { 111,2322 }, { 112,2322 }, { 113,2322 },
 { 114,2322 }, { 115,2322 }, { 116,2322 }, { 117,2322 }, { 118,2322 },
 { 119,2322 }, { 120,2322 }, { 121,2322 }, { 122,2322 }, { 123,2414 },
 { 124,3434 }, { 125,2414 }, { 126,2322 }, { 127,2322 }, { 128,2322 },
 { 129,2322 }, { 130,2322 }, { 131,2322 }, { 132,2322 }, { 133,2322 },
 { 134,2322 }, { 135,2322 }, { 136,2322 }, { 137,2322 }, { 138,2322 },

 { 139,2322 }, { 140,2322 }, { 141,2322 }, { 142,2322 }, { 143,2322 },
 { 144,2322 }, { 145,2322 }, { 146,2322 }, { 147,2322 }, { 148,2322 },
 { 149,2322 }, { 150,2322 }, { 151,2322 }, { 152,2322 }, { 153,2322 },
 { 154,2322 }, { 155,2322 }, { 156,2322 }, { 157,2322 }, { 158,2322 },
 { 159,2322 }, { 160,2322 }, { 161,2322 }, { 162,2322 }, { 163,2322 },
 { 164,2322 }, { 165,2322 }, { 166,2322 }, { 167,2322 }, { 168,2322 },
 { 169,2322 }, { 170,2322 }, { 171,2322 }, { 172,2322 }, { 173,2322 },
 { 174,2322 }, { 175,2322 }, { 176,2322 }, { 177,2322 }, { 178,2322 },
 { 179,2322 }, { 180,2322 }, { 181,2322 }, { 182,2322 }, { 183,2322 },
 { 184,2322 }, { 185,2322 }, { 186,2322 }, { 187,2322 }, { 188,2322 },

 { 189,2322 }, { 190,2322 }, { 191,2322 }, { 192,2322 }, { 193,2322 },
 { 194,2322 }, { 195,2322 }, { 196,2322 }, { 197,2322 }, { 198,2322 },
 { 199,2322 }, { 200,2322 }, { 201,2322 }, { 202,2322 }, { 203,2322 },
 { 204,2322 }, { 205,2322 }, { 206,2322 }, { 207,2322 }, { 208,2322 },
 { 209,2322 }, { 210,2322 }, { 211,2322 }, { 212,2322 }, { 213,2322 },
 { 214,2322 }, { 215,2322 }, { 216,2322 }, { 217,2322 }, { 218,2322 },
 { 219,2322 }, { 220,2322 }, { 221,2322 }, { 222,2322 }, { 223,2322 },
 { 224,2322 }, { 225,2322 }, { 226,2322 }, { 227,2322 }, { 228,2322 },
 { 229,2322 }, { 230,2322 }, { 231,2322 }, { 232,2322 }, { 233,2322 },
 { 234,2322 }, { 235,2322 }, { 236,2322 }, { 237,2322 }, { 238,2322 },

 { 239,2322 }, { 240,2322 }, { 241,2322 }, { 242,2322 }, { 243,2322 },
 { 244,2322 }, { 245,2322 }, { 246,2322 }, { 247,2322 }, { 248,2322 },
 { 249,2322 }, { 250,2322 }, { 251,2322 }, { 252,2322 }, { 253,2322 },
 { 254,2322 }, { 255,2322 }, { 256,2322 }, {   0,   0 }, {   0,15108 },
 {   1,3208 }, {   2,3208 }, {   3,3208 }, {   4,3208 }, {   5,3208 },
 {   6,3208 }, {   7,3208 }, {   8,3208 }, {   9,3208 }, {  10,3208 },
 {  11,3208 }, {  12,3208 }, {  13,3208 }, {  14,3208 }, {  15,3208 },
 {  16,3208 }, {  17,3208 }, {  18,3208 }, {  19,3208 }, {  20,3208 },
 {  21,3208 }, {  22,3208 }, {  23,3208 }, {  24,3208 }, {  25,3208 },
 {  26,3208 }, {  27,3208 }, {  28,3208 }, {  29,3208 }, {  30,3208 },

 {  31,3208 }, {  32,3208 }, {  33,3208 }, {  34,3178 }, {  35,3208 },
 {  36,3208 }, {  37,3208 }, {  38,3208 }, {  39,3208 }, {  40,3208 },
 {  41,3208 }, {  42,3208 }, {  43,3208 }, {  44,3208 }, {  45,3208 },
 {  46,3208 }, {  47,3208 }, {  48,3208 }, {  49,3208 }, {  50,3208 },
 {  51,3208 }, {  52,3208 }, {  53,3208 }, {  54,3208 }, {  55,3208 },
 {  56,3208 }, {  57,3208 }, {  58,3208 }, {  59,3208 }, {  60,3208 },
 {  61,3208 }, {  62,3208 }, {  63,3208 }, {  64,3208 }, {  65,3208 },
 {  66,3208 }, {  67,3208 }, {  68,3208 }, {  69,3208 }, {  70,3208 },
 {  71,3208 }, {  72,3208 }, {  73,3208 }, {  74,3208 }, {  75,3208 },
 {  76,3208 }, {  77,3208 }, {  78,3208 }, {  79,3208 }, {  80,3208 },

 {  81,3208 }, {  82,3208 }, {  83,3208 }, {  84,3208 }, {  85,3208 },
 {  86,3208 }, {  87,3208 }, {  88,3208 }, {  89,3208 }, {  90,3208 },
 {  91,3208 }, {  92,3466 }, {  93,3208 }, {  94,3208 }, {  95,3208 },
 {  96,3208 }, {  97,3208 }, {  98,3208 }, {  99,3208 }, { 100,3208 },
 { 101,3208 }, { 102,3208 }, { 103,3208 }, { 104,3208 }, { 105,3208 },
 { 106,3208 }, { 107,3208 }, { 108,3208 }, { 109,3208 }, { 110,3208 },
 { 111,3208 }, { 112,3208 }, { 113,3208 }, { 114,3208 }, { 115,3208 },
 { 116,3208 }, { 117,3208 }, { 118,3208 }, { 119,3208 }, { 120,3208 },
 { 121,3208 }, { 122,3208 }, { 123,3208 }, { 124,3208 }, { 125,3208 },
 { 126,3208 }, { 127,3208 }, { 128,3208 }, { 129,3208 }, { 130,3208 },

 { 131,3208 }, { 132,3208 }, { 133,3208 }, { 134,3208 }, { 135,3208 },
 { 136,3208 }, { 137,3208 }, { 138,3208 }, { 139,3208 }, { 140,3208 },
 { 141,3208 }, { 142,3208 }, { 143,3208 }, { 144,3208 }, { 145,3208 },
 { 146,3208 }, { 147,3208 }, { 148,3208 }, { 149,3208 }, { 150,3208 },
 { 151,3208 }, { 152,3208 }, { 153,3208 }, { 154,3208 }, { 155,3208 },
 { 156,3208 }, { 157,3208 }, { 158,3208 }, { 159,3208 }, { 160,3208 },
 { 161,3208 }, { 162,3208 }, { 163,3208 }, { 164,3208 }, { 165,3208 },
 { 166,3208 }, { 167,3208 }, { 168,3208 }, { 169,3208 }, { 170,3208 },
 { 171,3208 }, { 172,3208 }, { 173,3208 }, { 174,3208 }, { 175,3208 },
 { 176,3208 }, { 177,3208 }, { 178,3208 }, { 179,3208 }, { 180,3208 },

 { 181,3208 }, { 182,3208 }, { 183,3208 }, { 184,3208 }, { 185,3208 },
 { 186,3208 }, { 187,3208 }, { 188,3208 }, { 189,3208 }, { 190,3208 },
 { 191,3208 }, { 192,3208 }, { 193,3208 }, { 194,3208 }, { 195,3208 },
 { 196,3208 }, { 197,3208 }, { 198,3208 }, { 199,3208 }, { 200,3208 },
 { 201,3208 }, { 202,3208 }, { 203,3208 }, { 204,3208 }, { 205,3208 },
 { 206,3208 }, { 207,3208 }, { 208,3208 }, { 209,3208 }, { 210,3208 },
 { 211,3208 }, { 212,3208 }, { 213,3208 }, { 214,3208 }, { 215,3208 },
 { 216,3208 }, { 217,3208 }, { 218,3208 }, { 219,3208 }, { 220,3208 },
 { 221,3208 }, { 222,3208 }, { 223,3208 }, { 224,3208 }, { 225,3208 },
 { 226,3208 }, { 227,3208 }, { 228,3208 }, { 229,3208 }, { 230,3208 },

 { 231,3208 }, { 232,3208 }, { 233,3208 }, { 234,3208 }, { 235,3208 },
 { 236,3208 }, { 237,3208 }, { 238,3208 }, { 239,3208 }, { 240,3208 },
 { 241,3208 }, { 242,3208 }, { 243,3208 }, { 244,3208 }, { 245,3208 },
 { 246,3208 }, { 247,3208 }, { 248,3208 }, { 249,3208 }, { 250,3208 },
 { 251,3208 }, { 252,3208 }, { 253,3208 }, { 254,3208 }, { 255,3208 },
 { 256,3208 }, {   0,   0 }, {   0,14850 }, {   1,2950 }, {   2,2950 },
 {   3,2950 }, {   4,2950 }, {   5,2950 }, {   6,2950 }, {   7,2950 },
 {   8,2950 }, {   9,2950 }, {  10,2950 }, {  11,2950 }, {  12,2950 },
 {  13,2950 }, {  14,2950 }, {  15,2950 }, {  16,2950 }, {  17,2950 },
 {  18,2950 }, {  19,2950 }, {  20,2950 }, {  21,2950 }, {  22,2950 },

 {  23,2950 }, {  24,2950 }, {  25,2950 }, {  26,2950 }, {  27,2950 },
 {  28,2950 }, {  29,2950 }, {  30,2950 }, {  31,2950 }, {  32,2950 },
 {  33,2950 }, {  34,2920 }, {  35,2950 }, {  36,2950 }, {  37,2950 },
 {  38,2950 }, {  39,2950 }, {  40,2950 }, {  41,2950 }, {  42,2950 },
 {  43,2950 }, {  44,2950 }, {  45,2950 }, {  46,2950 }, {  47,2950 },
 {  48,2950 }, {  49,2950 }, {  50,2950 }, {  51,2950 }, {  52,2950 },
 {  53,2950 }, {  54,2950 }, {  55,2950 }, {  56,2950 }, {  57,2950 },
 {  58,2950 }, {  59,2950 }, {  60,2950 }, {  61,2950 }, {  62,2950 },
 {  63,2950 }, {  64,2950 }, {  65,2950 }, {  66,2950 }, {  67,2950 },
 {  68,2950 }, {  69,2950 }, {  70,2950 }, {  71,2950 }, {  72,2950 },

 {  73,2950 }, {  74,2950 }, {  75,2950 }, {  76,2950 }, {  77,2950 },
 {  78,2950 }, {  79,2950 }, {  80,2950 }, {  81,2950 }, {  82,2950 },
 {  83,2950 }, {  84,2950 }, {  85,2950 }, {  86,2950 }, {  87,2950 },
 {  88,2950 }, {  89,2950 }, {  90,2950 }, {  91,2950 }, {  92,3208 },
 {  93,2950 }, {  94,2950 }, {  95,2950 }, {  96,2950 }, {  97,2950 },
 {  98,2950 }, {  99,2950 }, { 100,2950 }, { 101,2950 }, { 102,2950 },
 { 103,2950 }, { 104,2950 }, { 105,2950 }, { 106,2950 }, { 107,2950 },
 { 108,2950 }, { 109,2950 }, { 110,2950 }, { 111,2950 }, { 112,2950 },
 { 113,2950 }, { 114,2950 }, { 115,2950 }, { 116,2950 }, { 117,2950 },
 { 118,2950 }, { 119,2950 }, { 120,2950 }, { 121,2950 }, { 122,2950 },

 { 123,2950 }, { 124,2950 }, { 125,2950 }, { 126,2950 }, { 127,2950 },
 { 128,2950 }, { 129,2950 }, { 130,2950 }, { 131,2950 }, { 132,2950 },
 { 133,2950 }, { 134,2950 }, { 135,2950 }, { 136,2950 }, { 137,2950 },
 { 138,2950 }, { 139,2950 }, { 140,2950 }, { 141,2950 }, { 142,2950 },
 { 143,2950 }, { 144,2950 }, { 145,2950 }, { 146,2950 }, { 147,2950 },
 { 148,2950 }, { 149,2950 }, { 150,2950 }, { 151,2950 }, { 152,2950 },
 { 153,2950 }, { 154,2950 }, { 155,2950 }, { 156,2950 }, { 157,2950 },
 { 158,2950 }, { 159,2950 }, { 160,2950 }, { 161,2950 }, { 162,2950 },
 { 163,2950 }, { 164,2950 }, { 165,2950 }, { 166,2950 }, { 167,2950 },
 { 168,2950 }, { 169,2950 }, { 170,2950 }, { 171,2950 }, { 172,2950 },

 { 173,2950 }, { 174,2950 }, { 175,2950 }, { 176,2950 }, { 177,2950 },
 { 178,2950 }, { 179,2950 }, { 180,2950 }, { 181,2950 }, { 182,2950 },
 { 183,2950 }, { 184,2950 }, { 185,2950 }, { 186,2950 }, { 187,2950 },
 { 188,2950 }, { 189,2950 }, { 190,2950 }, { 191,2950 }, { 192,2950 },
 { 193,2950 }, { 194,2950 }, { 195,2950 }, { 196,2950 }, { 197,2950 },
 { 198,2950 }, { 199,2950 }, { 200,2950 }, { 201,2950 }, { 202,2950 },
 { 203,2950 }, { 204,2950 }, { 205,2950 }, { 206,2950 }, { 207,2950 },
 { 208,2950 }, { 209,2950 }, { 210,2950 }, { 211,2950 }, { 212,2950 },
 { 213,2950 }, { 214,2950 }, { 215,2950 }, { 216,2950 }, { 217,2950 },
 { 218,2950 }, { 219,2950 }, { 220,2950 }, { 221,2950 }, { 222,2950 },

 { 223,2950 }, { 224,2950 }, { 225,2950 }, { 226,2950 }, { 227,2950 },
 { 228,2950 }, { 229,2950 }, { 230,2950 }, { 231,2950 }, { 232,2950 },
 { 233,2950 }, { 234,2950 }, { 235,2950 }, { 236,2950 }, { 237,2950 },
 { 238,2950 }, { 239,2950 }, { 240,2950 }, { 241,2950 }, { 242,2950 },
 { 243,2950 }, { 244,2950 }, { 245,2950 }, { 246,2950 }, { 247,2950 },
 { 248,2950 }, { 249,2950 }, { 250,2950 }, { 251,2950 }, { 252,2950 },
 { 253,2950 }, { 254,2950 }, { 255,2950 }, { 256,2950 }, {   0,   0 },
 {   0,14592 }, {   1,3208 }, {   2,3208 }, {   3,3208 }, {   4,3208 },
 {   5,3208 }, {   6,3208 }, {   7,3208 }, {   8,3208 }, {   9,3466 },
 {  10,3466 }, {  11,3208 }, {  12,3466 }, {  13,3466 }, {  14,3208 },

 {  15,3208 }, {  16,3208 }, {  17,3208 }, {  18,3208 }, {  19,3208 },
 {  20,3208 }, {  21,3208 }, {  22,3208 }, {  23,3208 }, {  24,3208 },
 {  25,3208 }, {  26,3208 }, {  27,3208 }, {  28,3208 }, {  29,3208 },
 {  30,3208 }, {  31,3208 }, {  32,3466 }, {  33,2664 }, {  34,2664 },
 {  35,2664 }, {  36,2664 }, {  37,2664 }, {  38,2664 }, {  39,3208 },
 {  40,2664 }, {  41,2664 }, {  42,2664 }, {  43,2664 }, {  44,2664 },
 {  45,2664 }, {  46,2664 }, {  47,2684 }, {  48,3208 }, {  49,3208 },
 {  50,3208 }, {  51,3208 }, {  52,3208 }, {  53,3208 }, {  54,3208 },
 {  55,3208 }, {  56,3208 }, {  57,3208 }, {  58,2664 }, {  59,3208 },
 {  60,2664 }, {  61,2664 }, {  62,2664 }, {  63,2664 }, {  64,2664 },

 {  65,3208 }, {  66,3208 }, {  67,3208 }, {  68,3208 }, {  69,3208 },
 {  70,3208 }, {  71,3208 }, {  72,3208 }, {  73,3208 }, {  74,3208 },
 {  75,3208 }, {  76,3208 }, {  77,3208 }, {  78,3208 }, {  79,3208 },
 {  80,3208 }, {  81,3208 }, {  82,3208 }, {  83,3208 }, {  84,3208 },
 {  85,3208 }, {  86,3208 }, {  87,3208 }, {  88,3208 }, {  89,3208 },
 {  90,3208 }, {  91,2664 }, {  92,2950 }, {  93,2664 }, {  94,3208 },
 {  95,3208 }, {  96,3208 }, {  97,3208 }, {  98,3208 }, {  99,3208 },
 { 100,3208 }, { 101,3208 }, { 102,3208 }, { 103,3208 }, { 104,3208 },
 { 105,3208 }, { 106,3208 }, { 107,3208 }, { 108,3208 }, { 109,3208 },
 { 110,3208 }, { 111,3208 }, { 112,3208 }, { 113,3208 }, { 114,3208 },

 { 115,3208 }, { 116,3208 }, { 117,3208 }, { 118,3208 }, { 119,3208 },
 { 120,3208 }, { 121,3208 }, { 122,3208 }, { 123,2664 }, { 124,2664 },
 { 125,2664 }, { 126,3208 }, { 127,3208 }, { 128,3208 }, { 129,3208 },
 { 130,3208 }, { 131,3208 }, { 132,3208 }, { 133,3208 }, { 134,3208 },
 { 135,3208 }, { 136,3208 }, { 137,3208 }, { 138,3208 }, { 139,3208 },
 { 140,3208 }, { 141,3208 }, { 142,3208 }, { 143,3208 }, { 144,3208 },
 { 145,3208 }, { 146,3208 }, { 147,3208 }, { 148,3208 }, { 149,3208 },
 { 150,3208 }, { 151,3208 }, { 152,3208 }, { 153,3208 }, { 154,3208 },
 { 155,3208 }, { 156,3208 }, { 157,3208 }, { 158,3208 }, { 159,3208 },
 { 160,3208 }, { 161,3208 }, { 162,3208 }, { 163,3208 }, { 164,3208 },

 { 165,3208 }, { 166,3208 }, { 167,3208 }, { 168,3208 }, { 169,3208 },
 { 170,3208 }, { 171,3208 }, { 172,3208 }, { 173,3208 }, { 174,3208 },
 { 175,3208 }, { 176,3208 }, { 177,3208 }, { 178,3208 }, { 179,3208 },
 { 180,3208 }, { 181,3208 }, { 182,3208 }, { 183,3208 }, { 184,3208 },
 { 185,3208 }, { 186,3208 }, { 187,3208 }, { 188,3208 }, { 189,3208 },
 { 190,3208 }, { 191,3208 }, { 192,3208 }, { 193,3208 }, { 194,3208 },
 { 195,3208 }, { 196,3208 }, { 197,3208 }, { 198,3208 }, { 199,3208 },
 { 200,3208 }, { 201,3208 }, { 202,3208 }, { 203,3208 }, { 204,3208 },
 { 205,3208 }, { 206,3208 }, { 207,3208 }, { 208,3208 }, { 209,3208 },
 { 210,3208 }, { 211,3208 }, { 212,3208 }, { 213,3208 }, { 214,3208 },

 { 215,3208 }, { 216,3208 }, { 217,3208 }, { 218,3208 }, { 219,3208 },
 { 220,3208 }, { 221,3208 }, { 222,3208 }, { 223,3208 }, { 224,3208 },
 { 225,3208 }, { 226,3208 }, { 227,3208 }, { 228,3208 }, { 229,3208 },
 { 230,3208 }, { 231,3208 }, { 232,3208 }, { 233,3208 }, { 234,3208 },
 { 235,3208 }, { 236,3208 }, { 237,3208 }, { 238,3208 }, { 239,3208 },
 { 240,3208 }, { 241,3208 }, { 242,3208 }, { 243,3208 }, { 244,3208 },
 { 245,3208 }, { 246,3208 }, { 247,3208 }, { 248,3208 }, { 249,3208 },
 { 250,3208 }, { 251,3208 }, { 252,3208 }, { 253,3208 }, { 254,3208 },
 { 255,3208 }, { 256,3208 }, {   0,   0 }, {   0,14334 }, {   1,2950 },
 {   2,2950 }, {   3,2950 }, {   4,2950 }, {   5,2950 }, {   6,2950 },

 {   7,2950 }, {   8,2950 }, {   9,3208 }, {  10,3208 }, {  11,2950 },
 {  12,3208 }, {  13,3208 }, {  14,2950 }, {  15,2950 }, {  16,2950 },
 {  17,2950 }, {  18,2950 }, {  19,2950 }, {  20,2950 }, {  21,2950 },
 {  22,2950 }, {  23,2950 }, {  24,2950 }, {  25,2950 }, {  26,2950 },
 {  27,2950 }, {  28,2950 }, {  29,2950 }, {  30,2950 }, {  31,2950 },
 {  32,3208 }, {  33,2406 }, {  34,2406 }, {  35,2406 }, {  36,2406 },
 {  37,2406 }, {  38,2406 }, {  39,2950 }, {  40,2406 }, {  41,2406 },
 {  42,2406 }, {  43,2406 }, {  44,2406 }, {  45,2406 }, {  46,2406 },
 {  47,2426 }, {  48,2950 }, {  49,2950 }, {  50,2950 }, {  51,2950 },
 {  52,2950 }, {  53,2950 }, {  54,2950 }, {  55,2950 }, {  56,2950 },

 {  57,2950 }, {  58,2406 }, {  59,2950 }, {  60,2406 }, {  61,2406 },
 {  62,2406 }, {  63,2406 }, {  64,2406 }, {  65,2950 }, {  66,2950 },
 {  67,2950 }, {  68,2950 }, {  69,2950 }, {  70,2950 }, {  71,2950 },
 {  72,2950 }, {  73,2950 }, {  74,2950 }, {  75,2950 }, {  76,2950 },
 {  77,2950 }, {  78,2950 }, {  79,2950 }, {  80,2950 }, {  81,2950 },
 {  82,2950 }, {  83,2950 }, {  84,2950 }, {  85,2950 }, {  86,2950 },
 {  87,2950 }, {  88,2950 }, {  89,2950 }, {  90,2950 }, {  91,2406 },
 {  92,2692 }, {  93,2406 }, {  94,2950 }, {  95,2950 }, {  96,2950 },
 {  97,2950 }, {  98,2950 }, {  99,2950 }, { 100,2950 }, { 101,2950 },
 { 102,2950 }, { 103,2950 }, { 104,2950 }, { 105,2950 }, { 106,2950 },

 { 107,2950 }, { 108,2950 }, { 109,2950 }, { 110,2950 }, { 111,2950 },
 { 112,2950 }, { 113,2950 }, { 114,2950 }, { 115,2950 }, { 116,2950 },
 { 117,2950 }, { 118,2950 }, { 119,2950 }, { 120,2950 }, { 121,2950 },
 { 122,2950 }, { 123,2406 }, { 124,2406 }, { 125,2406 }, { 126,2950 },
 { 127,2950 }, { 128,2950 }, { 129,2950 }, { 130,2950 }, { 131,2950 },
 { 132,2950 }, { 133,2950 }, { 134,2950 }, { 135,2950 }, { 136,2950 },
 { 137,2950 }, { 138,2950 }, { 139,2950 }, { 140,2950 }, { 141,2950 },
 { 142,2950 }, { 143,2950 }, { 144,2950 }, { 145,2950 }, { 146,2950 },
 { 147,2950 }, { 148,2950 }, { 149,2950 }, { 150,2950 }, { 151,2950 },
 { 152,2950 }, { 153,2950 }, { 154,2950 }, { 155,2950 }, { 156,2950 },

 { 157,2950 }, { 158,2950 }, { 159,2950 }, { 160,2950 }, { 161,2950 },
 { 162,2950 }, { 163,2950 }, { 164,2950 }, { 165,2950 }, { 166,2950 },
 { 167,2950 }, { 168,2950 }, { 169,2950 }, { 170,2950 }, { 171,2950 },
 { 172,2950 }, { 173,2950 }, { 174,2950 }, { 175,2950 }, { 176,2950 },
 { 177,2950 }, { 178,2950 }, { 179,2950 }, { 180,2950 }, { 181,2950 },
 { 182,2950 }, { 183,2950 }, { 184,2950 }, { 185,2950 }, { 186,2950 },
 { 187,2950 }, { 188,2950 }, { 189,2950 }, { 190,2950 }, { 191,2950 },
 { 192,2950 }, { 193,2950 }, { 194,2950 }, { 195,2950 }, { 196,2950 },
 { 197,2950 }, { 198,2950 }, { 199,2950 }, { 200,2950 }, { 201,2950 },
 { 202,2950 }, { 203,2950 }, { 204,2950 }, { 205,2950 }, { 206,2950 },

 { 207,2950 }, { 208,2950 }, { 209,2950 }, { 210,2950 }, { 211,2950 },
 { 212,2950 }, { 213,2950 }, { 214,2950 }, { 215,2950 }, { 216,2950 },
 { 217,2950 }, { 218,2950 }, { 219,2950 }, { 220,2950 }, { 221,2950 },
 { 222,2950 }, { 223,2950 }, { 224,2950 }, { 225,2950 }, { 226,2950 },
 { 227,2950 }, { 228,2950 }, { 229,2950 }, { 230,2950 }, { 231,2950 },
 { 232,2950 }, { 233,2950 }, { 234,2950 }, { 235,2950 }, { 236,2950 },
 { 237,2950 }, { 238,2950 }, { 239,2950 }, { 240,2950 }, { 241,2950 },
 { 242,2950 }, { 243,2950 }, { 244,2950 }, { 245,2950 }, { 246,2950 },
 { 247,2950 }, { 248,2950 }, { 249,2950 }, { 250,2950 }, { 251,2950 },
 { 252,2950 }, { 253,2950 }, { 254,2950 }, { 255,2950 }, { 256,2950 },

 {   0,   0 }, {   0,14076 }, {   1,2176 }, {   2,2176 }, {   3,2176 },
 {   4,2176 }, {   5,2176 }, {   6,2176 }, {   7,2176 }, {   8,2176 },
 {   9,2176 }, {  10,2176 }, {  11,2176 }, {  12,2176 }, {  13,2176 },
 {  14,2176 }, {  15,2176 }, {  16,2176 }, {  17,2176 }, {  18,2176 },
 {  19,2176 }, {  20,2176 }, {  21,2176 }, {  22,2176 }, {  23,2176 },
 {  24,2176 }, {  25,2176 }, {  26,2176 }, {  27,2176 }, {  28,2176 },
 {  29,2176 }, {  30,2176 }, {  31,2176 }, {  32,2176 }, {  33,2176 },
 {  34,2170 }, {  35,2176 }, {  36,2176 }, {  37,2176 }, {  38,2176 },
 {  39,2176 }, {  40,2176 }, {  41,2176 }, {  42,2176 }, {  43,2176 },
 {  44,2176 }, {  45,2176 }, {  46,2176 }, {  47,2176 }, {  48,2176 },

 {  49,2176 }, {  50,2176 }, {  51,2176 }, {  52,2176 }, {  53,2176 },
 {  54,2176 }, {  55,2176 }, {  56,2176 }, {  57,2176 }, {  58,2176 },
 {  59,2176 }, {  60,2176 }, {  61,2176 }, {  62,2176 }, {  63,2176 },
 {  64,2176 }, {  65,2176 }, {  66,2176 }, {  67,2176 }, {  68,2176 },
 {  69,2176 }, {  70,2176 }, {  71,2176 }, {  72,2176 }, {  73,2176 },
 {  74,2176 }, {  75,2176 }, {  76,2176 }, {  77,2176 }, {  78,2176 },
 {  79,2176 }, {  80,2176 }, {  81,2176 }, {  82,2176 }, {  83,2176 },
 {  84,2176 }, {  85,2176 }, {  86,2176 }, {  87,2176 }, {  88,2176 },
 {  89,2176 }, {  90,2176 }, {  91,2176 }, {  92,2434 }, {  93,2176 },
 {  94,2176 }, {  95,2176 }, {  96,2176 }, {  97,2176 }, {  98,2176 },

 {  99,2176 }, { 100,2176 }, { 101,2176 }, { 102,2176 }, { 103,2176 },
 { 104,2176 }, { 105,2176 }, { 106,2176 }, { 107,2176 }, { 108,2176 },
 { 109,2176 }, { 110,2176 }, { 111,2176 }, { 112,2176 }, { 113,2176 },
 { 114,2176 }, { 115,2176 }, { 116,2176 }, { 117,2176 }, { 118,2176 },
 { 119,2176 }, { 120,2176 }, { 121,2176 }, { 122,2176 }, { 123,2176 },
 { 124,2176 }, { 125,2176 }, { 126,2176 }, { 127,2176 }, { 128,2176 },
 { 129,2176 }, { 130,2176 }, { 131,2176 }, { 132,2176 }, { 133,2176 },
 { 134,2176 }, { 135,2176 }, { 136,2176 }, { 137,2176 }, { 138,2176 },
 { 139,2176 }, { 140,2176 }, { 141,2176 }, { 142,2176 }, { 143,2176 },
 { 144,2176 }, { 145,2176 }, { 146,2176 }, { 147,2176 }, { 148,2176 },

 { 149,2176 }, { 150,2176 }, { 151,2176 }, { 152,2176 }, { 153,2176 },
 { 154,2176 }, { 155,2176 }, { 156,2176 }, { 157,2176 }, { 158,2176 },
 { 159,2176 }, { 160,2176 }, { 161,2176 }, { 162,2176 }, { 163,2176 },
 { 164,2176 }, { 165,2176 }, { 166,2176 }, { 167,2176 }, { 168,2176 },
 { 169,2176 }, { 170,2176 }, { 171,2176 }, { 172,2176 }, { 173,2176 },
 { 174,2176 }, { 175,2176 }, { 176,2176 }, { 177,2176 }, { 178,2176 },
 { 179,2176 }, { 180,2176 }, { 181,2176 }, { 182,2176 }, { 183,2176 },
 { 184,2176 }, { 185,2176 }, { 186,2176 }, { 187,2176 }, { 188,2176 },
 { 189,2176 }, { 190,2176 }, { 191,2176 }, { 192,2176 }, { 193,2176 },
 { 194,2176 }, { 195,2176 }, { 196,2176 }, { 197,2176 }, { 198,2176 },

 { 199,2176 }, { 200,2176 }, { 201,2176 }, { 202,2176 }, { 203,2176 },
 { 204,2176 }, { 205,2176 }, { 206,2176 }, { 207,2176 }, { 208,2176 },
 { 209,2176 }, { 210,2176 }, { 211,2176 }, { 212,2176 }, { 213,2176 },
 { 214,2176 }, { 215,2176 }, { 216,2176 }, { 217,2176 }, { 218,2176 },
 { 219,2176 }, { 220,2176 }, { 221,2176 }, { 222,2176 }, { 223,2176 },
 { 224,2176 }, { 225,2176 }, { 226,2176 }, { 227,2176 }, { 228,2176 },
 { 229,2176 }, { 230,2176 }, { 231,2176 }, { 232,2176 }, { 233,2176 },
 { 234,2176 }, { 235,2176 }, { 236,2176 }, { 237,2176 }, { 238,2176 },
 { 239,2176 }, { 240,2176 }, { 241,2176 }, { 242,2176 }, { 243,2176 },
 { 244,2176 }, { 245,2176 }, { 246,2176 }, { 247,2176 }, { 248,2176 },

 { 249,2176 }, { 250,2176 }, { 251,2176 }, { 252,2176 }, { 253,2176 },
 { 254,2176 }, { 255,2176 }, { 256,2176 }, {   0,   0 }, {   0,13818 },
 {   1,1918 }, {   2,1918 }, {   3,1918 }, {   4,1918 }, {   5,1918 },
 {   6,1918 }, {   7,1918 }, {   8,1918 }, {   9,1918 }, {  10,1918 },
 {  11,1918 }, {  12,1918 }, {  13,1918 }, {  14,1918 }, {  15,1918 },
 {  16,1918 }, {  17,1918 }, {  18,1918 }, {  19,1918 }, {  20,1918 },
 {  21,1918 }, {  22,1918 }, {  23,1918 }, {  24,1918 }, {  25,1918 },
 {  26,1918 }, {  27,1918 }, {  28,1918 }, {  29,1918 }, {  30,1918 },
 {  31,1918 }, {  32,1918 }, {  33,1918 }, {  34,1912 }, {  35,1918 },
 {  36,1918 }, {  37,1918 }, {  38,1918 }, {  39,1918 }, {  40,1918 },

 {  41,1918 }, {  42,1918 }, {  43,1918 }, {  44,1918 }, {  45,1918 },
 {  46,1918 }, {  47,1918 }, {  48,1918 }, {  49,1918 }, {  50,1918 },
 {  51,1918 }, {  52,1918 }, {  53,1918 }, {  54,1918 }, {  55,1918 },
 {  56,1918 }, {  57,1918 }, {  58,1918 }, {  59,1918 }, {  60,1918 },
 {  61,1918 }, {  62,1918 }, {  63,1918 }, {  64,1918 }, {  65,1918 },
 {  66,1918 }, {  67,1918 }, {  68,1918 }, {  69,1918 }, {  70,1918 },
 {  71,1918 }, {  72,1918 }, {  73,1918 }, {  74,1918 }, {  75,1918 },
 {  76,1918 }, {  77,1918 }, {  78,1918 }, {  79,1918 }, {  80,1918 },
 {  81,1918 }, {  82,1918 }, {  83,1918 }, {  84,1918 }, {  85,1918 },
 {  86,1918 }, {  87,1918 }, {  88,1918 }, {  89,1918 }, {  90,1918 },

 {  91,1918 }, {  92,2176 }, {  93,1918 }, {  94,1918 }, {  95,1918 },
 {  96,1918 }, {  97,1918 }, {  98,1918 }, {  99,1918 }, { 100,1918 },
 { 101,1918 }, { 102,1918 }, { 103,1918 }, { 104,1918 }, { 105,1918 },
 { 106,1918 }, { 107,1918 }, { 108,1918 }, { 109,1918 }, { 110,1918 },
 { 111,1918 }, { 112,1918 }, { 113,1918 }, { 114,1918 }, { 115,1918 },
 { 116,1918 }, { 117,1918 }, { 118,1918 }, { 119,1918 }, { 120,1918 },
 { 121,1918 }, { 122,1918 }, { 123,1918 }, { 124,1918 }, { 125,1918 },
 { 126,1918 }, { 127,1918 }, { 128,1918 }, { 129,1918 }, { 130,1918 },
 { 131,1918 }, { 132,1918 }, { 133,1918 }, { 134,1918 }, { 135,1918 },
 { 136,1918 }, { 137,1918 }, { 138,1918 }, { 139,1918 }, { 140,1918 },

 { 141,1918 }, { 142,1918 }, { 143,1918 }, { 144,1918 }, { 145,1918 },
 { 146,1918 }, { 147,1918 }, { 148,1918 }, { 149,1918 }, { 150,1918 },
 { 151,1918 }, { 152,1918 }, { 153,1918 }, { 154,1918 }, { 155,1918 },
 { 156,1918 }, { 157,1918 }, { 158,1918 }, { 159,1918 }, { 160,1918 },
 { 161,1918 }, { 162,1918 }, { 163,1918 }, { 164,1918 }, { 165,1918 },
 { 166,1918 }, { 167,1918 }, { 168,1918 }, { 169,1918 }, { 170,1918 },
 { 171,1918 }, { 172,1918 }, { 173,1918 }, { 174,1918 }, { 175,1918 },
 { 176,1918 }, { 177,1918 }, { 178,1918 }, { 179,1918 }, { 180,1918 },
 { 181,1918 }, { 182,1918 }, { 183,1918 }, { 184,1918 }, { 185,1918 },
 { 186,1918 }, { 187,1918 }, { 188,1918 }, { 189,1918 }, { 190,1918 },

 { 191,1918 }, { 192,1918 }, { 193,1918 }, { 194,1918 }, { 195,1918 },
 { 196,1918 }, { 197,1918 }, { 198,1918 }, { 199,1918 }, { 200,1918 },
 { 201,1918 }, { 202,1918 }, { 203,1918 }, { 204,1918 }, { 205,1918 },
 { 206,1918 }, { 207,1918 }, { 208,1918 }, { 209,1918 }, { 210,1918 },
 { 211,1918 }, { 212,1918 }, { 213,1918 }, { 214,1918 }, { 215,1918 },
 { 216,1918 }, { 217,1918 }, { 218,1918 }, { 219,1918 }, { 220,1918 },
 { 221,1918 }, { 222,1918 }, { 223,1918 }, { 224,1918 }, { 225,1918 },
 { 226,1918 }, { 227,1918 }, { 228,1918 }, { 229,1918 }, { 230,1918 },
 { 231,1918 }, { 232,1918 }, { 233,1918 }, { 234,1918 }, { 235,1918 },
 { 236,1918 }, { 237,1918 }, { 238,1918 }, { 239,1918 }, { 240,1918 },

 { 241,1918 }, { 242,1918 }, { 243,1918 }, { 244,1918 }, { 245,1918 },
 { 246,1918 }, { 247,1918 }, { 248,1918 }, { 249,1918 }, { 250,1918 },
 { 251,1918 }, { 252,1918 }, { 253,1918 }, { 254,1918 }, { 255,1918 },
 { 256,1918 }, {   0,   0 }, {   0,13560 }, {   1,2468 }, {   2,2468 },
 {   3,2468 }, {   4,2468 }, {   5,2468 }, {   6,2468 }, {   7,2468 },
 {   8,2468 }, {   9,2468 }, {  10,2468 }, {  11,2468 }, {  12,2468 },
 {  13,2468 }, {  14,2468 }, {  15,2468 }, {  16,2468 }, {  17,2468 },
 {  18,2468 }, {  19,2468 }, {  20,2468 }, {  21,2468 }, {  22,2468 },
 {  23,2468 }, {  24,2468 }, {  25,2468 }, {  26,2468 }, {  27,2468 },
 {  28,2468 }, {  29,2468 }, {  30,2468 }, {  31,2468 }, {  32,2468 },

 {  33,2468 }, {  34,2468 }, {  35,2468 }, {  36,2468 }, {  37,2468 },
 {  38,2468 }, {  39,2468 }, {  40,2468 }, {  41,2468 }, {  42,2189 },
 {  43,2468 }, {  44,2468 }, {  45,2468 }, {  46,2468 }, {  47,2468 },
 {  48,2468 }, {  49,2468 }, {  50,2468 }, {  51,2468 }, {  52,2468 },
 {  53,2468 }, {  54,2468 }, {  55,2468 }, {  56,2468 }, {  57,2468 },
 {  58,2468 }, {  59,2468 }, {  60,2468 }, {  61,2468 }, {  62,2468 },
 {  63,2468 }, {  64,2468 }, {  65,2468 }, {  66,2468 }, {  67,2468 },
 {  68,2468 }, {  69,2468 }, {  70,2468 }, {  71,2468 }, {  72,2468 },
 {  73,2468 }, {  74,2468 }, {  75,2468 }, {  76,2468 }, {  77,2468 },
 {  78,2468 }, {  79,2468 }, {  80,2468 }, {  81,2468 }, {  82,2468 },

 {  83,2468 }, {  84,2468 }, {  85,2468 }, {  86,2468 }, {  87,2468 },
 {  88,2468 }, {  89,2468 }, {  90,2468 }, {  91,2468 }, {  92,2468 },
 {  93,2468 }, {  94,2468 }, {  95,2468 }, {  96,2468 }, {  97,2468 },
 {  98,2468 }, {  99,2468 }, { 100,2468 }, { 101,2468 }, { 102,2468 },
 { 103,2468 }, { 104,2468 }, { 105,2468 }, { 106,2468 }, { 107,2468 },
 { 108,2468 }, { 109,2468 }, { 110,2468 }, { 111,2468 }, { 112,2468 },
 { 113,2468 }, { 114,2468 }, { 115,2468 }, { 116,2468 }, { 117,2468 },
 { 118,2468 }, { 119,2468 }, { 120,2468 }, { 121,2468 }, { 122,2468 },
 { 123,2468 }, { 124,2468 }, { 125,2468 }, { 126,2468 }, { 127,2468 },
 { 128,2468 }, { 129,2468 }, { 130,2468 }, { 131,2468 }, { 132,2468 },

 { 133,2468 }, { 134,2468 }, { 135,2468 }, { 136,2468 }, { 137,2468 },
 { 138,2468 }, { 139,2468 }, { 140,2468 }, { 141,2468 }, { 142,2468 },
 { 143,2468 }, { 144,2468 }, { 145,2468 }, { 146,2468 }, { 147,2468 },
 { 148,2468 }, { 149,2468 }, { 150,2468 }, { 151,2468 }, { 152,2468 },
 { 153,2468 }, { 154,2468 }, { 155,2468 }, { 156,2468 }, { 157,2468 },
 { 158,2468 }, { 159,2468 }, { 160,2468 }, { 161,2468 }, { 162,2468 },
 { 163,2468 }, { 164,2468 }, { 165,2468 }, { 166,2468 }, { 167,2468 },
 { 168,2468 }, { 169,2468 }, { 170,2468 }, { 171,2468 }, { 172,2468 },
 { 173,2468 }, { 174,2468 }, { 175,2468 }, { 176,2468 }, { 177,2468 },
 { 178,2468 }, { 179,2468 }, { 180,2468 }, { 181,2468 }, { 182,2468 },

 { 183,2468 }, { 184,2468 }, { 185,2468 }, { 186,2468 }, { 187,2468 },
 { 188,2468 }, { 189,2468 }, { 190,2468 }, { 191,2468 }, { 192,2468 },
 { 193,2468 }, { 194,2468 }, { 195,2468 }, { 196,2468 }, { 197,2468 },
 { 198,2468 }, { 199,2468 }, { 200,2468 }, { 201,2468 }, { 202,2468 },
 { 203,2468 }, { 204,2468 }, { 205,2468 }, { 206,2468 }, { 207,2468 },
 { 208,2468 }, { 209,2468 }, { 210,2468 }, { 211,2468 }, { 212,2468 },
 { 213,2468 }, { 214,2468 }, { 215,2468 }, { 216,2468 }, { 217,2468 },
 { 218,2468 }, { 219,2468 }, { 220,2468 }, { 221,2468 }, { 222,2468 },
 { 223,2468 }, { 224,2468 }, { 225,2468 }, { 226,2468 }, { 227,2468 },
 { 228,2468 }, { 229,2468 }, { 230,2468 }, { 231,2468 }, { 232,2468 },

 { 233,2468 }, { 234,2468 }, { 235,2468 }, { 236,2468 }, { 237,2468 },
 { 238,2468 }, { 239,2468 }, { 240,2468 }, { 241,2468 }, { 242,2468 },
 { 243,2468 }, { 244,2468 }, { 245,2468 }, { 246,2468 }, { 247,2468 },
 { 248,2468 }, { 249,2468 }, { 250,2468 }, { 251,2468 }, { 252,2468 },
 { 253,2468 }, { 254,2468 }, { 255,2468 }, { 256,2468 }, {   0,   0 },
 {   0,13302 }, {   1,2210 }, {   2,2210 }, {   3,2210 }, {   4,2210 },
 {   5,2210 }, {   6,2210 }, {   7,2210 }, {   8,2210 }, {   9,2210 },
 {  10,2210 }, {  11,2210 }, {  12,2210 }, {  13,2210 }, {  14,2210 },
 {  15,2210 }, {  16,2210 }, {  17,2210 }, {  18,2210 }, {  19,2210 },
 {  20,2210 }, {  21,2210 }, {  22,2210 }, {  23,2210 }, {  24,2210 },

 {  25,2210 }, {  26,2210 }, {  27,2210 }, {  28,2210 }, {  29,2210 },
 {  30,2210 }, {  31,2210 }, {  32,2210 }, {  33,2210 }, {  34,2210 },
 {  35,2210 }, {  36,2210 }, {  37,2210 }, {  38,2210 }, {  39,2210 },
 {  40,2210 }, {  41,2210 }, {  42,1931 }, {  43,2210 }, {  44,2210 },
 {  45,2210 }, {  46,2210 }, {  47,2210 }, {  48,2210 }, {  49,2210 },
 {  50,2210 }, {  51,2210 }, {  52,2210 }, {  53,2210 }, {  54,2210 },
 {  55,2210 }, {  56,2210 }, {  57,2210 }, {  58,2210 }, {  59,2210 },
 {  60,2210 }, {  61,2210 }, {  62,2210 }, {  63,2210 }, {  64,2210 },
 {  65,2210 }, {  66,2210 }, {  67,2210 }, {  68,2210 }, {  69,2210 },
 {  70,2210 }, {  71,2210 }, {  72,2210 }, {  73,2210 }, {  74,2210 },

 {  75,2210 }, {  76,2210 }, {  77,2210 }, {  78,2210 }, {  79,2210 },
 {  80,2210 }, {  81,2210 }, {  82,2210 }, {  83,2210 }, {  84,2210 },
 {  85,2210 }, {  86,2210 }, {  87,2210 }, {  88,2210 }, {  89,2210 },
 {  90,2210 }, {  91,2210 }, {  92,2210 }, {  93,2210 }, {  94,2210 },
 {  95,2210 }, {  96,2210 }, {  97,2210 }, {  98,2210 }, {  99,2210 },
 { 100,2210 }, { 101,2210 }, { 102,2210 }, { 103,2210 }, { 104,2210 },
 { 105,2210 }, { 106,2210 }, { 107,2210 }, { 108,2210 }, { 109,2210 },
 { 110,2210 }, { 111,2210 }, { 112,2210 }, { 113,2210 }, { 114,2210 },
 { 115,2210 }, { 116,2210 }, { 117,2210 }, { 118,2210 }, { 119,2210 },
 { 120,2210 }, { 121,2210 }, { 122,2210 }, { 123,2210 }, { 124,2210 },

 { 125,2210 }, { 126,2210 }, { 127,2210 }, { 128,2210 }, { 129,2210 },
 { 130,2210 }, { 131,2210 }, { 132,2210 }, { 133,2210 }, { 134,2210 },
 { 135,2210 }, { 136,2210 }, { 137,2210 }, { 138,2210 }, { 139,2210 },
 { 140,2210 }, { 141,2210 }, { 142,2210 }, { 143,2210 }, { 144,2210 },
 { 145,2210 }, { 146,2210 }, { 147,2210 }, { 148,2210 }, { 149,2210 },
 { 150,2210 }, { 151,2210 }, { 152,2210 }, { 153,2210 }, { 154,2210 },
 { 155,2210 }, { 156,2210 }, { 157,2210 }, { 158,2210 }, { 159,2210 },
 { 160,2210 }, { 161,2210 }, { 162,2210 }, { 163,2210 }, { 164,2210 },
 { 165,2210 }, { 166,2210 }, { 167,2210 }, { 168,2210 }, { 169,2210 },
 { 170,2210 }, { 171,2210 }, { 172,2210 }, { 173,2210 }, { 174,2210 },

 { 175,2210 }, { 176,2210 }, { 177,2210 }, { 178,2210 }, { 179,2210 },
 { 180,2210 }, { 181,2210 }, { 182,2210 }, { 183,2210 }, { 184,2210 },
 { 185,2210 }, { 186,2210 }, { 187,2210 }, { 188,2210 }, { 189,2210 },
 { 190,2210 }, { 191,2210 }, { 192,2210 }, { 193,2210 }, { 194,2210 },
 { 195,2210 }, { 196,2210 }, { 197,2210 }, { 198,2210 }, { 199,2210 },
 { 200,2210 }, { 201,2210 }, { 202,2210 }, { 203,2210 }, { 204,2210 },
 { 205,2210 }, { 206,2210 }, { 207,2210 }, { 208,2210 }, { 209,2210 },
 { 210,2210 }, { 211,2210 }, { 212,2210 }, { 213,2210 }, { 214,2210 },
 { 215,2210 }, { 216,2210 }, { 217,2210 }, { 218,2210 }, { 219,2210 },
 { 220,2210 }, { 221,2210 }, { 222,2210 }, { 223,2210 }, { 224,2210 },

 { 225,2210 }, { 226,2210 }, { 227,2210 }, { 228,2210 }, { 229,2210 },
 { 230,2210 }, { 231,2210 }, { 232,2210 }, { 233,2210 }, { 234,2210 },
 { 235,2210 }, { 236,2210 }, { 237,2210 }, { 238,2210 }, { 239,2210 },
 { 240,2210 }, { 241,2210 }, { 242,2210 }, { 243,2210 }, { 244,2210 },
 { 245,2210 }, { 246,2210 }, { 247,2210 }, { 248,2210 }, { 249,2210 },
 { 250,2210 }, { 251,2210 }, { 252,2210 }, { 253,2210 }, { 254,2210 },
 { 255,2210 }, { 256,2210 }, {   0,  52 }, {   0,13044 }, {   1,2210 },
 {   2,2210 }, {   3,2210 }, {   4,2210 }, {   5,2210 }, {   6,2210 },
 {   7,2210 }, {   8,2210 }, {   0,   0 }, {   0,   0 }, {  11,2210 },
 {   0,   0 }, {   0,   0 }, {  14,2210 }, {  15,2210 }, {  16,2210 },

 {  17,2210 }, {  18,2210 }, {  19,2210 }, {  20,2210 }, {  21,2210 },
 {  22,2210 }, {  23,2210 }, {  24,2210 }, {  25,2210 }, {  26,2210 },
 {  27,2210 }, {  28,2210 }, {  29,2210 }, {  30,2210 }, {  31,2210 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,2210 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,2210 }, {  49,2210 }, {  50,2210 }, {  51,2210 },
 {  52,2210 }, {  53,2210 }, {  54,2210 }, {  55,2210 }, {  56,2210 },
 {  57,2210 }, {   0,   0 }, {  59,2210 }, {   0,   0 }, {   0,  26 },
 {   0,12982 }, {   0,  50 }, {   0,12980 }, {  65,2210 }, {  66,2210 },

 {  67,2210 }, {  68,2210 }, {  69,2210 }, {  70,2210 }, {  71,2210 },
 {  72,2210 }, {  73,2210 }, {  74,2210 }, {  75,2210 }, {  76,2210 },
 {  77,2210 }, {  78,2210 }, {  79,2210 }, {  80,2210 }, {  81,2210 },
 {  82,2210 }, {  83,2210 }, {  84,2210 }, {  85,2210 }, {  86,2210 },
 {  87,2210 }, {  88,2210 }, {  89,2210 }, {  90,2210 }, {   0,  37 },
 {   0,12952 }, {   0,   0 }, {  94,2210 }, {  95,2210 }, {  96,2210 },
 {  97,2210 }, {  98,2210 }, {  99,2210 }, { 100,2210 }, { 101,2210 },
 { 102,2210 }, { 103,2210 }, { 104,2210 }, { 105,2210 }, { 106,2210 },
 { 107,2210 }, { 108,2210 }, { 109,2210 }, { 110,2210 }, { 111,2210 },
 { 112,2210 }, { 113,2210 }, { 114,2210 }, { 115,2210 }, { 116,2210 },

 { 117,2210 }, { 118,2210 }, { 119,2210 }, { 120,2210 }, { 121,2210 },
 { 122,2210 }, {  61,1631 }, {   0,   0 }, {   0,   0 }, { 126,2210 },
 { 127,2210 }, { 128,2210 }, { 129,2210 }, { 130,2210 }, { 131,2210 },
 { 132,2210 }, { 133,2210 }, { 134,2210 }, { 135,2210 }, { 136,2210 },
 { 137,2210 }, { 138,2210 }, { 139,2210 }, { 140,2210 }, { 141,2210 },
 { 142,2210 }, { 143,2210 }, { 144,2210 }, { 145,2210 }, { 146,2210 },
 { 147,2210 }, { 148,2210 }, { 149,2210 }, { 150,2210 }, { 151,2210 },
 { 152,2210 }, { 153,2210 }, { 154,2210 }, { 155,2210 }, { 156,2210 },
 { 157,2210 }, { 158,2210 }, { 159,2210 }, { 160,2210 }, { 161,2210 },
 { 162,2210 }, { 163,2210 }, { 164,2210 }, { 165,2210 }, { 166,2210 },

 { 167,2210 }, { 168,2210 }, { 169,2210 }, { 170,2210 }, { 171,2210 },
 { 172,2210 }, { 173,2210 }, { 174,2210 }, { 175,2210 }, { 176,2210 },
 { 177,2210 }, { 178,2210 }, { 179,2210 }, { 180,2210 }, { 181,2210 },
 { 182,2210 }, { 183,2210 }, { 184,2210 }, { 185,2210 }, { 186,2210 },
 { 187,2210 }, { 188,2210 }, { 189,2210 }, { 190,2210 }, { 191,2210 },
 { 192,2210 }, { 193,2210 }, { 194,2210 }, { 195,2210 }, { 196,2210 },
 { 197,2210 }, { 198,2210 }, { 199,2210 }, { 200,2210 }, { 201,2210 },
 { 202,2210 }, { 203,2210 }, { 204,2210 }, { 205,2210 }, { 206,2210 },
 { 207,2210 }, { 208,2210 }, { 209,2210 }, { 210,2210 }, { 211,2210 },
 { 212,2210 }, { 213,2210 }, { 214,2210 }, { 215,2210 }, { 216,2210 },

 { 217,2210 }, { 218,2210 }, { 219,2210 }, { 220,2210 }, { 221,2210 },
 { 222,2210 }, { 223,2210 }, { 224,2210 }, { 225,2210 }, { 226,2210 },
 { 227,2210 }, { 228,2210 }, { 229,2210 }, { 230,2210 }, { 231,2210 },
 { 232,2210 }, { 233,2210 }, { 234,2210 }, { 235,2210 }, { 236,2210 },
 { 237,2210 }, { 238,2210 }, { 239,2210 }, { 240,2210 }, { 241,2210 },
 { 242,2210 }, { 243,2210 }, { 244,2210 }, { 245,2210 }, { 246,2210 },
 { 247,2210 }, { 248,2210 }, { 249,2210 }, { 250,2210 }, { 251,2210 },
 { 252,2210 }, { 253,2210 }, { 254,2210 }, { 255,2210 }, { 256,2210 },
 {   0,  38 }, {   0,12786 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   9,2210 }, {  10,2210 }, {   0,   0 }, {  12,2210 }, {  13,2210 },
 {   0,   0 }, {   0,  37 }, {   0,12770 }, {   0,   0 }, {   0,  37 },
 {   0,12767 }, {   1,2210 }, {   2,2210 }, {   3,2210 }, {   4,2210 },
 {   5,2210 }, {   6,2210 }, {   7,2210 }, {   8,2210 }, {   0,   0 },
 {   0,   0 }, {  11,2210 }, {   0,   0 }, {  32,2210 }, {  14,2210 },
 {  15,2210 }, {  16,2210 }, {  17,2210 }, {  18,2210 }, {  19,2210 },
 {  20,2210 }, {  21,2210 }, {  22,2210 }, {  23,2210 }, {  24,2210 },
 {  25,2210 }, {  26,2210 }, {  27,2210 }, {  28,2210 }, {  29,2210 },
 {  30,2210 }, {  31,2210 }, {   0,   0 }, {   0,   0 }, {  34,1418 },
 {  38,1423 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,2210 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,2210 }, {  49,2210 },
 {  50,2210 }, {  51,2210 }, {  52,2210 }, {  53,2210 }, {  54,2210 },
 {  55,2210 }, {  56,2210 }, {  57,2210 }, {   0,   0 }, {  59,2210 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,2210 }, {  66,2210 }, {  67,2210 }, {  68,2210 }, {  69,2210 },
 {  70,2210 }, {  71,2210 }, {  72,2210 }, {  73,2210 }, {  74,2210 },
 {  75,2210 }, {  76,2210 }, {  77,2210 }, {  78,2210 }, {  79,2210 },
 {  80,2210 }, {  81,2210 }, {  82,2210 }, {  83,2210 }, {  84,2210 },
 {  85,2210 }, {  86,2210 }, {  87,2210 }, {  88,2210 }, {  89,2210 },

 {  90,2210 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,2210 },
 {  95,2210 }, {  96,2210 }, {  97,2210 }, {  98,2210 }, {  99,2210 },
 { 100,2210 }, { 101,2210 }, { 102,2210 }, { 103,2210 }, { 104,2210 },
 { 105,2210 }, { 106,2210 }, { 107,2210 }, { 108,2210 }, { 109,2210 },
 { 110,2210 }, { 111,2210 }, { 112,2210 }, { 113,2210 }, { 114,2210 },
 { 115,2210 }, { 116,2210 }, { 117,2210 }, { 118,2210 }, { 119,2210 },
 { 120,2210 }, { 121,2210 }, { 122,2210 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 126,2210 }, { 127,2210 }, { 128,2210 }, { 129,2210 },
 { 130,2210 }, { 131,2210 }, { 132,2210 }, { 133,2210 }, { 134,2210 },
 { 135,2210 }, { 136,2210 }, { 137,2210 }, { 138,2210 }, { 139,2210 },

 { 140,2210 }, { 141,2210 }, { 142,2210 }, { 143,2210 }, { 144,2210 },
 { 145,2210 }, { 146,2210 }, { 147,2210 }, { 148,2210 }, { 149,2210 },
 { 150,2210 }, { 151,2210 }, { 152,2210 }, { 153,2210 }, { 154,2210 },
 { 155,2210 }, { 156,2210 }, { 157,2210 }, { 158,2210 }, { 159,2210 },
 { 160,2210 }, { 161,2210 }, { 162,2210 }, { 163,2210 }, { 164,2210 },
 { 165,2210 }, { 166,2210 }, { 167,2210 }, { 168,2210 }, { 169,2210 },
 { 170,2210 }, { 171,2210 }, { 172,2210 }, { 173,2210 }, { 174,2210 },
 { 175,2210 }, { 176,2210 }, { 177,2210 }, { 178,2210 }, { 179,2210 },
 { 180,2210 }, { 181,2210 }, { 182,2210 }, { 183,2210 }, { 184,2210 },
 { 185,2210 }, { 186,2210 }, { 187,2210 }, { 188,2210 }, { 189,2210 },

 { 190,2210 }, { 191,2210 }, { 192,2210 }, { 193,2210 }, { 194,2210 },
 { 195,2210 }, { 196,2210 }, { 197,2210 }, { 198,2210 }, { 199,2210 },
 { 200,2210 }, { 201,2210 }, { 202,2210 }, { 203,2210 }, { 204,2210 },
 { 205,2210 }, { 206,2210 }, { 207,2210 }, { 208,2210 }, { 209,2210 },
 { 210,2210 }, { 211,2210 }, { 212,2210 }, { 213,2210 }, { 214,2210 },
 { 215,2210 }, { 216,2210 }, { 217,2210 }, { 218,2210 }, { 219,2210 },
 { 220,2210 }, { 221,2210 }, { 222,2210 }, { 223,2210 }, { 224,2210 },
 { 225,2210 }, { 226,2210 }, { 227,2210 }, { 228,2210 }, { 229,2210 },
 { 230,2210 }, { 231,2210 }, { 232,2210 }, { 233,2210 }, { 234,2210 },
 { 235,2210 }, { 236,2210 }, { 237,2210 }, { 238,2210 }, { 239,2210 },

 { 240,2210 }, { 241,2210 }, { 242,2210 }, { 243,2210 }, { 244,2210 },
 { 245,2210 }, { 246,2210 }, { 247,2210 }, { 248,2210 }, { 249,2210 },
 { 250,2210 }, { 251,2210 }, { 252,2210 }, { 253,2210 }, { 254,2210 },
 { 255,2210 }, { 256,2210 }, {   0,  37 }, {   0,12509 }, {   0,  37 },
 {   0,12507 }, {   0,  37 }, {   0,12505 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  28 }, {   0,12500 }, {   0,   0 }, {   0,  37 },
 {   0,12497 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  34 },

 {   0,12477 }, {   0,  51 }, {   0,12475 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,1166 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,1164 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,2208 }, {  49,2208 },
 {  50,2208 }, {  51,2208 }, {  52,2208 }, {  53,2208 }, {  54,2208 },
 {  55,2208 }, {  56,2208 }, {  57,2208 }, {   0,  42 }, {   0,12448 },
 {   1,2407 }, {   2,2407 }, {   3,2407 }, {   4,2407 }, {   5,2407 },
 {   6,2407 }, {   7,2407 }, {   8,2407 }, {  61,1161 }, {  62,1163 },
 {  11,2407 }, {  61,1175 }, {   0,   0 }, {  14,2407 }, {  15,2407 },
 {  16,2407 }, {  17,2407 }, {  18,2407 }, {  19,2407 }, {  20,2407 },

 {  21,2407 }, {  22,2407 }, {  23,2407 }, {  24,2407 }, {  25,2407 },
 {  26,2407 }, {  27,2407 }, {  28,2407 }, {  29,2407 }, {  30,2407 },
 {  31,2407 }, {  61,1157 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,2407 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  46,2665 }, {   0,   0 }, {  48,2407 }, {  49,2407 }, {  50,2407 },
 {  51,2407 }, {  52,2407 }, {  53,2407 }, {  54,2407 }, {  55,2407 },
 {  56,2407 }, {  57,2407 }, {   0,   0 }, {  59,2407 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2407 },
 {  66,2923 }, {  67,2407 }, {  68,2407 }, {  69,3181 }, {  70,2407 },

 {  71,2407 }, {  72,2407 }, {  73,2407 }, {  74,2407 }, {  75,2407 },
 {  76,2407 }, {  77,2407 }, {  78,2407 }, {  79,3439 }, {  80,2407 },
 {  81,2407 }, {  82,2407 }, {  83,2407 }, {  84,2407 }, {  85,2407 },
 {  86,2407 }, {  87,2407 }, {  88,3697 }, {  89,2407 }, {  90,2407 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,2407 }, {  95,2407 },
 {  96,2407 }, {  97,2407 }, {  98,2923 }, {  99,2407 }, { 100,2407 },
 { 101,3181 }, { 102,2407 }, { 103,2407 }, { 104,2407 }, { 105,2407 },
 { 106,2407 }, { 107,2407 }, { 108,2407 }, { 109,2407 }, { 110,2407 },
 { 111,3439 }, { 112,2407 }, { 113,2407 }, { 114,2407 }, { 115,2407 },
 { 116,2407 }, { 117,2407 }, { 118,2407 }, { 119,2407 }, { 120,3697 },

 { 121,2407 }, { 122,2407 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 126,2407 }, { 127,2407 }, { 128,2407 }, { 129,2407 }, { 130,2407 },
 { 131,2407 }, { 132,2407 }, { 133,2407 }, { 134,2407 }, { 135,2407 },
 { 136,2407 }, { 137,2407 }, { 138,2407 }, { 139,2407 }, { 140,2407 },
 { 141,2407 }, { 142,2407 }, { 143,2407 }, { 144,2407 }, { 145,2407 },
 { 146,2407 }, { 147,2407 }, { 148,2407 }, { 149,2407 }, { 150,2407 },
 { 151,2407 }, { 152,2407 }, { 153,2407 }, { 154,2407 }, { 155,2407 },
 { 156,2407 }, { 157,2407 }, { 158,2407 }, { 159,2407 }, { 160,2407 },
 { 161,2407 }, { 162,2407 }, { 163,2407 }, { 164,2407 }, { 165,2407 },
 { 166,2407 }, { 167,2407 }, { 168,2407 }, { 169,2407 }, { 170,2407 },

 { 171,2407 }, { 172,2407 }, { 173,2407 }, { 174,2407 }, { 175,2407 },
 { 176,2407 }, { 177,2407 }, { 178,2407 }, { 179,2407 }, { 180,2407 },
 { 181,2407 }, { 182,2407 }, { 183,2407 }, { 184,2407 }, { 185,2407 },
 { 186,2407 }, { 187,2407 }, { 188,2407 }, { 189,2407 }, { 190,2407 },
 { 191,2407 }, { 192,2407 }, { 193,2407 }, { 194,2407 }, { 195,2407 },
 { 196,2407 }, { 197,2407 }, { 198,2407 }, { 199,2407 }, { 200,2407 },
 { 201,2407 }, { 202,2407 }, { 203,2407 }, { 204,2407 }, { 205,2407 },
 { 206,2407 }, { 207,2407 }, { 208,2407 }, { 209,2407 }, { 210,2407 },
 { 211,2407 }, { 212,2407 }, { 213,2407 }, { 214,2407 }, { 215,2407 },
 { 216,2407 }, { 217,2407 }, { 218,2407 }, { 219,2407 }, { 220,2407 },

 { 221,2407 }, { 222,2407 }, { 223,2407 }, { 224,2407 }, { 225,2407 },
 { 226,2407 }, { 227,2407 }, { 228,2407 }, { 229,2407 }, { 230,2407 },
 { 231,2407 }, { 232,2407 }, { 233,2407 }, { 234,2407 }, { 235,2407 },
 { 236,2407 }, { 237,2407 }, { 238,2407 }, { 239,2407 }, { 240,2407 },
 { 241,2407 }, { 242,2407 }, { 243,2407 }, { 244,2407 }, { 245,2407 },
 { 246,2407 }, { 247,2407 }, { 248,2407 }, { 249,2407 }, { 250,2407 },
 { 251,2407 }, { 252,2407 }, { 253,2407 }, { 254,2407 }, { 255,2407 },
 { 256,2407 }, {   0,  42 }, {   0,12190 }, {   1,2149 }, {   2,2149 },
 {   3,2149 }, {   4,2149 }, {   5,2149 }, {   6,2149 }, {   7,2149 },
 {   8,2149 }, {   0,   0 }, {   0,   0 }, {  11,2149 }, {   0,   0 },

 {   0,   0 }, {  14,2149 }, {  15,2149 }, {  16,2149 }, {  17,2149 },
 {  18,2149 }, {  19,2149 }, {  20,2149 }, {  21,2149 }, {  22,2149 },
 {  23,2149 }, {  24,2149 }, {  25,2149 }, {  26,2149 }, {  27,2149 },
 {  28,2149 }, {  29,2149 }, {  30,2149 }, {  31,2149 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,2149 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,2407 }, {   0,   0 },
 {  48,3697 }, {  49,3697 }, {  50,3697 }, {  51,3697 }, {  52,3697 },
 {  53,3697 }, {  54,3697 }, {  55,3697 }, {  56,3697 }, {  57,3697 },
 {   0,   0 }, {  59,2149 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  65,2149 }, {  66,2149 }, {  67,2149 },
 {  68,2149 }, {  69,2923 }, {  70,2149 }, {  71,2149 }, {  72,2149 },
 {  73,2149 }, {  74,2149 }, {  75,2149 }, {  76,2149 }, {  77,2149 },
 {  78,2149 }, {  79,2149 }, {  80,2149 }, {  81,2149 }, {  82,2149 },
 {  83,2149 }, {  84,2149 }, {  85,2149 }, {  86,2149 }, {  87,2149 },
 {  88,2149 }, {  89,2149 }, {  90,2149 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,2149 }, {  95,3955 }, {  96,2149 }, {  97,2149 },
 {  98,2149 }, {  99,2149 }, { 100,2149 }, { 101,2923 }, { 102,2149 },
 { 103,2149 }, { 104,2149 }, { 105,2149 }, { 106,2149 }, { 107,2149 },
 { 108,2149 }, { 109,2149 }, { 110,2149 }, { 111,2149 }, { 112,2149 },

 { 113,2149 }, { 114,2149 }, { 115,2149 }, { 116,2149 }, { 117,2149 },
 { 118,2149 }, { 119,2149 }, { 120,2149 }, { 121,2149 }, { 122,2149 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,2149 }, { 127,2149 },
 { 128,2149 }, { 129,2149 }, { 130,2149 }, { 131,2149 }, { 132,2149 },
 { 133,2149 }, { 134,2149 }, { 135,2149 }, { 136,2149 }, { 137,2149 },
 { 138,2149 }, { 139,2149 }, { 140,2149 }, { 141,2149 }, { 142,2149 },
 { 143,2149 }, { 144,2149 }, { 145,2149 }, { 146,2149 }, { 147,2149 },
 { 148,2149 }, { 149,2149 }, { 150,2149 }, { 151,2149 }, { 152,2149 },
 { 153,2149 }, { 154,2149 }, { 155,2149 }, { 156,2149 }, { 157,2149 },
 { 158,2149 }, { 159,2149 }, { 160,2149 }, { 161,2149 }, { 162,2149 },

 { 163,2149 }, { 164,2149 }, { 165,2149 }, { 166,2149 }, { 167,2149 },
 { 168,2149 }, { 169,2149 }, { 170,2149 }, { 171,2149 }, { 172,2149 },
 { 173,2149 }, { 174,2149 }, { 175,2149 }, { 176,2149 }, { 177,2149 },
 { 178,2149 }, { 179,2149 }, { 180,2149 }, { 181,2149 }, { 182,2149 },
 { 183,2149 }, { 184,2149 }, { 185,2149 }, { 186,2149 }, { 187,2149 },
 { 188,2149 }, { 189,2149 }, { 190,2149 }, { 191,2149 }, { 192,2149 },
 { 193,2149 }, { 194,2149 }, { 195,2149 }, { 196,2149 }, { 197,2149 },
 { 198,2149 }, { 199,2149 }, { 200,2149 }, { 201,2149 }, { 202,2149 },
 { 203,2149 }, { 204,2149 }, { 205,2149 }, { 206,2149 }, { 207,2149 },
 { 208,2149 }, { 209,2149 }, { 210,2149 }, { 211,2149 }, { 212,2149 },

 { 213,2149 }, { 214,2149 }, { 215,2149 }, { 216,2149 }, { 217,2149 },
 { 218,2149 }, { 219,2149 }, { 220,2149 }, { 221,2149 }, { 222,2149 },
 { 223,2149 }, { 224,2149 }, { 225,2149 }, { 226,2149 }, { 227,2149 },
 { 228,2149 }, { 229,2149 }, { 230,2149 }, { 231,2149 }, { 232,2149 },
 { 233,2149 }, { 234,2149 }, { 235,2149 }, { 236,2149 }, { 237,2149 },
 { 238,2149 }, { 239,2149 }, { 240,2149 }, { 241,2149 }, { 242,2149 },
 { 243,2149 }, { 244,2149 }, { 245,2149 }, { 246,2149 }, { 247,2149 },
 { 248,2149 }, { 249,2149 }, { 250,2149 }, { 251,2149 }, { 252,2149 },
 { 253,2149 }, { 254,2149 }, { 255,2149 }, { 256,2149 }, {   0,  37 },
 {   0,11932 }, {   0,  18 }, {   0,11930 }, {   0,   4 }, {   0,11928 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   4 }, {   0,11908 },
 {   0,  19 }, {   0,11906 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  20 }, {   0,11900 }, {   1,3923 }, {   2,3923 },
 {   3,3923 }, {   4,3923 }, {   5,3923 }, {   6,3923 }, {   7,3923 },
 {   8,3923 }, {   9,3923 }, {  10,3923 }, {  11,3923 }, {  12,3923 },
 {  13,3923 }, {  14,3923 }, {  15,3923 }, {  16,3923 }, {  17,3923 },
 {  18,3923 }, {  19,3923 }, {  20,3923 }, {  21,3923 }, {  22,3923 },

 {  23,3923 }, {  24,3923 }, {  25,3923 }, {  26,3923 }, {  27,3923 },
 {  28,3923 }, {  29,3923 }, {  30,3923 }, {  31,3923 }, {  32,3923 },
 {  33,3923 }, {  42, 801 }, {  35,3923 }, {  36,3923 }, {  37,3923 },
 {  38,3923 }, {  39,3923 }, {  40,3923 }, {  41,3923 }, {  42,3923 },
 {  43,3923 }, {  44,3923 }, {  45,3923 }, {  46,3923 }, {  47,3923 },
 {  48,3923 }, {  49,3923 }, {  50,3923 }, {  51,3923 }, {  52,3923 },
 {  53,3923 }, {  54,3923 }, {  55,3923 }, {  56,3923 }, {  57,3923 },
 {  58,3923 }, {  59,3923 }, {  60,3923 }, {  61,3923 }, {  62,3923 },
 {  63,3923 }, {  64,3923 }, {  65,3923 }, {  66,3923 }, {  67,3923 },
 {  68,3923 }, {  69,3923 }, {  70,3923 }, {  71,3923 }, {  72,3923 },

 {  73,3923 }, {  74,3923 }, {  75,3923 }, {  76,3923 }, {  77,3923 },
 {  78,3923 }, {  79,3923 }, {  80,3923 }, {  81,3923 }, {  82,3923 },
 {  83,3923 }, {  84,3923 }, {  85,3923 }, {  86,3923 }, {  87,3923 },
 {  88,3923 }, {  89,3923 }, {  90,3923 }, {  91,3923 }, { 124, 640 },
 {  93,3923 }, {  94,3923 }, {  95,3923 }, {  96,3923 }, {  97,3923 },
 {  98,3923 }, {  99,3923 }, { 100,3923 }, { 101,3923 }, { 102,3923 },
 { 103,3923 }, { 104,3923 }, { 105,3923 }, { 106,3923 }, { 107,3923 },
 { 108,3923 }, { 109,3923 }, { 110,3923 }, { 111,3923 }, { 112,3923 },
 { 113,3923 }, { 114,3923 }, { 115,3923 }, { 116,3923 }, { 117,3923 },
 { 118,3923 }, { 119,3923 }, { 120,3923 }, { 121,3923 }, { 122,3923 },

 { 123,3923 }, { 124,3923 }, { 125,3923 }, { 126,3923 }, { 127,3923 },
 { 128,3923 }, { 129,3923 }, { 130,3923 }, { 131,3923 }, { 132,3923 },
 { 133,3923 }, { 134,3923 }, { 135,3923 }, { 136,3923 }, { 137,3923 },
 { 138,3923 }, { 139,3923 }, { 140,3923 }, { 141,3923 }, { 142,3923 },
 { 143,3923 }, { 144,3923 }, { 145,3923 }, { 146,3923 }, { 147,3923 },
 { 148,3923 }, { 149,3923 }, { 150,3923 }, { 151,3923 }, { 152,3923 },
 { 153,3923 }, { 154,3923 }, { 155,3923 }, { 156,3923 }, { 157,3923 },
 { 158,3923 }, { 159,3923 }, { 160,3923 }, { 161,3923 }, { 162,3923 },
 { 163,3923 }, { 164,3923 }, { 165,3923 }, { 166,3923 }, { 167,3923 },
 { 168,3923 }, { 169,3923 }, { 170,3923 }, { 171,3923 }, { 172,3923 },

 { 173,3923 }, { 174,3923 }, { 175,3923 }, { 176,3923 }, { 177,3923 },
 { 178,3923 }, { 179,3923 }, { 180,3923 }, { 181,3923 }, { 182,3923 },
 { 183,3923 }, { 184,3923 }, { 185,3923 }, { 186,3923 }, { 187,3923 },
 { 188,3923 }, { 189,3923 }, { 190,3923 }, { 191,3923 }, { 192,3923 },
 { 193,3923 }, { 194,3923 }, { 195,3923 }, { 196,3923 }, { 197,3923 },
 { 198,3923 }, { 199,3923 }, { 200,3923 }, { 201,3923 }, { 202,3923 },
 { 203,3923 }, { 204,3923 }, { 205,3923 }, { 206,3923 }, { 207,3923 },
 { 208,3923 }, { 209,3923 }, { 210,3923 }, { 211,3923 }, { 212,3923 },
 { 213,3923 }, { 214,3923 }, { 215,3923 }, { 216,3923 }, { 217,3923 },
 { 218,3923 }, { 219,3923 }, { 220,3923 }, { 221,3923 }, { 222,3923 },

 { 223,3923 }, { 224,3923 }, { 225,3923 }, { 226,3923 }, { 227,3923 },
 { 228,3923 }, { 229,3923 }, { 230,3923 }, { 231,3923 }, { 232,3923 },
 { 233,3923 }, { 234,3923 }, { 235,3923 }, { 236,3923 }, { 237,3923 },
 { 238,3923 }, { 239,3923 }, { 240,3923 }, { 241,3923 }, { 242,3923 },
 { 243,3923 }, { 244,3923 }, { 245,3923 }, { 246,3923 }, { 247,3923 },
 { 248,3923 }, { 249,3923 }, { 250,3923 }, { 251,3923 }, { 252,3923 },
 { 253,3923 }, { 254,3923 }, { 255,3923 }, { 256,3923 }, {   0,  17 },
 {   0,11642 }, {   1, 382 }, {   2, 382 }, {   3, 382 }, {   4, 382 },
 {   5, 382 }, {   6, 382 }, {   7, 382 }, {   8, 382 }, {   9, 382 },
 {   0,   0 }, {  11, 382 }, {  12, 382 }, {  13, 382 }, {  14, 382 },

 {  15, 382 }, {  16, 382 }, {  17, 382 }, {  18, 382 }, {  19, 382 },
 {  20, 382 }, {  21, 382 }, {  22, 382 }, {  23, 382 }, {  24, 382 },
 {  25, 382 }, {  26, 382 }, {  27, 382 }, {  28, 382 }, {  29, 382 },
 {  30, 382 }, {  31, 382 }, {  32, 382 }, {  33, 382 }, {  34, 382 },
 {  35, 382 }, {  36, 382 }, {  37, 382 }, {  38, 382 }, {  39, 382 },
 {  40, 382 }, {  41, 382 }, {  42, 382 }, {  43, 382 }, {  44, 382 },
 {  45, 382 }, {  46, 382 }, {  47, 382 }, {  48, 382 }, {  49, 382 },
 {  50, 382 }, {  51, 382 }, {  52, 382 }, {  53, 382 }, {  54, 382 },
 {  55, 382 }, {  56, 382 }, {  57, 382 }, {  58, 382 }, {  59, 382 },
 {  60, 382 }, {  61, 382 }, {  62, 382 }, {  63, 382 }, {  64, 382 },

 {  65, 382 }, {  66, 382 }, {  67, 382 }, {  68, 382 }, {  69, 382 },
 {  70, 382 }, {  71, 382 }, {  72, 382 }, {  73, 382 }, {  74, 382 },
 {  75, 382 }, {  76, 382 }, {  77, 382 }, {  78, 382 }, {  79, 382 },
 {  80, 382 }, {  81, 382 }, {  82, 382 }, {  83, 382 }, {  84, 382 },
 {  85, 382 }, {  86, 382 }, {  87, 382 }, {  88, 382 }, {  89, 382 },
 {  90, 382 }, {  91, 382 }, {  92, 382 }, {  93, 382 }, {  94, 382 },
 {  95, 382 }, {  96, 382 }, {  97, 382 }, {  98, 518 }, {  99, 382 },
 { 100, 382 }, { 101, 382 }, { 102, 520 }, { 103, 382 }, { 104, 382 },
 { 105, 382 }, { 106, 382 }, { 107, 382 }, { 108, 382 }, { 109, 382 },
 { 110, 522 }, { 111, 382 }, { 112, 382 }, { 113, 382 }, { 114, 524 },

 { 115, 382 }, { 116, 531 }, { 117,3923 }, { 118, 533 }, { 119, 382 },
 { 120,3961 }, { 121, 382 }, { 122, 382 }, { 123, 382 }, { 124, 382 },
 { 125, 382 }, { 126, 382 }, { 127, 382 }, { 128, 382 }, { 129, 382 },
 { 130, 382 }, { 131, 382 }, { 132, 382 }, { 133, 382 }, { 134, 382 },
 { 135, 382 }, { 136, 382 }, { 137, 382 }, { 138, 382 }, { 139, 382 },
 { 140, 382 }, { 141, 382 }, { 142, 382 }, { 143, 382 }, { 144, 382 },
 { 145, 382 }, { 146, 382 }, { 147, 382 }, { 148, 382 }, { 149, 382 },
 { 150, 382 }, { 151, 382 }, { 152, 382 }, { 153, 382 }, { 154, 382 },
 { 155, 382 }, { 156, 382 }, { 157, 382 }, { 158, 382 }, { 159, 382 },
 { 160, 382 }, { 161, 382 }, { 162, 382 }, { 163, 382 }, { 164, 382 },

 { 165, 382 }, { 166, 382 }, { 167, 382 }, { 168, 382 }, { 169, 382 },
 { 170, 382 }, { 171, 382 }, { 172, 382 }, { 173, 382 }, { 174, 382 },
 { 175, 382 }, { 176, 382 }, { 177, 382 }, { 178, 382 }, { 179, 382 },
 { 180, 382 }, { 181, 382 }, { 182, 382 }, { 183, 382 }, { 184, 382 },
 { 185, 382 }, { 186, 382 }, { 187, 382 }, { 188, 382 }, { 189, 382 },
 { 190, 382 }, { 191, 382 }, { 192, 382 }, { 193, 382 }, { 194, 382 },
 { 195, 382 }, { 196, 382 }, { 197, 382 }, { 198, 382 }, { 199, 382 },
 { 200, 382 }, { 201, 382 }, { 202, 382 }, { 203, 382 }, { 204, 382 },
 { 205, 382 }, { 206, 382 }, { 207, 382 }, { 208, 382 }, { 209, 382 },
 { 210, 382 }, { 211, 382 }, { 212, 382 }, { 213, 382 }, { 214, 382 },

 { 215, 382 }, { 216, 382 }, { 217, 382 }, { 218, 382 }, { 219, 382 },
 { 220, 382 }, { 221, 382 }, { 222, 382 }, { 223, 382 }, { 224, 382 },
 { 225, 382 }, { 226, 382 }, { 227, 382 }, { 228, 382 }, { 229, 382 },
 { 230, 382 }, { 231, 382 }, { 232, 382 }, { 233, 382 }, { 234, 382 },
 { 235, 382 }, { 236, 382 }, { 237, 382 }, { 238, 382 }, { 239, 382 },
 { 240, 382 }, { 241, 382 }, { 242, 382 }, { 243, 382 }, { 244, 382 },
 { 245, 382 }, { 246, 382 }, { 247, 382 }, { 248, 382 }, { 249, 382 },
 { 250, 382 }, { 251, 382 }, { 252, 382 }, { 253, 382 }, { 254, 382 },
 { 255, 382 }, { 256, 382 }, {   0,   1 }, {   0,11384 }, {   1,3807 },
 {   2,3807 }, {   3,3807 }, {   4,3807 }, {   5,3807 }, {   6,3807 },

 {   7,3807 }, {   8,3807 }, {   0,   0 }, {   0,   0 }, {  11,3807 },
 {   0,  23 }, {   0,11371 }, {  14,3807 }, {  15,3807 }, {  16,3807 },
 {  17,3807 }, {  18,3807 }, {  19,3807 }, {  20,3807 }, {  21,3807 },
 {  22,3807 }, {  23,3807 }, {  24,3807 }, {  25,3807 }, {  26,3807 },
 {  27,3807 }, {  28,3807 }, {  29,3807 }, {  30,3807 }, {  31,3807 },
 {   0,  32 }, {   0,11351 }, {   0,  36 }, {   0,11349 }, {   0,  24 },
 {   0,11347 }, {   0,   0 }, {  39,3807 }, {   0,  27 }, {   0,11343 },
 {   0,  39 }, {   0,11341 }, {   0,  29 }, {   0,11339 }, {   0,  31 },
 {   0,11337 }, {  48,3807 }, {  49,3807 }, {  50,3807 }, {  51,3807 },
 {  52,3807 }, {  53,3807 }, {  54,3807 }, {  55,3807 }, {  56,3807 },

 {  57,3807 }, {   0,   0 }, {  59,3807 }, {  47, 266 }, {   0,  30 },
 {   0,11322 }, {   0,  33 }, {   0,11320 }, {  65,3807 }, {  66,3807 },
 {  67,3807 }, {  68,3807 }, {  69,3807 }, {  70,3807 }, {  71,3807 },
 {  72,3807 }, {  73,3807 }, {  74,3807 }, {  75,3807 }, {  76,3807 },
 {  77,3807 }, {  78,3807 }, {  79,3807 }, {  80,3807 }, {  81,3807 },
 {  82,3807 }, {  83,3807 }, {  84,3807 }, {  85,3807 }, {  86,3807 },
 {  87,3807 }, {  88,3807 }, {  89,3807 }, {  90,3807 }, {   0,  25 },
 {   0,11292 }, {   0,   0 }, {  94,3807 }, {  95,3807 }, {  96,3807 },
 {  97,3807 }, {  98,3807 }, {  99,3807 }, { 100,3807 }, { 101,3807 },
 { 102,3807 }, { 103,3807 }, { 104,3807 }, { 105,3807 }, { 106,3807 },

 { 107,3807 }, { 108,3807 }, { 109,3807 }, { 110,3807 }, { 111,3807 },
 { 112,3807 }, { 113,3807 }, { 114,3807 }, { 115,3807 }, { 116,3807 },
 { 117,3807 }, { 118,3807 }, { 119,3807 }, { 120,3807 }, { 121,3807 },
 { 122,3807 }, {   0,  16 }, {   0,11260 }, {   0,   0 }, { 126,3807 },
 { 127,3807 }, { 128,3807 }, { 129,3807 }, { 130,3807 }, { 131,3807 },
 { 132,3807 }, { 133,3807 }, { 134,3807 }, { 135,3807 }, { 136,3807 },
 { 137,3807 }, { 138,3807 }, { 139,3807 }, { 140,3807 }, { 141,3807 },
 { 142,3807 }, { 143,3807 }, { 144,3807 }, { 145,3807 }, { 146,3807 },
 { 147,3807 }, { 148,3807 }, { 149,3807 }, { 150,3807 }, { 151,3807 },
 { 152,3807 }, { 153,3807 }, { 154,3807 }, { 155,3807 }, { 156,3807 },

 { 157,3807 }, { 158,3807 }, { 159,3807 }, { 160,3807 }, { 161,3807 },
 { 162,3807 }, { 163,3807 }, { 164,3807 }, { 165,3807 }, { 166,3807 },
 { 167,3807 }, { 168,3807 }, { 169,3807 }, { 170,3807 }, { 171,3807 },
 { 172,3807 }, { 173,3807 }, { 174,3807 }, { 175,3807 }, { 176,3807 },
 { 177,3807 }, { 178,3807 }, { 179,3807 }, { 180,3807 }, { 181,3807 },
 { 182,3807 }, { 183,3807 }, { 184,3807 }, { 185,3807 }, { 186,3807 },
 { 187,3807 }, { 188,3807 }, { 189,3807 }, { 190,3807 }, { 191,3807 },
 { 192,3807 }, { 193,3807 }, { 194,3807 }, { 195,3807 }, { 196,3807 },
 { 197,3807 }, { 198,3807 }, { 199,3807 }, { 200,3807 }, { 201,3807 },
 { 202,3807 }, { 203,3807 }, { 204,3807 }, { 205,3807 }, { 206,3807 },

 { 207,3807 }, { 208,3807 }, { 209,3807 }, { 210,3807 }, { 211,3807 },
 { 212,3807 }, { 213,3807 }, { 214,3807 }, { 215,3807 }, { 216,3807 },
 { 217,3807 }, { 218,3807 }, { 219,3807 }, { 220,3807 }, { 221,3807 },
 { 222,3807 }, { 223,3807 }, { 224,3807 }, { 225,3807 }, { 226,3807 },
 { 227,3807 }, { 228,3807 }, { 229,3807 }, { 230,3807 }, { 231,3807 },
 { 232,3807 }, { 233,3807 }, { 234,3807 }, { 235,3807 }, { 236,3807 },
 { 237,3807 }, { 238,3807 }, { 239,3807 }, { 240,3807 }, { 241,3807 },
 { 242,3807 }, { 243,3807 }, { 244,3807 }, { 245,3807 }, { 246,3807 },
 { 247,3807 }, { 248,3807 }, { 249,3807 }, { 250,3807 }, { 251,3807 },
 { 252,3807 }, { 253,3807 }, { 254,3807 }, { 255,3807 }, { 256,3807 },

 {   0,   2 }, {   0,11126 }, {   0,   5 }, {   0,11124 }, {   0,   6 },
 {   0,11122 }, {   0,   7 }, {   0,11120 }, {   0,   8 }, {   0,11118 },
 {   9,3807 }, {  10,3807 }, {   0,   0 }, {  12,3807 }, {  13,3807 },
 {   0,   9 }, {   0,11111 }, {   0,  10 }, {   0,11109 }, {   0,   3 },
 {   0,11107 }, {   0,  21 }, {   0,11105 }, {   0,  48 }, {   0,11103 },
 {   0,  12 }, {   0,11101 }, {   0,  49 }, {   0,11099 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,3807 }, {   0,  22 },
 {   0,11092 }, {   1,3807 }, {   2,3807 }, {   3,3807 }, {   4,3807 },
 {   5,3807 }, {   6,3807 }, {   7,3807 }, {   8,3807 }, {   9,3807 },
 {  10,3807 }, {  11,3807 }, {  12,3807 }, {  13,3807 }, {  14,3807 },

 {  15,3807 }, {  16,3807 }, {  17,3807 }, {  18,3807 }, {  19,3807 },
 {  20,3807 }, {  21,3807 }, {  22,3807 }, {  23,3807 }, {  24,3807 },
 {  25,3807 }, {  26,3807 }, {  27,3807 }, {  28,3807 }, {  29,3807 },
 {  30,3807 }, {  31,3807 }, {  32,3807 }, {  33,3807 }, {  34,3807 },
 {  35,3807 }, {  36,3807 }, {  37,3807 }, {  38,3807 }, {  39,3807 },
 {  40,3807 }, {  41,3807 }, {   0,   0 }, {  43,3807 }, {  44,3807 },
 {  45,3807 }, {  46,3807 }, {  47,3807 }, {  48,3807 }, {  49,3807 },
 {  50,3807 }, {  51,3807 }, {  52,3807 }, {  53,3807 }, {  54,3807 },
 {  55,3807 }, {  56,3807 }, {  57,3807 }, {  58,3807 }, {  59,3807 },
 {  60,3807 }, {  61,3807 }, {  62,3807 }, {  63,3807 }, {  64,3807 },

 {  65,3807 }, {  66,3807 }, {  67,3807 }, {  68,3807 }, {  69,3807 },
 {  70,3807 }, {  71,3807 }, {  72,3807 }, {  73,3807 }, {  74,3807 },
 {  75,3807 }, {  76,3807 }, {  77,3807 }, {  78,3807 }, {  79,3807 },
 {  80,3807 }, {  81,3807 }, {  82,3807 }, {  83,3807 }, {  84,3807 },
 {  85,3807 }, {  86,3807 }, {  87,3807 }, {  88,3807 }, {  89,3807 },
 {  90,3807 }, {  91,3807 }, {  92,3807 }, {  93,3807 }, {  94,3807 },
 {  95,3807 }, {  96,3807 }, {  97,3807 }, {  98,3807 }, {  99,3807 },
 { 100,3807 }, { 101,3807 }, { 102,3807 }, { 103,3807 }, { 104,3807 },
 { 105,3807 }, { 106,3807 }, { 107,3807 }, { 108,3807 }, { 109,3807 },
 { 110,3807 }, { 111,3807 }, { 112,3807 }, { 113,3807 }, { 114,3807 },

 { 115,3807 }, { 116,3807 }, { 117,3807 }, { 118,3807 }, { 119,3807 },
 { 120,3807 }, { 121,3807 }, { 122,3807 }, { 123,3807 }, { 124,3807 },
 { 125,3807 }, { 126,3807 }, { 127,3807 }, { 128,3807 }, { 129,3807 },
 { 130,3807 }, { 131,3807 }, { 132,3807 }, { 133,3807 }, { 134,3807 },
 { 135,3807 }, { 136,3807 }, { 137,3807 }, { 138,3807 }, { 139,3807 },
 { 140,3807 }, { 141,3807 }, { 142,3807 }, { 143,3807 }, { 144,3807 },
 { 145,3807 }, { 146,3807 }, { 147,3807 }, { 148,3807 }, { 149,3807 },
 { 150,3807 }, { 151,3807 }, { 152,3807 }, { 153,3807 }, { 154,3807 },
 { 155,3807 }, { 156,3807 }, { 157,3807 }, { 158,3807 }, { 159,3807 },
 { 160,3807 }, { 161,3807 }, { 162,3807 }, { 163,3807 }, { 164,3807 },

 { 165,3807 }, { 166,3807 }, { 167,3807 }, { 168,3807 }, { 169,3807 },
 { 170,3807 }, { 171,3807 }, { 172,3807 }, { 173,3807 }, { 174,3807 },
 { 175,3807 }, { 176,3807 }, { 177,3807 }, { 178,3807 }, { 179,3807 },
 { 180,3807 }, { 181,3807 }, { 182,3807 }, { 183,3807 }, { 184,3807 },
 { 185,3807 }, { 186,3807 }, { 187,3807 }, { 188,3807 }, { 189,3807 },
 { 190,3807 }, { 191,3807 }, { 192,3807 }, { 193,3807 }, { 194,3807 },
 { 195,3807 }, { 196,3807 }, { 197,3807 }, { 198,3807 }, { 199,3807 },
 { 200,3807 }, { 201,3807 }, { 202,3807 }, { 203,3807 }, { 204,3807 },
 { 205,3807 }, { 206,3807 }, { 207,3807 }, { 208,3807 }, { 209,3807 },
 { 210,3807 }, { 211,3807 }, { 212,3807 }, { 213,3807 }, { 214,3807 },

 { 215,3807 }, { 216,3807 }, { 217,3807 }, { 218,3807 }, { 219,3807 },
 { 220,3807 }, { 221,3807 }, { 222,3807 }, { 223,3807 }, { 224,3807 },
 { 225,3807 }, { 226,3807 }, { 227,3807 }, { 228,3807 }, { 229,3807 },
 { 230,3807 }, { 231,3807 }, { 232,3807 }, { 233,3807 }, { 234,3807 },
 { 235,3807 }, { 236,3807 }, { 237,3807 }, { 238,3807 }, { 239,3807 },
 { 240,3807 }, { 241,3807 }, { 242,3807 }, { 243,3807 }, { 244,3807 },
 { 245,3807 }, { 246,3807 }, { 247,3807 }, { 248,3807 }, { 249,3807 },
 { 250,3807 }, { 251,3807 }, { 252,3807 }, { 253,3807 }, { 254,3807 },
 { 255,3807 }, { 256,3807 }, {   0,  52 }, {   0,10834 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },

 {   7,   0 }, {   8,   0 }, {   0,   0 }, {   0,   0 }, {  11,   0 },
 {   0,   0 }, {   0,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {   0,  11 }, {   0,10801 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },

 {  57,   0 }, {   0,   0 }, {  59,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },

 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, {   0,   0 }, {   0,   0 }, {  92,3084 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },

 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },

 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },

 {   0,  38 }, {   0,10576 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   9,   0 }, {  10,   0 }, {   0,   0 }, {  12,   0 }, {  13,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  35 },
 {   0,10557 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   0,   0 },
 {   0,   0 }, {  11,   0 }, {   0,   0 }, {  32,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },

 {  30,   0 }, {  31,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {  59,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },

 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },

 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },

 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },

 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,  41 }, {   0,10299 }, {   1,-804 },
 {   2,-804 }, {   3,-804 }, {   4,-804 }, {   5,-804 }, {   6,-804 },
 {   7,-804 }, {   8,-804 }, {   0,   0 }, {   0,   0 }, {  11,-804 },
 {   0,   0 }, {   0,   0 }, {  14,-804 }, {  15,-804 }, {  16,-804 },
 {  17,-804 }, {  18,-804 }, {  19,-804 }, {  20,-804 }, {  21,-804 },

 {  22,-804 }, {  23,-804 }, {  24,-804 }, {  25,-804 }, {  26,-804 },
 {  27,-804 }, {  28,-804 }, {  29,-804 }, {  30,-804 }, {  31,-804 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-804 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,3272 }, {  49,3272 }, {  50,3272 }, {  51,3272 },
 {  52,3272 }, {  53,3272 }, {  54,3272 }, {  55,3272 }, {  56,3272 },
 {  57,3272 }, {   0,   0 }, {  59,-804 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-804 }, {  66,-804 },
 {  67,-804 }, {  68,-804 }, {  69,3530 }, {  70,-804 }, {  71,-804 },

 {  72,-804 }, {  73,-804 }, {  74,-804 }, {  75,-804 }, {  76,-804 },
 {  77,-804 }, {  78,-804 }, {  79,-804 }, {  80,-804 }, {  81,-804 },
 {  82,-804 }, {  83,-804 }, {  84,-804 }, {  85,-804 }, {  86,-804 },
 {  87,-804 }, {  88,-804 }, {  89,-804 }, {  90,-804 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,-804 }, {  95,3540 }, {  96,-804 },
 {  97,-804 }, {  98,-804 }, {  99,-804 }, { 100,-804 }, { 101,3530 },
 { 102,-804 }, { 103,-804 }, { 104,-804 }, { 105,-804 }, { 106,-804 },
 { 107,-804 }, { 108,-804 }, { 109,-804 }, { 110,-804 }, { 111,-804 },
 { 112,-804 }, { 113,-804 }, { 114,-804 }, { 115,-804 }, { 116,-804 },
 { 117,-804 }, { 118,-804 }, { 119,-804 }, { 120,-804 }, { 121,-804 },

 { 122,-804 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,-804 },
 { 127,-804 }, { 128,-804 }, { 129,-804 }, { 130,-804 }, { 131,-804 },
 { 132,-804 }, { 133,-804 }, { 134,-804 }, { 135,-804 }, { 136,-804 },
 { 137,-804 }, { 138,-804 }, { 139,-804 }, { 140,-804 }, { 141,-804 },
 { 142,-804 }, { 143,-804 }, { 144,-804 }, { 145,-804 }, { 146,-804 },
 { 147,-804 }, { 148,-804 }, { 149,-804 }, { 150,-804 }, { 151,-804 },
 { 152,-804 }, { 153,-804 }, { 154,-804 }, { 155,-804 }, { 156,-804 },
 { 157,-804 }, { 158,-804 }, { 159,-804 }, { 160,-804 }, { 161,-804 },
 { 162,-804 }, { 163,-804 }, { 164,-804 }, { 165,-804 }, { 166,-804 },
 { 167,-804 }, { 168,-804 }, { 169,-804 }, { 170,-804 }, { 171,-804 },

 { 172,-804 }, { 173,-804 }, { 174,-804 }, { 175,-804 }, { 176,-804 },
 { 177,-804 }, { 178,-804 }, { 179,-804 }, { 180,-804 }, { 181,-804 },
 { 182,-804 }, { 183,-804 }, { 184,-804 }, { 185,-804 }, { 186,-804 },
 { 187,-804 }, { 188,-804 }, { 189,-804 }, { 190,-804 }, { 191,-804 },
 { 192,-804 }, { 193,-804 }, { 194,-804 }, { 195,-804 }, { 196,-804 },
 { 197,-804 }, { 198,-804 }, { 199,-804 }, { 200,-804 }, { 201,-804 },
 { 202,-804 }, { 203,-804 }, { 204,-804 }, { 205,-804 }, { 206,-804 },
 { 207,-804 }, { 208,-804 }, { 209,-804 }, { 210,-804 }, { 211,-804 },
 { 212,-804 }, { 213,-804 }, { 214,-804 }, { 215,-804 }, { 216,-804 },
 { 217,-804 }, { 218,-804 }, { 219,-804 }, { 220,-804 }, { 221,-804 },

 { 222,-804 }, { 223,-804 }, { 224,-804 }, { 225,-804 }, { 226,-804 },
 { 227,-804 }, { 228,-804 }, { 229,-804 }, { 230,-804 }, { 231,-804 },
 { 232,-804 }, { 233,-804 }, { 234,-804 }, { 235,-804 }, { 236,-804 },
 { 237,-804 }, { 238,-804 }, { 239,-804 }, { 240,-804 }, { 241,-804 },
 { 242,-804 }, { 243,-804 }, { 244,-804 }, { 245,-804 }, { 246,-804 },
 { 247,-804 }, { 248,-804 }, { 249,-804 }, { 250,-804 }, { 251,-804 },
 { 252,-804 }, { 253,-804 }, { 254,-804 }, { 255,-804 }, { 256,-804 },
 {   0,  47 }, {   0,10041 }, {   1,-793 }, {   2,-793 }, {   3,-793 },
 {   4,-793 }, {   5,-793 }, {   6,-793 }, {   7,-793 }, {   8,-793 },
 {   0,   0 }, {   0,   0 }, {  11,-793 }, {   0,   0 }, {   0,   0 },

 {  14,-793 }, {  15,-793 }, {  16,-793 }, {  17,-793 }, {  18,-793 },
 {  19,-793 }, {  20,-793 }, {  21,-793 }, {  22,-793 }, {  23,-793 },
 {  24,-793 }, {  25,-793 }, {  26,-793 }, {  27,-793 }, {  28,-793 },
 {  29,-793 }, {  30,-793 }, {  31,-793 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-793 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-793 },
 {  49,-793 }, {  50,-793 }, {  51,-793 }, {  52,-793 }, {  53,-793 },
 {  54,-793 }, {  55,-793 }, {  56,-793 }, {  57,-793 }, {   0,   0 },
 {  59,-793 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  65,-793 }, {  66,-793 }, {  67,-793 }, {  68,-793 },
 {  69,-793 }, {  70,-793 }, {  71,-793 }, {  72,-793 }, {  73,-793 },
 {  74,-793 }, {  75,-793 }, {  76,-793 }, {  77,-793 }, {  78,-793 },
 {  79,-793 }, {  80,-793 }, {  81,-793 }, {  82,-793 }, {  83,-793 },
 {  84,-793 }, {  85,-793 }, {  86,-793 }, {  87,-793 }, {  88,-793 },
 {  89,-793 }, {  90,-793 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,-793 }, {  95,-793 }, {  96,-793 }, {  97,-793 }, {  98,-793 },
 {  99,-793 }, { 100,-793 }, { 101,-793 }, { 102,-793 }, { 103,-793 },
 { 104,-793 }, { 105,-793 }, { 106,-793 }, { 107,-793 }, { 108,-793 },
 { 109,-793 }, { 110,-793 }, { 111,-793 }, { 112,-793 }, { 113,-793 },

 { 114,-793 }, { 115,-793 }, { 116,-793 }, { 117,-793 }, { 118,-793 },
 { 119,-793 }, { 120,-793 }, { 121,-793 }, { 122,-793 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 126,-793 }, { 127,-793 }, { 128,-793 },
 { 129,-793 }, { 130,-793 }, { 131,-793 }, { 132,-793 }, { 133,-793 },
 { 134,-793 }, { 135,-793 }, { 136,-793 }, { 137,-793 }, { 138,-793 },
 { 139,-793 }, { 140,-793 }, { 141,-793 }, { 142,-793 }, { 143,-793 },
 { 144,-793 }, { 145,-793 }, { 146,-793 }, { 147,-793 }, { 148,-793 },
 { 149,-793 }, { 150,-793 }, { 151,-793 }, { 152,-793 }, { 153,-793 },
 { 154,-793 }, { 155,-793 }, { 156,-793 }, { 157,-793 }, { 158,-793 },
 { 159,-793 }, { 160,-793 }, { 161,-793 }, { 162,-793 }, { 163,-793 },

 { 164,-793 }, { 165,-793 }, { 166,-793 }, { 167,-793 }, { 168,-793 },
 { 169,-793 }, { 170,-793 }, { 171,-793 }, { 172,-793 }, { 173,-793 },
 { 174,-793 }, { 175,-793 }, { 176,-793 }, { 177,-793 }, { 178,-793 },
 { 179,-793 }, { 180,-793 }, { 181,-793 }, { 182,-793 }, { 183,-793 },
 { 184,-793 }, { 185,-793 }, { 186,-793 }, { 187,-793 }, { 188,-793 },
 { 189,-793 }, { 190,-793 }, { 191,-793 }, { 192,-793 }, { 193,-793 },
 { 194,-793 }, { 195,-793 }, { 196,-793 }, { 197,-793 }, { 198,-793 },
 { 199,-793 }, { 200,-793 }, { 201,-793 }, { 202,-793 }, { 203,-793 },
 { 204,-793 }, { 205,-793 }, { 206,-793 }, { 207,-793 }, { 208,-793 },
 { 209,-793 }, { 210,-793 }, { 211,-793 }, { 212,-793 }, { 213,-793 },

 { 214,-793 }, { 215,-793 }, { 216,-793 }, { 217,-793 }, { 218,-793 },
 { 219,-793 }, { 220,-793 }, { 221,-793 }, { 222,-793 }, { 223,-793 },
 { 224,-793 }, { 225,-793 }, { 226,-793 }, { 227,-793 }, { 228,-793 },
 { 229,-793 }, { 230,-793 }, { 231,-793 }, { 232,-793 }, { 233,-793 },
 { 234,-793 }, { 235,-793 }, { 236,-793 }, { 237,-793 }, { 238,-793 },
 { 239,-793 }, { 240,-793 }, { 241,-793 }, { 242,-793 }, { 243,-793 },
 { 244,-793 }, { 245,-793 }, { 246,-793 }, { 247,-793 }, { 248,-793 },
 { 249,-793 }, { 250,-793 }, { 251,-793 }, { 252,-793 }, { 253,-793 },
 { 254,-793 }, { 255,-793 }, { 256,-793 }, {   0,  41 }, {   0,9783 },
 {   1,-1320 }, {   2,-1320 }, {   3,-1320 }, {   4,-1320 }, {   5,-1320 },

 {   6,-1320 }, {   7,-1320 }, {   8,-1320 }, {   0,   0 }, {   0,   0 },
 {  11,-1320 }, {   0,   0 }, {   0,   0 }, {  14,-1320 }, {  15,-1320 },
 {  16,-1320 }, {  17,-1320 }, {  18,-1320 }, {  19,-1320 }, {  20,-1320 },
 {  21,-1320 }, {  22,-1320 }, {  23,-1320 }, {  24,-1320 }, {  25,-1320 },
 {  26,-1320 }, {  27,-1320 }, {  28,-1320 }, {  29,-1320 }, {  30,-1320 },
 {  31,-1320 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-1320 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,3083 }, {  49,3083 }, {  50,3083 },
 {  51,3083 }, {  52,3083 }, {  53,3083 }, {  54,3083 }, {  55,3083 },

 {  56,3083 }, {  57,3083 }, {   0,   0 }, {  59,-1320 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-1320 },
 {  66,-1320 }, {  67,-1320 }, {  68,-1320 }, {  69,3014 }, {  70,-1320 },
 {  71,-1320 }, {  72,-1320 }, {  73,-1320 }, {  74,-1320 }, {  75,-1320 },
 {  76,-1320 }, {  77,-1320 }, {  78,-1320 }, {  79,-1320 }, {  80,-1320 },
 {  81,-1320 }, {  82,-1320 }, {  83,-1320 }, {  84,-1320 }, {  85,-1320 },
 {  86,-1320 }, {  87,-1320 }, {  88,-1320 }, {  89,-1320 }, {  90,-1320 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-1320 }, {  95,-1320 },
 {  96,-1320 }, {  97,-1320 }, {  98,-1320 }, {  99,-1320 }, { 100,-1320 },
 { 101,3014 }, { 102,-1320 }, { 103,-1320 }, { 104,-1320 }, { 105,-1320 },

 { 106,-1320 }, { 107,-1320 }, { 108,-1320 }, { 109,-1320 }, { 110,-1320 },
 { 111,-1320 }, { 112,-1320 }, { 113,-1320 }, { 114,-1320 }, { 115,-1320 },
 { 116,-1320 }, { 117,-1320 }, { 118,-1320 }, { 119,-1320 }, { 120,-1320 },
 { 121,-1320 }, { 122,-1320 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 126,-1320 }, { 127,-1320 }, { 128,-1320 }, { 129,-1320 }, { 130,-1320 },
 { 131,-1320 }, { 132,-1320 }, { 133,-1320 }, { 134,-1320 }, { 135,-1320 },
 { 136,-1320 }, { 137,-1320 }, { 138,-1320 }, { 139,-1320 }, { 140,-1320 },
 { 141,-1320 }, { 142,-1320 }, { 143,-1320 }, { 144,-1320 }, { 145,-1320 },
 { 146,-1320 }, { 147,-1320 }, { 148,-1320 }, { 149,-1320 }, { 150,-1320 },
 { 151,-1320 }, { 152,-1320 }, { 153,-1320 }, { 154,-1320 }, { 155,-1320 },

 { 156,-1320 }, { 157,-1320 }, { 158,-1320 }, { 159,-1320 }, { 160,-1320 },
 { 161,-1320 }, { 162,-1320 }, { 163,-1320 }, { 164,-1320 }, { 165,-1320 },
 { 166,-1320 }, { 167,-1320 }, { 168,-1320 }, { 169,-1320 }, { 170,-1320 },
 { 171,-1320 }, { 172,-1320 }, { 173,-1320 }, { 174,-1320 }, { 175,-1320 },
 { 176,-1320 }, { 177,-1320 }, { 178,-1320 }, { 179,-1320 }, { 180,-1320 },
 { 181,-1320 }, { 182,-1320 }, { 183,-1320 }, { 184,-1320 }, { 185,-1320 },
 { 186,-1320 }, { 187,-1320 }, { 188,-1320 }, { 189,-1320 }, { 190,-1320 },
 { 191,-1320 }, { 192,-1320 }, { 193,-1320 }, { 194,-1320 }, { 195,-1320 },
 { 196,-1320 }, { 197,-1320 }, { 198,-1320 }, { 199,-1320 }, { 200,-1320 },
 { 201,-1320 }, { 202,-1320 }, { 203,-1320 }, { 204,-1320 }, { 205,-1320 },

 { 206,-1320 }, { 207,-1320 }, { 208,-1320 }, { 209,-1320 }, { 210,-1320 },
 { 211,-1320 }, { 212,-1320 }, { 213,-1320 }, { 214,-1320 }, { 215,-1320 },
 { 216,-1320 }, { 217,-1320 }, { 218,-1320 }, { 219,-1320 }, { 220,-1320 },
 { 221,-1320 }, { 222,-1320 }, { 223,-1320 }, { 224,-1320 }, { 225,-1320 },
 { 226,-1320 }, { 227,-1320 }, { 228,-1320 }, { 229,-1320 }, { 230,-1320 },
 { 231,-1320 }, { 232,-1320 }, { 233,-1320 }, { 234,-1320 }, { 235,-1320 },
 { 236,-1320 }, { 237,-1320 }, { 238,-1320 }, { 239,-1320 }, { 240,-1320 },
 { 241,-1320 }, { 242,-1320 }, { 243,-1320 }, { 244,-1320 }, { 245,-1320 },
 { 246,-1320 }, { 247,-1320 }, { 248,-1320 }, { 249,-1320 }, { 250,-1320 },
 { 251,-1320 }, { 252,-1320 }, { 253,-1320 }, { 254,-1320 }, { 255,-1320 },

 { 256,-1320 }, {   0,  47 }, {   0,9525 }, {   1,-1309 }, {   2,-1309 },
 {   3,-1309 }, {   4,-1309 }, {   5,-1309 }, {   6,-1309 }, {   7,-1309 },
 {   8,-1309 }, {   0,   0 }, {   0,   0 }, {  11,-1309 }, {   0,   0 },
 {   0,   0 }, {  14,-1309 }, {  15,-1309 }, {  16,-1309 }, {  17,-1309 },
 {  18,-1309 }, {  19,-1309 }, {  20,-1309 }, {  21,-1309 }, {  22,-1309 },
 {  23,-1309 }, {  24,-1309 }, {  25,-1309 }, {  26,-1309 }, {  27,-1309 },
 {  28,-1309 }, {  29,-1309 }, {  30,-1309 }, {  31,-1309 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,-1309 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,3083 }, {  49,3083 }, {  50,-1309 }, {  51,-1309 }, {  52,-1309 },
 {  53,-1309 }, {  54,-1309 }, {  55,-1309 }, {  56,-1309 }, {  57,-1309 },
 {   0,   0 }, {  59,-1309 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-1309 }, {  66,-1309 }, {  67,-1309 },
 {  68,-1309 }, {  69,-1309 }, {  70,-1309 }, {  71,-1309 }, {  72,-1309 },
 {  73,-1309 }, {  74,-1309 }, {  75,-1309 }, {  76,-1309 }, {  77,-1309 },
 {  78,-1309 }, {  79,-1309 }, {  80,-1309 }, {  81,-1309 }, {  82,-1309 },
 {  83,-1309 }, {  84,-1309 }, {  85,-1309 }, {  86,-1309 }, {  87,-1309 },
 {  88,-1309 }, {  89,-1309 }, {  90,-1309 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,-1309 }, {  95,-1309 }, {  96,-1309 }, {  97,-1309 },

 {  98,-1309 }, {  99,-1309 }, { 100,-1309 }, { 101,-1309 }, { 102,-1309 },
 { 103,-1309 }, { 104,-1309 }, { 105,-1309 }, { 106,-1309 }, { 107,-1309 },
 { 108,-1309 }, { 109,-1309 }, { 110,-1309 }, { 111,-1309 }, { 112,-1309 },
 { 113,-1309 }, { 114,-1309 }, { 115,-1309 }, { 116,-1309 }, { 117,-1309 },
 { 118,-1309 }, { 119,-1309 }, { 120,-1309 }, { 121,-1309 }, { 122,-1309 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,-1309 }, { 127,-1309 },
 { 128,-1309 }, { 129,-1309 }, { 130,-1309 }, { 131,-1309 }, { 132,-1309 },
 { 133,-1309 }, { 134,-1309 }, { 135,-1309 }, { 136,-1309 }, { 137,-1309 },
 { 138,-1309 }, { 139,-1309 }, { 140,-1309 }, { 141,-1309 }, { 142,-1309 },
 { 143,-1309 }, { 144,-1309 }, { 145,-1309 }, { 146,-1309 }, { 147,-1309 },

 { 148,-1309 }, { 149,-1309 }, { 150,-1309 }, { 151,-1309 }, { 152,-1309 },
 { 153,-1309 }, { 154,-1309 }, { 155,-1309 }, { 156,-1309 }, { 157,-1309 },
 { 158,-1309 }, { 159,-1309 }, { 160,-1309 }, { 161,-1309 }, { 162,-1309 },
 { 163,-1309 }, { 164,-1309 }, { 165,-1309 }, { 166,-1309 }, { 167,-1309 },
 { 168,-1309 }, { 169,-1309 }, { 170,-1309 }, { 171,-1309 }, { 172,-1309 },
 { 173,-1309 }, { 174,-1309 }, { 175,-1309 }, { 176,-1309 }, { 177,-1309 },
 { 178,-1309 }, { 179,-1309 }, { 180,-1309 }, { 181,-1309 }, { 182,-1309 },
 { 183,-1309 }, { 184,-1309 }, { 185,-1309 }, { 186,-1309 }, { 187,-1309 },
 { 188,-1309 }, { 189,-1309 }, { 190,-1309 }, { 191,-1309 }, { 192,-1309 },
 { 193,-1309 }, { 194,-1309 }, { 195,-1309 }, { 196,-1309 }, { 197,-1309 },

 { 198,-1309 }, { 199,-1309 }, { 200,-1309 }, { 201,-1309 }, { 202,-1309 },
 { 203,-1309 }, { 204,-1309 }, { 205,-1309 }, { 206,-1309 }, { 207,-1309 },
 { 208,-1309 }, { 209,-1309 }, { 210,-1309 }, { 211,-1309 }, { 212,-1309 },
 { 213,-1309 }, { 214,-1309 }, { 215,-1309 }, { 216,-1309 }, { 217,-1309 },
 { 218,-1309 }, { 219,-1309 }, { 220,-1309 }, { 221,-1309 }, { 222,-1309 },
 { 223,-1309 }, { 224,-1309 }, { 225,-1309 }, { 226,-1309 }, { 227,-1309 },
 { 228,-1309 }, { 229,-1309 }, { 230,-1309 }, { 231,-1309 }, { 232,-1309 },
 { 233,-1309 }, { 234,-1309 }, { 235,-1309 }, { 236,-1309 }, { 237,-1309 },
 { 238,-1309 }, { 239,-1309 }, { 240,-1309 }, { 241,-1309 }, { 242,-1309 },
 { 243,-1309 }, { 244,-1309 }, { 245,-1309 }, { 246,-1309 }, { 247,-1309 },

 { 248,-1309 }, { 249,-1309 }, { 250,-1309 }, { 251,-1309 }, { 252,-1309 },
 { 253,-1309 }, { 254,-1309 }, { 255,-1309 }, { 256,-1309 }, {   0,  47 },
 {   0,9267 }, {   1,-1567 }, {   2,-1567 }, {   3,-1567 }, {   4,-1567 },
 {   5,-1567 }, {   6,-1567 }, {   7,-1567 }, {   8,-1567 }, {   0,   0 },
 {   0,   0 }, {  11,-1567 }, {   0,   0 }, {   0,   0 }, {  14,-1567 },
 {  15,-1567 }, {  16,-1567 }, {  17,-1567 }, {  18,-1567 }, {  19,-1567 },
 {  20,-1567 }, {  21,-1567 }, {  22,-1567 }, {  23,-1567 }, {  24,-1567 },
 {  25,-1567 }, {  26,-1567 }, {  27,-1567 }, {  28,-1567 }, {  29,-1567 },
 {  30,-1567 }, {  31,-1567 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-1567 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  43,3083 }, {   0,   0 },
 {  45,3083 }, {   0,   0 }, {   0,   0 }, {  48,3142 }, {  49,3142 },
 {  50,3142 }, {  51,3142 }, {  52,3142 }, {  53,3142 }, {  54,3142 },
 {  55,3142 }, {  56,3142 }, {  57,3142 }, {   0,   0 }, {  59,-1567 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-1567 }, {  66,-1567 }, {  67,-1567 }, {  68,-1567 }, {  69,-1567 },
 {  70,-1567 }, {  71,-1567 }, {  72,-1567 }, {  73,-1567 }, {  74,-1567 },
 {  75,-1567 }, {  76,-1567 }, {  77,-1567 }, {  78,-1567 }, {  79,-1567 },
 {  80,-1567 }, {  81,-1567 }, {  82,-1567 }, {  83,-1567 }, {  84,-1567 },
 {  85,-1567 }, {  86,-1567 }, {  87,-1567 }, {  88,-1567 }, {  89,-1567 },

 {  90,-1567 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-1567 },
 {  95,-1567 }, {  96,-1567 }, {  97,-1567 }, {  98,-1567 }, {  99,-1567 },
 { 100,-1567 }, { 101,-1567 }, { 102,-1567 }, { 103,-1567 }, { 104,-1567 },
 { 105,-1567 }, { 106,-1567 }, { 107,-1567 }, { 108,-1567 }, { 109,-1567 },
 { 110,-1567 }, { 111,-1567 }, { 112,-1567 }, { 113,-1567 }, { 114,-1567 },
 { 115,-1567 }, { 116,-1567 }, { 117,-1567 }, { 118,-1567 }, { 119,-1567 },
 { 120,-1567 }, { 121,-1567 }, { 122,-1567 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 126,-1567 }, { 127,-1567 }, { 128,-1567 }, { 129,-1567 },
 { 130,-1567 }, { 131,-1567 }, { 132,-1567 }, { 133,-1567 }, { 134,-1567 },
 { 135,-1567 }, { 136,-1567 }, { 137,-1567 }, { 138,-1567 }, { 139,-1567 },

 { 140,-1567 }, { 141,-1567 }, { 142,-1567 }, { 143,-1567 }, { 144,-1567 },
 { 145,-1567 }, { 146,-1567 }, { 147,-1567 }, { 148,-1567 }, { 149,-1567 },
 { 150,-1567 }, { 151,-1567 }, { 152,-1567 }, { 153,-1567 }, { 154,-1567 },
 { 155,-1567 }, { 156,-1567 }, { 157,-1567 }, { 158,-1567 }, { 159,-1567 },
 { 160,-1567 }, { 161,-1567 }, { 162,-1567 }, { 163,-1567 }, { 164,-1567 },
 { 165,-1567 }, { 166,-1567 }, { 167,-1567 }, { 168,-1567 }, { 169,-1567 },
 { 170,-1567 }, { 171,-1567 }, { 172,-1567 }, { 173,-1567 }, { 174,-1567 },
 { 175,-1567 }, { 176,-1567 }, { 177,-1567 }, { 178,-1567 }, { 179,-1567 },
 { 180,-1567 }, { 181,-1567 }, { 182,-1567 }, { 183,-1567 }, { 184,-1567 },
 { 185,-1567 }, { 186,-1567 }, { 187,-1567 }, { 188,-1567 }, { 189,-1567 },

 { 190,-1567 }, { 191,-1567 }, { 192,-1567 }, { 193,-1567 }, { 194,-1567 },
 { 195,-1567 }, { 196,-1567 }, { 197,-1567 }, { 198,-1567 }, { 199,-1567 },
 { 200,-1567 }, { 201,-1567 }, { 202,-1567 }, { 203,-1567 }, { 204,-1567 },
 { 205,-1567 }, { 206,-1567 }, { 207,-1567 }, { 208,-1567 }, { 209,-1567 },
 { 210,-1567 }, { 211,-1567 }, { 212,-1567 }, { 213,-1567 }, { 214,-1567 },
 { 215,-1567 }, { 216,-1567 }, { 217,-1567 }, { 218,-1567 }, { 219,-1567 },
 { 220,-1567 }, { 221,-1567 }, { 222,-1567 }, { 223,-1567 }, { 224,-1567 },
 { 225,-1567 }, { 226,-1567 }, { 227,-1567 }, { 228,-1567 }, { 229,-1567 },
 { 230,-1567 }, { 231,-1567 }, { 232,-1567 }, { 233,-1567 }, { 234,-1567 },
 { 235,-1567 }, { 236,-1567 }, { 237,-1567 }, { 238,-1567 }, { 239,-1567 },

 { 240,-1567 }, { 241,-1567 }, { 242,-1567 }, { 243,-1567 }, { 244,-1567 },
 { 245,-1567 }, { 246,-1567 }, { 247,-1567 }, { 248,-1567 }, { 249,-1567 },
 { 250,-1567 }, { 251,-1567 }, { 252,-1567 }, { 253,-1567 }, { 254,-1567 },
 { 255,-1567 }, { 256,-1567 }, {   0,  47 }, {   0,9009 }, {   1,-1825 },
 {   2,-1825 }, {   3,-1825 }, {   4,-1825 }, {   5,-1825 }, {   6,-1825 },
 {   7,-1825 }, {   8,-1825 }, {   0,   0 }, {   0,   0 }, {  11,-1825 },
 {   0,   0 }, {   0,   0 }, {  14,-1825 }, {  15,-1825 }, {  16,-1825 },
 {  17,-1825 }, {  18,-1825 }, {  19,-1825 }, {  20,-1825 }, {  21,-1825 },
 {  22,-1825 }, {  23,-1825 }, {  24,-1825 }, {  25,-1825 }, {  26,-1825 },
 {  27,-1825 }, {  28,-1825 }, {  29,-1825 }, {  30,-1825 }, {  31,-1825 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-1825 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,3142 }, {  49,3142 }, {  50,3142 }, {  51,3142 },
 {  52,3142 }, {  53,3142 }, {  54,3142 }, {  55,3142 }, {  56,-1825 },
 {  57,-1825 }, {   0,   0 }, {  59,-1825 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-1825 }, {  66,-1825 },
 {  67,-1825 }, {  68,-1825 }, {  69,-1825 }, {  70,-1825 }, {  71,-1825 },
 {  72,-1825 }, {  73,-1825 }, {  74,-1825 }, {  75,-1825 }, {  76,-1825 },
 {  77,-1825 }, {  78,-1825 }, {  79,-1825 }, {  80,-1825 }, {  81,-1825 },

 {  82,-1825 }, {  83,-1825 }, {  84,-1825 }, {  85,-1825 }, {  86,-1825 },
 {  87,-1825 }, {  88,-1825 }, {  89,-1825 }, {  90,-1825 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,-1825 }, {  95,-1825 }, {  96,-1825 },
 {  97,-1825 }, {  98,-1825 }, {  99,-1825 }, { 100,-1825 }, { 101,-1825 },
 { 102,-1825 }, { 103,-1825 }, { 104,-1825 }, { 105,-1825 }, { 106,-1825 },
 { 107,-1825 }, { 108,-1825 }, { 109,-1825 }, { 110,-1825 }, { 111,-1825 },
 { 112,-1825 }, { 113,-1825 }, { 114,-1825 }, { 115,-1825 }, { 116,-1825 },
 { 117,-1825 }, { 118,-1825 }, { 119,-1825 }, { 120,-1825 }, { 121,-1825 },
 { 122,-1825 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,-1825 },
 { 127,-1825 }, { 128,-1825 }, { 129,-1825 }, { 130,-1825 }, { 131,-1825 },

 { 132,-1825 }, { 133,-1825 }, { 134,-1825 }, { 135,-1825 }, { 136,-1825 },
 { 137,-1825 }, { 138,-1825 }, { 139,-1825 }, { 140,-1825 }, { 141,-1825 },
 { 142,-1825 }, { 143,-1825 }, { 144,-1825 }, { 145,-1825 }, { 146,-1825 },
 { 147,-1825 }, { 148,-1825 }, { 149,-1825 }, { 150,-1825 }, { 151,-1825 },
 { 152,-1825 }, { 153,-1825 }, { 154,-1825 }, { 155,-1825 }, { 156,-1825 },
 { 157,-1825 }, { 158,-1825 }, { 159,-1825 }, { 160,-1825 }, { 161,-1825 },
 { 162,-1825 }, { 163,-1825 }, { 164,-1825 }, { 165,-1825 }, { 166,-1825 },
 { 167,-1825 }, { 168,-1825 }, { 169,-1825 }, { 170,-1825 }, { 171,-1825 },
 { 172,-1825 }, { 173,-1825 }, { 174,-1825 }, { 175,-1825 }, { 176,-1825 },
 { 177,-1825 }, { 178,-1825 }, { 179,-1825 }, { 180,-1825 }, { 181,-1825 },

 { 182,-1825 }, { 183,-1825 }, { 184,-1825 }, { 185,-1825 }, { 186,-1825 },
 { 187,-1825 }, { 188,-1825 }, { 189,-1825 }, { 190,-1825 }, { 191,-1825 },
 { 192,-1825 }, { 193,-1825 }, { 194,-1825 }, { 195,-1825 }, { 196,-1825 },
 { 197,-1825 }, { 198,-1825 }, { 199,-1825 }, { 200,-1825 }, { 201,-1825 },
 { 202,-1825 }, { 203,-1825 }, { 204,-1825 }, { 205,-1825 }, { 206,-1825 },
 { 207,-1825 }, { 208,-1825 }, { 209,-1825 }, { 210,-1825 }, { 211,-1825 },
 { 212,-1825 }, { 213,-1825 }, { 214,-1825 }, { 215,-1825 }, { 216,-1825 },
 { 217,-1825 }, { 218,-1825 }, { 219,-1825 }, { 220,-1825 }, { 221,-1825 },
 { 222,-1825 }, { 223,-1825 }, { 224,-1825 }, { 225,-1825 }, { 226,-1825 },
 { 227,-1825 }, { 228,-1825 }, { 229,-1825 }, { 230,-1825 }, { 231,-1825 },

 { 232,-1825 }, { 233,-1825 }, { 234,-1825 }, { 235,-1825 }, { 236,-1825 },
 { 237,-1825 }, { 238,-1825 }, { 239,-1825 }, { 240,-1825 }, { 241,-1825 },
 { 242,-1825 }, { 243,-1825 }, { 244,-1825 }, { 245,-1825 }, { 246,-1825 },
 { 247,-1825 }, { 248,-1825 }, { 249,-1825 }, { 250,-1825 }, { 251,-1825 },
 { 252,-1825 }, { 253,-1825 }, { 254,-1825 }, { 255,-1825 }, { 256,-1825 },
 {   0,  47 }, {   0,8751 }, {   1,-2083 }, {   2,-2083 }, {   3,-2083 },
 {   4,-2083 }, {   5,-2083 }, {   6,-2083 }, {   7,-2083 }, {   8,-2083 },
 {   0,   0 }, {   0,   0 }, {  11,-2083 }, {   0,   0 }, {   0,   0 },
 {  14,-2083 }, {  15,-2083 }, {  16,-2083 }, {  17,-2083 }, {  18,-2083 },
 {  19,-2083 }, {  20,-2083 }, {  21,-2083 }, {  22,-2083 }, {  23,-2083 },

 {  24,-2083 }, {  25,-2083 }, {  26,-2083 }, {  27,-2083 }, {  28,-2083 },
 {  29,-2083 }, {  30,-2083 }, {  31,-2083 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-2083 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,3142 },
 {  49,3142 }, {  50,3142 }, {  51,3142 }, {  52,3142 }, {  53,3142 },
 {  54,3142 }, {  55,3142 }, {  56,3142 }, {  57,3142 }, {   0,   0 },
 {  59,-2083 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,3142 }, {  66,3142 }, {  67,3142 }, {  68,3142 },
 {  69,3142 }, {  70,3142 }, {  71,-2083 }, {  72,-2083 }, {  73,-2083 },

 {  74,-2083 }, {  75,-2083 }, {  76,-2083 }, {  77,-2083 }, {  78,-2083 },
 {  79,-2083 }, {  80,-2083 }, {  81,-2083 }, {  82,-2083 }, {  83,-2083 },
 {  84,-2083 }, {  85,-2083 }, {  86,-2083 }, {  87,-2083 }, {  88,-2083 },
 {  89,-2083 }, {  90,-2083 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,-2083 }, {  95,-2083 }, {  96,-2083 }, {  97,3142 }, {  98,3142 },
 {  99,3142 }, { 100,3142 }, { 101,3142 }, { 102,3142 }, { 103,-2083 },
 { 104,-2083 }, { 105,-2083 }, { 106,-2083 }, { 107,-2083 }, { 108,-2083 },
 { 109,-2083 }, { 110,-2083 }, { 111,-2083 }, { 112,-2083 }, { 113,-2083 },
 { 114,-2083 }, { 115,-2083 }, { 116,-2083 }, { 117,-2083 }, { 118,-2083 },
 { 119,-2083 }, { 120,-2083 }, { 121,-2083 }, { 122,-2083 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 126,-2083 }, { 127,-2083 }, { 128,-2083 },
 { 129,-2083 }, { 130,-2083 }, { 131,-2083 }, { 132,-2083 }, { 133,-2083 },
 { 134,-2083 }, { 135,-2083 }, { 136,-2083 }, { 137,-2083 }, { 138,-2083 },
 { 139,-2083 }, { 140,-2083 }, { 141,-2083 }, { 142,-2083 }, { 143,-2083 },
 { 144,-2083 }, { 145,-2083 }, { 146,-2083 }, { 147,-2083 }, { 148,-2083 },
 { 149,-2083 }, { 150,-2083 }, { 151,-2083 }, { 152,-2083 }, { 153,-2083 },
 { 154,-2083 }, { 155,-2083 }, { 156,-2083 }, { 157,-2083 }, { 158,-2083 },
 { 159,-2083 }, { 160,-2083 }, { 161,-2083 }, { 162,-2083 }, { 163,-2083 },
 { 164,-2083 }, { 165,-2083 }, { 166,-2083 }, { 167,-2083 }, { 168,-2083 },
 { 169,-2083 }, { 170,-2083 }, { 171,-2083 }, { 172,-2083 }, { 173,-2083 },

 { 174,-2083 }, { 175,-2083 }, { 176,-2083 }, { 177,-2083 }, { 178,-2083 },
 { 179,-2083 }, { 180,-2083 }, { 181,-2083 }, { 182,-2083 }, { 183,-2083 },
 { 184,-2083 }, { 185,-2083 }, { 186,-2083 }, { 187,-2083 }, { 188,-2083 },
 { 189,-2083 }, { 190,-2083 }, { 191,-2083 }, { 192,-2083 }, { 193,-2083 },
 { 194,-2083 }, { 195,-2083 }, { 196,-2083 }, { 197,-2083 }, { 198,-2083 },
 { 199,-2083 }, { 200,-2083 }, { 201,-2083 }, { 202,-2083 }, { 203,-2083 },
 { 204,-2083 }, { 205,-2083 }, { 206,-2083 }, { 207,-2083 }, { 208,-2083 },
 { 209,-2083 }, { 210,-2083 }, { 211,-2083 }, { 212,-2083 }, { 213,-2083 },
 { 214,-2083 }, { 215,-2083 }, { 216,-2083 }, { 217,-2083 }, { 218,-2083 },
 { 219,-2083 }, { 220,-2083 }, { 221,-2083 }, { 222,-2083 }, { 223,-2083 },

 { 224,-2083 }, { 225,-2083 }, { 226,-2083 }, { 227,-2083 }, { 228,-2083 },
 { 229,-2083 }, { 230,-2083 }, { 231,-2083 }, { 232,-2083 }, { 233,-2083 },
 { 234,-2083 }, { 235,-2083 }, { 236,-2083 }, { 237,-2083 }, { 238,-2083 },
 { 239,-2083 }, { 240,-2083 }, { 241,-2083 }, { 242,-2083 }, { 243,-2083 },
 { 244,-2083 }, { 245,-2083 }, { 246,-2083 }, { 247,-2083 }, { 248,-2083 },
 { 249,-2083 }, { 250,-2083 }, { 251,-2083 }, { 252,-2083 }, { 253,-2083 },
 { 254,-2083 }, { 255,-2083 }, { 256,-2083 }, {   0,  42 }, {   0,8493 },
 {   1,-1548 }, {   2,-1548 }, {   3,-1548 }, {   4,-1548 }, {   5,-1548 },
 {   6,-1548 }, {   7,-1548 }, {   8,-1548 }, {   0,   0 }, {   0,   0 },
 {  11,-1548 }, {   0,   0 }, {   0,   0 }, {  14,-1548 }, {  15,-1548 },

 {  16,-1548 }, {  17,-1548 }, {  18,-1548 }, {  19,-1548 }, {  20,-1548 },
 {  21,-1548 }, {  22,-1548 }, {  23,-1548 }, {  24,-1548 }, {  25,-1548 },
 {  26,-1548 }, {  27,-1548 }, {  28,-1548 }, {  29,-1548 }, {  30,-1548 },
 {  31,-1548 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-1548 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  46,-1290 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {  59,-1548 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-1548 },

 {  66,-1548 }, {  67,-1548 }, {  68,-1548 }, {  69,-774 }, {  70,-1548 },
 {  71,-1548 }, {  72,-1548 }, {  73,-1548 }, {  74,-1548 }, {  75,-1548 },
 {  76,-1548 }, {  77,-1548 }, {  78,-1548 }, {  79,-1548 }, {  80,-1548 },
 {  81,-1548 }, {  82,-1548 }, {  83,-1548 }, {  84,-1548 }, {  85,-1548 },
 {  86,-1548 }, {  87,-1548 }, {  88,-1548 }, {  89,-1548 }, {  90,-1548 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-1548 }, {  95, 258 },
 {  96,-1548 }, {  97,-1548 }, {  98,-1548 }, {  99,-1548 }, { 100,-1548 },
 { 101,-774 }, { 102,-1548 }, { 103,-1548 }, { 104,-1548 }, { 105,-1548 },
 { 106,-1548 }, { 107,-1548 }, { 108,-1548 }, { 109,-1548 }, { 110,-1548 },
 { 111,-1548 }, { 112,-1548 }, { 113,-1548 }, { 114,-1548 }, { 115,-1548 },

 { 116,-1548 }, { 117,-1548 }, { 118,-1548 }, { 119,-1548 }, { 120,-1548 },
 { 121,-1548 }, { 122,-1548 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 126,-1548 }, { 127,-1548 }, { 128,-1548 }, { 129,-1548 }, { 130,-1548 },
 { 131,-1548 }, { 132,-1548 }, { 133,-1548 }, { 134,-1548 }, { 135,-1548 },
 { 136,-1548 }, { 137,-1548 }, { 138,-1548 }, { 139,-1548 }, { 140,-1548 },
 { 141,-1548 }, { 142,-1548 }, { 143,-1548 }, { 144,-1548 }, { 145,-1548 },
 { 146,-1548 }, { 147,-1548 }, { 148,-1548 }, { 149,-1548 }, { 150,-1548 },
 { 151,-1548 }, { 152,-1548 }, { 153,-1548 }, { 154,-1548 }, { 155,-1548 },
 { 156,-1548 }, { 157,-1548 }, { 158,-1548 }, { 159,-1548 }, { 160,-1548 },
 { 161,-1548 }, { 162,-1548 }, { 163,-1548 }, { 164,-1548 }, { 165,-1548 },

 { 166,-1548 }, { 167,-1548 }, { 168,-1548 }, { 169,-1548 }, { 170,-1548 },
 { 171,-1548 }, { 172,-1548 }, { 173,-1548 }, { 174,-1548 }, { 175,-1548 },
 { 176,-1548 }, { 177,-1548 }, { 178,-1548 }, { 179,-1548 }, { 180,-1548 },
 { 181,-1548 }, { 182,-1548 }, { 183,-1548 }, { 184,-1548 }, { 185,-1548 },
 { 186,-1548 }, { 187,-1548 }, { 188,-1548 }, { 189,-1548 }, { 190,-1548 },
 { 191,-1548 }, { 192,-1548 }, { 193,-1548 }, { 194,-1548 }, { 195,-1548 },
 { 196,-1548 }, { 197,-1548 }, { 198,-1548 }, { 199,-1548 }, { 200,-1548 },
 { 201,-1548 }, { 202,-1548 }, { 203,-1548 }, { 204,-1548 }, { 205,-1548 },
 { 206,-1548 }, { 207,-1548 }, { 208,-1548 }, { 209,-1548 }, { 210,-1548 },
 { 211,-1548 }, { 212,-1548 }, { 213,-1548 }, { 214,-1548 }, { 215,-1548 },

 { 216,-1548 }, { 217,-1548 }, { 218,-1548 }, { 219,-1548 }, { 220,-1548 },
 { 221,-1548 }, { 222,-1548 }, { 223,-1548 }, { 224,-1548 }, { 225,-1548 },
 { 226,-1548 }, { 227,-1548 }, { 228,-1548 }, { 229,-1548 }, { 230,-1548 },
 { 231,-1548 }, { 232,-1548 }, { 233,-1548 }, { 234,-1548 }, { 235,-1548 },
 { 236,-1548 }, { 237,-1548 }, { 238,-1548 }, { 239,-1548 }, { 240,-1548 },
 { 241,-1548 }, { 242,-1548 }, { 243,-1548 }, { 244,-1548 }, { 245,-1548 },
 { 246,-1548 }, { 247,-1548 }, { 248,-1548 }, { 249,-1548 }, { 250,-1548 },
 { 251,-1548 }, { 252,-1548 }, { 253,-1548 }, { 254,-1548 }, { 255,-1548 },
 { 256,-1548 }, {   0,  47 }, {   0,8235 }, {   1,-2599 }, {   2,-2599 },
 {   3,-2599 }, {   4,-2599 }, {   5,-2599 }, {   6,-2599 }, {   7,-2599 },

 {   8,-2599 }, {   0,   0 }, {   0,   0 }, {  11,-2599 }, {   0,   0 },
 {   0,   0 }, {  14,-2599 }, {  15,-2599 }, {  16,-2599 }, {  17,-2599 },
 {  18,-2599 }, {  19,-2599 }, {  20,-2599 }, {  21,-2599 }, {  22,-2599 },
 {  23,-2599 }, {  24,-2599 }, {  25,-2599 }, {  26,-2599 }, {  27,-2599 },
 {  28,-2599 }, {  29,-2599 }, {  30,-2599 }, {  31,-2599 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,-2599 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,2884 }, {  49,2884 }, {  50,2884 }, {  51,2884 }, {  52,2884 },
 {  53,2884 }, {  54,2884 }, {  55,2884 }, {  56,2884 }, {  57,2884 },

 {   0,   0 }, {  59,-2599 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-2599 }, {  66,-2599 }, {  67,-2599 },
 {  68,-2599 }, {  69,-2599 }, {  70,-2599 }, {  71,-2599 }, {  72,-2599 },
 {  73,-2599 }, {  74,-2599 }, {  75,-2599 }, {  76,-2599 }, {  77,-2599 },
 {  78,-2599 }, {  79,-2599 }, {  80,-2599 }, {  81,-2599 }, {  82,-2599 },
 {  83,-2599 }, {  84,-2599 }, {  85,-2599 }, {  86,-2599 }, {  87,-2599 },
 {  88,-2599 }, {  89,-2599 }, {  90,-2599 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,-2599 }, {  95,-2599 }, {  96,-2599 }, {  97,-2599 },
 {  98,-2599 }, {  99,-2599 }, { 100,-2599 }, { 101,-2599 }, { 102,-2599 },
 { 103,-2599 }, { 104,-2599 }, { 105,-2599 }, { 106,-2599 }, { 107,-2599 },

 { 108,-2599 }, { 109,-2599 }, { 110,-2599 }, { 111,-2599 }, { 112,-2599 },
 { 113,-2599 }, { 114,-2599 }, { 115,-2599 }, { 116,-2599 }, { 117,-2599 },
 { 118,-2599 }, { 119,-2599 }, { 120,-2599 }, { 121,-2599 }, { 122,-2599 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,-2599 }, { 127,-2599 },
 { 128,-2599 }, { 129,-2599 }, { 130,-2599 }, { 131,-2599 }, { 132,-2599 },
 { 133,-2599 }, { 134,-2599 }, { 135,-2599 }, { 136,-2599 }, { 137,-2599 },
 { 138,-2599 }, { 139,-2599 }, { 140,-2599 }, { 141,-2599 }, { 142,-2599 },
 { 143,-2599 }, { 144,-2599 }, { 145,-2599 }, { 146,-2599 }, { 147,-2599 },
 { 148,-2599 }, { 149,-2599 }, { 150,-2599 }, { 151,-2599 }, { 152,-2599 },
 { 153,-2599 }, { 154,-2599 }, { 155,-2599 }, { 156,-2599 }, { 157,-2599 },

 { 158,-2599 }, { 159,-2599 }, { 160,-2599 }, { 161,-2599 }, { 162,-2599 },
 { 163,-2599 }, { 164,-2599 }, { 165,-2599 }, { 166,-2599 }, { 167,-2599 },
 { 168,-2599 }, { 169,-2599 }, { 170,-2599 }, { 171,-2599 }, { 172,-2599 },
 { 173,-2599 }, { 174,-2599 }, { 175,-2599 }, { 176,-2599 }, { 177,-2599 },
 { 178,-2599 }, { 179,-2599 }, { 180,-2599 }, { 181,-2599 }, { 182,-2599 },
 { 183,-2599 }, { 184,-2599 }, { 185,-2599 }, { 186,-2599 }, { 187,-2599 },
 { 188,-2599 }, { 189,-2599 }, { 190,-2599 }, { 191,-2599 }, { 192,-2599 },
 { 193,-2599 }, { 194,-2599 }, { 195,-2599 }, { 196,-2599 }, { 197,-2599 },
 { 198,-2599 }, { 199,-2599 }, { 200,-2599 }, { 201,-2599 }, { 202,-2599 },
 { 203,-2599 }, { 204,-2599 }, { 205,-2599 }, { 206,-2599 }, { 207,-2599 },

 { 208,-2599 }, { 209,-2599 }, { 210,-2599 }, { 211,-2599 }, { 212,-2599 },
 { 213,-2599 }, { 214,-2599 }, { 215,-2599 }, { 216,-2599 }, { 217,-2599 },
 { 218,-2599 }, { 219,-2599 }, { 220,-2599 }, { 221,-2599 }, { 222,-2599 },
 { 223,-2599 }, { 224,-2599 }, { 225,-2599 }, { 226,-2599 }, { 227,-2599 },
 { 228,-2599 }, { 229,-2599 }, { 230,-2599 }, { 231,-2599 }, { 232,-2599 },
 { 233,-2599 }, { 234,-2599 }, { 235,-2599 }, { 236,-2599 }, { 237,-2599 },
 { 238,-2599 }, { 239,-2599 }, { 240,-2599 }, { 241,-2599 }, { 242,-2599 },
 { 243,-2599 }, { 244,-2599 }, { 245,-2599 }, { 246,-2599 }, { 247,-2599 },
 { 248,-2599 }, { 249,-2599 }, { 250,-2599 }, { 251,-2599 }, { 252,-2599 },
 { 253,-2599 }, { 254,-2599 }, { 255,-2599 }, { 256,-2599 }, {   0,  20 },

 {   0,7977 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {   0,   0 },
 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },

 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {   0,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },

 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },

 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },

 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },

 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,  13 }, {   0,7719 }, {   0,  15 },
 {   0,7717 }, {   0,  13 }, {   0,7715 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  14 }, {   0,7681 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,2626 }, {  49,2626 }, {  50,2626 }, {  51,2626 },
 {  52,2626 }, {  53,2626 }, {  54,2626 }, {  55,2626 }, {  56,2626 },
 {  57,2626 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2626 }, {  66,2626 },
 {  67,2626 }, {  68,2626 }, {  69,2626 }, {  70,2626 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,2649 },
 {  49,2649 }, {  50,2649 }, {  51,2649 }, {  52,2649 }, {  53,2649 },

 {  54,2649 }, {  55,2649 }, {  56,2649 }, {  57,2649 }, {   0,   0 },
 {  97,2626 }, {  98,2626 }, {  99,2626 }, { 100,2626 }, { 101,2626 },
 { 102,2626 }, {  65,2649 }, {  66,2649 }, {  67,2649 }, {  68,2649 },
 {  69,2649 }, {  70,2649 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 117,7421 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 123,2649 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 125,-3086 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,2649 }, {  98,2649 },
 {  99,2649 }, { 100,2649 }, { 101,2649 }, { 102,2649 }, {   0,   1 },

 {   0,7577 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   0,   0 },
 {   0,   0 }, {  11,   0 }, {   0,   0 }, {   0,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },

 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {  59,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },

 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },

 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },

 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },

 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,   2 }, {   0,7319 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 }, {   0,   0 },
 {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  32,   0 }, {   0,  22 }, {   0,7285 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },

 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },
 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 }, {   0,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },

 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },

 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },

 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },

 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  41 },

 {   0,7027 }, {   1,-4076 }, {   2,-4076 }, {   3,-4076 }, {   4,-4076 },
 {   5,-4076 }, {   6,-4076 }, {   7,-4076 }, {   8,-4076 }, {   0,   0 },
 {   0,   0 }, {  11,-4076 }, {   0,   0 }, {   0,   0 }, {  14,-4076 },
 {  15,-4076 }, {  16,-4076 }, {  17,-4076 }, {  18,-4076 }, {  19,-4076 },
 {  20,-4076 }, {  21,-4076 }, {  22,-4076 }, {  23,-4076 }, {  24,-4076 },
 {  25,-4076 }, {  26,-4076 }, {  27,-4076 }, {  28,-4076 }, {  29,-4076 },
 {  30,-4076 }, {  31,-4076 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-4076 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },

 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {  59,-4076 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-4076 }, {  66,-4076 }, {  67,-4076 }, {  68,-4076 }, {  69, 258 },
 {  70,-4076 }, {  71,-4076 }, {  72,-4076 }, {  73,-4076 }, {  74,-4076 },
 {  75,-4076 }, {  76,-4076 }, {  77,-4076 }, {  78,-4076 }, {  79,-4076 },
 {  80,-4076 }, {  81,-4076 }, {  82,-4076 }, {  83,-4076 }, {  84,-4076 },
 {  85,-4076 }, {  86,-4076 }, {  87,-4076 }, {  88,-4076 }, {  89,-4076 },
 {  90,-4076 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-4076 },
 {  95, 268 }, {  96,-4076 }, {  97,-4076 }, {  98,-4076 }, {  99,-4076 },

 { 100,-4076 }, { 101, 258 }, { 102,-4076 }, { 103,-4076 }, { 104,-4076 },
 { 105,-4076 }, { 106,-4076 }, { 107,-4076 }, { 108,-4076 }, { 109,-4076 },
 { 110,-4076 }, { 111,-4076 }, { 112,-4076 }, { 113,-4076 }, { 114,-4076 },
 { 115,-4076 }, { 116,-4076 }, { 117,-4076 }, { 118,-4076 }, { 119,-4076 },
 { 120,-4076 }, { 121,-4076 }, { 122,-4076 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 126,-4076 }, { 127,-4076 }, { 128,-4076 }, { 129,-4076 },
 { 130,-4076 }, { 131,-4076 }, { 132,-4076 }, { 133,-4076 }, { 134,-4076 },
 { 135,-4076 }, { 136,-4076 }, { 137,-4076 }, { 138,-4076 }, { 139,-4076 },
 { 140,-4076 }, { 141,-4076 }, { 142,-4076 }, { 143,-4076 }, { 144,-4076 },
 { 145,-4076 }, { 146,-4076 }, { 147,-4076 }, { 148,-4076 }, { 149,-4076 },

 { 150,-4076 }, { 151,-4076 }, { 152,-4076 }, { 153,-4076 }, { 154,-4076 },
 { 155,-4076 }, { 156,-4076 }, { 157,-4076 }, { 158,-4076 }, { 159,-4076 },
 { 160,-4076 }, { 161,-4076 }, { 162,-4076 }, { 163,-4076 }, { 164,-4076 },
 { 165,-4076 }, { 166,-4076 }, { 167,-4076 }, { 168,-4076 }, { 169,-4076 },
 { 170,-4076 }, { 171,-4076 }, { 172,-4076 }, { 173,-4076 }, { 174,-4076 },
 { 175,-4076 }, { 176,-4076 }, { 177,-4076 }, { 178,-4076 }, { 179,-4076 },
 { 180,-4076 }, { 181,-4076 }, { 182,-4076 }, { 183,-4076 }, { 184,-4076 },
 { 185,-4076 }, { 186,-4076 }, { 187,-4076 }, { 188,-4076 }, { 189,-4076 },
 { 190,-4076 }, { 191,-4076 }, { 192,-4076 }, { 193,-4076 }, { 194,-4076 },
 { 195,-4076 }, { 196,-4076 }, { 197,-4076 }, { 198,-4076 }, { 199,-4076 },

 { 200,-4076 }, { 201,-4076 }, { 202,-4076 }, { 203,-4076 }, { 204,-4076 },
 { 205,-4076 }, { 206,-4076 }, { 207,-4076 }, { 208,-4076 }, { 209,-4076 },
 { 210,-4076 }, { 211,-4076 }, { 212,-4076 }, { 213,-4076 }, { 214,-4076 },
 { 215,-4076 }, { 216,-4076 }, { 217,-4076 }, { 218,-4076 }, { 219,-4076 },
 { 220,-4076 }, { 221,-4076 }, { 222,-4076 }, { 223,-4076 }, { 224,-4076 },
 { 225,-4076 }, { 226,-4076 }, { 227,-4076 }, { 228,-4076 }, { 229,-4076 },
 { 230,-4076 }, { 231,-4076 }, { 232,-4076 }, { 233,-4076 }, { 234,-4076 },
 { 235,-4076 }, { 236,-4076 }, { 237,-4076 }, { 238,-4076 }, { 239,-4076 },
 { 240,-4076 }, { 241,-4076 }, { 242,-4076 }, { 243,-4076 }, { 244,-4076 },
 { 245,-4076 }, { 246,-4076 }, { 247,-4076 }, { 248,-4076 }, { 249,-4076 },

 { 250,-4076 }, { 251,-4076 }, { 252,-4076 }, { 253,-4076 }, { 254,-4076 },
 { 255,-4076 }, { 256,-4076 }, {   0,  48 }, {   0,6769 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  48 }, {   0,6759 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  43, 585 }, {   0,   0 }, {  45, 585 }, {   0,   0 },
 {   0,   0 }, {  48,1841 }, {  49,1841 }, {  50,1841 }, {  51,1841 },
 {  52,1841 }, {  53,1841 }, {  54,1841 }, {  55,1841 }, {  56,1841 },
 {  57,1841 }, {  48,2089 }, {  49,2089 }, {  50,2089 }, {  51,2089 },
 {  52,2089 }, {  53,2089 }, {  54,2089 }, {  55,2089 }, {  56,2089 },
 {  57,2089 }, {   0,  41 }, {   0,6700 }, {   1,-4403 }, {   2,-4403 },
 {   3,-4403 }, {   4,-4403 }, {   5,-4403 }, {   6,-4403 }, {   7,-4403 },
 {   8,-4403 }, {   0,   0 }, {   0,   0 }, {  11,-4403 }, {   0,   0 },
 {   0,   0 }, {  14,-4403 }, {  15,-4403 }, {  16,-4403 }, {  17,-4403 },
 {  18,-4403 }, {  19,-4403 }, {  20,-4403 }, {  21,-4403 }, {  22,-4403 },

 {  23,-4403 }, {  24,-4403 }, {  25,-4403 }, {  26,-4403 }, {  27,-4403 },
 {  28,-4403 }, {  29,-4403 }, {  30,-4403 }, {  31,-4403 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,-4403 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,2288 }, {  49,2288 }, {  50,2288 }, {  51,2288 }, {  52,2288 },
 {  53,2288 }, {  54,2288 }, {  55,2288 }, {  56,2288 }, {  57,2288 },
 {   0,   0 }, {  59,-4403 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-4403 }, {  66,-4403 }, {  67,-4403 },
 {  68,-4403 }, {  69, -69 }, {  70,-4403 }, {  71,-4403 }, {  72,-4403 },

 {  73,-4403 }, {  74,-4403 }, {  75,-4403 }, {  76,-4403 }, {  77,-4403 },
 {  78,-4403 }, {  79,-4403 }, {  80,-4403 }, {  81,-4403 }, {  82,-4403 },
 {  83,-4403 }, {  84,-4403 }, {  85,-4403 }, {  86,-4403 }, {  87,-4403 },
 {  88,-4403 }, {  89,-4403 }, {  90,-4403 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,-4403 }, {  95,2546 }, {  96,-4403 }, {  97,-4403 },
 {  98,-4403 }, {  99,-4403 }, { 100,-4403 }, { 101, -69 }, { 102,-4403 },
 { 103,-4403 }, { 104,-4403 }, { 105,-4403 }, { 106,-4403 }, { 107,-4403 },
 { 108,-4403 }, { 109,-4403 }, { 110,-4403 }, { 111,-4403 }, { 112,-4403 },
 { 113,-4403 }, { 114,-4403 }, { 115,-4403 }, { 116,-4403 }, { 117,-4403 },
 { 118,-4403 }, { 119,-4403 }, { 120,-4403 }, { 121,-4403 }, { 122,-4403 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,-4403 }, { 127,-4403 },
 { 128,-4403 }, { 129,-4403 }, { 130,-4403 }, { 131,-4403 }, { 132,-4403 },
 { 133,-4403 }, { 134,-4403 }, { 135,-4403 }, { 136,-4403 }, { 137,-4403 },
 { 138,-4403 }, { 139,-4403 }, { 140,-4403 }, { 141,-4403 }, { 142,-4403 },
 { 143,-4403 }, { 144,-4403 }, { 145,-4403 }, { 146,-4403 }, { 147,-4403 },
 { 148,-4403 }, { 149,-4403 }, { 150,-4403 }, { 151,-4403 }, { 152,-4403 },
 { 153,-4403 }, { 154,-4403 }, { 155,-4403 }, { 156,-4403 }, { 157,-4403 },
 { 158,-4403 }, { 159,-4403 }, { 160,-4403 }, { 161,-4403 }, { 162,-4403 },
 { 163,-4403 }, { 164,-4403 }, { 165,-4403 }, { 166,-4403 }, { 167,-4403 },
 { 168,-4403 }, { 169,-4403 }, { 170,-4403 }, { 171,-4403 }, { 172,-4403 },

 { 173,-4403 }, { 174,-4403 }, { 175,-4403 }, { 176,-4403 }, { 177,-4403 },
 { 178,-4403 }, { 179,-4403 }, { 180,-4403 }, { 181,-4403 }, { 182,-4403 },
 { 183,-4403 }, { 184,-4403 }, { 185,-4403 }, { 186,-4403 }, { 187,-4403 },
 { 188,-4403 }, { 189,-4403 }, { 190,-4403 }, { 191,-4403 }, { 192,-4403 },
 { 193,-4403 }, { 194,-4403 }, { 195,-4403 }, { 196,-4403 }, { 197,-4403 },
 { 198,-4403 }, { 199,-4403 }, { 200,-4403 }, { 201,-4403 }, { 202,-4403 },
 { 203,-4403 }, { 204,-4403 }, { 205,-4403 }, { 206,-4403 }, { 207,-4403 },
 { 208,-4403 }, { 209,-4403 }, { 210,-4403 }, { 211,-4403 }, { 212,-4403 },
 { 213,-4403 }, { 214,-4403 }, { 215,-4403 }, { 216,-4403 }, { 217,-4403 },
 { 218,-4403 }, { 219,-4403 }, { 220,-4403 }, { 221,-4403 }, { 222,-4403 },

 { 223,-4403 }, { 224,-4403 }, { 225,-4403 }, { 226,-4403 }, { 227,-4403 },
 { 228,-4403 }, { 229,-4403 }, { 230,-4403 }, { 231,-4403 }, { 232,-4403 },
 { 233,-4403 }, { 234,-4403 }, { 235,-4403 }, { 236,-4403 }, { 237,-4403 },
 { 238,-4403 }, { 239,-4403 }, { 240,-4403 }, { 241,-4403 }, { 242,-4403 },
 { 243,-4403 }, { 244,-4403 }, { 245,-4403 }, { 246,-4403 }, { 247,-4403 },
 { 248,-4403 }, { 249,-4403 }, { 250,-4403 }, { 251,-4403 }, { 252,-4403 },
 { 253,-4403 }, { 254,-4403 }, { 255,-4403 }, { 256,-4403 }, {   0,  45 },
 {   0,6442 }, {   1,-4392 }, {   2,-4392 }, {   3,-4392 }, {   4,-4392 },
 {   5,-4392 }, {   6,-4392 }, {   7,-4392 }, {   8,-4392 }, {   0,   0 },
 {   0,   0 }, {  11,-4392 }, {   0,   0 }, {   0,   0 }, {  14,-4392 },

 {  15,-4392 }, {  16,-4392 }, {  17,-4392 }, {  18,-4392 }, {  19,-4392 },
 {  20,-4392 }, {  21,-4392 }, {  22,-4392 }, {  23,-4392 }, {  24,-4392 },
 {  25,-4392 }, {  26,-4392 }, {  27,-4392 }, {  28,-4392 }, {  29,-4392 },
 {  30,-4392 }, {  31,-4392 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-4392 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,2347 }, {  49,2347 },
 {  50,-4392 }, {  51,-4392 }, {  52,-4392 }, {  53,-4392 }, {  54,-4392 },
 {  55,-4392 }, {  56,-4392 }, {  57,-4392 }, {   0,   0 }, {  59,-4392 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  65,-4392 }, {  66,-4392 }, {  67,-4392 }, {  68,-4392 }, {  69,-4392 },
 {  70,-4392 }, {  71,-4392 }, {  72,-4392 }, {  73,-4392 }, {  74,-4392 },
 {  75,-4392 }, {  76,-4392 }, {  77,-4392 }, {  78,-4392 }, {  79,-4392 },
 {  80,-4392 }, {  81,-4392 }, {  82,-4392 }, {  83,-4392 }, {  84,-4392 },
 {  85,-4392 }, {  86,-4392 }, {  87,-4392 }, {  88,-4392 }, {  89,-4392 },
 {  90,-4392 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-4392 },
 {  95,2605 }, {  96,-4392 }, {  97,-4392 }, {  98,-4392 }, {  99,-4392 },
 { 100,-4392 }, { 101,-4392 }, { 102,-4392 }, { 103,-4392 }, { 104,-4392 },
 { 105,-4392 }, { 106,-4392 }, { 107,-4392 }, { 108,-4392 }, { 109,-4392 },
 { 110,-4392 }, { 111,-4392 }, { 112,-4392 }, { 113,-4392 }, { 114,-4392 },

 { 115,-4392 }, { 116,-4392 }, { 117,-4392 }, { 118,-4392 }, { 119,-4392 },
 { 120,-4392 }, { 121,-4392 }, { 122,-4392 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 126,-4392 }, { 127,-4392 }, { 128,-4392 }, { 129,-4392 },
 { 130,-4392 }, { 131,-4392 }, { 132,-4392 }, { 133,-4392 }, { 134,-4392 },
 { 135,-4392 }, { 136,-4392 }, { 137,-4392 }, { 138,-4392 }, { 139,-4392 },
 { 140,-4392 }, { 141,-4392 }, { 142,-4392 }, { 143,-4392 }, { 144,-4392 },
 { 145,-4392 }, { 146,-4392 }, { 147,-4392 }, { 148,-4392 }, { 149,-4392 },
 { 150,-4392 }, { 151,-4392 }, { 152,-4392 }, { 153,-4392 }, { 154,-4392 },
 { 155,-4392 }, { 156,-4392 }, { 157,-4392 }, { 158,-4392 }, { 159,-4392 },
 { 160,-4392 }, { 161,-4392 }, { 162,-4392 }, { 163,-4392 }, { 164,-4392 },

 { 165,-4392 }, { 166,-4392 }, { 167,-4392 }, { 168,-4392 }, { 169,-4392 },
 { 170,-4392 }, { 171,-4392 }, { 172,-4392 }, { 173,-4392 }, { 174,-4392 },
 { 175,-4392 }, { 176,-4392 }, { 177,-4392 }, { 178,-4392 }, { 179,-4392 },
 { 180,-4392 }, { 181,-4392 }, { 182,-4392 }, { 183,-4392 }, { 184,-4392 },
 { 185,-4392 }, { 186,-4392 }, { 187,-4392 }, { 188,-4392 }, { 189,-4392 },
 { 190,-4392 }, { 191,-4392 }, { 192,-4392 }, { 193,-4392 }, { 194,-4392 },
 { 195,-4392 }, { 196,-4392 }, { 197,-4392 }, { 198,-4392 }, { 199,-4392 },
 { 200,-4392 }, { 201,-4392 }, { 202,-4392 }, { 203,-4392 }, { 204,-4392 },
 { 205,-4392 }, { 206,-4392 }, { 207,-4392 }, { 208,-4392 }, { 209,-4392 },
 { 210,-4392 }, { 211,-4392 }, { 212,-4392 }, { 213,-4392 }, { 214,-4392 },

 { 215,-4392 }, { 216,-4392 }, { 217,-4392 }, { 218,-4392 }, { 219,-4392 },
 { 220,-4392 }, { 221,-4392 }, { 222,-4392 }, { 223,-4392 }, { 224,-4392 },
 { 225,-4392 }, { 226,-4392 }, { 227,-4392 }, { 228,-4392 }, { 229,-4392 },
 { 230,-4392 }, { 231,-4392 }, { 232,-4392 }, { 233,-4392 }, { 234,-4392 },
 { 235,-4392 }, { 236,-4392 }, { 237,-4392 }, { 238,-4392 }, { 239,-4392 },
 { 240,-4392 }, { 241,-4392 }, { 242,-4392 }, { 243,-4392 }, { 244,-4392 },
 { 245,-4392 }, { 246,-4392 }, { 247,-4392 }, { 248,-4392 }, { 249,-4392 },
 { 250,-4392 }, { 251,-4392 }, { 252,-4392 }, { 253,-4392 }, { 254,-4392 },
 { 255,-4392 }, { 256,-4392 }, {   0,  46 }, {   0,6184 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,1256 }, {  49,1256 }, {  50,1256 }, {  51,1256 },
 {  52,1256 }, {  53,1256 }, {  54,1256 }, {  55,1256 }, {  56,1256 },

 {  57,1256 }, {   0,  40 }, {   0,6125 }, {   1,2546 }, {   2,2546 },
 {   3,2546 }, {   4,2546 }, {   5,2546 }, {   6,2546 }, {   7,2546 },
 {   8,2546 }, {   0,   0 }, {   0,   0 }, {  11,2546 }, {   0,   0 },
 {   0,   0 }, {  14,2546 }, {  15,2546 }, {  16,2546 }, {  17,2546 },
 {  18,2546 }, {  19,2546 }, {  20,2546 }, {  21,2546 }, {  22,2546 },
 {  23,2546 }, {  24,2546 }, {  25,2546 }, {  26,2546 }, {  27,2546 },
 {  28,2546 }, {  29,2546 }, {  30,2546 }, {  31,2546 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,2546 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,2804 }, {  49,2804 }, {  50,2804 }, {  51,2804 }, {  52,2804 },
 {  53,2804 }, {  54,2804 }, {  55,2804 }, {  56,2804 }, {  57,2804 },
 {   0,   0 }, {  59,2546 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,2546 }, {  66,2546 }, {  67,2546 },
 {  68,2546 }, {  69,2546 }, {  70,2546 }, {  71,2546 }, {  72,2546 },
 {  73,2546 }, {  74,2546 }, {  75,2546 }, {  76,2546 }, {  77,2546 },
 {  78,2546 }, {  79,2546 }, {  80,2546 }, {  81,2546 }, {  82,2546 },
 {  83,2546 }, {  84,2546 }, {  85,2546 }, {  86,2546 }, {  87,2546 },
 {  88,2546 }, {  89,2546 }, {  90,2546 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,2546 }, {  95,3062 }, {  96,2546 }, {  97,2546 },

 {  98,2546 }, {  99,2546 }, { 100,2546 }, { 101,2546 }, { 102,2546 },
 { 103,2546 }, { 104,2546 }, { 105,2546 }, { 106,2546 }, { 107,2546 },
 { 108,2546 }, { 109,2546 }, { 110,2546 }, { 111,2546 }, { 112,2546 },
 { 113,2546 }, { 114,2546 }, { 115,2546 }, { 116,2546 }, { 117,2546 },
 { 118,2546 }, { 119,2546 }, { 120,2546 }, { 121,2546 }, { 122,2546 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,2546 }, { 127,2546 },
 { 128,2546 }, { 129,2546 }, { 130,2546 }, { 131,2546 }, { 132,2546 },
 { 133,2546 }, { 134,2546 }, { 135,2546 }, { 136,2546 }, { 137,2546 },
 { 138,2546 }, { 139,2546 }, { 140,2546 }, { 141,2546 }, { 142,2546 },
 { 143,2546 }, { 144,2546 }, { 145,2546 }, { 146,2546 }, { 147,2546 },

 { 148,2546 }, { 149,2546 }, { 150,2546 }, { 151,2546 }, { 152,2546 },
 { 153,2546 }, { 154,2546 }, { 155,2546 }, { 156,2546 }, { 157,2546 },
 { 158,2546 }, { 159,2546 }, { 160,2546 }, { 161,2546 }, { 162,2546 },
 { 163,2546 }, { 164,2546 }, { 165,2546 }, { 166,2546 }, { 167,2546 },
 { 168,2546 }, { 169,2546 }, { 170,2546 }, { 171,2546 }, { 172,2546 },
 { 173,2546 }, { 174,2546 }, { 175,2546 }, { 176,2546 }, { 177,2546 },
 { 178,2546 }, { 179,2546 }, { 180,2546 }, { 181,2546 }, { 182,2546 },
 { 183,2546 }, { 184,2546 }, { 185,2546 }, { 186,2546 }, { 187,2546 },
 { 188,2546 }, { 189,2546 }, { 190,2546 }, { 191,2546 }, { 192,2546 },
 { 193,2546 }, { 194,2546 }, { 195,2546 }, { 196,2546 }, { 197,2546 },

 { 198,2546 }, { 199,2546 }, { 200,2546 }, { 201,2546 }, { 202,2546 },
 { 203,2546 }, { 204,2546 }, { 205,2546 }, { 206,2546 }, { 207,2546 },
 { 208,2546 }, { 209,2546 }, { 210,2546 }, { 211,2546 }, { 212,2546 },
 { 213,2546 }, { 214,2546 }, { 215,2546 }, { 216,2546 }, { 217,2546 },
 { 218,2546 }, { 219,2546 }, { 220,2546 }, { 221,2546 }, { 222,2546 },
 { 223,2546 }, { 224,2546 }, { 225,2546 }, { 226,2546 }, { 227,2546 },
 { 228,2546 }, { 229,2546 }, { 230,2546 }, { 231,2546 }, { 232,2546 },
 { 233,2546 }, { 234,2546 }, { 235,2546 }, { 236,2546 }, { 237,2546 },
 { 238,2546 }, { 239,2546 }, { 240,2546 }, { 241,2546 }, { 242,2546 },
 { 243,2546 }, { 244,2546 }, { 245,2546 }, { 246,2546 }, { 247,2546 },

 { 248,2546 }, { 249,2546 }, { 250,2546 }, { 251,2546 }, { 252,2546 },
 { 253,2546 }, { 254,2546 }, { 255,2546 }, { 256,2546 }, {   0,  44 },
 {   0,5867 }, {   1,-4967 }, {   2,-4967 }, {   3,-4967 }, {   4,-4967 },
 {   5,-4967 }, {   6,-4967 }, {   7,-4967 }, {   8,-4967 }, {   0,   0 },
 {   0,   0 }, {  11,-4967 }, {   0,   0 }, {   0,   0 }, {  14,-4967 },
 {  15,-4967 }, {  16,-4967 }, {  17,-4967 }, {  18,-4967 }, {  19,-4967 },
 {  20,-4967 }, {  21,-4967 }, {  22,-4967 }, {  23,-4967 }, {  24,-4967 },
 {  25,-4967 }, {  26,-4967 }, {  27,-4967 }, {  28,-4967 }, {  29,-4967 },
 {  30,-4967 }, {  31,-4967 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-4967 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,3062 }, {  49,3062 },
 {  50,3062 }, {  51,3062 }, {  52,3062 }, {  53,3062 }, {  54,3062 },
 {  55,3062 }, {  56,-4967 }, {  57,-4967 }, {   0,   0 }, {  59,-4967 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-4967 }, {  66,-4967 }, {  67,-4967 }, {  68,-4967 }, {  69,-4967 },
 {  70,-4967 }, {  71,-4967 }, {  72,-4967 }, {  73,-4967 }, {  74,-4967 },
 {  75,-4967 }, {  76,-4967 }, {  77,-4967 }, {  78,-4967 }, {  79,-4967 },
 {  80,-4967 }, {  81,-4967 }, {  82,-4967 }, {  83,-4967 }, {  84,-4967 },
 {  85,-4967 }, {  86,-4967 }, {  87,-4967 }, {  88,-4967 }, {  89,-4967 },

 {  90,-4967 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-4967 },
 {  95,3320 }, {  96,-4967 }, {  97,-4967 }, {  98,-4967 }, {  99,-4967 },
 { 100,-4967 }, { 101,-4967 }, { 102,-4967 }, { 103,-4967 }, { 104,-4967 },
 { 105,-4967 }, { 106,-4967 }, { 107,-4967 }, { 108,-4967 }, { 109,-4967 },
 { 110,-4967 }, { 111,-4967 }, { 112,-4967 }, { 113,-4967 }, { 114,-4967 },
 { 115,-4967 }, { 116,-4967 }, { 117,-4967 }, { 118,-4967 }, { 119,-4967 },
 { 120,-4967 }, { 121,-4967 }, { 122,-4967 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 126,-4967 }, { 127,-4967 }, { 128,-4967 }, { 129,-4967 },
 { 130,-4967 }, { 131,-4967 }, { 132,-4967 }, { 133,-4967 }, { 134,-4967 },
 { 135,-4967 }, { 136,-4967 }, { 137,-4967 }, { 138,-4967 }, { 139,-4967 },

 { 140,-4967 }, { 141,-4967 }, { 142,-4967 }, { 143,-4967 }, { 144,-4967 },
 { 145,-4967 }, { 146,-4967 }, { 147,-4967 }, { 148,-4967 }, { 149,-4967 },
 { 150,-4967 }, { 151,-4967 }, { 152,-4967 }, { 153,-4967 }, { 154,-4967 },
 { 155,-4967 }, { 156,-4967 }, { 157,-4967 }, { 158,-4967 }, { 159,-4967 },
 { 160,-4967 }, { 161,-4967 }, { 162,-4967 }, { 163,-4967 }, { 164,-4967 },
 { 165,-4967 }, { 166,-4967 }, { 167,-4967 }, { 168,-4967 }, { 169,-4967 },
 { 170,-4967 }, { 171,-4967 }, { 172,-4967 }, { 173,-4967 }, { 174,-4967 },
 { 175,-4967 }, { 176,-4967 }, { 177,-4967 }, { 178,-4967 }, { 179,-4967 },
 { 180,-4967 }, { 181,-4967 }, { 182,-4967 }, { 183,-4967 }, { 184,-4967 },
 { 185,-4967 }, { 186,-4967 }, { 187,-4967 }, { 188,-4967 }, { 189,-4967 },

 { 190,-4967 }, { 191,-4967 }, { 192,-4967 }, { 193,-4967 }, { 194,-4967 },
 { 195,-4967 }, { 196,-4967 }, { 197,-4967 }, { 198,-4967 }, { 199,-4967 },
 { 200,-4967 }, { 201,-4967 }, { 202,-4967 }, { 203,-4967 }, { 204,-4967 },
 { 205,-4967 }, { 206,-4967 }, { 207,-4967 }, { 208,-4967 }, { 209,-4967 },
 { 210,-4967 }, { 211,-4967 }, { 212,-4967 }, { 213,-4967 }, { 214,-4967 },
 { 215,-4967 }, { 216,-4967 }, { 217,-4967 }, { 218,-4967 }, { 219,-4967 },
 { 220,-4967 }, { 221,-4967 }, { 222,-4967 }, { 223,-4967 }, { 224,-4967 },
 { 225,-4967 }, { 226,-4967 }, { 227,-4967 }, { 228,-4967 }, { 229,-4967 },
 { 230,-4967 }, { 231,-4967 }, { 232,-4967 }, { 233,-4967 }, { 234,-4967 },
 { 235,-4967 }, { 236,-4967 }, { 237,-4967 }, { 238,-4967 }, { 239,-4967 },

 { 240,-4967 }, { 241,-4967 }, { 242,-4967 }, { 243,-4967 }, { 244,-4967 },
 { 245,-4967 }, { 246,-4967 }, { 247,-4967 }, { 248,-4967 }, { 249,-4967 },
 { 250,-4967 }, { 251,-4967 }, { 252,-4967 }, { 253,-4967 }, { 254,-4967 },
 { 255,-4967 }, { 256,-4967 }, {   0,  43 }, {   0,5609 }, {   1,-5225 },
 {   2,-5225 }, {   3,-5225 }, {   4,-5225 }, {   5,-5225 }, {   6,-5225 },
 {   7,-5225 }, {   8,-5225 }, {   0,   0 }, {   0,   0 }, {  11,-5225 },
 {   0,   0 }, {   0,   0 }, {  14,-5225 }, {  15,-5225 }, {  16,-5225 },
 {  17,-5225 }, {  18,-5225 }, {  19,-5225 }, {  20,-5225 }, {  21,-5225 },
 {  22,-5225 }, {  23,-5225 }, {  24,-5225 }, {  25,-5225 }, {  26,-5225 },
 {  27,-5225 }, {  28,-5225 }, {  29,-5225 }, {  30,-5225 }, {  31,-5225 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-5225 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,3320 }, {  49,3320 }, {  50,3320 }, {  51,3320 },
 {  52,3320 }, {  53,3320 }, {  54,3320 }, {  55,3320 }, {  56,3320 },
 {  57,3320 }, {   0,   0 }, {  59,-5225 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3320 }, {  66,3320 },
 {  67,3320 }, {  68,3320 }, {  69,3320 }, {  70,3320 }, {  71,-5225 },
 {  72,-5225 }, {  73,-5225 }, {  74,-5225 }, {  75,-5225 }, {  76,-5225 },
 {  77,-5225 }, {  78,-5225 }, {  79,-5225 }, {  80,-5225 }, {  81,-5225 },

 {  82,-5225 }, {  83,-5225 }, {  84,-5225 }, {  85,-5225 }, {  86,-5225 },
 {  87,-5225 }, {  88,-5225 }, {  89,-5225 }, {  90,-5225 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,-5225 }, {  95,3578 }, {  96,-5225 },
 {  97,3320 }, {  98,3320 }, {  99,3320 }, { 100,3320 }, { 101,3320 },
 { 102,3320 }, { 103,-5225 }, { 104,-5225 }, { 105,-5225 }, { 106,-5225 },
 { 107,-5225 }, { 108,-5225 }, { 109,-5225 }, { 110,-5225 }, { 111,-5225 },
 { 112,-5225 }, { 113,-5225 }, { 114,-5225 }, { 115,-5225 }, { 116,-5225 },
 { 117,-5225 }, { 118,-5225 }, { 119,-5225 }, { 120,-5225 }, { 121,-5225 },
 { 122,-5225 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,-5225 },
 { 127,-5225 }, { 128,-5225 }, { 129,-5225 }, { 130,-5225 }, { 131,-5225 },

 { 132,-5225 }, { 133,-5225 }, { 134,-5225 }, { 135,-5225 }, { 136,-5225 },
 { 137,-5225 }, { 138,-5225 }, { 139,-5225 }, { 140,-5225 }, { 141,-5225 },
 { 142,-5225 }, { 143,-5225 }, { 144,-5225 }, { 145,-5225 }, { 146,-5225 },
 { 147,-5225 }, { 148,-5225 }, { 149,-5225 }, { 150,-5225 }, { 151,-5225 },
 { 152,-5225 }, { 153,-5225 }, { 154,-5225 }, { 155,-5225 }, { 156,-5225 },
 { 157,-5225 }, { 158,-5225 }, { 159,-5225 }, { 160,-5225 }, { 161,-5225 },
 { 162,-5225 }, { 163,-5225 }, { 164,-5225 }, { 165,-5225 }, { 166,-5225 },
 { 167,-5225 }, { 168,-5225 }, { 169,-5225 }, { 170,-5225 }, { 171,-5225 },
 { 172,-5225 }, { 173,-5225 }, { 174,-5225 }, { 175,-5225 }, { 176,-5225 },
 { 177,-5225 }, { 178,-5225 }, { 179,-5225 }, { 180,-5225 }, { 181,-5225 },

 { 182,-5225 }, { 183,-5225 }, { 184,-5225 }, { 185,-5225 }, { 186,-5225 },
 { 187,-5225 }, { 188,-5225 }, { 189,-5225 }, { 190,-5225 }, { 191,-5225 },
 { 192,-5225 }, { 193,-5225 }, { 194,-5225 }, { 195,-5225 }, { 196,-5225 },
 { 197,-5225 }, { 198,-5225 }, { 199,-5225 }, { 200,-5225 }, { 201,-5225 },
 { 202,-5225 }, { 203,-5225 }, { 204,-5225 }, { 205,-5225 }, { 206,-5225 },
 { 207,-5225 }, { 208,-5225 }, { 209,-5225 }, { 210,-5225 }, { 211,-5225 },
 { 212,-5225 }, { 213,-5225 }, { 214,-5225 }, { 215,-5225 }, { 216,-5225 },
 { 217,-5225 }, { 218,-5225 }, { 219,-5225 }, { 220,-5225 }, { 221,-5225 },
 { 222,-5225 }, { 223,-5225 }, { 224,-5225 }, { 225,-5225 }, { 226,-5225 },
 { 227,-5225 }, { 228,-5225 }, { 229,-5225 }, { 230,-5225 }, { 231,-5225 },

 { 232,-5225 }, { 233,-5225 }, { 234,-5225 }, { 235,-5225 }, { 236,-5225 },
 { 237,-5225 }, { 238,-5225 }, { 239,-5225 }, { 240,-5225 }, { 241,-5225 },
 { 242,-5225 }, { 243,-5225 }, { 244,-5225 }, { 245,-5225 }, { 246,-5225 },
 { 247,-5225 }, { 248,-5225 }, { 249,-5225 }, { 250,-5225 }, { 251,-5225 },
 { 252,-5225 }, { 253,-5225 }, { 254,-5225 }, { 255,-5225 }, { 256,-5225 },
 {   0,  42 }, {   0,5351 }, {   1,-4690 }, {   2,-4690 }, {   3,-4690 },
 {   4,-4690 }, {   5,-4690 }, {   6,-4690 }, {   7,-4690 }, {   8,-4690 },
 {   0,   0 }, {   0,   0 }, {  11,-4690 }, {   0,   0 }, {   0,   0 },
 {  14,-4690 }, {  15,-4690 }, {  16,-4690 }, {  17,-4690 }, {  18,-4690 },
 {  19,-4690 }, {  20,-4690 }, {  21,-4690 }, {  22,-4690 }, {  23,-4690 },

 {  24,-4690 }, {  25,-4690 }, {  26,-4690 }, {  27,-4690 }, {  28,-4690 },
 {  29,-4690 }, {  30,-4690 }, {  31,-4690 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-4690 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  46,-4432 }, {   0,   0 }, {  48,-3142 },
 {  49,-3142 }, {  50,-3142 }, {  51,-3142 }, {  52,-3142 }, {  53,-3142 },
 {  54,-3142 }, {  55,-3142 }, {  56,-3142 }, {  57,-3142 }, {   0,   0 },
 {  59,-4690 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-4690 }, {  66,-4690 }, {  67,-4690 }, {  68,-4690 },
 {  69,-3916 }, {  70,-4690 }, {  71,-4690 }, {  72,-4690 }, {  73,-4690 },

 {  74,-4690 }, {  75,-4690 }, {  76,-4690 }, {  77,-4690 }, {  78,-4690 },
 {  79,-4690 }, {  80,-4690 }, {  81,-4690 }, {  82,-4690 }, {  83,-4690 },
 {  84,-4690 }, {  85,-4690 }, {  86,-4690 }, {  87,-4690 }, {  88,-4690 },
 {  89,-4690 }, {  90,-4690 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,-4690 }, {  95,-2884 }, {  96,-4690 }, {  97,-4690 }, {  98,-4690 },
 {  99,-4690 }, { 100,-4690 }, { 101,-3916 }, { 102,-4690 }, { 103,-4690 },
 { 104,-4690 }, { 105,-4690 }, { 106,-4690 }, { 107,-4690 }, { 108,-4690 },
 { 109,-4690 }, { 110,-4690 }, { 111,-4690 }, { 112,-4690 }, { 113,-4690 },
 { 114,-4690 }, { 115,-4690 }, { 116,-4690 }, { 117,-4690 }, { 118,-4690 },
 { 119,-4690 }, { 120,-4690 }, { 121,-4690 }, { 122,-4690 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 126,-4690 }, { 127,-4690 }, { 128,-4690 },
 { 129,-4690 }, { 130,-4690 }, { 131,-4690 }, { 132,-4690 }, { 133,-4690 },
 { 134,-4690 }, { 135,-4690 }, { 136,-4690 }, { 137,-4690 }, { 138,-4690 },
 { 139,-4690 }, { 140,-4690 }, { 141,-4690 }, { 142,-4690 }, { 143,-4690 },
 { 144,-4690 }, { 145,-4690 }, { 146,-4690 }, { 147,-4690 }, { 148,-4690 },
 { 149,-4690 }, { 150,-4690 }, { 151,-4690 }, { 152,-4690 }, { 153,-4690 },
 { 154,-4690 }, { 155,-4690 }, { 156,-4690 }, { 157,-4690 }, { 158,-4690 },
 { 159,-4690 }, { 160,-4690 }, { 161,-4690 }, { 162,-4690 }, { 163,-4690 },
 { 164,-4690 }, { 165,-4690 }, { 166,-4690 }, { 167,-4690 }, { 168,-4690 },
 { 169,-4690 }, { 170,-4690 }, { 171,-4690 }, { 172,-4690 }, { 173,-4690 },

 { 174,-4690 }, { 175,-4690 }, { 176,-4690 }, { 177,-4690 }, { 178,-4690 },
 { 179,-4690 }, { 180,-4690 }, { 181,-4690 }, { 182,-4690 }, { 183,-4690 },
 { 184,-4690 }, { 185,-4690 }, { 186,-4690 }, { 187,-4690 }, { 188,-4690 },
 { 189,-4690 }, { 190,-4690 }, { 191,-4690 }, { 192,-4690 }, { 193,-4690 },
 { 194,-4690 }, { 195,-4690 }, { 196,-4690 }, { 197,-4690 }, { 198,-4690 },
 { 199,-4690 }, { 200,-4690 }, { 201,-4690 }, { 202,-4690 }, { 203,-4690 },
 { 204,-4690 }, { 205,-4690 }, { 206,-4690 }, { 207,-4690 }, { 208,-4690 },
 { 209,-4690 }, { 210,-4690 }, { 211,-4690 }, { 212,-4690 }, { 213,-4690 },
 { 214,-4690 }, { 215,-4690 }, { 216,-4690 }, { 217,-4690 }, { 218,-4690 },
 { 219,-4690 }, { 220,-4690 }, { 221,-4690 }, { 222,-4690 }, { 223,-4690 },

 { 224,-4690 }, { 225,-4690 }, { 226,-4690 }, { 227,-4690 }, { 228,-4690 },
 { 229,-4690 }, { 230,-4690 }, { 231,-4690 }, { 232,-4690 }, { 233,-4690 },
 { 234,-4690 }, { 235,-4690 }, { 236,-4690 }, { 237,-4690 }, { 238,-4690 },
 { 239,-4690 }, { 240,-4690 }, { 241,-4690 }, { 242,-4690 }, { 243,-4690 },
 { 244,-4690 }, { 245,-4690 }, { 246,-4690 }, { 247,-4690 }, { 248,-4690 },
 { 249,-4690 }, { 250,-4690 }, { 251,-4690 }, { 252,-4690 }, { 253,-4690 },
 { 254,-4690 }, { 255,-4690 }, { 256,-4690 }, {   0,  13 }, {   0,5093 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  13 }, {   0,5070 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,3320 }, {  49,3320 }, {  50,3320 },
 {  51,3320 }, {  52,3320 }, {  53,3320 }, {  54,3320 }, {  55,3320 },
 {  56,3320 }, {  57,3320 }, {   0,   0 }, {   0,   0 }, {   0,  14 },
 {   0,5032 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3320 },

 {  66,3320 }, {  67,3320 }, {  68,3320 }, {  69,3320 }, {  70,3320 },
 {  48,3320 }, {  49,3320 }, {  50,3320 }, {  51,3320 }, {  52,3320 },
 {  53,3320 }, {  54,3320 }, {  55,3320 }, {  56,3320 }, {  57,3320 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,3320 }, {  66,3320 }, {  67,3320 },
 {  68,3320 }, {  69,3320 }, {  70,3320 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,3320 }, {  98,3320 }, {  99,3320 }, { 100,3320 },
 { 101,3320 }, { 102,3320 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-6069 }, {  49,-6069 },
 {  50,-6069 }, {  51,-6069 }, {  52,-6069 }, {  53,-6069 }, {  54,-6069 },

 {  55,-6069 }, {  56,-6069 }, {  57,-6069 }, {   0,   0 }, {  97,3320 },
 {  98,3320 }, {  99,3320 }, { 100,3320 }, { 101,3320 }, { 102,3320 },
 {  65,-6069 }, {  66,-6069 }, {  67,-6069 }, {  68,-6069 }, {  69,-6069 },
 {  70,-6069 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,-6069 }, {  98,-6069 }, {  99,-6069 },
 { 100,-6069 }, { 101,-6069 }, { 102,-6069 }, {   0,  40 }, {   0,4928 },

 {   1,-6171 }, {   2,-6171 }, {   3,-6171 }, {   4,-6171 }, {   5,-6171 },
 {   6,-6171 }, {   7,-6171 }, {   8,-6171 }, {   0,   0 }, {   0,   0 },
 {  11,-6171 }, {   0,   0 }, {   0,   0 }, {  14,-6171 }, {  15,-6171 },
 {  16,-6171 }, {  17,-6171 }, {  18,-6171 }, {  19,-6171 }, {  20,-6171 },
 {  21,-6171 }, {  22,-6171 }, {  23,-6171 }, {  24,-6171 }, {  25,-6171 },
 {  26,-6171 }, {  27,-6171 }, {  28,-6171 }, {  29,-6171 }, {  30,-6171 },
 {  31,-6171 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-6171 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,3290 }, {  49,3290 }, {  50,3290 },

 {  51,3290 }, {  52,3290 }, {  53,3290 }, {  54,3290 }, {  55,3290 },
 {  56,3290 }, {  57,3290 }, {   0,   0 }, {  59,-6171 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-6171 },
 {  66,-6171 }, {  67,-6171 }, {  68,-6171 }, {  69,-6171 }, {  70,-6171 },
 {  71,-6171 }, {  72,-6171 }, {  73,-6171 }, {  74,-6171 }, {  75,-6171 },
 {  76,-6171 }, {  77,-6171 }, {  78,-6171 }, {  79,-6171 }, {  80,-6171 },
 {  81,-6171 }, {  82,-6171 }, {  83,-6171 }, {  84,-6171 }, {  85,-6171 },
 {  86,-6171 }, {  87,-6171 }, {  88,-6171 }, {  89,-6171 }, {  90,-6171 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-6171 }, {  95,3548 },
 {  96,-6171 }, {  97,-6171 }, {  98,-6171 }, {  99,-6171 }, { 100,-6171 },

 { 101,-6171 }, { 102,-6171 }, { 103,-6171 }, { 104,-6171 }, { 105,-6171 },
 { 106,-6171 }, { 107,-6171 }, { 108,-6171 }, { 109,-6171 }, { 110,-6171 },
 { 111,-6171 }, { 112,-6171 }, { 113,-6171 }, { 114,-6171 }, { 115,-6171 },
 { 116,-6171 }, { 117,-6171 }, { 118,-6171 }, { 119,-6171 }, { 120,-6171 },
 { 121,-6171 }, { 122,-6171 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 126,-6171 }, { 127,-6171 }, { 128,-6171 }, { 129,-6171 }, { 130,-6171 },
 { 131,-6171 }, { 132,-6171 }, { 133,-6171 }, { 134,-6171 }, { 135,-6171 },
 { 136,-6171 }, { 137,-6171 }, { 138,-6171 }, { 139,-6171 }, { 140,-6171 },
 { 141,-6171 }, { 142,-6171 }, { 143,-6171 }, { 144,-6171 }, { 145,-6171 },
 { 146,-6171 }, { 147,-6171 }, { 148,-6171 }, { 149,-6171 }, { 150,-6171 },

 { 151,-6171 }, { 152,-6171 }, { 153,-6171 }, { 154,-6171 }, { 155,-6171 },
 { 156,-6171 }, { 157,-6171 }, { 158,-6171 }, { 159,-6171 }, { 160,-6171 },
 { 161,-6171 }, { 162,-6171 }, { 163,-6171 }, { 164,-6171 }, { 165,-6171 },
 { 166,-6171 }, { 167,-6171 }, { 168,-6171 }, { 169,-6171 }, { 170,-6171 },
 { 171,-6171 }, { 172,-6171 }, { 173,-6171 }, { 174,-6171 }, { 175,-6171 },
 { 176,-6171 }, { 177,-6171 }, { 178,-6171 }, { 179,-6171 }, { 180,-6171 },
 { 181,-6171 }, { 182,-6171 }, { 183,-6171 }, { 184,-6171 }, { 185,-6171 },
 { 186,-6171 }, { 187,-6171 }, { 188,-6171 }, { 189,-6171 }, { 190,-6171 },
 { 191,-6171 }, { 192,-6171 }, { 193,-6171 }, { 194,-6171 }, { 195,-6171 },
 { 196,-6171 }, { 197,-6171 }, { 198,-6171 }, { 199,-6171 }, { 200,-6171 },

 { 201,-6171 }, { 202,-6171 }, { 203,-6171 }, { 204,-6171 }, { 205,-6171 },
 { 206,-6171 }, { 207,-6171 }, { 208,-6171 }, { 209,-6171 }, { 210,-6171 },
 { 211,-6171 }, { 212,-6171 }, { 213,-6171 }, { 214,-6171 }, { 215,-6171 },
 { 216,-6171 }, { 217,-6171 }, { 218,-6171 }, { 219,-6171 }, { 220,-6171 },
 { 221,-6171 }, { 222,-6171 }, { 223,-6171 }, { 224,-6171 }, { 225,-6171 },
 { 226,-6171 }, { 227,-6171 }, { 228,-6171 }, { 229,-6171 }, { 230,-6171 },
 { 231,-6171 }, { 232,-6171 }, { 233,-6171 }, { 234,-6171 }, { 235,-6171 },
 { 236,-6171 }, { 237,-6171 }, { 238,-6171 }, { 239,-6171 }, { 240,-6171 },
 { 241,-6171 }, { 242,-6171 }, { 243,-6171 }, { 244,-6171 }, { 245,-6171 },
 { 246,-6171 }, { 247,-6171 }, { 248,-6171 }, { 249,-6171 }, { 250,-6171 },

 { 251,-6171 }, { 252,-6171 }, { 253,-6171 }, { 254,-6171 }, { 255,-6171 },
 { 256,-6171 }, {   0,  41 }, {   0,4670 }, {   1,-6433 }, {   2,-6433 },
 {   3,-6433 }, {   4,-6433 }, {   5,-6433 }, {   6,-6433 }, {   7,-6433 },
 {   8,-6433 }, {   0,   0 }, {   0,   0 }, {  11,-6433 }, {   0,   0 },
 {   0,   0 }, {  14,-6433 }, {  15,-6433 }, {  16,-6433 }, {  17,-6433 },
 {  18,-6433 }, {  19,-6433 }, {  20,-6433 }, {  21,-6433 }, {  22,-6433 },
 {  23,-6433 }, {  24,-6433 }, {  25,-6433 }, {  26,-6433 }, {  27,-6433 },
 {  28,-6433 }, {  29,-6433 }, {  30,-6433 }, {  31,-6433 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,-6433 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-2357 }, {  49,-2357 }, {  50,-2357 }, {  51,-2357 }, {  52,-2357 },
 {  53,-2357 }, {  54,-2357 }, {  55,-2357 }, {  56,-2357 }, {  57,-2357 },
 {   0,   0 }, {  59,-6433 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-6433 }, {  66,-6433 }, {  67,-6433 },
 {  68,-6433 }, {  69,-2099 }, {  70,-6433 }, {  71,-6433 }, {  72,-6433 },
 {  73,-6433 }, {  74,-6433 }, {  75,-6433 }, {  76,-6433 }, {  77,-6433 },
 {  78,-6433 }, {  79,-6433 }, {  80,-6433 }, {  81,-6433 }, {  82,-6433 },
 {  83,-6433 }, {  84,-6433 }, {  85,-6433 }, {  86,-6433 }, {  87,-6433 },
 {  88,-6433 }, {  89,-6433 }, {  90,-6433 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  94,-6433 }, {  95,-2089 }, {  96,-6433 }, {  97,-6433 },
 {  98,-6433 }, {  99,-6433 }, { 100,-6433 }, { 101,-2099 }, { 102,-6433 },
 { 103,-6433 }, { 104,-6433 }, { 105,-6433 }, { 106,-6433 }, { 107,-6433 },
 { 108,-6433 }, { 109,-6433 }, { 110,-6433 }, { 111,-6433 }, { 112,-6433 },
 { 113,-6433 }, { 114,-6433 }, { 115,-6433 }, { 116,-6433 }, { 117,-6433 },
 { 118,-6433 }, { 119,-6433 }, { 120,-6433 }, { 121,-6433 }, { 122,-6433 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,-6433 }, { 127,-6433 },
 { 128,-6433 }, { 129,-6433 }, { 130,-6433 }, { 131,-6433 }, { 132,-6433 },
 { 133,-6433 }, { 134,-6433 }, { 135,-6433 }, { 136,-6433 }, { 137,-6433 },
 { 138,-6433 }, { 139,-6433 }, { 140,-6433 }, { 141,-6433 }, { 142,-6433 },

 { 143,-6433 }, { 144,-6433 }, { 145,-6433 }, { 146,-6433 }, { 147,-6433 },
 { 148,-6433 }, { 149,-6433 }, { 150,-6433 }, { 151,-6433 }, { 152,-6433 },
 { 153,-6433 }, { 154,-6433 }, { 155,-6433 }, { 156,-6433 }, { 157,-6433 },
 { 158,-6433 }, { 159,-6433 }, { 160,-6433 }, { 161,-6433 }, { 162,-6433 },
 { 163,-6433 }, { 164,-6433 }, { 165,-6433 }, { 166,-6433 }, { 167,-6433 },
 { 168,-6433 }, { 169,-6433 }, { 170,-6433 }, { 171,-6433 }, { 172,-6433 },
 { 173,-6433 }, { 174,-6433 }, { 175,-6433 }, { 176,-6433 }, { 177,-6433 },
 { 178,-6433 }, { 179,-6433 }, { 180,-6433 }, { 181,-6433 }, { 182,-6433 },
 { 183,-6433 }, { 184,-6433 }, { 185,-6433 }, { 186,-6433 }, { 187,-6433 },
 { 188,-6433 }, { 189,-6433 }, { 190,-6433 }, { 191,-6433 }, { 192,-6433 },

 { 193,-6433 }, { 194,-6433 }, { 195,-6433 }, { 196,-6433 }, { 197,-6433 },
 { 198,-6433 }, { 199,-6433 }, { 200,-6433 }, { 201,-6433 }, { 202,-6433 },
 { 203,-6433 }, { 204,-6433 }, { 205,-6433 }, { 206,-6433 }, { 207,-6433 },
 { 208,-6433 }, { 209,-6433 }, { 210,-6433 }, { 211,-6433 }, { 212,-6433 },
 { 213,-6433 }, { 214,-6433 }, { 215,-6433 }, { 216,-6433 }, { 217,-6433 },
 { 218,-6433 }, { 219,-6433 }, { 220,-6433 }, { 221,-6433 }, { 222,-6433 },
 { 223,-6433 }, { 224,-6433 }, { 225,-6433 }, { 226,-6433 }, { 227,-6433 },
 { 228,-6433 }, { 229,-6433 }, { 230,-6433 }, { 231,-6433 }, { 232,-6433 },
 { 233,-6433 }, { 234,-6433 }, { 235,-6433 }, { 236,-6433 }, { 237,-6433 },
 { 238,-6433 }, { 239,-6433 }, { 240,-6433 }, { 241,-6433 }, { 242,-6433 },

 { 243,-6433 }, { 244,-6433 }, { 245,-6433 }, { 246,-6433 }, { 247,-6433 },
 { 248,-6433 }, { 249,-6433 }, { 250,-6433 }, { 251,-6433 }, { 252,-6433 },
 { 253,-6433 }, { 254,-6433 }, { 255,-6433 }, { 256,-6433 }, {   0,  41 },
 {   0,4412 }, {   1,-6691 }, {   2,-6691 }, {   3,-6691 }, {   4,-6691 },
 {   5,-6691 }, {   6,-6691 }, {   7,-6691 }, {   8,-6691 }, {   0,   0 },
 {   0,   0 }, {  11,-6691 }, {   0,   0 }, {   0,   0 }, {  14,-6691 },
 {  15,-6691 }, {  16,-6691 }, {  17,-6691 }, {  18,-6691 }, {  19,-6691 },
 {  20,-6691 }, {  21,-6691 }, {  22,-6691 }, {  23,-6691 }, {  24,-6691 },
 {  25,-6691 }, {  26,-6691 }, {  27,-6691 }, {  28,-6691 }, {  29,-6691 },
 {  30,-6691 }, {  31,-6691 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-6691 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {  59,-6691 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-6691 }, {  66,-6691 }, {  67,-6691 }, {  68,-6691 }, {  69,-2357 },
 {  70,-6691 }, {  71,-6691 }, {  72,-6691 }, {  73,-6691 }, {  74,-6691 },
 {  75,-6691 }, {  76,-6691 }, {  77,-6691 }, {  78,-6691 }, {  79,-6691 },
 {  80,-6691 }, {  81,-6691 }, {  82,-6691 }, {  83,-6691 }, {  84,-6691 },

 {  85,-6691 }, {  86,-6691 }, {  87,-6691 }, {  88,-6691 }, {  89,-6691 },
 {  90,-6691 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-6691 },
 {  95, 258 }, {  96,-6691 }, {  97,-6691 }, {  98,-6691 }, {  99,-6691 },
 { 100,-6691 }, { 101,-2357 }, { 102,-6691 }, { 103,-6691 }, { 104,-6691 },
 { 105,-6691 }, { 106,-6691 }, { 107,-6691 }, { 108,-6691 }, { 109,-6691 },
 { 110,-6691 }, { 111,-6691 }, { 112,-6691 }, { 113,-6691 }, { 114,-6691 },
 { 115,-6691 }, { 116,-6691 }, { 117,-6691 }, { 118,-6691 }, { 119,-6691 },
 { 120,-6691 }, { 121,-6691 }, { 122,-6691 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 126,-6691 }, { 127,-6691 }, { 128,-6691 }, { 129,-6691 },
 { 130,-6691 }, { 131,-6691 }, { 132,-6691 }, { 133,-6691 }, { 134,-6691 },

 { 135,-6691 }, { 136,-6691 }, { 137,-6691 }, { 138,-6691 }, { 139,-6691 },
 { 140,-6691 }, { 141,-6691 }, { 142,-6691 }, { 143,-6691 }, { 144,-6691 },
 { 145,-6691 }, { 146,-6691 }, { 147,-6691 }, { 148,-6691 }, { 149,-6691 },
 { 150,-6691 }, { 151,-6691 }, { 152,-6691 }, { 153,-6691 }, { 154,-6691 },
 { 155,-6691 }, { 156,-6691 }, { 157,-6691 }, { 158,-6691 }, { 159,-6691 },
 { 160,-6691 }, { 161,-6691 }, { 162,-6691 }, { 163,-6691 }, { 164,-6691 },
 { 165,-6691 }, { 166,-6691 }, { 167,-6691 }, { 168,-6691 }, { 169,-6691 },
 { 170,-6691 }, { 171,-6691 }, { 172,-6691 }, { 173,-6691 }, { 174,-6691 },
 { 175,-6691 }, { 176,-6691 }, { 177,-6691 }, { 178,-6691 }, { 179,-6691 },
 { 180,-6691 }, { 181,-6691 }, { 182,-6691 }, { 183,-6691 }, { 184,-6691 },

 { 185,-6691 }, { 186,-6691 }, { 187,-6691 }, { 188,-6691 }, { 189,-6691 },
 { 190,-6691 }, { 191,-6691 }, { 192,-6691 }, { 193,-6691 }, { 194,-6691 },
 { 195,-6691 }, { 196,-6691 }, { 197,-6691 }, { 198,-6691 }, { 199,-6691 },
 { 200,-6691 }, { 201,-6691 }, { 202,-6691 }, { 203,-6691 }, { 204,-6691 },
 { 205,-6691 }, { 206,-6691 }, { 207,-6691 }, { 208,-6691 }, { 209,-6691 },
 { 210,-6691 }, { 211,-6691 }, { 212,-6691 }, { 213,-6691 }, { 214,-6691 },
 { 215,-6691 }, { 216,-6691 }, { 217,-6691 }, { 218,-6691 }, { 219,-6691 },
 { 220,-6691 }, { 221,-6691 }, { 222,-6691 }, { 223,-6691 }, { 224,-6691 },
 { 225,-6691 }, { 226,-6691 }, { 227,-6691 }, { 228,-6691 }, { 229,-6691 },
 { 230,-6691 }, { 231,-6691 }, { 232,-6691 }, { 233,-6691 }, { 234,-6691 },

 { 235,-6691 }, { 236,-6691 }, { 237,-6691 }, { 238,-6691 }, { 239,-6691 },
 { 240,-6691 }, { 241,-6691 }, { 242,-6691 }, { 243,-6691 }, { 244,-6691 },
 { 245,-6691 }, { 246,-6691 }, { 247,-6691 }, { 248,-6691 }, { 249,-6691 },
 { 250,-6691 }, { 251,-6691 }, { 252,-6691 }, { 253,-6691 }, { 254,-6691 },
 { 255,-6691 }, { 256,-6691 }, {   0,  48 }, {   0,4154 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,2833 }, {  49,2833 }, {  50,2833 }, {  51,2833 },
 {  52,2833 }, {  53,2833 }, {  54,2833 }, {  55,2833 }, {  56,2833 },
 {  57,2833 }, {   0,  45 }, {   0,4095 }, {   1,-6739 }, {   2,-6739 },
 {   3,-6739 }, {   4,-6739 }, {   5,-6739 }, {   6,-6739 }, {   7,-6739 },
 {   8,-6739 }, {   0,   0 }, {   0,   0 }, {  11,-6739 }, {   0,   0 },
 {   0,   0 }, {  14,-6739 }, {  15,-6739 }, {  16,-6739 }, {  17,-6739 },

 {  18,-6739 }, {  19,-6739 }, {  20,-6739 }, {  21,-6739 }, {  22,-6739 },
 {  23,-6739 }, {  24,-6739 }, {  25,-6739 }, {  26,-6739 }, {  27,-6739 },
 {  28,-6739 }, {  29,-6739 }, {  30,-6739 }, {  31,-6739 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,-6739 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,-6739 }, {  51,-6739 }, {  52,-6739 },
 {  53,-6739 }, {  54,-6739 }, {  55,-6739 }, {  56,-6739 }, {  57,-6739 },
 {   0,   0 }, {  59,-6739 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-6739 }, {  66,-6739 }, {  67,-6739 },

 {  68,-6739 }, {  69,-6739 }, {  70,-6739 }, {  71,-6739 }, {  72,-6739 },
 {  73,-6739 }, {  74,-6739 }, {  75,-6739 }, {  76,-6739 }, {  77,-6739 },
 {  78,-6739 }, {  79,-6739 }, {  80,-6739 }, {  81,-6739 }, {  82,-6739 },
 {  83,-6739 }, {  84,-6739 }, {  85,-6739 }, {  86,-6739 }, {  87,-6739 },
 {  88,-6739 }, {  89,-6739 }, {  90,-6739 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,-6739 }, {  95, 258 }, {  96,-6739 }, {  97,-6739 },
 {  98,-6739 }, {  99,-6739 }, { 100,-6739 }, { 101,-6739 }, { 102,-6739 },
 { 103,-6739 }, { 104,-6739 }, { 105,-6739 }, { 106,-6739 }, { 107,-6739 },
 { 108,-6739 }, { 109,-6739 }, { 110,-6739 }, { 111,-6739 }, { 112,-6739 },
 { 113,-6739 }, { 114,-6739 }, { 115,-6739 }, { 116,-6739 }, { 117,-6739 },

 { 118,-6739 }, { 119,-6739 }, { 120,-6739 }, { 121,-6739 }, { 122,-6739 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,-6739 }, { 127,-6739 },
 { 128,-6739 }, { 129,-6739 }, { 130,-6739 }, { 131,-6739 }, { 132,-6739 },
 { 133,-6739 }, { 134,-6739 }, { 135,-6739 }, { 136,-6739 }, { 137,-6739 },
 { 138,-6739 }, { 139,-6739 }, { 140,-6739 }, { 141,-6739 }, { 142,-6739 },
 { 143,-6739 }, { 144,-6739 }, { 145,-6739 }, { 146,-6739 }, { 147,-6739 },
 { 148,-6739 }, { 149,-6739 }, { 150,-6739 }, { 151,-6739 }, { 152,-6739 },
 { 153,-6739 }, { 154,-6739 }, { 155,-6739 }, { 156,-6739 }, { 157,-6739 },
 { 158,-6739 }, { 159,-6739 }, { 160,-6739 }, { 161,-6739 }, { 162,-6739 },
 { 163,-6739 }, { 164,-6739 }, { 165,-6739 }, { 166,-6739 }, { 167,-6739 },

 { 168,-6739 }, { 169,-6739 }, { 170,-6739 }, { 171,-6739 }, { 172,-6739 },
 { 173,-6739 }, { 174,-6739 }, { 175,-6739 }, { 176,-6739 }, { 177,-6739 },
 { 178,-6739 }, { 179,-6739 }, { 180,-6739 }, { 181,-6739 }, { 182,-6739 },
 { 183,-6739 }, { 184,-6739 }, { 185,-6739 }, { 186,-6739 }, { 187,-6739 },
 { 188,-6739 }, { 189,-6739 }, { 190,-6739 }, { 191,-6739 }, { 192,-6739 },
 { 193,-6739 }, { 194,-6739 }, { 195,-6739 }, { 196,-6739 }, { 197,-6739 },
 { 198,-6739 }, { 199,-6739 }, { 200,-6739 }, { 201,-6739 }, { 202,-6739 },
 { 203,-6739 }, { 204,-6739 }, { 205,-6739 }, { 206,-6739 }, { 207,-6739 },
 { 208,-6739 }, { 209,-6739 }, { 210,-6739 }, { 211,-6739 }, { 212,-6739 },
 { 213,-6739 }, { 214,-6739 }, { 215,-6739 }, { 216,-6739 }, { 217,-6739 },

 { 218,-6739 }, { 219,-6739 }, { 220,-6739 }, { 221,-6739 }, { 222,-6739 },
 { 223,-6739 }, { 224,-6739 }, { 225,-6739 }, { 226,-6739 }, { 227,-6739 },
 { 228,-6739 }, { 229,-6739 }, { 230,-6739 }, { 231,-6739 }, { 232,-6739 },
 { 233,-6739 }, { 234,-6739 }, { 235,-6739 }, { 236,-6739 }, { 237,-6739 },
 { 238,-6739 }, { 239,-6739 }, { 240,-6739 }, { 241,-6739 }, { 242,-6739 },
 { 243,-6739 }, { 244,-6739 }, { 245,-6739 }, { 246,-6739 }, { 247,-6739 },
 { 248,-6739 }, { 249,-6739 }, { 250,-6739 }, { 251,-6739 }, { 252,-6739 },
 { 253,-6739 }, { 254,-6739 }, { 255,-6739 }, { 256,-6739 }, {   0,  52 },
 {   0,3837 }, {   1,-6997 }, {   2,-6997 }, {   3,-6997 }, {   4,-6997 },
 {   5,-6997 }, {   6,-6997 }, {   7,-6997 }, {   8,-6997 }, {   0,   0 },

 {   0,   0 }, {  11,-6997 }, {   0,   0 }, {   0,   0 }, {  14,-6997 },
 {  15,-6997 }, {  16,-6997 }, {  17,-6997 }, {  18,-6997 }, {  19,-6997 },
 {  20,-6997 }, {  21,-6997 }, {  22,-6997 }, {  23,-6997 }, {  24,-6997 },
 {  25,-6997 }, {  26,-6997 }, {  27,-6997 }, {  28,-6997 }, {  29,-6997 },
 {  30,-6997 }, {  31,-6997 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-6997 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-258 }, {  49,-258 },
 {  50,-6997 }, {  51,-6997 }, {  52,-6997 }, {  53,-6997 }, {  54,-6997 },
 {  55,-6997 }, {  56,-6997 }, {  57,-6997 }, {   0,   0 }, {  59,-6997 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-6997 }, {  66,-6997 }, {  67,-6997 }, {  68,-6997 }, {  69,-6997 },
 {  70,-6997 }, {  71,-6997 }, {  72,-6997 }, {  73,-6997 }, {  74,-6997 },
 {  75,-6997 }, {  76,-6997 }, {  77,-6997 }, {  78,-6997 }, {  79,-6997 },
 {  80,-6997 }, {  81,-6997 }, {  82,-6997 }, {  83,-6997 }, {  84,-6997 },
 {  85,-6997 }, {  86,-6997 }, {  87,-6997 }, {  88,-6997 }, {  89,-6997 },
 {  90,-6997 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-6997 },
 {  95,-6997 }, {  96,-6997 }, {  97,-6997 }, {  98,-6997 }, {  99,-6997 },
 { 100,-6997 }, { 101,-6997 }, { 102,-6997 }, { 103,-6997 }, { 104,-6997 },
 { 105,-6997 }, { 106,-6997 }, { 107,-6997 }, { 108,-6997 }, { 109,-6997 },

 { 110,-6997 }, { 111,-6997 }, { 112,-6997 }, { 113,-6997 }, { 114,-6997 },
 { 115,-6997 }, { 116,-6997 }, { 117,-6997 }, { 118,-6997 }, { 119,-6997 },
 { 120,-6997 }, { 121,-6997 }, { 122,-6997 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 126,-6997 }, { 127,-6997 }, { 128,-6997 }, { 129,-6997 },
 { 130,-6997 }, { 131,-6997 }, { 132,-6997 }, { 133,-6997 }, { 134,-6997 },
 { 135,-6997 }, { 136,-6997 }, { 137,-6997 }, { 138,-6997 }, { 139,-6997 },
 { 140,-6997 }, { 141,-6997 }, { 142,-6997 }, { 143,-6997 }, { 144,-6997 },
 { 145,-6997 }, { 146,-6997 }, { 147,-6997 }, { 148,-6997 }, { 149,-6997 },
 { 150,-6997 }, { 151,-6997 }, { 152,-6997 }, { 153,-6997 }, { 154,-6997 },
 { 155,-6997 }, { 156,-6997 }, { 157,-6997 }, { 158,-6997 }, { 159,-6997 },

 { 160,-6997 }, { 161,-6997 }, { 162,-6997 }, { 163,-6997 }, { 164,-6997 },
 { 165,-6997 }, { 166,-6997 }, { 167,-6997 }, { 168,-6997 }, { 169,-6997 },
 { 170,-6997 }, { 171,-6997 }, { 172,-6997 }, { 173,-6997 }, { 174,-6997 },
 { 175,-6997 }, { 176,-6997 }, { 177,-6997 }, { 178,-6997 }, { 179,-6997 },
 { 180,-6997 }, { 181,-6997 }, { 182,-6997 }, { 183,-6997 }, { 184,-6997 },
 { 185,-6997 }, { 186,-6997 }, { 187,-6997 }, { 188,-6997 }, { 189,-6997 },
 { 190,-6997 }, { 191,-6997 }, { 192,-6997 }, { 193,-6997 }, { 194,-6997 },
 { 195,-6997 }, { 196,-6997 }, { 197,-6997 }, { 198,-6997 }, { 199,-6997 },
 { 200,-6997 }, { 201,-6997 }, { 202,-6997 }, { 203,-6997 }, { 204,-6997 },
 { 205,-6997 }, { 206,-6997 }, { 207,-6997 }, { 208,-6997 }, { 209,-6997 },

 { 210,-6997 }, { 211,-6997 }, { 212,-6997 }, { 213,-6997 }, { 214,-6997 },
 { 215,-6997 }, { 216,-6997 }, { 217,-6997 }, { 218,-6997 }, { 219,-6997 },
 { 220,-6997 }, { 221,-6997 }, { 222,-6997 }, { 223,-6997 }, { 224,-6997 },
 { 225,-6997 }, { 226,-6997 }, { 227,-6997 }, { 228,-6997 }, { 229,-6997 },
 { 230,-6997 }, { 231,-6997 }, { 232,-6997 }, { 233,-6997 }, { 234,-6997 },
 { 235,-6997 }, { 236,-6997 }, { 237,-6997 }, { 238,-6997 }, { 239,-6997 },
 { 240,-6997 }, { 241,-6997 }, { 242,-6997 }, { 243,-6997 }, { 244,-6997 },
 { 245,-6997 }, { 246,-6997 }, { 247,-6997 }, { 248,-6997 }, { 249,-6997 },
 { 250,-6997 }, { 251,-6997 }, { 252,-6997 }, { 253,-6997 }, { 254,-6997 },
 { 255,-6997 }, { 256,-6997 }, {   0,  49 }, {   0,3579 }, {   1,-7255 },

 {   2,-7255 }, {   3,-7255 }, {   4,-7255 }, {   5,-7255 }, {   6,-7255 },
 {   7,-7255 }, {   8,-7255 }, {   0,   0 }, {   0,   0 }, {  11,-7255 },
 {   0,   0 }, {   0,   0 }, {  14,-7255 }, {  15,-7255 }, {  16,-7255 },
 {  17,-7255 }, {  18,-7255 }, {  19,-7255 }, {  20,-7255 }, {  21,-7255 },
 {  22,-7255 }, {  23,-7255 }, {  24,-7255 }, {  25,-7255 }, {  26,-7255 },
 {  27,-7255 }, {  28,-7255 }, {  29,-7255 }, {  30,-7255 }, {  31,-7255 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-7255 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,-7255 }, {  49,-7255 }, {  50,-7255 }, {  51,-7255 },

 {  52,-7255 }, {  53,-7255 }, {  54,-7255 }, {  55,-7255 }, {  56,-7255 },
 {  57,-7255 }, {   0,   0 }, {  59,-7255 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-7255 }, {  66,-7255 },
 {  67,-7255 }, {  68,-7255 }, {  69,-7255 }, {  70,-7255 }, {  71,-7255 },
 {  72,-7255 }, {  73,-7255 }, {  74,-7255 }, {  75,-7255 }, {  76,-7255 },
 {  77,-7255 }, {  78,-7255 }, {  79,-7255 }, {  80,-7255 }, {  81,-7255 },
 {  82,-7255 }, {  83,-7255 }, {  84,-7255 }, {  85,-7255 }, {  86,-7255 },
 {  87,-7255 }, {  88,-7255 }, {  89,-7255 }, {  90,-7255 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,-7255 }, {  95,-7255 }, {  96,-7255 },
 {  97,-7255 }, {  98,-7255 }, {  99,-7255 }, { 100,-7255 }, { 101,-7255 },

 { 102,-7255 }, { 103,-7255 }, { 104,-7255 }, { 105,-7255 }, { 106,-7255 },
 { 107,-7255 }, { 108,-7255 }, { 109,-7255 }, { 110,-7255 }, { 111,-7255 },
 { 112,-7255 }, { 113,-7255 }, { 114,-7255 }, { 115,-7255 }, { 116,-7255 },
 { 117,-7255 }, { 118,-7255 }, { 119,-7255 }, { 120,-7255 }, { 121,-7255 },
 { 122,-7255 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,-7255 },
 { 127,-7255 }, { 128,-7255 }, { 129,-7255 }, { 130,-7255 }, { 131,-7255 },
 { 132,-7255 }, { 133,-7255 }, { 134,-7255 }, { 135,-7255 }, { 136,-7255 },
 { 137,-7255 }, { 138,-7255 }, { 139,-7255 }, { 140,-7255 }, { 141,-7255 },
 { 142,-7255 }, { 143,-7255 }, { 144,-7255 }, { 145,-7255 }, { 146,-7255 },
 { 147,-7255 }, { 148,-7255 }, { 149,-7255 }, { 150,-7255 }, { 151,-7255 },

 { 152,-7255 }, { 153,-7255 }, { 154,-7255 }, { 155,-7255 }, { 156,-7255 },
 { 157,-7255 }, { 158,-7255 }, { 159,-7255 }, { 160,-7255 }, { 161,-7255 },
 { 162,-7255 }, { 163,-7255 }, { 164,-7255 }, { 165,-7255 }, { 166,-7255 },
 { 167,-7255 }, { 168,-7255 }, { 169,-7255 }, { 170,-7255 }, { 171,-7255 },
 { 172,-7255 }, { 173,-7255 }, { 174,-7255 }, { 175,-7255 }, { 176,-7255 },
 { 177,-7255 }, { 178,-7255 }, { 179,-7255 }, { 180,-7255 }, { 181,-7255 },
 { 182,-7255 }, { 183,-7255 }, { 184,-7255 }, { 185,-7255 }, { 186,-7255 },
 { 187,-7255 }, { 188,-7255 }, { 189,-7255 }, { 190,-7255 }, { 191,-7255 },
 { 192,-7255 }, { 193,-7255 }, { 194,-7255 }, { 195,-7255 }, { 196,-7255 },
 { 197,-7255 }, { 198,-7255 }, { 199,-7255 }, { 200,-7255 }, { 201,-7255 },

 { 202,-7255 }, { 203,-7255 }, { 204,-7255 }, { 205,-7255 }, { 206,-7255 },
 { 207,-7255 }, { 208,-7255 }, { 209,-7255 }, { 210,-7255 }, { 211,-7255 },
 { 212,-7255 }, { 213,-7255 }, { 214,-7255 }, { 215,-7255 }, { 216,-7255 },
 { 217,-7255 }, { 218,-7255 }, { 219,-7255 }, { 220,-7255 }, { 221,-7255 },
 { 222,-7255 }, { 223,-7255 }, { 224,-7255 }, { 225,-7255 }, { 226,-7255 },
 { 227,-7255 }, { 228,-7255 }, { 229,-7255 }, { 230,-7255 }, { 231,-7255 },
 { 232,-7255 }, { 233,-7255 }, { 234,-7255 }, { 235,-7255 }, { 236,-7255 },
 { 237,-7255 }, { 238,-7255 }, { 239,-7255 }, { 240,-7255 }, { 241,-7255 },
 { 242,-7255 }, { 243,-7255 }, { 244,-7255 }, { 245,-7255 }, { 246,-7255 },
 { 247,-7255 }, { 248,-7255 }, { 249,-7255 }, { 250,-7255 }, { 251,-7255 },

 { 252,-7255 }, { 253,-7255 }, { 254,-7255 }, { 255,-7255 }, { 256,-7255 },
 {   0,  40 }, {   0,3321 }, {   1,-258 }, {   2,-258 }, {   3,-258 },
 {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 }, {   8,-258 },
 {   0,   0 }, {   0,   0 }, {  11,-258 }, {   0,   0 }, {   0,   0 },
 {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 }, {  18,-258 },
 {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 }, {  23,-258 },
 {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 }, {  28,-258 },
 {  29,-258 }, {  30,-258 }, {  31,-258 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-258 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {  59,-258 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 },
 {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 }, {  73,-258 },
 {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 }, {  78,-258 },
 {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 }, {  83,-258 },
 {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 }, {  88,-258 },
 {  89,-258 }, {  90,-258 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  94,-258 }, {  95, 258 }, {  96,-258 }, {  97,-258 }, {  98,-258 },
 {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-258 },
 { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 }, { 108,-258 },
 { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 }, { 113,-258 },
 { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 }, { 118,-258 },
 { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 126,-258 }, { 127,-258 }, { 128,-258 },
 { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 }, { 133,-258 },
 { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 }, { 138,-258 },
 { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 }, { 143,-258 },

 { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 }, { 148,-258 },
 { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 }, { 153,-258 },
 { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 }, { 158,-258 },
 { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 }, { 163,-258 },
 { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 }, { 168,-258 },
 { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 }, { 173,-258 },
 { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 }, { 178,-258 },
 { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 }, { 183,-258 },
 { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 }, { 188,-258 },
 { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 }, { 193,-258 },

 { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 }, { 198,-258 },
 { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 }, { 203,-258 },
 { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 }, { 208,-258 },
 { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 }, { 213,-258 },
 { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 }, { 218,-258 },
 { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 }, { 223,-258 },
 { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 }, { 228,-258 },
 { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 }, { 233,-258 },
 { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 }, { 238,-258 },
 { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 }, { 243,-258 },

 { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 }, { 248,-258 },
 { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 }, { 253,-258 },
 { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,  49 }, {   0,3063 },
 {   1,-7771 }, {   2,-7771 }, {   3,-7771 }, {   4,-7771 }, {   5,-7771 },
 {   6,-7771 }, {   7,-7771 }, {   8,-7771 }, {   0,   0 }, {   0,   0 },
 {  11,-7771 }, {   0,   0 }, {   0,   0 }, {  14,-7771 }, {  15,-7771 },
 {  16,-7771 }, {  17,-7771 }, {  18,-7771 }, {  19,-7771 }, {  20,-7771 },
 {  21,-7771 }, {  22,-7771 }, {  23,-7771 }, {  24,-7771 }, {  25,-7771 },
 {  26,-7771 }, {  27,-7771 }, {  28,-7771 }, {  29,-7771 }, {  30,-7771 },
 {  31,-7771 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-7771 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,2000 }, {  49,2000 }, {  50,2000 },
 {  51,2000 }, {  52,2000 }, {  53,2000 }, {  54,2000 }, {  55,2000 },
 {  56,2000 }, {  57,2000 }, {   0,   0 }, {  59,-7771 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-7771 },
 {  66,-7771 }, {  67,-7771 }, {  68,-7771 }, {  69,-7771 }, {  70,-7771 },
 {  71,-7771 }, {  72,-7771 }, {  73,-7771 }, {  74,-7771 }, {  75,-7771 },
 {  76,-7771 }, {  77,-7771 }, {  78,-7771 }, {  79,-7771 }, {  80,-7771 },
 {  81,-7771 }, {  82,-7771 }, {  83,-7771 }, {  84,-7771 }, {  85,-7771 },

 {  86,-7771 }, {  87,-7771 }, {  88,-7771 }, {  89,-7771 }, {  90,-7771 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-7771 }, {  95,-7771 },
 {  96,-7771 }, {  97,-7771 }, {  98,-7771 }, {  99,-7771 }, { 100,-7771 },
 { 101,-7771 }, { 102,-7771 }, { 103,-7771 }, { 104,-7771 }, { 105,-7771 },
 { 106,-7771 }, { 107,-7771 }, { 108,-7771 }, { 109,-7771 }, { 110,-7771 },
 { 111,-7771 }, { 112,-7771 }, { 113,-7771 }, { 114,-7771 }, { 115,-7771 },
 { 116,-7771 }, { 117,-7771 }, { 118,-7771 }, { 119,-7771 }, { 120,-7771 },
 { 121,-7771 }, { 122,-7771 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 126,-7771 }, { 127,-7771 }, { 128,-7771 }, { 129,-7771 }, { 130,-7771 },
 { 131,-7771 }, { 132,-7771 }, { 133,-7771 }, { 134,-7771 }, { 135,-7771 },

 { 136,-7771 }, { 137,-7771 }, { 138,-7771 }, { 139,-7771 }, { 140,-7771 },
 { 141,-7771 }, { 142,-7771 }, { 143,-7771 }, { 144,-7771 }, { 145,-7771 },
 { 146,-7771 }, { 147,-7771 }, { 148,-7771 }, { 149,-7771 }, { 150,-7771 },
 { 151,-7771 }, { 152,-7771 }, { 153,-7771 }, { 154,-7771 }, { 155,-7771 },
 { 156,-7771 }, { 157,-7771 }, { 158,-7771 }, { 159,-7771 }, { 160,-7771 },
 { 161,-7771 }, { 162,-7771 }, { 163,-7771 }, { 164,-7771 }, { 165,-7771 },
 { 166,-7771 }, { 167,-7771 }, { 168,-7771 }, { 169,-7771 }, { 170,-7771 },
 { 171,-7771 }, { 172,-7771 }, { 173,-7771 }, { 174,-7771 }, { 175,-7771 },
 { 176,-7771 }, { 177,-7771 }, { 178,-7771 }, { 179,-7771 }, { 180,-7771 },
 { 181,-7771 }, { 182,-7771 }, { 183,-7771 }, { 184,-7771 }, { 185,-7771 },

 { 186,-7771 }, { 187,-7771 }, { 188,-7771 }, { 189,-7771 }, { 190,-7771 },
 { 191,-7771 }, { 192,-7771 }, { 193,-7771 }, { 194,-7771 }, { 195,-7771 },
 { 196,-7771 }, { 197,-7771 }, { 198,-7771 }, { 199,-7771 }, { 200,-7771 },
 { 201,-7771 }, { 202,-7771 }, { 203,-7771 }, { 204,-7771 }, { 205,-7771 },
 { 206,-7771 }, { 207,-7771 }, { 208,-7771 }, { 209,-7771 }, { 210,-7771 },
 { 211,-7771 }, { 212,-7771 }, { 213,-7771 }, { 214,-7771 }, { 215,-7771 },
 { 216,-7771 }, { 217,-7771 }, { 218,-7771 }, { 219,-7771 }, { 220,-7771 },
 { 221,-7771 }, { 222,-7771 }, { 223,-7771 }, { 224,-7771 }, { 225,-7771 },
 { 226,-7771 }, { 227,-7771 }, { 228,-7771 }, { 229,-7771 }, { 230,-7771 },
 { 231,-7771 }, { 232,-7771 }, { 233,-7771 }, { 234,-7771 }, { 235,-7771 },

 { 236,-7771 }, { 237,-7771 }, { 238,-7771 }, { 239,-7771 }, { 240,-7771 },
 { 241,-7771 }, { 242,-7771 }, { 243,-7771 }, { 244,-7771 }, { 245,-7771 },
 { 246,-7771 }, { 247,-7771 }, { 248,-7771 }, { 249,-7771 }, { 250,-7771 },
 { 251,-7771 }, { 252,-7771 }, { 253,-7771 }, { 254,-7771 }, { 255,-7771 },
 { 256,-7771 }, {   0,  44 }, {   0,2805 }, {   1,-8029 }, {   2,-8029 },
 {   3,-8029 }, {   4,-8029 }, {   5,-8029 }, {   6,-8029 }, {   7,-8029 },
 {   8,-8029 }, {   0,   0 }, {   0,   0 }, {  11,-8029 }, {   0,   0 },
 {   0,   0 }, {  14,-8029 }, {  15,-8029 }, {  16,-8029 }, {  17,-8029 },
 {  18,-8029 }, {  19,-8029 }, {  20,-8029 }, {  21,-8029 }, {  22,-8029 },
 {  23,-8029 }, {  24,-8029 }, {  25,-8029 }, {  26,-8029 }, {  27,-8029 },

 {  28,-8029 }, {  29,-8029 }, {  30,-8029 }, {  31,-8029 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,-8029 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,-8029 }, {  57,-8029 },
 {   0,   0 }, {  59,-8029 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-8029 }, {  66,-8029 }, {  67,-8029 },
 {  68,-8029 }, {  69,-8029 }, {  70,-8029 }, {  71,-8029 }, {  72,-8029 },
 {  73,-8029 }, {  74,-8029 }, {  75,-8029 }, {  76,-8029 }, {  77,-8029 },

 {  78,-8029 }, {  79,-8029 }, {  80,-8029 }, {  81,-8029 }, {  82,-8029 },
 {  83,-8029 }, {  84,-8029 }, {  85,-8029 }, {  86,-8029 }, {  87,-8029 },
 {  88,-8029 }, {  89,-8029 }, {  90,-8029 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,-8029 }, {  95, 258 }, {  96,-8029 }, {  97,-8029 },
 {  98,-8029 }, {  99,-8029 }, { 100,-8029 }, { 101,-8029 }, { 102,-8029 },
 { 103,-8029 }, { 104,-8029 }, { 105,-8029 }, { 106,-8029 }, { 107,-8029 },
 { 108,-8029 }, { 109,-8029 }, { 110,-8029 }, { 111,-8029 }, { 112,-8029 },
 { 113,-8029 }, { 114,-8029 }, { 115,-8029 }, { 116,-8029 }, { 117,-8029 },
 { 118,-8029 }, { 119,-8029 }, { 120,-8029 }, { 121,-8029 }, { 122,-8029 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,-8029 }, { 127,-8029 },

 { 128,-8029 }, { 129,-8029 }, { 130,-8029 }, { 131,-8029 }, { 132,-8029 },
 { 133,-8029 }, { 134,-8029 }, { 135,-8029 }, { 136,-8029 }, { 137,-8029 },
 { 138,-8029 }, { 139,-8029 }, { 140,-8029 }, { 141,-8029 }, { 142,-8029 },
 { 143,-8029 }, { 144,-8029 }, { 145,-8029 }, { 146,-8029 }, { 147,-8029 },
 { 148,-8029 }, { 149,-8029 }, { 150,-8029 }, { 151,-8029 }, { 152,-8029 },
 { 153,-8029 }, { 154,-8029 }, { 155,-8029 }, { 156,-8029 }, { 157,-8029 },
 { 158,-8029 }, { 159,-8029 }, { 160,-8029 }, { 161,-8029 }, { 162,-8029 },
 { 163,-8029 }, { 164,-8029 }, { 165,-8029 }, { 166,-8029 }, { 167,-8029 },
 { 168,-8029 }, { 169,-8029 }, { 170,-8029 }, { 171,-8029 }, { 172,-8029 },
 { 173,-8029 }, { 174,-8029 }, { 175,-8029 }, { 176,-8029 }, { 177,-8029 },

 { 178,-8029 }, { 179,-8029 }, { 180,-8029 }, { 181,-8029 }, { 182,-8029 },
 { 183,-8029 }, { 184,-8029 }, { 185,-8029 }, { 186,-8029 }, { 187,-8029 },
 { 188,-8029 }, { 189,-8029 }, { 190,-8029 }, { 191,-8029 }, { 192,-8029 },
 { 193,-8029 }, { 194,-8029 }, { 195,-8029 }, { 196,-8029 }, { 197,-8029 },
 { 198,-8029 }, { 199,-8029 }, { 200,-8029 }, { 201,-8029 }, { 202,-8029 },
 { 203,-8029 }, { 204,-8029 }, { 205,-8029 }, { 206,-8029 }, { 207,-8029 },
 { 208,-8029 }, { 209,-8029 }, { 210,-8029 }, { 211,-8029 }, { 212,-8029 },
 { 213,-8029 }, { 214,-8029 }, { 215,-8029 }, { 216,-8029 }, { 217,-8029 },
 { 218,-8029 }, { 219,-8029 }, { 220,-8029 }, { 221,-8029 }, { 222,-8029 },
 { 223,-8029 }, { 224,-8029 }, { 225,-8029 }, { 226,-8029 }, { 227,-8029 },

 { 228,-8029 }, { 229,-8029 }, { 230,-8029 }, { 231,-8029 }, { 232,-8029 },
 { 233,-8029 }, { 234,-8029 }, { 235,-8029 }, { 236,-8029 }, { 237,-8029 },
 { 238,-8029 }, { 239,-8029 }, { 240,-8029 }, { 241,-8029 }, { 242,-8029 },
 { 243,-8029 }, { 244,-8029 }, { 245,-8029 }, { 246,-8029 }, { 247,-8029 },
 { 248,-8029 }, { 249,-8029 }, { 250,-8029 }, { 251,-8029 }, { 252,-8029 },
 { 253,-8029 }, { 254,-8029 }, { 255,-8029 }, { 256,-8029 }, {   0,  52 },
 {   0,2547 }, {   1,-8287 }, {   2,-8287 }, {   3,-8287 }, {   4,-8287 },
 {   5,-8287 }, {   6,-8287 }, {   7,-8287 }, {   8,-8287 }, {   0,   0 },
 {   0,   0 }, {  11,-8287 }, {   0,   0 }, {   0,   0 }, {  14,-8287 },
 {  15,-8287 }, {  16,-8287 }, {  17,-8287 }, {  18,-8287 }, {  19,-8287 },

 {  20,-8287 }, {  21,-8287 }, {  22,-8287 }, {  23,-8287 }, {  24,-8287 },
 {  25,-8287 }, {  26,-8287 }, {  27,-8287 }, {  28,-8287 }, {  29,-8287 },
 {  30,-8287 }, {  31,-8287 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-8287 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-258 }, {  49,-258 },
 {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 }, {  54,-258 },
 {  55,-258 }, {  56,-8287 }, {  57,-8287 }, {   0,   0 }, {  59,-8287 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-8287 }, {  66,-8287 }, {  67,-8287 }, {  68,-8287 }, {  69,-8287 },

 {  70,-8287 }, {  71,-8287 }, {  72,-8287 }, {  73,-8287 }, {  74,-8287 },
 {  75,-8287 }, {  76,-8287 }, {  77,-8287 }, {  78,-8287 }, {  79,-8287 },
 {  80,-8287 }, {  81,-8287 }, {  82,-8287 }, {  83,-8287 }, {  84,-8287 },
 {  85,-8287 }, {  86,-8287 }, {  87,-8287 }, {  88,-8287 }, {  89,-8287 },
 {  90,-8287 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-8287 },
 {  95,-8287 }, {  96,-8287 }, {  97,-8287 }, {  98,-8287 }, {  99,-8287 },
 { 100,-8287 }, { 101,-8287 }, { 102,-8287 }, { 103,-8287 }, { 104,-8287 },
 { 105,-8287 }, { 106,-8287 }, { 107,-8287 }, { 108,-8287 }, { 109,-8287 },
 { 110,-8287 }, { 111,-8287 }, { 112,-8287 }, { 113,-8287 }, { 114,-8287 },
 { 115,-8287 }, { 116,-8287 }, { 117,-8287 }, { 118,-8287 }, { 119,-8287 },

 { 120,-8287 }, { 121,-8287 }, { 122,-8287 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 126,-8287 }, { 127,-8287 }, { 128,-8287 }, { 129,-8287 },
 { 130,-8287 }, { 131,-8287 }, { 132,-8287 }, { 133,-8287 }, { 134,-8287 },
 { 135,-8287 }, { 136,-8287 }, { 137,-8287 }, { 138,-8287 }, { 139,-8287 },
 { 140,-8287 }, { 141,-8287 }, { 142,-8287 }, { 143,-8287 }, { 144,-8287 },
 { 145,-8287 }, { 146,-8287 }, { 147,-8287 }, { 148,-8287 }, { 149,-8287 },
 { 150,-8287 }, { 151,-8287 }, { 152,-8287 }, { 153,-8287 }, { 154,-8287 },
 { 155,-8287 }, { 156,-8287 }, { 157,-8287 }, { 158,-8287 }, { 159,-8287 },
 { 160,-8287 }, { 161,-8287 }, { 162,-8287 }, { 163,-8287 }, { 164,-8287 },
 { 165,-8287 }, { 166,-8287 }, { 167,-8287 }, { 168,-8287 }, { 169,-8287 },

 { 170,-8287 }, { 171,-8287 }, { 172,-8287 }, { 173,-8287 }, { 174,-8287 },
 { 175,-8287 }, { 176,-8287 }, { 177,-8287 }, { 178,-8287 }, { 179,-8287 },
 { 180,-8287 }, { 181,-8287 }, { 182,-8287 }, { 183,-8287 }, { 184,-8287 },
 { 185,-8287 }, { 186,-8287 }, { 187,-8287 }, { 188,-8287 }, { 189,-8287 },
 { 190,-8287 }, { 191,-8287 }, { 192,-8287 }, { 193,-8287 }, { 194,-8287 },
 { 195,-8287 }, { 196,-8287 }, { 197,-8287 }, { 198,-8287 }, { 199,-8287 },
 { 200,-8287 }, { 201,-8287 }, { 202,-8287 }, { 203,-8287 }, { 204,-8287 },
 { 205,-8287 }, { 206,-8287 }, { 207,-8287 }, { 208,-8287 }, { 209,-8287 },
 { 210,-8287 }, { 211,-8287 }, { 212,-8287 }, { 213,-8287 }, { 214,-8287 },
 { 215,-8287 }, { 216,-8287 }, { 217,-8287 }, { 218,-8287 }, { 219,-8287 },

 { 220,-8287 }, { 221,-8287 }, { 222,-8287 }, { 223,-8287 }, { 224,-8287 },
 { 225,-8287 }, { 226,-8287 }, { 227,-8287 }, { 228,-8287 }, { 229,-8287 },
 { 230,-8287 }, { 231,-8287 }, { 232,-8287 }, { 233,-8287 }, { 234,-8287 },
 { 235,-8287 }, { 236,-8287 }, { 237,-8287 }, { 238,-8287 }, { 239,-8287 },
 { 240,-8287 }, { 241,-8287 }, { 242,-8287 }, { 243,-8287 }, { 244,-8287 },
 { 245,-8287 }, { 246,-8287 }, { 247,-8287 }, { 248,-8287 }, { 249,-8287 },
 { 250,-8287 }, { 251,-8287 }, { 252,-8287 }, { 253,-8287 }, { 254,-8287 },
 { 255,-8287 }, { 256,-8287 }, {   0,  43 }, {   0,2289 }, {   1,-8545 },
 {   2,-8545 }, {   3,-8545 }, {   4,-8545 }, {   5,-8545 }, {   6,-8545 },
 {   7,-8545 }, {   8,-8545 }, {   0,   0 }, {   0,   0 }, {  11,-8545 },

 {   0,   0 }, {   0,   0 }, {  14,-8545 }, {  15,-8545 }, {  16,-8545 },
 {  17,-8545 }, {  18,-8545 }, {  19,-8545 }, {  20,-8545 }, {  21,-8545 },
 {  22,-8545 }, {  23,-8545 }, {  24,-8545 }, {  25,-8545 }, {  26,-8545 },
 {  27,-8545 }, {  28,-8545 }, {  29,-8545 }, {  30,-8545 }, {  31,-8545 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-8545 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {   0,   0 }, {  59,-8545 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,-8545 },
 {  72,-8545 }, {  73,-8545 }, {  74,-8545 }, {  75,-8545 }, {  76,-8545 },
 {  77,-8545 }, {  78,-8545 }, {  79,-8545 }, {  80,-8545 }, {  81,-8545 },
 {  82,-8545 }, {  83,-8545 }, {  84,-8545 }, {  85,-8545 }, {  86,-8545 },
 {  87,-8545 }, {  88,-8545 }, {  89,-8545 }, {  90,-8545 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,-8545 }, {  95, 258 }, {  96,-8545 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,-8545 }, { 104,-8545 }, { 105,-8545 }, { 106,-8545 },
 { 107,-8545 }, { 108,-8545 }, { 109,-8545 }, { 110,-8545 }, { 111,-8545 },

 { 112,-8545 }, { 113,-8545 }, { 114,-8545 }, { 115,-8545 }, { 116,-8545 },
 { 117,-8545 }, { 118,-8545 }, { 119,-8545 }, { 120,-8545 }, { 121,-8545 },
 { 122,-8545 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,-8545 },
 { 127,-8545 }, { 128,-8545 }, { 129,-8545 }, { 130,-8545 }, { 131,-8545 },
 { 132,-8545 }, { 133,-8545 }, { 134,-8545 }, { 135,-8545 }, { 136,-8545 },
 { 137,-8545 }, { 138,-8545 }, { 139,-8545 }, { 140,-8545 }, { 141,-8545 },
 { 142,-8545 }, { 143,-8545 }, { 144,-8545 }, { 145,-8545 }, { 146,-8545 },
 { 147,-8545 }, { 148,-8545 }, { 149,-8545 }, { 150,-8545 }, { 151,-8545 },
 { 152,-8545 }, { 153,-8545 }, { 154,-8545 }, { 155,-8545 }, { 156,-8545 },
 { 157,-8545 }, { 158,-8545 }, { 159,-8545 }, { 160,-8545 }, { 161,-8545 },

 { 162,-8545 }, { 163,-8545 }, { 164,-8545 }, { 165,-8545 }, { 166,-8545 },
 { 167,-8545 }, { 168,-8545 }, { 169,-8545 }, { 170,-8545 }, { 171,-8545 },
 { 172,-8545 }, { 173,-8545 }, { 174,-8545 }, { 175,-8545 }, { 176,-8545 },
 { 177,-8545 }, { 178,-8545 }, { 179,-8545 }, { 180,-8545 }, { 181,-8545 },
 { 182,-8545 }, { 183,-8545 }, { 184,-8545 }, { 185,-8545 }, { 186,-8545 },
 { 187,-8545 }, { 188,-8545 }, { 189,-8545 }, { 190,-8545 }, { 191,-8545 },
 { 192,-8545 }, { 193,-8545 }, { 194,-8545 }, { 195,-8545 }, { 196,-8545 },
 { 197,-8545 }, { 198,-8545 }, { 199,-8545 }, { 200,-8545 }, { 201,-8545 },
 { 202,-8545 }, { 203,-8545 }, { 204,-8545 }, { 205,-8545 }, { 206,-8545 },
 { 207,-8545 }, { 208,-8545 }, { 209,-8545 }, { 210,-8545 }, { 211,-8545 },

 { 212,-8545 }, { 213,-8545 }, { 214,-8545 }, { 215,-8545 }, { 216,-8545 },
 { 217,-8545 }, { 218,-8545 }, { 219,-8545 }, { 220,-8545 }, { 221,-8545 },
 { 222,-8545 }, { 223,-8545 }, { 224,-8545 }, { 225,-8545 }, { 226,-8545 },
 { 227,-8545 }, { 228,-8545 }, { 229,-8545 }, { 230,-8545 }, { 231,-8545 },
 { 232,-8545 }, { 233,-8545 }, { 234,-8545 }, { 235,-8545 }, { 236,-8545 },
 { 237,-8545 }, { 238,-8545 }, { 239,-8545 }, { 240,-8545 }, { 241,-8545 },
 { 242,-8545 }, { 243,-8545 }, { 244,-8545 }, { 245,-8545 }, { 246,-8545 },
 { 247,-8545 }, { 248,-8545 }, { 249,-8545 }, { 250,-8545 }, { 251,-8545 },
 { 252,-8545 }, { 253,-8545 }, { 254,-8545 }, { 255,-8545 }, { 256,-8545 },
 {   0,  52 }, {   0,2031 }, {   1,-8803 }, {   2,-8803 }, {   3,-8803 },

 {   4,-8803 }, {   5,-8803 }, {   6,-8803 }, {   7,-8803 }, {   8,-8803 },
 {   0,   0 }, {   0,   0 }, {  11,-8803 }, {   0,   0 }, {   0,   0 },
 {  14,-8803 }, {  15,-8803 }, {  16,-8803 }, {  17,-8803 }, {  18,-8803 },
 {  19,-8803 }, {  20,-8803 }, {  21,-8803 }, {  22,-8803 }, {  23,-8803 },
 {  24,-8803 }, {  25,-8803 }, {  26,-8803 }, {  27,-8803 }, {  28,-8803 },
 {  29,-8803 }, {  30,-8803 }, {  31,-8803 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-8803 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-258 },
 {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 },

 {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 }, {   0,   0 },
 {  59,-8803 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 },
 {  69,-258 }, {  70,-258 }, {  71,-8803 }, {  72,-8803 }, {  73,-8803 },
 {  74,-8803 }, {  75,-8803 }, {  76,-8803 }, {  77,-8803 }, {  78,-8803 },
 {  79,-8803 }, {  80,-8803 }, {  81,-8803 }, {  82,-8803 }, {  83,-8803 },
 {  84,-8803 }, {  85,-8803 }, {  86,-8803 }, {  87,-8803 }, {  88,-8803 },
 {  89,-8803 }, {  90,-8803 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,-8803 }, {  95,-8803 }, {  96,-8803 }, {  97,-258 }, {  98,-258 },
 {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-8803 },

 { 104,-8803 }, { 105,-8803 }, { 106,-8803 }, { 107,-8803 }, { 108,-8803 },
 { 109,-8803 }, { 110,-8803 }, { 111,-8803 }, { 112,-8803 }, { 113,-8803 },
 { 114,-8803 }, { 115,-8803 }, { 116,-8803 }, { 117,-8803 }, { 118,-8803 },
 { 119,-8803 }, { 120,-8803 }, { 121,-8803 }, { 122,-8803 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 126,-8803 }, { 127,-8803 }, { 128,-8803 },
 { 129,-8803 }, { 130,-8803 }, { 131,-8803 }, { 132,-8803 }, { 133,-8803 },
 { 134,-8803 }, { 135,-8803 }, { 136,-8803 }, { 137,-8803 }, { 138,-8803 },
 { 139,-8803 }, { 140,-8803 }, { 141,-8803 }, { 142,-8803 }, { 143,-8803 },
 { 144,-8803 }, { 145,-8803 }, { 146,-8803 }, { 147,-8803 }, { 148,-8803 },
 { 149,-8803 }, { 150,-8803 }, { 151,-8803 }, { 152,-8803 }, { 153,-8803 },

 { 154,-8803 }, { 155,-8803 }, { 156,-8803 }, { 157,-8803 }, { 158,-8803 },
 { 159,-8803 }, { 160,-8803 }, { 161,-8803 }, { 162,-8803 }, { 163,-8803 },
 { 164,-8803 }, { 165,-8803 }, { 166,-8803 }, { 167,-8803 }, { 168,-8803 },
 { 169,-8803 }, { 170,-8803 }, { 171,-8803 }, { 172,-8803 }, { 173,-8803 },
 { 174,-8803 }, { 175,-8803 }, { 176,-8803 }, { 177,-8803 }, { 178,-8803 },
 { 179,-8803 }, { 180,-8803 }, { 181,-8803 }, { 182,-8803 }, { 183,-8803 },
 { 184,-8803 }, { 185,-8803 }, { 186,-8803 }, { 187,-8803 }, { 188,-8803 },
 { 189,-8803 }, { 190,-8803 }, { 191,-8803 }, { 192,-8803 }, { 193,-8803 },
 { 194,-8803 }, { 195,-8803 }, { 196,-8803 }, { 197,-8803 }, { 198,-8803 },
 { 199,-8803 }, { 200,-8803 }, { 201,-8803 }, { 202,-8803 }, { 203,-8803 },

 { 204,-8803 }, { 205,-8803 }, { 206,-8803 }, { 207,-8803 }, { 208,-8803 },
 { 209,-8803 }, { 210,-8803 }, { 211,-8803 }, { 212,-8803 }, { 213,-8803 },
 { 214,-8803 }, { 215,-8803 }, { 216,-8803 }, { 217,-8803 }, { 218,-8803 },
 { 219,-8803 }, { 220,-8803 }, { 221,-8803 }, { 222,-8803 }, { 223,-8803 },
 { 224,-8803 }, { 225,-8803 }, { 226,-8803 }, { 227,-8803 }, { 228,-8803 },
 { 229,-8803 }, { 230,-8803 }, { 231,-8803 }, { 232,-8803 }, { 233,-8803 },
 { 234,-8803 }, { 235,-8803 }, { 236,-8803 }, { 237,-8803 }, { 238,-8803 },
 { 239,-8803 }, { 240,-8803 }, { 241,-8803 }, { 242,-8803 }, { 243,-8803 },
 { 244,-8803 }, { 245,-8803 }, { 246,-8803 }, { 247,-8803 }, { 248,-8803 },
 { 249,-8803 }, { 250,-8803 }, { 251,-8803 }, { 252,-8803 }, { 253,-8803 },

 { 254,-8803 }, { 255,-8803 }, { 256,-8803 }, {   0,  13 }, {   0,1773 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  13 }, {   0,1750 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  48, 968 }, {  49, 968 }, {  50, 968 },
 {  51, 968 }, {  52, 968 }, {  53, 968 }, {  54, 968 }, {  55, 968 },
 {  56, 968 }, {  57, 968 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 968 },
 {  66, 968 }, {  67, 968 }, {  68, 968 }, {  69, 968 }, {  70, 968 },
 {  48, 968 }, {  49, 968 }, {  50, 968 }, {  51, 968 }, {  52, 968 },
 {  53, 968 }, {  54, 968 }, {  55, 968 }, {  56, 968 }, {  57, 968 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65, 968 }, {  66, 968 }, {  67, 968 },
 {  68, 968 }, {  69, 968 }, {  70, 968 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  97, 968 }, {  98, 968 }, {  99, 968 }, { 100, 968 },
 { 101, 968 }, { 102, 968 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 968 },
 {  98, 968 }, {  99, 968 }, { 100, 968 }, { 101, 968 }, { 102, 968 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  40 }, {   0,1638 },
 {   1,-9461 }, {   2,-9461 }, {   3,-9461 }, {   4,-9461 }, {   5,-9461 },
 {   6,-9461 }, {   7,-9461 }, {   8,-9461 }, {   0,   0 }, {   0,   0 },

 {  11,-9461 }, {   0,   0 }, { 125,-9051 }, {  14,-9461 }, {  15,-9461 },
 {  16,-9461 }, {  17,-9461 }, {  18,-9461 }, {  19,-9461 }, {  20,-9461 },
 {  21,-9461 }, {  22,-9461 }, {  23,-9461 }, {  24,-9461 }, {  25,-9461 },
 {  26,-9461 }, {  27,-9461 }, {  28,-9461 }, {  29,-9461 }, {  30,-9461 },
 {  31,-9461 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-9461 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {  59,-9461 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-9461 },
 {  66,-9461 }, {  67,-9461 }, {  68,-9461 }, {  69,-9461 }, {  70,-9461 },
 {  71,-9461 }, {  72,-9461 }, {  73,-9461 }, {  74,-9461 }, {  75,-9461 },
 {  76,-9461 }, {  77,-9461 }, {  78,-9461 }, {  79,-9461 }, {  80,-9461 },
 {  81,-9461 }, {  82,-9461 }, {  83,-9461 }, {  84,-9461 }, {  85,-9461 },
 {  86,-9461 }, {  87,-9461 }, {  88,-9461 }, {  89,-9461 }, {  90,-9461 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-9461 }, {  95, 258 },
 {  96,-9461 }, {  97,-9461 }, {  98,-9461 }, {  99,-9461 }, { 100,-9461 },
 { 101,-9461 }, { 102,-9461 }, { 103,-9461 }, { 104,-9461 }, { 105,-9461 },
 { 106,-9461 }, { 107,-9461 }, { 108,-9461 }, { 109,-9461 }, { 110,-9461 },

 { 111,-9461 }, { 112,-9461 }, { 113,-9461 }, { 114,-9461 }, { 115,-9461 },
 { 116,-9461 }, { 117,-9461 }, { 118,-9461 }, { 119,-9461 }, { 120,-9461 },
 { 121,-9461 }, { 122,-9461 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 126,-9461 }, { 127,-9461 }, { 128,-9461 }, { 129,-9461 }, { 130,-9461 },
 { 131,-9461 }, { 132,-9461 }, { 133,-9461 }, { 134,-9461 }, { 135,-9461 },
 { 136,-9461 }, { 137,-9461 }, { 138,-9461 }, { 139,-9461 }, { 140,-9461 },
 { 141,-9461 }, { 142,-9461 }, { 143,-9461 }, { 144,-9461 }, { 145,-9461 },
 { 146,-9461 }, { 147,-9461 }, { 148,-9461 }, { 149,-9461 }, { 150,-9461 },
 { 151,-9461 }, { 152,-9461 }, { 153,-9461 }, { 154,-9461 }, { 155,-9461 },
 { 156,-9461 }, { 157,-9461 }, { 158,-9461 }, { 159,-9461 }, { 160,-9461 },

 { 161,-9461 }, { 162,-9461 }, { 163,-9461 }, { 164,-9461 }, { 165,-9461 },
 { 166,-9461 }, { 167,-9461 }, { 168,-9461 }, { 169,-9461 }, { 170,-9461 },
 { 171,-9461 }, { 172,-9461 }, { 173,-9461 }, { 174,-9461 }, { 175,-9461 },
 { 176,-9461 }, { 177,-9461 }, { 178,-9461 }, { 179,-9461 }, { 180,-9461 },
 { 181,-9461 }, { 182,-9461 }, { 183,-9461 }, { 184,-9461 }, { 185,-9461 },
 { 186,-9461 }, { 187,-9461 }, { 188,-9461 }, { 189,-9461 }, { 190,-9461 },
 { 191,-9461 }, { 192,-9461 }, { 193,-9461 }, { 194,-9461 }, { 195,-9461 },
 { 196,-9461 }, { 197,-9461 }, { 198,-9461 }, { 199,-9461 }, { 200,-9461 },
 { 201,-9461 }, { 202,-9461 }, { 203,-9461 }, { 204,-9461 }, { 205,-9461 },
 { 206,-9461 }, { 207,-9461 }, { 208,-9461 }, { 209,-9461 }, { 210,-9461 },

 { 211,-9461 }, { 212,-9461 }, { 213,-9461 }, { 214,-9461 }, { 215,-9461 },
 { 216,-9461 }, { 217,-9461 }, { 218,-9461 }, { 219,-9461 }, { 220,-9461 },
 { 221,-9461 }, { 222,-9461 }, { 223,-9461 }, { 224,-9461 }, { 225,-9461 },
 { 226,-9461 }, { 227,-9461 }, { 228,-9461 }, { 229,-9461 }, { 230,-9461 },
 { 231,-9461 }, { 232,-9461 }, { 233,-9461 }, { 234,-9461 }, { 235,-9461 },
 { 236,-9461 }, { 237,-9461 }, { 238,-9461 }, { 239,-9461 }, { 240,-9461 },
 { 241,-9461 }, { 242,-9461 }, { 243,-9461 }, { 244,-9461 }, { 245,-9461 },
 { 246,-9461 }, { 247,-9461 }, { 248,-9461 }, { 249,-9461 }, { 250,-9461 },
 { 251,-9461 }, { 252,-9461 }, { 253,-9461 }, { 254,-9461 }, { 255,-9461 },
 { 256,-9461 }, {   0,  49 }, {   0,1380 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48, 710 }, {  49, 710 }, {  50, 710 }, {  51, 710 }, {  52, 710 },

 {  53, 710 }, {  54, 710 }, {  55, 710 }, {  56, 710 }, {  57, 710 },
 {   0,  41 }, {   0,1321 }, {   1,-9782 }, {   2,-9782 }, {   3,-9782 },
 {   4,-9782 }, {   5,-9782 }, {   6,-9782 }, {   7,-9782 }, {   8,-9782 },
 {   0,   0 }, {   0,   0 }, {  11,-9782 }, {   0,   0 }, {   0,   0 },
 {  14,-9782 }, {  15,-9782 }, {  16,-9782 }, {  17,-9782 }, {  18,-9782 },
 {  19,-9782 }, {  20,-9782 }, {  21,-9782 }, {  22,-9782 }, {  23,-9782 },
 {  24,-9782 }, {  25,-9782 }, {  26,-9782 }, {  27,-9782 }, {  28,-9782 },
 {  29,-9782 }, {  30,-9782 }, {  31,-9782 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-9782 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-3091 },
 {  49,-3091 }, {  50,-3091 }, {  51,-3091 }, {  52,-3091 }, {  53,-3091 },
 {  54,-3091 }, {  55,-3091 }, {  56,-3091 }, {  57,-3091 }, {   0,   0 },
 {  59,-9782 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-9782 }, {  66,-9782 }, {  67,-9782 }, {  68,-9782 },
 {  69,-5448 }, {  70,-9782 }, {  71,-9782 }, {  72,-9782 }, {  73,-9782 },
 {  74,-9782 }, {  75,-9782 }, {  76,-9782 }, {  77,-9782 }, {  78,-9782 },
 {  79,-9782 }, {  80,-9782 }, {  81,-9782 }, {  82,-9782 }, {  83,-9782 },
 {  84,-9782 }, {  85,-9782 }, {  86,-9782 }, {  87,-9782 }, {  88,-9782 },
 {  89,-9782 }, {  90,-9782 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  94,-9782 }, {  95,-2833 }, {  96,-9782 }, {  97,-9782 }, {  98,-9782 },
 {  99,-9782 }, { 100,-9782 }, { 101,-5448 }, { 102,-9782 }, { 103,-9782 },
 { 104,-9782 }, { 105,-9782 }, { 106,-9782 }, { 107,-9782 }, { 108,-9782 },
 { 109,-9782 }, { 110,-9782 }, { 111,-9782 }, { 112,-9782 }, { 113,-9782 },
 { 114,-9782 }, { 115,-9782 }, { 116,-9782 }, { 117,-9782 }, { 118,-9782 },
 { 119,-9782 }, { 120,-9782 }, { 121,-9782 }, { 122,-9782 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 126,-9782 }, { 127,-9782 }, { 128,-9782 },
 { 129,-9782 }, { 130,-9782 }, { 131,-9782 }, { 132,-9782 }, { 133,-9782 },
 { 134,-9782 }, { 135,-9782 }, { 136,-9782 }, { 137,-9782 }, { 138,-9782 },
 { 139,-9782 }, { 140,-9782 }, { 141,-9782 }, { 142,-9782 }, { 143,-9782 },

 { 144,-9782 }, { 145,-9782 }, { 146,-9782 }, { 147,-9782 }, { 148,-9782 },
 { 149,-9782 }, { 150,-9782 }, { 151,-9782 }, { 152,-9782 }, { 153,-9782 },
 { 154,-9782 }, { 155,-9782 }, { 156,-9782 }, { 157,-9782 }, { 158,-9782 },
 { 159,-9782 }, { 160,-9782 }, { 161,-9782 }, { 162,-9782 }, { 163,-9782 },
 { 164,-9782 }, { 165,-9782 }, { 166,-9782 }, { 167,-9782 }, { 168,-9782 },
 { 169,-9782 }, { 170,-9782 }, { 171,-9782 }, { 172,-9782 }, { 173,-9782 },
 { 174,-9782 }, { 175,-9782 }, { 176,-9782 }, { 177,-9782 }, { 178,-9782 },
 { 179,-9782 }, { 180,-9782 }, { 181,-9782 }, { 182,-9782 }, { 183,-9782 },
 { 184,-9782 }, { 185,-9782 }, { 186,-9782 }, { 187,-9782 }, { 188,-9782 },
 { 189,-9782 }, { 190,-9782 }, { 191,-9782 }, { 192,-9782 }, { 193,-9782 },

 { 194,-9782 }, { 195,-9782 }, { 196,-9782 }, { 197,-9782 }, { 198,-9782 },
 { 199,-9782 }, { 200,-9782 }, { 201,-9782 }, { 202,-9782 }, { 203,-9782 },
 { 204,-9782 }, { 205,-9782 }, { 206,-9782 }, { 207,-9782 }, { 208,-9782 },
 { 209,-9782 }, { 210,-9782 }, { 211,-9782 }, { 212,-9782 }, { 213,-9782 },
 { 214,-9782 }, { 215,-9782 }, { 216,-9782 }, { 217,-9782 }, { 218,-9782 },
 { 219,-9782 }, { 220,-9782 }, { 221,-9782 }, { 222,-9782 }, { 223,-9782 },
 { 224,-9782 }, { 225,-9782 }, { 226,-9782 }, { 227,-9782 }, { 228,-9782 },
 { 229,-9782 }, { 230,-9782 }, { 231,-9782 }, { 232,-9782 }, { 233,-9782 },
 { 234,-9782 }, { 235,-9782 }, { 236,-9782 }, { 237,-9782 }, { 238,-9782 },
 { 239,-9782 }, { 240,-9782 }, { 241,-9782 }, { 242,-9782 }, { 243,-9782 },

 { 244,-9782 }, { 245,-9782 }, { 246,-9782 }, { 247,-9782 }, { 248,-9782 },
 { 249,-9782 }, { 250,-9782 }, { 251,-9782 }, { 252,-9782 }, { 253,-9782 },
 { 254,-9782 }, { 255,-9782 }, { 256,-9782 }, {   0,  40 }, {   0,1063 },
 {   1,-2516 }, {   2,-2516 }, {   3,-2516 }, {   4,-2516 }, {   5,-2516 },
 {   6,-2516 }, {   7,-2516 }, {   8,-2516 }, {   0,   0 }, {   0,   0 },
 {  11,-2516 }, {   0,   0 }, {   0,   0 }, {  14,-2516 }, {  15,-2516 },
 {  16,-2516 }, {  17,-2516 }, {  18,-2516 }, {  19,-2516 }, {  20,-2516 },
 {  21,-2516 }, {  22,-2516 }, {  23,-2516 }, {  24,-2516 }, {  25,-2516 },
 {  26,-2516 }, {  27,-2516 }, {  28,-2516 }, {  29,-2516 }, {  30,-2516 },
 {  31,-2516 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-2516 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-2258 }, {  49,-2258 }, {  50,-2258 },
 {  51,-2258 }, {  52,-2258 }, {  53,-2258 }, {  54,-2258 }, {  55,-2258 },
 {  56,-2258 }, {  57,-2258 }, {   0,   0 }, {  59,-2516 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-2516 },
 {  66,-2516 }, {  67,-2516 }, {  68,-2516 }, {  69,-2516 }, {  70,-2516 },
 {  71,-2516 }, {  72,-2516 }, {  73,-2516 }, {  74,-2516 }, {  75,-2516 },
 {  76,-2516 }, {  77,-2516 }, {  78,-2516 }, {  79,-2516 }, {  80,-2516 },
 {  81,-2516 }, {  82,-2516 }, {  83,-2516 }, {  84,-2516 }, {  85,-2516 },

 {  86,-2516 }, {  87,-2516 }, {  88,-2516 }, {  89,-2516 }, {  90,-2516 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-2516 }, {  95,-2000 },
 {  96,-2516 }, {  97,-2516 }, {  98,-2516 }, {  99,-2516 }, { 100,-2516 },
 { 101,-2516 }, { 102,-2516 }, { 103,-2516 }, { 104,-2516 }, { 105,-2516 },
 { 106,-2516 }, { 107,-2516 }, { 108,-2516 }, { 109,-2516 }, { 110,-2516 },
 { 111,-2516 }, { 112,-2516 }, { 113,-2516 }, { 114,-2516 }, { 115,-2516 },
 { 116,-2516 }, { 117,-2516 }, { 118,-2516 }, { 119,-2516 }, { 120,-2516 },
 { 121,-2516 }, { 122,-2516 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 126,-2516 }, { 127,-2516 }, { 128,-2516 }, { 129,-2516 }, { 130,-2516 },
 { 131,-2516 }, { 132,-2516 }, { 133,-2516 }, { 134,-2516 }, { 135,-2516 },

 { 136,-2516 }, { 137,-2516 }, { 138,-2516 }, { 139,-2516 }, { 140,-2516 },
 { 141,-2516 }, { 142,-2516 }, { 143,-2516 }, { 144,-2516 }, { 145,-2516 },
 { 146,-2516 }, { 147,-2516 }, { 148,-2516 }, { 149,-2516 }, { 150,-2516 },
 { 151,-2516 }, { 152,-2516 }, { 153,-2516 }, { 154,-2516 }, { 155,-2516 },
 { 156,-2516 }, { 157,-2516 }, { 158,-2516 }, { 159,-2516 }, { 160,-2516 },
 { 161,-2516 }, { 162,-2516 }, { 163,-2516 }, { 164,-2516 }, { 165,-2516 },
 { 166,-2516 }, { 167,-2516 }, { 168,-2516 }, { 169,-2516 }, { 170,-2516 },
 { 171,-2516 }, { 172,-2516 }, { 173,-2516 }, { 174,-2516 }, { 175,-2516 },
 { 176,-2516 }, { 177,-2516 }, { 178,-2516 }, { 179,-2516 }, { 180,-2516 },
 { 181,-2516 }, { 182,-2516 }, { 183,-2516 }, { 184,-2516 }, { 185,-2516 },

 { 186,-2516 }, { 187,-2516 }, { 188,-2516 }, { 189,-2516 }, { 190,-2516 },
 { 191,-2516 }, { 192,-2516 }, { 193,-2516 }, { 194,-2516 }, { 195,-2516 },
 { 196,-2516 }, { 197,-2516 }, { 198,-2516 }, { 199,-2516 }, { 200,-2516 },
 { 201,-2516 }, { 202,-2516 }, { 203,-2516 }, { 204,-2516 }, { 205,-2516 },
 { 206,-2516 }, { 207,-2516 }, { 208,-2516 }, { 209,-2516 }, { 210,-2516 },
 { 211,-2516 }, { 212,-2516 }, { 213,-2516 }, { 214,-2516 }, { 215,-2516 },
 { 216,-2516 }, { 217,-2516 }, { 218,-2516 }, { 219,-2516 }, { 220,-2516 },
 { 221,-2516 }, { 222,-2516 }, { 223,-2516 }, { 224,-2516 }, { 225,-2516 },
 { 226,-2516 }, { 227,-2516 }, { 228,-2516 }, { 229,-2516 }, { 230,-2516 },
 { 231,-2516 }, { 232,-2516 }, { 233,-2516 }, { 234,-2516 }, { 235,-2516 },

 { 236,-2516 }, { 237,-2516 }, { 238,-2516 }, { 239,-2516 }, { 240,-2516 },
 { 241,-2516 }, { 242,-2516 }, { 243,-2516 }, { 244,-2516 }, { 245,-2516 },
 { 246,-2516 }, { 247,-2516 }, { 248,-2516 }, { 249,-2516 }, { 250,-2516 },
 { 251,-2516 }, { 252,-2516 }, { 253,-2516 }, { 254,-2516 }, { 255,-2516 },
 { 256,-2516 }, {   0,  13 }, {   0, 805 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  13 },
 {   0, 782 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-9996 }, {  49,-9996 }, {  50,-9996 }, {  51,-9996 }, {  52,-9996 },
 {  53,-9996 }, {  54,-9996 }, {  55,-9996 }, {  56,-9996 }, {  57,-9996 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-9996 }, {  66,-9996 }, {  67,-9996 },
 {  68,-9996 }, {  69,-9996 }, {  70,-9996 }, {  48, 370 }, {  49, 370 },
 {  50, 370 }, {  51, 370 }, {  52, 370 }, {  53, 370 }, {  54, 370 },

 {  55, 370 }, {  56, 370 }, {  57, 370 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65, 370 }, {  66, 370 }, {  67, 370 }, {  68, 370 }, {  69, 370 },
 {  70, 370 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-9996 },
 {  98,-9996 }, {  99,-9996 }, { 100,-9996 }, { 101,-9996 }, { 102,-9996 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97, 370 }, {  98, 370 }, {  99, 370 },
 { 100, 370 }, { 101, 370 }, { 102, 370 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  40 }, {   0, 670 }, {   1,-10429 }, {   2,-10429 },
 {   3,-10429 }, {   4,-10429 }, {   5,-10429 }, {   6,-10429 }, {   7,-10429 },
 {   8,-10429 }, {   0,   0 }, {   0,   0 }, {  11,-10429 }, {   0,   0 },
 { 125,-10019 }, {  14,-10429 }, {  15,-10429 }, {  16,-10429 }, {  17,-10429 },
 {  18,-10429 }, {  19,-10429 }, {  20,-10429 }, {  21,-10429 }, {  22,-10429 },
 {  23,-10429 }, {  24,-10429 }, {  25,-10429 }, {  26,-10429 }, {  27,-10429 },
 {  28,-10429 }, {  29,-10429 }, {  30,-10429 }, {  31,-10429 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  39,-10429 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-968 }, {  49,-968 }, {  50,-968 }, {  51,-968 }, {  52,-968 },
 {  53,-968 }, {  54,-968 }, {  55,-968 }, {  56,-968 }, {  57,-968 },
 {   0,   0 }, {  59,-10429 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-10429 }, {  66,-10429 }, {  67,-10429 },
 {  68,-10429 }, {  69,-10429 }, {  70,-10429 }, {  71,-10429 }, {  72,-10429 },
 {  73,-10429 }, {  74,-10429 }, {  75,-10429 }, {  76,-10429 }, {  77,-10429 },
 {  78,-10429 }, {  79,-10429 }, {  80,-10429 }, {  81,-10429 }, {  82,-10429 },
 {  83,-10429 }, {  84,-10429 }, {  85,-10429 }, {  86,-10429 }, {  87,-10429 },
 {  88,-10429 }, {  89,-10429 }, {  90,-10429 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  94,-10429 }, {  95,-710 }, {  96,-10429 }, {  97,-10429 },
 {  98,-10429 }, {  99,-10429 }, { 100,-10429 }, { 101,-10429 }, { 102,-10429 },
 { 103,-10429 }, { 104,-10429 }, { 105,-10429 }, { 106,-10429 }, { 107,-10429 },
 { 108,-10429 }, { 109,-10429 }, { 110,-10429 }, { 111,-10429 }, { 112,-10429 },
 { 113,-10429 }, { 114,-10429 }, { 115,-10429 }, { 116,-10429 }, { 117,-10429 },
 { 118,-10429 }, { 119,-10429 }, { 120,-10429 }, { 121,-10429 }, { 122,-10429 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 126,-10429 }, { 127,-10429 },
 { 128,-10429 }, { 129,-10429 }, { 130,-10429 }, { 131,-10429 }, { 132,-10429 },
 { 133,-10429 }, { 134,-10429 }, { 135,-10429 }, { 136,-10429 }, { 137,-10429 },
 { 138,-10429 }, { 139,-10429 }, { 140,-10429 }, { 141,-10429 }, { 142,-10429 },

 { 143,-10429 }, { 144,-10429 }, { 145,-10429 }, { 146,-10429 }, { 147,-10429 },
 { 148,-10429 }, { 149,-10429 }, { 150,-10429 }, { 151,-10429 }, { 152,-10429 },
 { 153,-10429 }, { 154,-10429 }, { 155,-10429 }, { 156,-10429 }, { 157,-10429 },
 { 158,-10429 }, { 159,-10429 }, { 160,-10429 }, { 161,-10429 }, { 162,-10429 },
 { 163,-10429 }, { 164,-10429 }, { 165,-10429 }, { 166,-10429 }, { 167,-10429 },
 { 168,-10429 }, { 169,-10429 }, { 170,-10429 }, { 171,-10429 }, { 172,-10429 },
 { 173,-10429 }, { 174,-10429 }, { 175,-10429 }, { 176,-10429 }, { 177,-10429 },
 { 178,-10429 }, { 179,-10429 }, { 180,-10429 }, { 181,-10429 }, { 182,-10429 },
 { 183,-10429 }, { 184,-10429 }, { 185,-10429 }, { 186,-10429 }, { 187,-10429 },
 { 188,-10429 }, { 189,-10429 }, { 190,-10429 }, { 191,-10429 }, { 192,-10429 },

 { 193,-10429 }, { 194,-10429 }, { 195,-10429 }, { 196,-10429 }, { 197,-10429 },
 { 198,-10429 }, { 199,-10429 }, { 200,-10429 }, { 201,-10429 }, { 202,-10429 },
 { 203,-10429 }, { 204,-10429 }, { 205,-10429 }, { 206,-10429 }, { 207,-10429 },
 { 208,-10429 }, { 209,-10429 }, { 210,-10429 }, { 211,-10429 }, { 212,-10429 },
 { 213,-10429 }, { 214,-10429 }, { 215,-10429 }, { 216,-10429 }, { 217,-10429 },
 { 218,-10429 }, { 219,-10429 }, { 220,-10429 }, { 221,-10429 }, { 222,-10429 },
 { 223,-10429 }, { 224,-10429 }, { 225,-10429 }, { 226,-10429 }, { 227,-10429 },
 { 228,-10429 }, { 229,-10429 }, { 230,-10429 }, { 231,-10429 }, { 232,-10429 },
 { 233,-10429 }, { 234,-10429 }, { 235,-10429 }, { 236,-10429 }, { 237,-10429 },
 { 238,-10429 }, { 239,-10429 }, { 240,-10429 }, { 241,-10429 }, { 242,-10429 },

 { 243,-10429 }, { 244,-10429 }, { 245,-10429 }, { 246,-10429 }, { 247,-10429 },
 { 248,-10429 }, { 249,-10429 }, { 250,-10429 }, { 251,-10429 }, { 252,-10429 },
 { 253,-10429 }, { 254,-10429 }, { 255,-10429 }, { 256,-10429 }, {   0,  13 },
 {   0, 412 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,  13 }, {   0, 374 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,  38 }, {  49,  38 },
 {  50,  38 }, {  51,  38 }, {  52,  38 }, {  53,  38 }, {  54,  38 },
 {  55,  38 }, {  56,  38 }, {  57,  38 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,  38 }, {  66,  38 }, {  67,  38 }, {  68,  38 }, {  69,  38 },
 {  70,  38 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  48, 116 }, {  49, 116 }, {  50, 116 }, {  51, 116 },
 {  52, 116 }, {  53, 116 }, {  54, 116 }, {  55, 116 }, {  56, 116 },
 {  57, 116 }, {   0,   0 }, {  97,  38 }, {  98,  38 }, {  99,  38 },
 { 100,  38 }, { 101,  38 }, { 102,  38 }, {  65, 116 }, {  66, 116 },
 {  67, 116 }, {  68, 116 }, {  69, 116 }, {  70, 116 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  13 }, {   0, 296 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 125,-10389 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  97, 116 }, {  98, 116 }, {  99, 116 }, { 100, 116 }, { 101, 116 },
 { 102, 116 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  13 }, {   0, 258 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 125,-10427 }, {  48,-4797 },
 {  49,-4797 }, {  50,-4797 }, {  51,-4797 }, {  52,-4797 }, {  53,-4797 },
 {  54,-4797 }, {  55,-4797 }, {  56,-4797 }, {  57,-4797 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-4797 }, {  66,-4797 }, {  67,-4797 }, {  68,-4797 },

 {  69,-4797 }, {  70,-4797 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-7457 }, {  49,-7457 }, {  50,-7457 },
 {  51,-7457 }, {  52,-7457 }, {  53,-7457 }, {  54,-7457 }, {  55,-7457 },
 {  56,-7457 }, {  57,-7457 }, {   0,   0 }, {  97,-4797 }, {  98,-4797 },
 {  99,-4797 }, { 100,-4797 }, { 101,-4797 }, { 102,-4797 }, {  65,-7457 },
 {  66,-7457 }, {  67,-7457 }, {  68,-7457 }, {  69,-7457 }, {  70,-7457 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 123,-4774 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,-7457 }, {  98,-7457 }, {  99,-7457 }, { 100,-7457 },
 { 101,-7457 }, { 102,-7457 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 125,-10543 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 257,  54 }, {   1,   0 },    };

static const struct yy_trans_info *yy_start_state_list[11] =
    {
    &yy_transition[1],
    &yy_transition[3],
    &yy_transition[261],
    &yy_transition[519],
    &yy_transition[777],
    &yy_transition[1035],
    &yy_transition[1293],
    &yy_transition[1551],
    &yy_transition[1809],
    &yy_transition[2067],
    &yy_transition[2325],

    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"

#line 33 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
struct jsonpath_yy_extra_type
{
	JsonPathString scanstring;
};

static void addstring(bool init, char *s, int l, yyscan_t yyscanner);
static void addchar(bool init, char c, yyscan_t yyscanner);
static enum yytokentype checkKeyword(yyscan_t yyscanner);
static bool parseUnicode(char *s, int l, struct Node *escontext, yyscan_t yyscanner);
static bool parseHexChar(char *s, struct Node *escontext, yyscan_t yyscanner);

/* Avoid exit() on fatal scanner errors (a bit ugly -- see yy_fatal_error) */
#undef fprintf
#define fprintf(file, fmt, msg)  fprintf_to_ereport(fmt, msg)

static void
fprintf_to_ereport(const char *fmt, const char *msg)
{
	ereport(ERROR, (errmsg_internal("%s", msg)));
}

/* LCOV_EXCL_START */

#line 4089 "jsonpath_scan.c"
#define YY_NO_INPUT 1
/*
 * We use exclusive states for quoted and non-quoted strings,
 * quoted variable names and C-style comments.
 * Exclusive states:
 *  <xq> - quoted strings
 *  <xnq> - non-quoted strings
 *  <xvq> - quoted variable names
 *  <xc> - C-style comment
 */

/* "other" means anything that's not special, blank, or '\' or '"' */
/* DecimalInteger in ECMAScript; must not start with 0 unless it's exactly 0 */
/* DecimalDigits in ECMAScript; only used as part of other rules */
/* Non-decimal integers; in ECMAScript, these must not have underscore after prefix */
#line 4105 "jsonpath_scan.c"

#define INITIAL 0
#define xq 1
#define xnq 2
#define xvq 3
#define xc 4

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#define YY_EXTRA_TYPE struct jsonpath_yy_extra_type *

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			int yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 120 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"


#line 4382 "jsonpath_scan.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start_state_list[yyg->yy_start];
yy_match:
		{
		const struct yy_trans_info *yy_trans_info;

		YY_CHAR yy_c;

		for ( yy_c = YY_SC_TO_UI(*yy_cp);
		      (yy_trans_info = &yy_current_state[yy_c])->
		yy_verify == yy_c;
		      yy_c = YY_SC_TO_UI(*++yy_cp) )
			yy_current_state += yy_trans_info->yy_nxt;
		}

yy_find_action:
		yy_act = yy_current_state[-1].yy_nxt;

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
YY_RULE_SETUP
#line 122 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									addstring(false, yytext, yyleng, yyscanner);
								}
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 126 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									yylval->str = yyextra->scanstring;
									BEGIN INITIAL;
									return checkKeyword(yyscanner);
								}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 132 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									yylval->str = yyextra->scanstring;
									BEGIN xc;
								}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 137 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									yylval->str = yyextra->scanstring;
									yyless(0);
									BEGIN INITIAL;
									return checkKeyword(yyscanner);
								}
	YY_BREAK
case YY_STATE_EOF(xnq):
#line 144 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									yylval->str = yyextra->scanstring;
									BEGIN INITIAL;
									return checkKeyword(yyscanner);
								}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 150 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ addchar(false, '\b', yyscanner); }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 152 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ addchar(false, '\f', yyscanner); }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 154 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ addchar(false, '\n', yyscanner); }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 156 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ addchar(false, '\r', yyscanner); }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 158 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ addchar(false, '\t', yyscanner); }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 160 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ addchar(false, '\v', yyscanner); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 162 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
								if (!parseUnicode(yytext, yyleng, escontext, yyscanner))
									yyterminate();
							}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 167 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
								if (!parseHexChar(yytext, escontext, yyscanner))
									yyterminate();
							}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 172 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
								jsonpath_yyerror(NULL, escontext, yyscanner,
												 "invalid Unicode escape sequence");
								yyterminate();
							}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 178 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
								jsonpath_yyerror(NULL, escontext, yyscanner,
												 "invalid hexadecimal character sequence");
								yyterminate();
							}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 184 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
								/* throw back the \\, and treat as unicode */
								yyless(yyleng - 1);
								if (!parseUnicode(yytext, yyleng, escontext, yyscanner))
									yyterminate();
							}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 191 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ addchar(false, yytext[1], yyscanner); }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 193 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
								jsonpath_yyerror(NULL, escontext, yyscanner,
												 "unexpected end after backslash");
								yyterminate();
							}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xvq):
#line 199 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
								jsonpath_yyerror(NULL, escontext, yyscanner,
												 "unterminated quoted string");
								yyterminate();
							}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 205 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									yylval->str = yyextra->scanstring;
									BEGIN INITIAL;
									return STRING_P;
								}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 211 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									yylval->str = yyextra->scanstring;
									BEGIN INITIAL;
									return VARIABLE_P;
								}
	YY_BREAK
case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 217 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ addstring(false, yytext, yyleng, yyscanner); }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 219 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ BEGIN INITIAL; }
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 221 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 223 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ }
	YY_BREAK
case YY_STATE_EOF(xc):
#line 225 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									jsonpath_yyerror(NULL, escontext, yyscanner,
													 "unexpected end of comment");
									yyterminate();
								}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 230 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ return AND_P; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 232 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ return OR_P; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 234 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ return NOT_P; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 236 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ return ANY_P; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 238 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ return LESS_P; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 240 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ return LESSEQUAL_P; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 242 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ return EQUAL_P; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 244 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ return NOTEQUAL_P; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 246 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ return NOTEQUAL_P; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 248 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ return GREATEREQUAL_P; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 250 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ return GREATER_P; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 252 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									addstring(true, yytext + 1, yyleng - 1, yyscanner);
									addchar(false, '\0', yyscanner);
									yylval->str = yyextra->scanstring;
									return VARIABLE_P;
								}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 259 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									addchar(true, '\0', yyscanner);
									BEGIN xvq;
								}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 264 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ return *yytext; }
	YY_BREAK
case 38:
/* rule 38 can match eol */
YY_RULE_SETUP
#line 266 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ /* ignore */ }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 268 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									addchar(true, '\0', yyscanner);
									BEGIN xc;
								}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 273 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									addstring(true, yytext, yyleng, yyscanner);
									addchar(false, '\0', yyscanner);
									yylval->str = yyextra->scanstring;
									return NUMERIC_P;
								}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 280 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									addstring(true, yytext, yyleng, yyscanner);
									addchar(false, '\0', yyscanner);
									yylval->str = yyextra->scanstring;
									return NUMERIC_P;
								}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 287 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									addstring(true, yytext, yyleng, yyscanner);
									addchar(false, '\0', yyscanner);
									yylval->str = yyextra->scanstring;
									return INT_P;
								}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 294 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									addstring(true, yytext, yyleng, yyscanner);
									addchar(false, '\0', yyscanner);
									yylval->str = yyextra->scanstring;
									return INT_P;
								}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 301 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									addstring(true, yytext, yyleng, yyscanner);
									addchar(false, '\0', yyscanner);
									yylval->str = yyextra->scanstring;
									return INT_P;
								}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 308 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									addstring(true, yytext, yyleng, yyscanner);
									addchar(false, '\0', yyscanner);
									yylval->str = yyextra->scanstring;
									return INT_P;
								}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 315 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									jsonpath_yyerror(NULL, escontext, yyscanner,
													 "invalid numeric literal");
									yyterminate();
								}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 320 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									jsonpath_yyerror(NULL, escontext, yyscanner,
													 "trailing junk after numeric literal");
									yyterminate();
								}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 325 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									jsonpath_yyerror(NULL, escontext, yyscanner,
													 "trailing junk after numeric literal");
									yyterminate();
								}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 330 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									jsonpath_yyerror(NULL, escontext, yyscanner,
													 "trailing junk after numeric literal");
									yyterminate();
								}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 335 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									addchar(true, '\0', yyscanner);
									BEGIN xq;
								}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 340 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									yyless(0);
									addchar(true, '\0', yyscanner);
									BEGIN xnq;
								}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 346 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{
									addstring(true, yytext, yyleng, yyscanner);
									BEGIN xnq;
								}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 351 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
{ yyterminate(); }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 353 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 4829 "jsonpath_scan.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yy_start_state_list[yyg->yy_start];

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		yy_current_state += yy_current_state[(*yy_cp ? YY_SC_TO_UI(*yy_cp) : 256)].yy_nxt;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */

	int yy_c = 256;
	const struct yy_trans_info *yy_trans_info;

	yy_trans_info = &yy_current_state[(unsigned int) yy_c];
	yy_current_state += yy_trans_info->yy_nxt;
	yy_is_jam = (yy_trans_info->yy_verify != yy_c);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr);
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf , yyscanner );

	yyfree( (void *) b , yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack(yyscanner);

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER , yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr , yyscan_t yyscanner)
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) , yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n , yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n , yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int yyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int yyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int yyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *yyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void yyset_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void yyset_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void yyset_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int yyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void yyset_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * yyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void yyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )
{
    struct yyguts_t dummy_yyguts;

    yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    yyset_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER , yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	yyfree(yyg->yy_buffer_stack , yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        yyfree( yyg->yy_start_stack , yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 353 "/build/postgresql/src/build/../postgresql-18.0/src/backend/utils/adt/jsonpath_scan.l"


/* LCOV_EXCL_STOP */

/* see scan.l */
#undef yyextra
#define yyextra  (((struct yyguts_t *) yyscanner)->yyextra_r)

void
jsonpath_yyerror(JsonPathParseResult **result, struct Node *escontext,
				 yyscan_t yyscanner,
				 const char *message)
{
	struct yyguts_t *yyg = (struct yyguts_t *) yyscanner;	/* needed for yytext
															 * macro */

	/* don't overwrite escontext if it's already been set */
	if (SOFT_ERROR_OCCURRED(escontext))
		return;

	if (*yytext == YY_END_OF_BUFFER_CHAR)
	{
		errsave(escontext,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: %s is typically "syntax error" */
				 errmsg("%s at end of jsonpath input", _(message))));
	}
	else
	{
		errsave(escontext,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: first %s is typically "syntax error" */
				 errmsg("%s at or near \"%s\" of jsonpath input",
						_(message), yytext)));
	}
}

typedef struct JsonPathKeyword
{
	int16		len;
	bool		lowercase;
	int			val;
	const char *keyword;
} JsonPathKeyword;

/*
 * Array of key words should be sorted by length and then
 * alphabetical order
 */
static const JsonPathKeyword keywords[] = {
	{2, false, IS_P, "is"},
	{2, false, TO_P, "to"},
	{3, false, ABS_P, "abs"},
	{3, false, LAX_P, "lax"},
	{4, false, DATE_P, "date"},
	{4, false, FLAG_P, "flag"},
	{4, false, LAST_P, "last"},
	{4, true, NULL_P, "null"},
	{4, false, SIZE_P, "size"},
	{4, false, TIME_P, "time"},
	{4, true, TRUE_P, "true"},
	{4, false, TYPE_P, "type"},
	{4, false, WITH_P, "with"},
	{5, true, FALSE_P, "false"},
	{5, false, FLOOR_P, "floor"},
	{6, false, BIGINT_P, "bigint"},
	{6, false, DOUBLE_P, "double"},
	{6, false, EXISTS_P, "exists"},
	{6, false, NUMBER_P, "number"},
	{6, false, STARTS_P, "starts"},
	{6, false, STRICT_P, "strict"},
	{6, false, STRINGFUNC_P, "string"},
	{7, false, BOOLEAN_P, "boolean"},
	{7, false, CEILING_P, "ceiling"},
	{7, false, DECIMAL_P, "decimal"},
	{7, false, INTEGER_P, "integer"},
	{7, false, TIME_TZ_P, "time_tz"},
	{7, false, UNKNOWN_P, "unknown"},
	{8, false, DATETIME_P, "datetime"},
	{8, false, KEYVALUE_P, "keyvalue"},
	{9, false, TIMESTAMP_P, "timestamp"},
	{10, false, LIKE_REGEX_P, "like_regex"},
	{12, false, TIMESTAMP_TZ_P, "timestamp_tz"},
};

/*
 * Check if current scanstring value is a keyword
 */
static enum yytokentype
checkKeyword(yyscan_t yyscanner)
{
	int			res = IDENT_P;
	int			diff;
	const JsonPathKeyword *StopLow = keywords,
			   *StopHigh = keywords + lengthof(keywords),
			   *StopMiddle;

	if (yyextra->scanstring.len > keywords[lengthof(keywords) - 1].len)
		return res;

	while (StopLow < StopHigh)
	{
		StopMiddle = StopLow + ((StopHigh - StopLow) >> 1);

		if (StopMiddle->len == yyextra->scanstring.len)
			diff = pg_strncasecmp(StopMiddle->keyword, yyextra->scanstring.val,
								  yyextra->scanstring.len);
		else
			diff = StopMiddle->len - yyextra->scanstring.len;

		if (diff < 0)
			StopLow = StopMiddle + 1;
		else if (diff > 0)
			StopHigh = StopMiddle;
		else
		{
			if (StopMiddle->lowercase)
				diff = strncmp(StopMiddle->keyword, yyextra->scanstring.val,
							   yyextra->scanstring.len);

			if (diff == 0)
				res = StopMiddle->val;

			break;
		}
	}

	return res;
}

/*
 * Resize scanstring so that it can append string of given length.
 * Reinitialize if required.
 */
static void
resizeString(bool init, int appendLen, yyscan_t yyscanner)
{
	if (init)
	{
		yyextra->scanstring.total = Max(32, appendLen);
		yyextra->scanstring.val = (char *) palloc(yyextra->scanstring.total);
		yyextra->scanstring.len = 0;
	}
	else
	{
		if (yyextra->scanstring.len + appendLen >= yyextra->scanstring.total)
		{
			while (yyextra->scanstring.len + appendLen >= yyextra->scanstring.total)
				yyextra->scanstring.total *= 2;
			yyextra->scanstring.val = repalloc(yyextra->scanstring.val, yyextra->scanstring.total);
		}
	}
}

/* Add set of bytes at "s" of length "l" to scanstring */
static void
addstring(bool init, char *s, int l, yyscan_t yyscanner)
{
	resizeString(init, l + 1, yyscanner);
	memcpy(yyextra->scanstring.val + yyextra->scanstring.len, s, l);
	yyextra->scanstring.len += l;
}

/* Add single byte "c" to scanstring */
static void
addchar(bool init, char c, yyscan_t yyscanner)
{
	resizeString(init, 1, yyscanner);
	yyextra->scanstring.val[yyextra->scanstring.len] = c;
	if (c != '\0')
		yyextra->scanstring.len++;
}

/* Interface to jsonpath parser */
JsonPathParseResult *
parsejsonpath(const char *str, int len, struct Node *escontext)
{
	JsonPathParseResult *parseresult;
	yyscan_t	scanner;
	struct jsonpath_yy_extra_type yyext;

	if (jsonpath_yylex_init(&scanner) != 0)
		elog(ERROR, "yylex_init() failed: %m");

	yyset_extra(&yyext, scanner);

	if (len <= 0)
		len = strlen(str);

	jsonpath_yy_scan_bytes(str, len, scanner);

	if (jsonpath_yyparse(&parseresult, escontext, scanner) != 0)
		jsonpath_yyerror(NULL, escontext, scanner, "invalid input");	/* shouldn't happen */

	jsonpath_yylex_destroy(scanner);

	return parseresult;
}

/* Turn hex character into integer */
static bool
hexval(char c, int *result, struct Node *escontext, yyscan_t yyscanner)
{
	if (c >= '0' && c <= '9')
	{
		*result = c - '0';
		return true;
	}
	if (c >= 'a' && c <= 'f')
	{
		*result = c - 'a' + 0xA;
		return true;
	}
	if (c >= 'A' && c <= 'F')
	{
		*result = c - 'A' + 0xA;
		return true;
	}
	jsonpath_yyerror(NULL, escontext, yyscanner, "invalid hexadecimal digit");
	return false;
}

/* Add given unicode character to scanstring */
static bool
addUnicodeChar(int ch, struct Node *escontext, yyscan_t yyscanner)
{
	if (ch == 0)
	{
		/* We can't allow this, since our TEXT type doesn't */
		ereturn(escontext, false,
				(errcode(ERRCODE_UNTRANSLATABLE_CHARACTER),
				 errmsg("unsupported Unicode escape sequence"),
				 errdetail("\\u0000 cannot be converted to text.")));
	}
	else
	{
		char		cbuf[MAX_UNICODE_EQUIVALENT_STRING + 1];

		/*
		 * If we're trapping the error status, call the noerror form of the
		 * conversion function. Otherwise call the normal form which provides
		 * more detailed errors.
		 */

		if (!escontext || !IsA(escontext, ErrorSaveContext))
			pg_unicode_to_server(ch, (unsigned char *) cbuf);
		else if (!pg_unicode_to_server_noerror(ch, (unsigned char *) cbuf))
			ereturn(escontext, false,
					(errcode(ERRCODE_SYNTAX_ERROR),
					 errmsg("could not convert Unicode to server encoding")));
		addstring(false, cbuf, strlen(cbuf), yyscanner);
	}
	return true;
}

/* Add unicode character, processing any surrogate pairs */
static bool
addUnicode(int ch, int *hi_surrogate, struct Node *escontext, yyscan_t yyscanner)
{
	if (is_utf16_surrogate_first(ch))
	{
		if (*hi_surrogate != -1)
			ereturn(escontext, false,
					(errcode(ERRCODE_INVALID_TEXT_REPRESENTATION),
					 errmsg("invalid input syntax for type %s", "jsonpath"),
					 errdetail("Unicode high surrogate must not follow "
							   "a high surrogate.")));
		*hi_surrogate = ch;
		return true;
	}
	else if (is_utf16_surrogate_second(ch))
	{
		if (*hi_surrogate == -1)
			ereturn(escontext, false,
					(errcode(ERRCODE_INVALID_TEXT_REPRESENTATION),
					 errmsg("invalid input syntax for type %s", "jsonpath"),
					 errdetail("Unicode low surrogate must follow a high "
							   "surrogate.")));
		ch = surrogate_pair_to_codepoint(*hi_surrogate, ch);
		*hi_surrogate = -1;
	}
	else if (*hi_surrogate != -1)
	{
		ereturn(escontext, false,
				(errcode(ERRCODE_INVALID_TEXT_REPRESENTATION),
				 errmsg("invalid input syntax for type %s", "jsonpath"),
				 errdetail("Unicode low surrogate must follow a high "
						   "surrogate.")));
	}

	return addUnicodeChar(ch, escontext, yyscanner);
}

/*
 * parseUnicode was adopted from json_lex_string() in
 * src/backend/utils/adt/json.c
 */
static bool
parseUnicode(char *s, int l, struct Node *escontext, yyscan_t yyscanner)
{
	int			i = 2;
	int			hi_surrogate = -1;

	for (i = 2; i < l; i += 2)	/* skip '\u' */
	{
		int			ch = 0;
		int			j,
					si;

		if (s[i] == '{')		/* parse '\u{XX...}' */
		{
			while (s[++i] != '}' && i < l)
			{
				if (!hexval(s[i], &si, escontext, yyscanner))
					return false;
				ch = (ch << 4) | si;
			}
			i++;				/* skip '}' */
		}
		else					/* parse '\uXXXX' */
		{
			for (j = 0; j < 4 && i < l; j++)
			{
				if (!hexval(s[i++], &si, escontext, yyscanner))
					return false;
				ch = (ch << 4) | si;
			}
		}

		if (!addUnicode(ch, &hi_surrogate, escontext, yyscanner))
			return false;
	}

	if (hi_surrogate != -1)
	{
		ereturn(escontext, false,
				(errcode(ERRCODE_INVALID_TEXT_REPRESENTATION),
				 errmsg("invalid input syntax for type %s", "jsonpath"),
				 errdetail("Unicode low surrogate must follow a high "
						   "surrogate.")));
	}

	return true;
}

/* Parse sequence of hex-encoded characters */
static bool
parseHexChar(char *s, struct Node *escontext, yyscan_t yyscanner)
{
	int			s2,
				s3,
				ch;

	if (!hexval(s[2], &s2, escontext, yyscanner))
		return false;
	if (!hexval(s[3], &s3, escontext, yyscanner))
		return false;

	ch = (s2 << 4) | s3;

	return addUnicodeChar(ch, escontext, yyscanner);
}

/*
 * Interface functions to make flex use palloc() instead of malloc().
 * It'd be better to make these static, but flex insists otherwise.
 */

void *
jsonpath_yyalloc(yy_size_t bytes, yyscan_t yyscanner)
{
	return palloc(bytes);
}

void *
jsonpath_yyrealloc(void *ptr, yy_size_t bytes, yyscan_t yyscanner)
{
	if (ptr)
		return repalloc(ptr, bytes);
	else
		return palloc(bytes);
}

void
jsonpath_yyfree(void *ptr, yyscan_t yyscanner)
{
	if (ptr)
		pfree(ptr);
}

