/* gitg-commit-model.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-commit-model.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <libgit2-glib/ggit.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_COMMIT_MODEL_0_PROPERTY,
	GITG_COMMIT_MODEL_LIMIT_PROPERTY,
	GITG_COMMIT_MODEL_SORT_MODE_PROPERTY,
	GITG_COMMIT_MODEL_REPOSITORY_PROPERTY,
	GITG_COMMIT_MODEL_NUM_PROPERTIES
};
static GParamSpec* gitg_commit_model_properties[GITG_COMMIT_MODEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GitgCommitModelWalkData GitgCommitModelWalkData;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
enum  {
	GITG_COMMIT_MODEL_STARTED_SIGNAL,
	GITG_COMMIT_MODEL_UPDATE_SIGNAL,
	GITG_COMMIT_MODEL_FINISHED_SIGNAL,
	GITG_COMMIT_MODEL_BEGIN_CLEAR_SIGNAL,
	GITG_COMMIT_MODEL_END_CLEAR_SIGNAL,
	GITG_COMMIT_MODEL_NUM_SIGNALS
};
static guint gitg_commit_model_signals[GITG_COMMIT_MODEL_NUM_SIGNALS] = {0};

struct _GitgCommitModelPrivate {
	GitgRepository* d_repository;
	GCancellable* d_cancellable;
	GitgCommit** d_ids;
	gint d_ids_length1;
	gint _d_ids_size_;
	GRecMutex __lock_d_ids;
	GitgCommit** d_hidden_ids;
	gint d_hidden_ids_length1;
	gint _d_hidden_ids_size_;
	GThread* d_thread;
	GgitRevisionWalker* d_walker;
	guint d_advertized_size;
	guint d_idleid;
	GRecMutex __lock_d_idleid;
	GitgLanes* d_lanes;
	GgitSortMode d_sortmode;
	GeeHashMap* d_id_hash;
	GRecMutex __lock_d_id_hash;
	GgitOId** d_include;
	gint d_include_length1;
	gint _d_include_size_;
	GgitOId** d_exclude;
	gint d_exclude_length1;
	gint _d_exclude_size_;
	guint d_size;
	gint d_stamp;
	guint _limit;
	GgitOId** _permanent_lanes;
	gint _permanent_lanes_length1;
	gint __permanent_lanes_size_;
};

struct _Block2Data {
	int _ref_count_;
	GitgCommitModel* self;
	GSourceFunc finishedcb;
	gpointer finishedcb_target;
	GDestroyNotify finishedcb_target_destroy_notify;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	guint newsize;
};

struct _Block4Data {
	int _ref_count_;
	GitgCommitModel* self;
	GgitOId** included;
	gint included_length1;
	gint _included_size_;
	GgitOId** excluded;
	gint excluded_length1;
	gint _excluded_size_;
	guint limit;
	GSourceFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	gdouble wait_elapsed_incremental;
	gdouble wait_elapsed;
	GgitOId** permlanes;
	gint permlanes_length1;
	gint _permlanes_size_;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _GitgCommitModelWalkData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgCommitModel* self;
	GCancellable* cancellable;
	Block4Data* _data4_;
	GgitOId** _tmp0_;
	gint _tmp0__length1;
	GgitOId** _tmp1_;
	gint _tmp1__length1;
	GgitOId** _tmp2_;
	gint _tmp2__length1;
	GgitOId** _tmp3_;
	gint _tmp3__length1;
	guint _tmp4_;
	gdouble wait_elapsed_initial;
	gint _tmp5_;
	GgitOId** _tmp6_;
	GThreadFunc run;
	gpointer run_target;
	GThread* _tmp7_;
	GThreadFunc _tmp8_;
	gpointer _tmp8__target;
	GThread* _tmp9_;
	GThread* _tmp10_;
	GError* _inner_error0_;
};

static gint GitgCommitModel_private_offset;
static gpointer gitg_commit_model_parent_class = NULL;
static GtkTreeModelIface * gitg_commit_model_gtk_tree_model_parent_iface = NULL;

static void _vala_GgitOId_free (GgitOId* self);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static GgitOId** _vala_array_dup1 (GgitOId** self,
                            gssize length);
static GgitOId** _vala_array_dup2 (GgitOId** self,
                            gssize length);
static void gitg_commit_model_real_dispose (GObject* base);
static void gitg_commit_model_cancel (GitgCommitModel* self);
static void gitg_commit_model_clear (GitgCommitModel* self);
static void gitg_commit_model_walk (GitgCommitModel* self,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
static void gitg_commit_model_walk_finish (GitgCommitModel* self,
                                    GAsyncResult* _res_);
static void __lambda39_ (GitgCommitModel* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda39__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static GgitOId** _vala_array_dup3 (GgitOId** self,
                            gssize length);
static GgitOId** _vala_array_dup4 (GgitOId** self,
                            gssize length);
static GgitOId** _vala_array_dup5 (GgitOId** self,
                            gssize length);
static void gitg_commit_model_notify_batch (GitgCommitModel* self,
                                     GSourceFunc finishedcb,
                                     gpointer finishedcb_target,
                                     GDestroyNotify finishedcb_target_destroy_notify);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean ___lambda36_ (Block3Data* _data3_);
static void gitg_commit_model_emit_update (GitgCommitModel* self,
                                    guint added);
static gboolean ____lambda36__gsource_func (gpointer self);
static gboolean gitg_commit_model_needs_resize (GitgCommitModel* self,
                                         GitgCommit** ids,
                                         gint ids_length1,
                                         guint* size);
static void gitg_commit_model_walk_data_free (gpointer _data);
static gboolean gitg_commit_model_walk_co (GitgCommitModelWalkData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static GgitOId** _vala_array_dup6 (GgitOId** self,
                            gssize length);
static GgitOId** _vala_array_dup7 (GgitOId** self,
                            gssize length);
static gboolean _gitg_commit_model_walk_co_gsource_func (gpointer self);
static void* __lambda35_ (Block4Data* _data4_);
static void _vala_array_add1 (GgitOId** * array,
                       gint* length,
                       gint* size,
                       GgitOId* value);
static guint ___lambda37_ (GitgCommitModel* self,
                    GgitOId* i);
static guint ____lambda37__gee_hash_data_func (gconstpointer v,
                                        gpointer self);
static gboolean ___lambda38_ (GitgCommitModel* self,
                       GgitOId* a,
                       GgitOId* b);
static gboolean ____lambda38__gee_equal_data_func (gconstpointer a,
                                            gconstpointer b,
                                            gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static gpointer ___lambda35__gthread_func (gpointer self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static GType gitg_commit_model_real_get_column_type (GtkTreeModel* base,
                                              gint index);
static GtkTreeModelFlags gitg_commit_model_real_get_flags (GtkTreeModel* base);
static gboolean gitg_commit_model_real_get_iter (GtkTreeModel* base,
                                          GtkTreeIter* iter,
                                          GtkTreePath* path);
static gint* _vala_array_dup8 (gint* self,
                        gssize length);
static gint gitg_commit_model_real_get_n_columns (GtkTreeModel* base);
static GtkTreePath* gitg_commit_model_real_get_path (GtkTreeModel* base,
                                              GtkTreeIter* iter);
static void gitg_commit_model_real_get_value (GtkTreeModel* base,
                                       GtkTreeIter* iter,
                                       gint column,
                                       GValue* val);
static gint* _vala_array_dup9 (gint* self,
                        gssize length);
static gboolean gitg_commit_model_real_iter_children (GtkTreeModel* base,
                                               GtkTreeIter* iter,
                                               GtkTreeIter* parent);
static gboolean gitg_commit_model_real_iter_has_child (GtkTreeModel* base,
                                                GtkTreeIter* iter);
static gint gitg_commit_model_real_iter_n_children (GtkTreeModel* base,
                                             GtkTreeIter* iter);
static gboolean gitg_commit_model_real_iter_next (GtkTreeModel* base,
                                           GtkTreeIter* iter);
static gboolean gitg_commit_model_real_iter_nth_child (GtkTreeModel* base,
                                                GtkTreeIter* iter,
                                                GtkTreeIter* parent,
                                                gint n);
static gboolean gitg_commit_model_real_iter_parent (GtkTreeModel* base,
                                             GtkTreeIter* parent,
                                             GtkTreeIter* iter);
static GObject * gitg_commit_model_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void gitg_commit_model_finalize (GObject * obj);
static GType gitg_commit_model_get_type_once (void);
static void _vala_gitg_commit_model_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gitg_commit_model_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

GType
gitg_commit_model_columns_type (GitgCommitModelColumns self)
{
	GType result;
	switch (self) {
		case GITG_COMMIT_MODEL_COLUMNS_SHA1:
		case GITG_COMMIT_MODEL_COLUMNS_SUBJECT:
		case GITG_COMMIT_MODEL_COLUMNS_MESSAGE:
		case GITG_COMMIT_MODEL_COLUMNS_COMMITTER:
		case GITG_COMMIT_MODEL_COLUMNS_COMMITTER_NAME:
		case GITG_COMMIT_MODEL_COLUMNS_COMMITTER_EMAIL:
		case GITG_COMMIT_MODEL_COLUMNS_COMMITTER_DATE:
		case GITG_COMMIT_MODEL_COLUMNS_AUTHOR:
		case GITG_COMMIT_MODEL_COLUMNS_AUTHOR_NAME:
		case GITG_COMMIT_MODEL_COLUMNS_AUTHOR_EMAIL:
		case GITG_COMMIT_MODEL_COLUMNS_AUTHOR_DATE:
		{
			result = G_TYPE_STRING;
			return result;
		}
		case GITG_COMMIT_MODEL_COLUMNS_COMMIT:
		{
			result = GITG_TYPE_COMMIT;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = G_TYPE_INVALID;
	return result;
}

 G_GNUC_NO_INLINE static GType
gitg_commit_model_columns_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_COMMIT_MODEL_COLUMNS_SHA1, "GITG_COMMIT_MODEL_COLUMNS_SHA1", "sha1"}, {GITG_COMMIT_MODEL_COLUMNS_SUBJECT, "GITG_COMMIT_MODEL_COLUMNS_SUBJECT", "subject"}, {GITG_COMMIT_MODEL_COLUMNS_MESSAGE, "GITG_COMMIT_MODEL_COLUMNS_MESSAGE", "message"}, {GITG_COMMIT_MODEL_COLUMNS_AUTHOR, "GITG_COMMIT_MODEL_COLUMNS_AUTHOR", "author"}, {GITG_COMMIT_MODEL_COLUMNS_AUTHOR_NAME, "GITG_COMMIT_MODEL_COLUMNS_AUTHOR_NAME", "author-name"}, {GITG_COMMIT_MODEL_COLUMNS_AUTHOR_EMAIL, "GITG_COMMIT_MODEL_COLUMNS_AUTHOR_EMAIL", "author-email"}, {GITG_COMMIT_MODEL_COLUMNS_AUTHOR_DATE, "GITG_COMMIT_MODEL_COLUMNS_AUTHOR_DATE", "author-date"}, {GITG_COMMIT_MODEL_COLUMNS_COMMITTER, "GITG_COMMIT_MODEL_COLUMNS_COMMITTER", "committer"}, {GITG_COMMIT_MODEL_COLUMNS_COMMITTER_NAME, "GITG_COMMIT_MODEL_COLUMNS_COMMITTER_NAME", "committer-name"}, {GITG_COMMIT_MODEL_COLUMNS_COMMITTER_EMAIL, "GITG_COMMIT_MODEL_COLUMNS_COMMITTER_EMAIL", "committer-email"}, {GITG_COMMIT_MODEL_COLUMNS_COMMITTER_DATE, "GITG_COMMIT_MODEL_COLUMNS_COMMITTER_DATE", "committer-date"}, {GITG_COMMIT_MODEL_COLUMNS_COMMIT, "GITG_COMMIT_MODEL_COLUMNS_COMMIT", "commit"}, {GITG_COMMIT_MODEL_COLUMNS_NUM, "GITG_COMMIT_MODEL_COLUMNS_NUM", "num"}, {0, NULL, NULL}};
	GType gitg_commit_model_columns_type_id;
	gitg_commit_model_columns_type_id = g_enum_register_static ("GitgCommitModelColumns", values);
	return gitg_commit_model_columns_type_id;
}

GType
gitg_commit_model_columns_get_type (void)
{
	static gsize gitg_commit_model_columns_type_id__once = 0;
	if (g_once_init_enter (&gitg_commit_model_columns_type_id__once)) {
		GType gitg_commit_model_columns_type_id;
		gitg_commit_model_columns_type_id = gitg_commit_model_columns_get_type_once ();
		g_once_init_leave (&gitg_commit_model_columns_type_id__once, gitg_commit_model_columns_type_id);
	}
	return gitg_commit_model_columns_type_id__once;
}

static inline gpointer
gitg_commit_model_get_instance_private (GitgCommitModel* self)
{
	return G_STRUCT_MEMBER_P (self, GitgCommitModel_private_offset);
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static GgitOId*
_vala_GgitOId_copy (GgitOId* self)
{
	return g_boxed_copy (ggit_oid_get_type (), self);
}

static gpointer
__vala_GgitOId_copy0 (gpointer self)
{
	return self ? _vala_GgitOId_copy (self) : NULL;
}

static GgitOId**
_vala_array_dup1 (GgitOId** self,
                  gssize length)
{
	if (length >= 0) {
		GgitOId** result;
		gssize i;
		result = g_new0 (GgitOId*, length + 1);
		for (i = 0; i < length; i++) {
			GgitOId* _tmp0_;
			_tmp0_ = __vala_GgitOId_copy0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GgitOId**
gitg_commit_model_get_permanent_lanes (GitgCommitModel* self,
                                       gint* result_length1)
{
	GgitOId** _tmp0_;
	gint _tmp0__length1;
	GgitOId** _tmp1_;
	gint _tmp1__length1;
	GgitOId** _tmp2_;
	gint _tmp2__length1;
	GgitOId** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_permanent_lanes;
	_tmp0__length1 = self->priv->_permanent_lanes_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GgitOId**
_vala_array_dup2 (GgitOId** self,
                  gssize length)
{
	if (length >= 0) {
		GgitOId** result;
		gssize i;
		result = g_new0 (GgitOId*, length + 1);
		for (i = 0; i < length; i++) {
			GgitOId* _tmp0_;
			_tmp0_ = __vala_GgitOId_copy0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
gitg_commit_model_set_permanent_lanes (GitgCommitModel* self,
                                       GgitOId** value,
                                       gint value_length1)
{
	GgitOId** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup2 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->_permanent_lanes = (_vala_array_free (self->priv->_permanent_lanes, self->priv->_permanent_lanes_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
	self->priv->_permanent_lanes = _tmp0_;
	self->priv->_permanent_lanes_length1 = _tmp0__length1;
	self->priv->__permanent_lanes_size_ = self->priv->_permanent_lanes_length1;
}

GitgCommitModel*
gitg_commit_model_construct (GType object_type,
                             GitgRepository* repository)
{
	GitgCommitModel * self = NULL;
	self = (GitgCommitModel*) g_object_new (object_type, "repository", repository, NULL);
	return self;
}

GitgCommitModel*
gitg_commit_model_new (GitgRepository* repository)
{
	return gitg_commit_model_construct (GITG_TYPE_COMMIT_MODEL, repository);
}

static void
gitg_commit_model_real_dispose (GObject* base)
{
	GitgCommitModel * self;
	self = (GitgCommitModel*) base;
	gitg_commit_model_cancel (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gitg_commit_model_cancel (GitgCommitModel* self)
{
	GCancellable* _tmp0_;
	GitgCommit** _tmp5_;
	GitgCommit** _tmp6_;
	GeeHashMap* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* cancellable = NULL;
		GCancellable* _tmp1_;
		GCancellable* _tmp2_;
		GCancellable* _tmp3_;
		GThread* _tmp4_;
		_tmp1_ = self->priv->d_cancellable;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		cancellable = _tmp2_;
		_g_object_unref0 (self->priv->d_cancellable);
		self->priv->d_cancellable = NULL;
		_tmp3_ = cancellable;
		g_cancellable_cancel (_tmp3_);
		_tmp4_ = self->priv->d_thread;
		self->priv->d_thread = NULL;
		g_thread_join (_tmp4_);
		_g_thread_unref0 (self->priv->d_thread);
		self->priv->d_thread = NULL;
		_g_object_unref0 (cancellable);
	}
	{
		g_rec_mutex_lock (&self->priv->__lock_d_idleid);
		{
			if (self->priv->d_idleid != ((guint) 0)) {
				g_source_remove (self->priv->d_idleid);
				self->priv->d_idleid = (guint) 0;
			}
		}
		__finally0:
		{
			g_rec_mutex_unlock (&self->priv->__lock_d_idleid);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	gitg_commit_model_clear (self);
	_tmp5_ = g_new0 (GitgCommit*, 0 + 1);
	self->priv->d_ids = (_vala_array_free (self->priv->d_ids, self->priv->d_ids_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_ids = _tmp5_;
	self->priv->d_ids_length1 = 0;
	self->priv->_d_ids_size_ = self->priv->d_ids_length1;
	_tmp6_ = g_new0 (GitgCommit*, 0 + 1);
	self->priv->d_hidden_ids = (_vala_array_free (self->priv->d_hidden_ids, self->priv->d_hidden_ids_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_hidden_ids = _tmp6_;
	self->priv->d_hidden_ids_length1 = 0;
	self->priv->_d_hidden_ids_size_ = self->priv->d_hidden_ids_length1;
	self->priv->d_advertized_size = (guint) 0;
	_tmp7_ = gee_hash_map_new (ggit_oid_get_type (), (GBoxedCopyFunc) _vala_GgitOId_copy, (GDestroyNotify) _vala_GgitOId_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_id_hash);
	self->priv->d_id_hash = _tmp7_;
}

static void
__lambda39_ (GitgCommitModel* self,
             GObject* obj,
             GAsyncResult* res)
{
	GThread* _tmp0_;
	g_return_if_fail (res != NULL);
	gitg_commit_model_walk_finish (self, res);
	_tmp0_ = self->priv->d_thread;
	self->priv->d_thread = NULL;
	g_thread_join (_tmp0_);
	_g_thread_unref0 (self->priv->d_thread);
	self->priv->d_thread = NULL;
	g_signal_emit (self, gitg_commit_model_signals[GITG_COMMIT_MODEL_FINISHED_SIGNAL], 0);
	_g_object_unref0 (self->priv->d_cancellable);
	self->priv->d_cancellable = NULL;
}

static void
___lambda39__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda39_ ((GitgCommitModel*) self, source_object, res);
	g_object_unref (self);
}

void
gitg_commit_model_reload (GitgCommitModel* self)
{
	gboolean _tmp0_ = FALSE;
	GitgRepository* _tmp1_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	g_return_if_fail (self != NULL);
	gitg_commit_model_cancel (self);
	_tmp1_ = self->priv->d_repository;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_ = 0;
		GgitOId** _tmp3_;
		GgitOId** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = gitg_commit_model_get_include (self, &_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _tmp2_;
		_tmp0_ = _tmp2_ == 0;
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = g_cancellable_new ();
	cancellable = _tmp5_;
	_tmp6_ = cancellable;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->d_cancellable);
	self->priv->d_cancellable = _tmp7_;
	g_signal_emit (self, gitg_commit_model_signals[GITG_COMMIT_MODEL_STARTED_SIGNAL], 0);
	_tmp8_ = cancellable;
	gitg_commit_model_walk (self, _tmp8_, ___lambda39__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (cancellable);
}

guint
gitg_commit_model_size (GitgCommitModel* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->d_advertized_size;
	return result;
}

GitgCommit*
gitg_commit_model_get (GitgCommitModel* self,
                       guint idx)
{
	GitgCommit* ret = NULL;
	GError* _inner_error0_ = NULL;
	GitgCommit* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (idx >= self->priv->d_advertized_size) {
		result = NULL;
		_g_object_unref0 (ret);
		return result;
	}
	{
		GitgCommit** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = self->priv->d_ids;
		_tmp0__length1 = self->priv->d_ids_length1;
		g_rec_mutex_lock (&self->priv->__lock_d_ids);
		{
			GitgCommit** _tmp1_;
			gint _tmp1__length1;
			GitgCommit* _tmp2_;
			GitgCommit* _tmp3_;
			_tmp1_ = self->priv->d_ids;
			_tmp1__length1 = self->priv->d_ids_length1;
			_tmp2_ = _tmp1_[idx];
			_tmp3_ = _g_object_ref0 (_tmp2_);
			_g_object_unref0 (ret);
			ret = _tmp3_;
		}
		__finally0:
		{
			GitgCommit** _tmp4_;
			gint _tmp4__length1;
			_tmp4_ = self->priv->d_ids;
			_tmp4__length1 = self->priv->d_ids_length1;
			g_rec_mutex_unlock (&self->priv->__lock_d_ids);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = ret;
	return result;
}

static GgitOId**
_vala_array_dup3 (GgitOId** self,
                  gssize length)
{
	if (length >= 0) {
		GgitOId** result;
		gssize i;
		result = g_new0 (GgitOId*, length + 1);
		for (i = 0; i < length; i++) {
			GgitOId* _tmp0_;
			_tmp0_ = __vala_GgitOId_copy0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
gitg_commit_model_set_include (GitgCommitModel* self,
                               GgitOId** ids,
                               gint ids_length1)
{
	GgitOId** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (ids != NULL) ? _vala_array_dup3 (ids, ids_length1) : ids;
	_tmp0__length1 = ids_length1;
	self->priv->d_include = (_vala_array_free (self->priv->d_include, self->priv->d_include_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
	self->priv->d_include = _tmp0_;
	self->priv->d_include_length1 = _tmp0__length1;
	self->priv->_d_include_size_ = self->priv->d_include_length1;
}

static GgitOId**
_vala_array_dup4 (GgitOId** self,
                  gssize length)
{
	if (length >= 0) {
		GgitOId** result;
		gssize i;
		result = g_new0 (GgitOId*, length + 1);
		for (i = 0; i < length; i++) {
			GgitOId* _tmp0_;
			_tmp0_ = __vala_GgitOId_copy0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GgitOId**
gitg_commit_model_get_include (GitgCommitModel* self,
                               gint* result_length1)
{
	GgitOId** _tmp0_;
	gint _tmp0__length1;
	GgitOId** _tmp1_;
	gint _tmp1__length1;
	GgitOId** _tmp2_;
	gint _tmp2__length1;
	GgitOId** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_include;
	_tmp0__length1 = self->priv->d_include_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup4 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GgitOId**
_vala_array_dup5 (GgitOId** self,
                  gssize length)
{
	if (length >= 0) {
		GgitOId** result;
		gssize i;
		result = g_new0 (GgitOId*, length + 1);
		for (i = 0; i < length; i++) {
			GgitOId* _tmp0_;
			_tmp0_ = __vala_GgitOId_copy0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
gitg_commit_model_set_exclude (GitgCommitModel* self,
                               GgitOId** ids,
                               gint ids_length1)
{
	GgitOId** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (ids != NULL) ? _vala_array_dup5 (ids, ids_length1) : ids;
	_tmp0__length1 = ids_length1;
	self->priv->d_exclude = (_vala_array_free (self->priv->d_exclude, self->priv->d_exclude_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
	self->priv->d_exclude = _tmp0_;
	self->priv->d_exclude_length1 = _tmp0__length1;
	self->priv->_d_exclude_size_ = self->priv->d_exclude_length1;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GitgCommitModel* self;
		self = _data2_->self;
		(_data2_->finishedcb_target_destroy_notify == NULL) ? NULL : (_data2_->finishedcb_target_destroy_notify (_data2_->finishedcb_target), NULL);
		_data2_->finishedcb = NULL;
		_data2_->finishedcb_target = NULL;
		_data2_->finishedcb_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GitgCommitModel* self;
		self = _data3_->_data2_->self;
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
___lambda36_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	GitgCommitModel* self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	{
		g_rec_mutex_lock (&self->priv->__lock_d_idleid);
		{
			guint added = 0U;
			if (self->priv->d_idleid == ((guint) 0)) {
				result = FALSE;
				{
					g_rec_mutex_unlock (&self->priv->__lock_d_idleid);
				}
				return result;
			}
			self->priv->d_idleid = (guint) 0;
			added = _data3_->newsize - self->priv->d_advertized_size;
			self->priv->d_advertized_size = _data3_->newsize;
			gitg_commit_model_emit_update (self, added);
			if (_data2_->finishedcb != NULL) {
				_data2_->finishedcb (_data2_->finishedcb_target);
			}
		}
		__finally0:
		{
			g_rec_mutex_unlock (&self->priv->__lock_d_idleid);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp0_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp0_;
		}
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda36__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda36_ (self);
	return result;
}

static void
gitg_commit_model_notify_batch (GitgCommitModel* self,
                                GSourceFunc finishedcb,
                                gpointer finishedcb_target,
                                GDestroyNotify finishedcb_target_destroy_notify)
{
	Block2Data* _data2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	(_data2_->finishedcb_target_destroy_notify == NULL) ? NULL : (_data2_->finishedcb_target_destroy_notify (_data2_->finishedcb_target), NULL);
	_data2_->finishedcb = NULL;
	_data2_->finishedcb_target = NULL;
	_data2_->finishedcb_target_destroy_notify = NULL;
	_data2_->finishedcb = finishedcb;
	_data2_->finishedcb_target = finishedcb_target;
	_data2_->finishedcb_target_destroy_notify = finishedcb_target_destroy_notify;
	{
		g_rec_mutex_lock (&self->priv->__lock_d_idleid);
		{
			Block3Data* _data3_;
			GitgCommit** _tmp0_;
			gint _tmp0__length1;
			_data3_ = g_slice_new0 (Block3Data);
			_data3_->_ref_count_ = 1;
			_data3_->_data2_ = block2_data_ref (_data2_);
			if (self->priv->d_idleid != ((guint) 0)) {
				g_source_remove (self->priv->d_idleid);
				self->priv->d_idleid = (guint) 0;
			}
			_tmp0_ = self->priv->d_ids;
			_tmp0__length1 = self->priv->d_ids_length1;
			_data3_->newsize = (guint) _tmp0__length1;
			self->priv->d_idleid = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda36__gsource_func, block3_data_ref (_data3_), block3_data_unref);
			block3_data_unref (_data3_);
			_data3_ = NULL;
		}
		__finally0:
		{
			g_rec_mutex_unlock (&self->priv->__lock_d_idleid);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static gboolean
gitg_commit_model_needs_resize (GitgCommitModel* self,
                                GitgCommit** ids,
                                gint ids_length1,
                                guint* size)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (((guint) ids_length1) < (*size)) {
		result = FALSE;
		return result;
	}
	if (ids_length1 < 20000) {
		*size = (*size) * 2;
	} else {
		*size = (guint) (((gdouble) (*size)) * 1.2);
	}
	result = TRUE;
	return result;
}

static void
gitg_commit_model_walk_data_free (gpointer _data)
{
	GitgCommitModelWalkData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgCommitModelWalkData, _data_);
}

static void
gitg_commit_model_walk (GitgCommitModel* self,
                        GCancellable* cancellable,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	GitgCommitModelWalkData* _data_;
	GitgCommitModel* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (GitgCommitModelWalkData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_commit_model_walk_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	gitg_commit_model_walk_co (_data_);
}

static void
gitg_commit_model_walk_finish (GitgCommitModel* self,
                               GAsyncResult* _res_)
{
	GitgCommitModelWalkData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GitgCommitModel* self;
		self = _data4_->self;
		_data4_->permlanes = (_vala_array_free (_data4_->permlanes, _data4_->permlanes_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
		(_data4_->cb_target_destroy_notify == NULL) ? NULL : (_data4_->cb_target_destroy_notify (_data4_->cb_target), NULL);
		_data4_->cb = NULL;
		_data4_->cb_target = NULL;
		_data4_->cb_target_destroy_notify = NULL;
		_data4_->excluded = (_vala_array_free (_data4_->excluded, _data4_->excluded_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
		_data4_->included = (_vala_array_free (_data4_->included, _data4_->included_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
		_g_object_unref0 (_data4_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static GgitOId**
_vala_array_dup6 (GgitOId** self,
                  gssize length)
{
	if (length >= 0) {
		GgitOId** result;
		gssize i;
		result = g_new0 (GgitOId*, length + 1);
		for (i = 0; i < length; i++) {
			GgitOId* _tmp0_;
			_tmp0_ = __vala_GgitOId_copy0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static GgitOId**
_vala_array_dup7 (GgitOId** self,
                  gssize length)
{
	if (length >= 0) {
		GgitOId** result;
		gssize i;
		result = g_new0 (GgitOId*, length + 1);
		for (i = 0; i < length; i++) {
			GgitOId* _tmp0_;
			_tmp0_ = __vala_GgitOId_copy0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
_gitg_commit_model_walk_co_gsource_func (gpointer self)
{
	gboolean result;
	result = gitg_commit_model_walk_co (self);
	return result;
}

static void
_vala_array_add1 (GgitOId** * array,
                  gint* length,
                  gint* size,
                  GgitOId* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GgitOId*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static guint
___lambda37_ (GitgCommitModel* self,
              GgitOId* i)
{
	guint result;
	g_return_val_if_fail (i != NULL, 0U);
	result = ggit_oid_hash (i);
	return result;
}

static guint
____lambda37__gee_hash_data_func (gconstpointer v,
                                  gpointer self)
{
	guint result;
	result = ___lambda37_ ((GitgCommitModel*) self, (GgitOId*) v);
	return result;
}

static gboolean
___lambda38_ (GitgCommitModel* self,
              GgitOId* a,
              GgitOId* b)
{
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	result = ggit_oid_equal (a, b);
	return result;
}

static gboolean
____lambda38__gee_equal_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gboolean result;
	result = ___lambda38_ ((GitgCommitModel*) self, (GgitOId*) a, (GgitOId*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void*
__lambda35_ (Block4Data* _data4_)
{
	GitgCommitModel* self;
	GgitRevisionWalker* _tmp0_;
	GgitRevisionWalker* _tmp6_;
	GgitRevisionWalker* _tmp7_;
	GeeHashSet* incset = NULL;
	GeeHashSet* _tmp8_;
	GgitOId** _tmp9_;
	gint _tmp9__length1;
	GgitOId** _tmp15_;
	gint _tmp15__length1;
	GgitOId** permanent = NULL;
	GgitOId** _tmp21_;
	gint permanent_length1;
	gint _permanent_size_;
	GgitOId** _tmp22_;
	gint _tmp22__length1;
	GitgLanes* _tmp28_;
	GgitOId** _tmp29_;
	gint _tmp29__length1;
	GeeHashSet* _tmp30_;
	guint size = 0U;
	guint hidden_size = 0U;
	GTimer* timer = NULL;
	GTimer* _tmp37_;
	GSourceFunc _tmp143_;
	gpointer _tmp143__target;
	GDestroyNotify _tmp143__target_destroy_notify;
	GError* _inner_error0_ = NULL;
	void* result;
	self = _data4_->self;
	_tmp0_ = self->priv->d_walker;
	if (_tmp0_ == NULL) {
		{
			GgitRevisionWalker* _tmp1_ = NULL;
			GitgRepository* _tmp2_;
			GgitRevisionWalker* _tmp3_;
			GgitRevisionWalker* _tmp4_;
			_tmp2_ = self->priv->d_repository;
			_tmp3_ = ggit_revision_walker_new ((GgitRepository*) _tmp2_, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (self->priv->d_walker);
			self->priv->d_walker = _tmp4_;
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GSourceFunc _tmp5_;
			gpointer _tmp5__target;
			GDestroyNotify _tmp5__target_destroy_notify;
			g_clear_error (&_inner_error0_);
			_tmp5_ = _data4_->cb;
			_tmp5__target = _data4_->cb_target;
			_tmp5__target_destroy_notify = _data4_->cb_target_destroy_notify;
			_data4_->cb = NULL;
			_data4_->cb_target = NULL;
			_data4_->cb_target_destroy_notify = NULL;
			gitg_commit_model_notify_batch (self, _tmp5_, _tmp5__target, _tmp5__target_destroy_notify);
			result = NULL;
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = self->priv->d_walker;
	ggit_revision_walker_reset (_tmp6_);
	_tmp7_ = self->priv->d_walker;
	ggit_revision_walker_set_sort_mode (_tmp7_, self->priv->d_sortmode);
	_tmp8_ = gee_hash_set_new (ggit_oid_get_type (), (GBoxedCopyFunc) _vala_GgitOId_copy, (GDestroyNotify) _vala_GgitOId_free, (GeeHashDataFunc) ggit_oid_hash, NULL, NULL, (GeeEqualDataFunc) ggit_oid_equal, NULL, NULL);
	incset = _tmp8_;
	_tmp9_ = _data4_->included;
	_tmp9__length1 = _data4_->included_length1;
	{
		GgitOId** oid_collection = NULL;
		gint oid_collection_length1 = 0;
		gint _oid_collection_size_ = 0;
		gint oid_it = 0;
		oid_collection = _tmp9_;
		oid_collection_length1 = _tmp9__length1;
		for (oid_it = 0; oid_it < oid_collection_length1; oid_it = oid_it + 1) {
			GgitOId* _tmp10_;
			GgitOId* oid = NULL;
			_tmp10_ = __vala_GgitOId_copy0 (oid_collection[oid_it]);
			oid = _tmp10_;
			{
				{
					GgitRevisionWalker* _tmp11_;
					GgitOId* _tmp12_;
					GeeHashSet* _tmp13_;
					GgitOId* _tmp14_;
					_tmp11_ = self->priv->d_walker;
					_tmp12_ = oid;
					ggit_revision_walker_push (_tmp11_, _tmp12_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
					_tmp13_ = incset;
					_tmp14_ = oid;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
				}
				goto __finally1;
				__catch1_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					__vala_GgitOId_free0 (oid);
					_g_object_unref0 (incset);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				__vala_GgitOId_free0 (oid);
			}
		}
	}
	_tmp15_ = _data4_->excluded;
	_tmp15__length1 = _data4_->excluded_length1;
	{
		GgitOId** oid_collection = NULL;
		gint oid_collection_length1 = 0;
		gint _oid_collection_size_ = 0;
		gint oid_it = 0;
		oid_collection = _tmp15_;
		oid_collection_length1 = _tmp15__length1;
		for (oid_it = 0; oid_it < oid_collection_length1; oid_it = oid_it + 1) {
			GgitOId* _tmp16_;
			GgitOId* oid = NULL;
			_tmp16_ = __vala_GgitOId_copy0 (oid_collection[oid_it]);
			oid = _tmp16_;
			{
				{
					GgitRevisionWalker* _tmp17_;
					GgitOId* _tmp18_;
					GeeHashSet* _tmp19_;
					GgitOId* _tmp20_;
					_tmp17_ = self->priv->d_walker;
					_tmp18_ = oid;
					ggit_revision_walker_hide (_tmp17_, _tmp18_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch2_g_error;
					}
					_tmp19_ = incset;
					_tmp20_ = oid;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp19_, _tmp20_);
				}
				goto __finally2;
				__catch2_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally2:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					__vala_GgitOId_free0 (oid);
					_g_object_unref0 (incset);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				__vala_GgitOId_free0 (oid);
			}
		}
	}
	_tmp21_ = g_new0 (GgitOId*, 0 + 1);
	permanent = _tmp21_;
	permanent_length1 = 0;
	_permanent_size_ = permanent_length1;
	_tmp22_ = _data4_->permlanes;
	_tmp22__length1 = _data4_->permlanes_length1;
	{
		GgitOId** oid_collection = NULL;
		gint oid_collection_length1 = 0;
		gint _oid_collection_size_ = 0;
		gint oid_it = 0;
		oid_collection = _tmp22_;
		oid_collection_length1 = _tmp22__length1;
		for (oid_it = 0; oid_it < oid_collection_length1; oid_it = oid_it + 1) {
			GgitOId* _tmp23_;
			GgitOId* oid = NULL;
			_tmp23_ = __vala_GgitOId_copy0 (oid_collection[oid_it]);
			oid = _tmp23_;
			{
				{
					GgitRevisionWalker* _tmp24_;
					GgitOId* _tmp25_;
					GgitOId* _tmp26_;
					GgitOId* _tmp27_;
					_tmp24_ = self->priv->d_walker;
					_tmp25_ = oid;
					ggit_revision_walker_push (_tmp24_, _tmp25_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch3_g_error;
					}
					_tmp26_ = oid;
					_tmp27_ = __vala_GgitOId_copy0 (_tmp26_);
					_vala_array_add1 (&permanent, &permanent_length1, &_permanent_size_, _tmp27_);
				}
				goto __finally3;
				__catch3_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally3:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					__vala_GgitOId_free0 (oid);
					permanent = (_vala_array_free (permanent, permanent_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
					_g_object_unref0 (incset);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				__vala_GgitOId_free0 (oid);
			}
		}
	}
	_tmp28_ = self->priv->d_lanes;
	_tmp29_ = permanent;
	_tmp29__length1 = permanent_length1;
	_tmp30_ = incset;
	gitg_lanes_reset (_tmp28_, _tmp29_, (gint) _tmp29__length1, _tmp30_);
	{
		GitgCommit** _tmp31_;
		gint _tmp31__length1;
		_tmp31_ = self->priv->d_ids;
		_tmp31__length1 = self->priv->d_ids_length1;
		g_rec_mutex_lock (&self->priv->__lock_d_ids);
		{
			GitgCommit** _tmp32_;
			GitgCommit** _tmp33_;
			GitgCommit** _tmp34_;
			gint _tmp34__length1;
			GitgCommit** _tmp35_;
			gint _tmp35__length1;
			_tmp32_ = g_new0 (GitgCommit*, 1000 + 1);
			self->priv->d_ids = (_vala_array_free (self->priv->d_ids, self->priv->d_ids_length1, (GDestroyNotify) g_object_unref), NULL);
			self->priv->d_ids = _tmp32_;
			self->priv->d_ids_length1 = 1000;
			self->priv->_d_ids_size_ = self->priv->d_ids_length1;
			_tmp33_ = g_new0 (GitgCommit*, 100 + 1);
			self->priv->d_hidden_ids = (_vala_array_free (self->priv->d_hidden_ids, self->priv->d_hidden_ids_length1, (GDestroyNotify) g_object_unref), NULL);
			self->priv->d_hidden_ids = _tmp33_;
			self->priv->d_hidden_ids_length1 = 100;
			self->priv->_d_hidden_ids_size_ = self->priv->d_hidden_ids_length1;
			_tmp34_ = self->priv->d_ids;
			_tmp34__length1 = self->priv->d_ids_length1;
			size = (guint) _tmp34__length1;
			_tmp35_ = self->priv->d_hidden_ids;
			_tmp35__length1 = self->priv->d_hidden_ids_length1;
			hidden_size = (guint) _tmp35__length1;
			self->priv->d_ids_length1 = 0;
			self->priv->d_hidden_ids_length1 = 0;
			self->priv->d_advertized_size = (guint) 0;
		}
		__finally4:
		{
			GitgCommit** _tmp36_;
			gint _tmp36__length1;
			_tmp36_ = self->priv->d_ids;
			_tmp36__length1 = self->priv->d_ids_length1;
			g_rec_mutex_unlock (&self->priv->__lock_d_ids);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			permanent = (_vala_array_free (permanent, permanent_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
			_g_object_unref0 (incset);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp37_ = g_timer_new ();
	timer = _tmp37_;
	{
		GeeHashMap* _tmp38_;
		_tmp38_ = self->priv->d_id_hash;
		g_rec_mutex_lock (&self->priv->__lock_d_id_hash);
		{
			GeeHashMap* _tmp39_;
			_tmp39_ = gee_hash_map_new (ggit_oid_get_type (), (GBoxedCopyFunc) _vala_GgitOId_copy, (GDestroyNotify) _vala_GgitOId_free, G_TYPE_INT, NULL, NULL, ____lambda37__gee_hash_data_func, g_object_ref (self), g_object_unref, ____lambda38__gee_equal_data_func, g_object_ref (self), g_object_unref, NULL, NULL, NULL);
			_g_object_unref0 (self->priv->d_id_hash);
			self->priv->d_id_hash = _tmp39_;
		}
		__finally5:
		{
			GeeHashMap* _tmp40_;
			_tmp40_ = self->priv->d_id_hash;
			g_rec_mutex_unlock (&self->priv->__lock_d_id_hash);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_timer_destroy0 (timer);
			permanent = (_vala_array_free (permanent, permanent_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
			_g_object_unref0 (incset);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		GgitOId* id = NULL;
		GitgCommit* commit = NULL;
		gint mylane = 0;
		GSList* lanes = NULL;
		gboolean finded = FALSE;
		GitgLanes* _tmp51_;
		GitgCommit* _tmp52_;
		GSList* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		gboolean _tmp55_;
		GTimer* _tmp139_;
		gboolean _tmp141_ = FALSE;
		if (g_cancellable_is_cancelled (_data4_->cancellable)) {
			result = NULL;
			_g_object_unref0 (commit);
			__vala_GgitOId_free0 (id);
			_g_timer_destroy0 (timer);
			permanent = (_vala_array_free (permanent, permanent_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
			_g_object_unref0 (incset);
			return result;
		}
		{
			GgitOId* _tmp41_ = NULL;
			GgitRevisionWalker* _tmp42_;
			GgitOId* _tmp43_;
			GgitOId* _tmp44_;
			GgitOId* _tmp45_;
			GitgCommit* _tmp46_ = NULL;
			GitgRepository* _tmp47_;
			GgitOId* _tmp48_;
			gpointer _tmp49_;
			GitgCommit* _tmp50_;
			_tmp42_ = self->priv->d_walker;
			_tmp43_ = ggit_revision_walker_next (_tmp42_, &_inner_error0_);
			_tmp41_ = _tmp43_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch6_g_error;
			}
			_tmp44_ = _tmp41_;
			_tmp41_ = NULL;
			__vala_GgitOId_free0 (id);
			id = _tmp44_;
			_tmp45_ = id;
			if (_tmp45_ == NULL) {
				__vala_GgitOId_free0 (_tmp41_);
				_g_object_unref0 (commit);
				__vala_GgitOId_free0 (id);
				break;
			}
			_tmp47_ = self->priv->d_repository;
			_tmp48_ = id;
			_tmp49_ = gitg_repository_lookup (_tmp47_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp48_, &_inner_error0_);
			_tmp46_ = (GitgCommit*) _tmp49_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				__vala_GgitOId_free0 (_tmp41_);
				goto __catch6_g_error;
			}
			_tmp50_ = _tmp46_;
			_tmp46_ = NULL;
			_g_object_unref0 (commit);
			commit = _tmp50_;
			_g_object_unref0 (_tmp46_);
			__vala_GgitOId_free0 (_tmp41_);
		}
		goto __finally6;
		__catch6_g_error:
		{
			g_clear_error (&_inner_error0_);
			_g_object_unref0 (commit);
			__vala_GgitOId_free0 (id);
			break;
		}
		__finally6:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (commit);
			__vala_GgitOId_free0 (id);
			_g_timer_destroy0 (timer);
			permanent = (_vala_array_free (permanent, permanent_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
			_g_object_unref0 (incset);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp51_ = self->priv->d_lanes;
		_tmp52_ = commit;
		_tmp55_ = gitg_lanes_next (_tmp51_, _tmp52_, &_tmp53_, &_tmp54_, TRUE);
		(lanes == NULL) ? NULL : (lanes = (_g_slist_free__g_object_unref0_ (lanes), NULL));
		lanes = _tmp53_;
		mylane = _tmp54_;
		finded = _tmp55_;
		if (finded) {
			GitgCommit* _tmp56_;
			const gchar* _tmp57_;
			GitgCommit* _tmp58_;
			GgitOId* _tmp59_;
			GgitOId* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			GitgCommit* _tmp63_;
			GSList* _tmp64_;
			GitgCommit** _tmp70_;
			gint _tmp70__length1;
			gboolean _tmp71_;
			GitgCommit** _tmp76_;
			gint _tmp76__length1;
			gint _tmp77_;
			GitgCommit* _tmp78_;
			GitgCommit* _tmp79_;
			_tmp56_ = commit;
			_tmp57_ = ggit_commit_get_subject ((GgitCommit*) _tmp56_);
			_tmp58_ = commit;
			_tmp59_ = ggit_object_get_id ((GgitObject*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = ggit_oid_to_string (_tmp60_);
			_tmp62_ = _tmp61_;
			g_debug ("gitg-commit-model.vala:424: finded parent for %s %s\n", _tmp57_, _tmp62_);
			_g_free0 (_tmp62_);
			__vala_GgitOId_free0 (_tmp60_);
			_tmp63_ = commit;
			_tmp64_ = lanes;
			lanes = NULL;
			gitg_commit_update_lanes (_tmp63_, _tmp64_, mylane);
			{
				GeeHashMap* _tmp65_;
				_tmp65_ = self->priv->d_id_hash;
				g_rec_mutex_lock (&self->priv->__lock_d_id_hash);
				{
					GeeHashMap* _tmp66_;
					GgitOId* _tmp67_;
					GitgCommit** _tmp68_;
					gint _tmp68__length1;
					_tmp66_ = self->priv->d_id_hash;
					_tmp67_ = id;
					_tmp68_ = self->priv->d_ids;
					_tmp68__length1 = self->priv->d_ids_length1;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp66_, _tmp67_, (gpointer) ((gintptr) _tmp68__length1));
				}
				__finally7:
				{
					GeeHashMap* _tmp69_;
					_tmp69_ = self->priv->d_id_hash;
					g_rec_mutex_unlock (&self->priv->__lock_d_id_hash);
				}
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					(lanes == NULL) ? NULL : (lanes = (_g_slist_free__g_object_unref0_ (lanes), NULL));
					_g_object_unref0 (commit);
					__vala_GgitOId_free0 (id);
					_g_timer_destroy0 (timer);
					permanent = (_vala_array_free (permanent, permanent_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
					_g_object_unref0 (incset);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp70_ = self->priv->d_ids;
			_tmp70__length1 = self->priv->d_ids_length1;
			_tmp71_ = gitg_commit_model_needs_resize (self, _tmp70_, (gint) _tmp70__length1, &size);
			if (_tmp71_) {
				gint l = 0;
				GitgCommit** _tmp72_;
				gint _tmp72__length1;
				_tmp72_ = self->priv->d_ids;
				_tmp72__length1 = self->priv->d_ids_length1;
				l = _tmp72__length1;
				{
					GitgCommit** _tmp73_;
					gint _tmp73__length1;
					_tmp73_ = self->priv->d_ids;
					_tmp73__length1 = self->priv->d_ids_length1;
					g_rec_mutex_lock (&self->priv->__lock_d_ids);
					{
						gint _tmp74_;
						_tmp74_ = (gint) size;
						self->priv->d_ids = g_renew (GitgCommit*, self->priv->d_ids, (gint) size);
						(_tmp74_ > self->priv->d_ids_length1) ? memset (self->priv->d_ids + self->priv->d_ids_length1, 0, sizeof (GitgCommit*) * (_tmp74_ - self->priv->d_ids_length1)) : NULL;
						self->priv->d_ids_length1 = _tmp74_;
						self->priv->_d_ids_size_ = _tmp74_;
						self->priv->d_ids_length1 = l;
					}
					__finally8:
					{
						GitgCommit** _tmp75_;
						gint _tmp75__length1;
						_tmp75_ = self->priv->d_ids;
						_tmp75__length1 = self->priv->d_ids_length1;
						g_rec_mutex_unlock (&self->priv->__lock_d_ids);
					}
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						(lanes == NULL) ? NULL : (lanes = (_g_slist_free__g_object_unref0_ (lanes), NULL));
						_g_object_unref0 (commit);
						__vala_GgitOId_free0 (id);
						_g_timer_destroy0 (timer);
						permanent = (_vala_array_free (permanent, permanent_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
						_g_object_unref0 (incset);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
			}
			_tmp76_ = self->priv->d_ids;
			_tmp76__length1 = self->priv->d_ids_length1;
			_tmp77_ = self->priv->d_ids_length1;
			self->priv->d_ids_length1 = _tmp77_ + 1;
			_tmp78_ = commit;
			_tmp79_ = _g_object_ref0 (_tmp78_);
			_g_object_unref0 (_tmp76_[_tmp77_]);
			_tmp76_[_tmp77_] = _tmp79_;
		}
		while (TRUE) {
			GitgLanes* _tmp80_;
			GeeLinkedList* _tmp81_;
			GeeLinkedList* _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			GeeIterator* iter = NULL;
			GitgLanes* _tmp85_;
			GeeLinkedList* _tmp86_;
			GeeLinkedList* _tmp87_;
			GeeIterator* _tmp88_;
			_tmp80_ = self->priv->d_lanes;
			_tmp81_ = gitg_lanes_get_miss_commits (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp82_);
			_tmp84_ = _tmp83_;
			if (!(_tmp84_ > 0)) {
				break;
			}
			finded = FALSE;
			_tmp85_ = self->priv->d_lanes;
			_tmp86_ = gitg_lanes_get_miss_commits (_tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp87_);
			iter = _tmp88_;
			while (TRUE) {
				GeeIterator* _tmp89_;
				GitgCommit* miss_commit = NULL;
				GeeIterator* _tmp90_;
				gpointer _tmp91_;
				GitgCommit* _tmp92_;
				const gchar* _tmp93_;
				GitgCommit* _tmp94_;
				GgitOId* _tmp95_;
				GgitOId* _tmp96_;
				gchar* _tmp97_;
				gchar* _tmp98_;
				gboolean tmp_finded = FALSE;
				GitgLanes* _tmp99_;
				GitgCommit* _tmp100_;
				GSList* _tmp101_ = NULL;
				gint _tmp102_ = 0;
				gboolean _tmp103_;
				_tmp89_ = iter;
				if (!gee_iterator_next (_tmp89_)) {
					break;
				}
				_tmp90_ = iter;
				_tmp91_ = gee_iterator_get (_tmp90_);
				miss_commit = (GitgCommit*) _tmp91_;
				_tmp92_ = miss_commit;
				_tmp93_ = ggit_commit_get_subject ((GgitCommit*) _tmp92_);
				_tmp94_ = miss_commit;
				_tmp95_ = ggit_object_get_id ((GgitObject*) _tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = ggit_oid_to_string (_tmp96_);
				_tmp98_ = _tmp97_;
				g_debug ("gitg-commit-model.vala:452: trying again %s %s", _tmp93_, _tmp98_);
				_g_free0 (_tmp98_);
				__vala_GgitOId_free0 (_tmp96_);
				_tmp99_ = self->priv->d_lanes;
				_tmp100_ = miss_commit;
				_tmp103_ = gitg_lanes_next (_tmp99_, _tmp100_, &_tmp101_, &_tmp102_, FALSE);
				(lanes == NULL) ? NULL : (lanes = (_g_slist_free__g_object_unref0_ (lanes), NULL));
				lanes = _tmp101_;
				mylane = _tmp102_;
				tmp_finded = _tmp103_;
				if (tmp_finded) {
					GitgCommit* _tmp104_;
					const gchar* _tmp105_;
					GitgCommit* _tmp106_;
					GgitOId* _tmp107_;
					GgitOId* _tmp108_;
					gchar* _tmp109_;
					gchar* _tmp110_;
					GeeIterator* _tmp111_;
					GitgCommit* _tmp112_;
					GitgCommit* _tmp113_;
					GitgCommit* _tmp114_;
					GSList* _tmp115_;
					GitgCommit** _tmp121_;
					gint _tmp121__length1;
					gboolean _tmp122_;
					GitgCommit** _tmp127_;
					gint _tmp127__length1;
					gint _tmp128_;
					GitgCommit* _tmp129_;
					GitgCommit* _tmp130_;
					finded = TRUE;
					_tmp104_ = miss_commit;
					_tmp105_ = ggit_commit_get_subject ((GgitCommit*) _tmp104_);
					_tmp106_ = miss_commit;
					_tmp107_ = ggit_object_get_id ((GgitObject*) _tmp106_);
					_tmp108_ = _tmp107_;
					_tmp109_ = ggit_oid_to_string (_tmp108_);
					_tmp110_ = _tmp109_;
					g_debug ("gitg-commit-model.vala:457: finded parent for miss %s %s\n", _tmp105_, _tmp110_);
					_g_free0 (_tmp110_);
					__vala_GgitOId_free0 (_tmp108_);
					_tmp111_ = iter;
					gee_iterator_remove (_tmp111_);
					_tmp112_ = miss_commit;
					_tmp113_ = _g_object_ref0 (_tmp112_);
					_g_object_unref0 (commit);
					commit = _tmp113_;
					_tmp114_ = commit;
					_tmp115_ = lanes;
					lanes = NULL;
					gitg_commit_update_lanes (_tmp114_, _tmp115_, mylane);
					{
						GeeHashMap* _tmp116_;
						_tmp116_ = self->priv->d_id_hash;
						g_rec_mutex_lock (&self->priv->__lock_d_id_hash);
						{
							GeeHashMap* _tmp117_;
							GgitOId* _tmp118_;
							GitgCommit** _tmp119_;
							gint _tmp119__length1;
							_tmp117_ = self->priv->d_id_hash;
							_tmp118_ = id;
							_tmp119_ = self->priv->d_ids;
							_tmp119__length1 = self->priv->d_ids_length1;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp117_, _tmp118_, (gpointer) ((gintptr) _tmp119__length1));
						}
						__finally9:
						{
							GeeHashMap* _tmp120_;
							_tmp120_ = self->priv->d_id_hash;
							g_rec_mutex_unlock (&self->priv->__lock_d_id_hash);
						}
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (miss_commit);
							_g_object_unref0 (iter);
							(lanes == NULL) ? NULL : (lanes = (_g_slist_free__g_object_unref0_ (lanes), NULL));
							_g_object_unref0 (commit);
							__vala_GgitOId_free0 (id);
							_g_timer_destroy0 (timer);
							permanent = (_vala_array_free (permanent, permanent_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
							_g_object_unref0 (incset);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp121_ = self->priv->d_ids;
					_tmp121__length1 = self->priv->d_ids_length1;
					_tmp122_ = gitg_commit_model_needs_resize (self, _tmp121_, (gint) _tmp121__length1, &size);
					if (_tmp122_) {
						gint l = 0;
						GitgCommit** _tmp123_;
						gint _tmp123__length1;
						_tmp123_ = self->priv->d_ids;
						_tmp123__length1 = self->priv->d_ids_length1;
						l = _tmp123__length1;
						{
							GitgCommit** _tmp124_;
							gint _tmp124__length1;
							_tmp124_ = self->priv->d_ids;
							_tmp124__length1 = self->priv->d_ids_length1;
							g_rec_mutex_lock (&self->priv->__lock_d_ids);
							{
								gint _tmp125_;
								_tmp125_ = (gint) size;
								self->priv->d_ids = g_renew (GitgCommit*, self->priv->d_ids, (gint) size);
								(_tmp125_ > self->priv->d_ids_length1) ? memset (self->priv->d_ids + self->priv->d_ids_length1, 0, sizeof (GitgCommit*) * (_tmp125_ - self->priv->d_ids_length1)) : NULL;
								self->priv->d_ids_length1 = _tmp125_;
								self->priv->_d_ids_size_ = _tmp125_;
								self->priv->d_ids_length1 = l;
							}
							__finally10:
							{
								GitgCommit** _tmp126_;
								gint _tmp126__length1;
								_tmp126_ = self->priv->d_ids;
								_tmp126__length1 = self->priv->d_ids_length1;
								g_rec_mutex_unlock (&self->priv->__lock_d_ids);
							}
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (miss_commit);
								_g_object_unref0 (iter);
								(lanes == NULL) ? NULL : (lanes = (_g_slist_free__g_object_unref0_ (lanes), NULL));
								_g_object_unref0 (commit);
								__vala_GgitOId_free0 (id);
								_g_timer_destroy0 (timer);
								permanent = (_vala_array_free (permanent, permanent_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
								_g_object_unref0 (incset);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
					}
					_tmp127_ = self->priv->d_ids;
					_tmp127__length1 = self->priv->d_ids_length1;
					_tmp128_ = self->priv->d_ids_length1;
					self->priv->d_ids_length1 = _tmp128_ + 1;
					_tmp129_ = commit;
					_tmp130_ = _g_object_ref0 (_tmp129_);
					_g_object_unref0 (_tmp127_[_tmp128_]);
					_tmp127_[_tmp128_] = _tmp130_;
				}
				_g_object_unref0 (miss_commit);
			}
			if (!finded) {
				_g_object_unref0 (iter);
				break;
			}
			_g_object_unref0 (iter);
		}
		if (!finded) {
			GitgCommit** _tmp131_;
			gint _tmp131__length1;
			gboolean _tmp132_;
			GitgCommit** _tmp135_;
			gint _tmp135__length1;
			gint _tmp136_;
			GitgCommit* _tmp137_;
			GitgCommit* _tmp138_;
			_tmp131_ = self->priv->d_hidden_ids;
			_tmp131__length1 = self->priv->d_hidden_ids_length1;
			_tmp132_ = gitg_commit_model_needs_resize (self, _tmp131_, (gint) _tmp131__length1, &hidden_size);
			if (_tmp132_) {
				gint l = 0;
				GitgCommit** _tmp133_;
				gint _tmp133__length1;
				gint _tmp134_;
				_tmp133_ = self->priv->d_hidden_ids;
				_tmp133__length1 = self->priv->d_hidden_ids_length1;
				l = _tmp133__length1;
				_tmp134_ = (gint) hidden_size;
				self->priv->d_hidden_ids = g_renew (GitgCommit*, self->priv->d_hidden_ids, (gint) hidden_size);
				(_tmp134_ > self->priv->d_hidden_ids_length1) ? memset (self->priv->d_hidden_ids + self->priv->d_hidden_ids_length1, 0, sizeof (GitgCommit*) * (_tmp134_ - self->priv->d_hidden_ids_length1)) : NULL;
				self->priv->d_hidden_ids_length1 = _tmp134_;
				self->priv->_d_hidden_ids_size_ = _tmp134_;
				self->priv->d_hidden_ids_length1 = l;
			}
			_tmp135_ = self->priv->d_hidden_ids;
			_tmp135__length1 = self->priv->d_hidden_ids_length1;
			_tmp136_ = self->priv->d_hidden_ids_length1;
			self->priv->d_hidden_ids_length1 = _tmp136_ + 1;
			_tmp137_ = commit;
			_tmp138_ = _g_object_ref0 (_tmp137_);
			_g_object_unref0 (_tmp135_[_tmp136_]);
			_tmp135_[_tmp136_] = _tmp138_;
		}
		_tmp139_ = timer;
		if (g_timer_elapsed (_tmp139_, NULL) >= _data4_->wait_elapsed) {
			GTimer* _tmp140_;
			gitg_commit_model_notify_batch (self, NULL, NULL, NULL);
			_tmp140_ = timer;
			g_timer_start (_tmp140_);
			_data4_->wait_elapsed = _data4_->wait_elapsed_incremental;
		}
		if (_data4_->limit > ((guint) 0)) {
			GitgCommit** _tmp142_;
			gint _tmp142__length1;
			_tmp142_ = self->priv->d_ids;
			_tmp142__length1 = self->priv->d_ids_length1;
			_tmp141_ = ((guint) _tmp142__length1) == _data4_->limit;
		} else {
			_tmp141_ = FALSE;
		}
		if (_tmp141_) {
			(lanes == NULL) ? NULL : (lanes = (_g_slist_free__g_object_unref0_ (lanes), NULL));
			_g_object_unref0 (commit);
			__vala_GgitOId_free0 (id);
			break;
		}
		(lanes == NULL) ? NULL : (lanes = (_g_slist_free__g_object_unref0_ (lanes), NULL));
		_g_object_unref0 (commit);
		__vala_GgitOId_free0 (id);
	}
	_tmp143_ = _data4_->cb;
	_tmp143__target = _data4_->cb_target;
	_tmp143__target_destroy_notify = _data4_->cb_target_destroy_notify;
	_data4_->cb = NULL;
	_data4_->cb_target = NULL;
	_data4_->cb_target_destroy_notify = NULL;
	gitg_commit_model_notify_batch (self, _tmp143_, _tmp143__target, _tmp143__target_destroy_notify);
	result = NULL;
	_g_timer_destroy0 (timer);
	permanent = (_vala_array_free (permanent, permanent_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
	_g_object_unref0 (incset);
	return result;
}

static gpointer
___lambda35__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda35_ (self);
	block4_data_unref (self);
	return result;
}

static gboolean
gitg_commit_model_walk_co (GitgCommitModelWalkData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data4_->cancellable);
	_data_->_data4_->cancellable = _data_->cancellable;
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->d_include;
	_data_->_tmp0__length1 = _data_->self->priv->d_include_length1;
	_data_->_tmp1_ = (_data_->_tmp0_ != NULL) ? _vala_array_dup6 (_data_->_tmp0_, _data_->_tmp0__length1) : _data_->_tmp0_;
	_data_->_tmp1__length1 = _data_->_tmp0__length1;
	_data_->_data4_->included = _data_->_tmp1_;
	_data_->_data4_->included_length1 = _data_->_tmp1__length1;
	_data_->_data4_->_included_size_ = _data_->_data4_->included_length1;
	_data_->_tmp2_ = _data_->self->priv->d_exclude;
	_data_->_tmp2__length1 = _data_->self->priv->d_exclude_length1;
	_data_->_tmp3_ = (_data_->_tmp2_ != NULL) ? _vala_array_dup7 (_data_->_tmp2_, _data_->_tmp2__length1) : _data_->_tmp2_;
	_data_->_tmp3__length1 = _data_->_tmp2__length1;
	_data_->_data4_->excluded = _data_->_tmp3_;
	_data_->_data4_->excluded_length1 = _data_->_tmp3__length1;
	_data_->_data4_->_excluded_size_ = _data_->_data4_->excluded_length1;
	_data_->_tmp4_ = _data_->self->priv->_limit;
	_data_->_data4_->limit = _data_->_tmp4_;
	_data_->_data4_->cb = _gitg_commit_model_walk_co_gsource_func;
	_data_->_data4_->cb_target = _data_;
	_data_->_data4_->cb_target_destroy_notify = NULL;
	_data_->wait_elapsed_initial = 1.0;
	_data_->_data4_->wait_elapsed_incremental = 0.2;
	_data_->_data4_->wait_elapsed = _data_->wait_elapsed_initial;
	_data_->_tmp5_ = 0;
	_data_->_tmp6_ = gitg_commit_model_get_permanent_lanes (_data_->self, &_data_->_tmp5_);
	_data_->_data4_->permlanes = _data_->_tmp6_;
	_data_->_data4_->permlanes_length1 = _data_->_tmp5_;
	_data_->_data4_->_permlanes_size_ = _data_->_data4_->permlanes_length1;
	_data_->run = ___lambda35__gthread_func;
	_data_->run_target = block4_data_ref (_data_->_data4_);
	{
		_data_->_tmp8_ = _data_->run;
		_data_->_tmp8__target = _data_->run_target;
		_data_->run = NULL;
		_data_->run_target = NULL;
		_data_->_tmp9_ = g_thread_try_new ("gitg-history-walk", _data_->_tmp8_, _data_->_tmp8__target, &_data_->_inner_error0_);
		_data_->_tmp7_ = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp10_ = _data_->_tmp7_;
		_data_->_tmp7_ = NULL;
		_g_thread_unref0 (_data_->self->priv->d_thread);
		_data_->self->priv->d_thread = _data_->_tmp10_;
		_g_thread_unref0 (_data_->_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_g_thread_unref0 (_data_->self->priv->d_thread);
		_data_->self->priv->d_thread = NULL;
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
gitg_commit_model_clear (GitgCommitModel* self)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_signal_emit (self, gitg_commit_model_signals[GITG_COMMIT_MODEL_BEGIN_CLEAR_SIGNAL], 0);
	_tmp0_ = gtk_tree_path_new_from_indices (self->priv->d_size, -1);
	path = _tmp0_;
	while (TRUE) {
		GtkTreePath* _tmp1_;
		guint _tmp2_;
		GtkTreePath* _tmp3_;
		GtkTreePath* _tmp4_;
		GtkTreePath* _tmp5_;
		if (!(self->priv->d_size > ((guint) 0))) {
			break;
		}
		_tmp1_ = path;
		gtk_tree_path_prev (_tmp1_);
		self->priv->d_size = self->priv->d_size - 1;
		_tmp2_ = self->priv->d_size;
		_tmp3_ = path;
		_tmp4_ = gtk_tree_path_copy (_tmp3_);
		_tmp5_ = _tmp4_;
		gtk_tree_model_row_deleted ((GtkTreeModel*) self, _tmp5_);
		__vala_GtkTreePath_free0 (_tmp5_);
	}
	self->priv->d_stamp = self->priv->d_stamp + 1;
	_tmp6_ = self->priv->d_stamp;
	g_signal_emit (self, gitg_commit_model_signals[GITG_COMMIT_MODEL_END_CLEAR_SIGNAL], 0);
	__vala_GtkTreePath_free0 (path);
}

static void
gitg_commit_model_emit_update (GitgCommitModel* self,
                               guint added)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_path_new_from_indices (self->priv->d_size, -1);
	path = _tmp0_;
	memset (&iter, 0, sizeof (GtkTreeIter));
	iter.stamp = self->priv->d_stamp;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint _tmp3_;
				GtkTreePath* _tmp4_;
				GtkTreePath* _tmp5_;
				GtkTreePath* _tmp6_;
				GtkTreeIter _tmp7_;
				GtkTreePath* _tmp8_;
				if (!_tmp1_) {
					guint _tmp2_;
					i = i + 1;
					_tmp2_ = i;
				}
				_tmp1_ = FALSE;
				if (!(i < added)) {
					break;
				}
				iter.user_data = (void*) ((gulong) self->priv->d_size);
				self->priv->d_size = self->priv->d_size + 1;
				_tmp3_ = self->priv->d_size;
				_tmp4_ = path;
				_tmp5_ = gtk_tree_path_copy (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = iter;
				gtk_tree_model_row_inserted ((GtkTreeModel*) self, _tmp6_, &_tmp7_);
				__vala_GtkTreePath_free0 (_tmp6_);
				_tmp8_ = path;
				gtk_tree_path_next (_tmp8_);
			}
		}
	}
	g_signal_emit (self, gitg_commit_model_signals[GITG_COMMIT_MODEL_UPDATE_SIGNAL], 0, added);
	__vala_GtkTreePath_free0 (path);
}

static GType
gitg_commit_model_real_get_column_type (GtkTreeModel* base,
                                        gint index)
{
	GitgCommitModel * self;
	GType result;
	self = (GitgCommitModel*) base;
	result = gitg_commit_model_columns_type ((GitgCommitModelColumns) index);
	return result;
}

static GtkTreeModelFlags
gitg_commit_model_real_get_flags (GtkTreeModel* base)
{
	GitgCommitModel * self;
	GtkTreeModelFlags result;
	self = (GitgCommitModel*) base;
	result = GTK_TREE_MODEL_LIST_ONLY | GTK_TREE_MODEL_ITERS_PERSIST;
	return result;
}

static gint*
_vala_array_dup8 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gboolean
gitg_commit_model_real_get_iter (GtkTreeModel* base,
                                 GtkTreeIter* iter,
                                 GtkTreePath* path)
{
	GitgCommitModel * self;
	GtkTreeIter _vala_iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gint* indices = NULL;
	gint _tmp1_ = 0;
	gint* _tmp2_;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint indices_length1;
	gint _indices_size_;
	gint* _tmp4_;
	gint _tmp4__length1;
	guint index = 0U;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	gboolean result;
	self = (GitgCommitModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	_vala_iter = _tmp0_;
	_tmp2_ = gtk_tree_path_get_indices_with_depth (path, &_tmp1_);
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup8 (_tmp2_, _tmp1_) : _tmp2_;
	_tmp3__length1 = _tmp1_;
	indices = _tmp3_;
	indices_length1 = _tmp3__length1;
	_indices_size_ = indices_length1;
	_tmp4_ = indices;
	_tmp4__length1 = indices_length1;
	if (_tmp4__length1 != 1) {
		result = FALSE;
		indices = (g_free (indices), NULL);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp5_ = indices;
	_tmp5__length1 = indices_length1;
	_tmp6_ = _tmp5_[0];
	index = (guint) _tmp6_;
	if (index >= self->priv->d_size) {
		result = FALSE;
		indices = (g_free (indices), NULL);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_vala_iter.user_data = (void*) ((gulong) index);
	_vala_iter.stamp = self->priv->d_stamp;
	result = TRUE;
	indices = (g_free (indices), NULL);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gint
gitg_commit_model_real_get_n_columns (GtkTreeModel* base)
{
	GitgCommitModel * self;
	gint result;
	self = (GitgCommitModel*) base;
	result = (gint) GITG_COMMIT_MODEL_COLUMNS_NUM;
	return result;
}

static GtkTreePath*
gitg_commit_model_real_get_path (GtkTreeModel* base,
                                 GtkTreeIter* iter)
{
	GitgCommitModel * self;
	guint id = 0U;
	GtkTreeIter _tmp0_;
	void* _tmp1_;
	GtkTreeIter _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreePath* result;
	self = (GitgCommitModel*) base;
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	_tmp1_ = _tmp0_.user_data;
	id = (guint) ((gulong) _tmp1_);
	_tmp2_ = *iter;
	g_return_val_if_fail (_tmp2_.stamp == self->priv->d_stamp, NULL);
	_tmp3_ = gtk_tree_path_new_from_indices ((gint) id, -1);
	result = _tmp3_;
	return result;
}

static void
gitg_commit_model_real_get_value (GtkTreeModel* base,
                                  GtkTreeIter* iter,
                                  gint column,
                                  GValue* val)
{
	GitgCommitModel * self;
	GValue _vala_val = {0};
	GValue _tmp0_ = {0};
	GtkTreeIter _tmp1_;
	guint idx = 0U;
	GtkTreeIter _tmp2_;
	void* _tmp3_;
	GitgCommit* commit = NULL;
	GitgCommit* _tmp4_;
	GitgCommit* _tmp5_;
	self = (GitgCommitModel*) base;
	g_return_if_fail (iter != NULL);
	G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
	_vala_val = _tmp0_;
	_tmp1_ = *iter;
	g_return_if_fail (_tmp1_.stamp == self->priv->d_stamp);
	_tmp2_ = *iter;
	_tmp3_ = _tmp2_.user_data;
	idx = (guint) ((gulong) _tmp3_);
	_tmp4_ = gitg_commit_model_get (self, idx);
	commit = _tmp4_;
	g_value_init (&_vala_val, gtk_tree_model_get_column_type ((GtkTreeModel*) self, column));
	_tmp5_ = commit;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (commit);
		if (val) {
			*val = _vala_val;
		} else {
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
		}
		return;
	}
	switch (column) {
		case GITG_COMMIT_MODEL_COLUMNS_SHA1:
		{
			GitgCommit* _tmp6_;
			GgitOId* _tmp7_;
			GgitOId* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp6_ = commit;
			_tmp7_ = ggit_object_get_id ((GgitObject*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = ggit_oid_to_string (_tmp8_);
			_tmp10_ = _tmp9_;
			g_value_set_string (&_vala_val, _tmp10_);
			_g_free0 (_tmp10_);
			__vala_GgitOId_free0 (_tmp8_);
			break;
		}
		case GITG_COMMIT_MODEL_COLUMNS_SUBJECT:
		{
			GitgCommit* _tmp11_;
			const gchar* _tmp12_;
			_tmp11_ = commit;
			_tmp12_ = ggit_commit_get_subject ((GgitCommit*) _tmp11_);
			g_value_set_string (&_vala_val, _tmp12_);
			break;
		}
		case GITG_COMMIT_MODEL_COLUMNS_MESSAGE:
		{
			GitgCommit* _tmp13_;
			const gchar* _tmp14_;
			_tmp13_ = commit;
			_tmp14_ = ggit_commit_get_message ((GgitCommit*) _tmp13_);
			g_value_set_string (&_vala_val, _tmp14_);
			break;
		}
		case GITG_COMMIT_MODEL_COLUMNS_COMMITTER:
		{
			GitgCommit* _tmp15_;
			GgitSignature* _tmp16_;
			GgitSignature* _tmp17_;
			const gchar* _tmp18_;
			GitgCommit* _tmp19_;
			GgitSignature* _tmp20_;
			GgitSignature* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp15_ = commit;
			_tmp16_ = ggit_commit_get_committer ((GgitCommit*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = ggit_signature_get_name (_tmp17_);
			_tmp19_ = commit;
			_tmp20_ = ggit_commit_get_committer ((GgitCommit*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = ggit_signature_get_email (_tmp21_);
			_tmp23_ = g_strdup_printf ("%s <%s>", _tmp18_, _tmp22_);
			_tmp24_ = _tmp23_;
			g_value_set_string (&_vala_val, _tmp24_);
			_g_free0 (_tmp24_);
			_g_object_unref0 (_tmp21_);
			_g_object_unref0 (_tmp17_);
			break;
		}
		case GITG_COMMIT_MODEL_COLUMNS_COMMITTER_NAME:
		{
			GitgCommit* _tmp25_;
			GgitSignature* _tmp26_;
			GgitSignature* _tmp27_;
			const gchar* _tmp28_;
			_tmp25_ = commit;
			_tmp26_ = ggit_commit_get_committer ((GgitCommit*) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = ggit_signature_get_name (_tmp27_);
			g_value_set_string (&_vala_val, _tmp28_);
			_g_object_unref0 (_tmp27_);
			break;
		}
		case GITG_COMMIT_MODEL_COLUMNS_COMMITTER_EMAIL:
		{
			GitgCommit* _tmp29_;
			GgitSignature* _tmp30_;
			GgitSignature* _tmp31_;
			const gchar* _tmp32_;
			_tmp29_ = commit;
			_tmp30_ = ggit_commit_get_committer ((GgitCommit*) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = ggit_signature_get_email (_tmp31_);
			g_value_set_string (&_vala_val, _tmp32_);
			_g_object_unref0 (_tmp31_);
			break;
		}
		case GITG_COMMIT_MODEL_COLUMNS_COMMITTER_DATE:
		{
			GitgCommit* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp33_ = commit;
			_tmp34_ = gitg_commit_get_committer_date_for_display (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = _tmp35_;
			g_value_set_string (&_vala_val, _tmp36_);
			_g_free0 (_tmp36_);
			break;
		}
		case GITG_COMMIT_MODEL_COLUMNS_AUTHOR:
		{
			GitgCommit* _tmp37_;
			GgitSignature* _tmp38_;
			GgitSignature* _tmp39_;
			const gchar* _tmp40_;
			GitgCommit* _tmp41_;
			GgitSignature* _tmp42_;
			GgitSignature* _tmp43_;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp37_ = commit;
			_tmp38_ = ggit_commit_get_author ((GgitCommit*) _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = ggit_signature_get_name (_tmp39_);
			_tmp41_ = commit;
			_tmp42_ = ggit_commit_get_author ((GgitCommit*) _tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = ggit_signature_get_email (_tmp43_);
			_tmp45_ = g_strdup_printf ("%s <%s>", _tmp40_, _tmp44_);
			_tmp46_ = _tmp45_;
			g_value_set_string (&_vala_val, _tmp46_);
			_g_free0 (_tmp46_);
			_g_object_unref0 (_tmp43_);
			_g_object_unref0 (_tmp39_);
			break;
		}
		case GITG_COMMIT_MODEL_COLUMNS_AUTHOR_NAME:
		{
			GitgCommit* _tmp47_;
			GgitSignature* _tmp48_;
			GgitSignature* _tmp49_;
			const gchar* _tmp50_;
			_tmp47_ = commit;
			_tmp48_ = ggit_commit_get_author ((GgitCommit*) _tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = ggit_signature_get_name (_tmp49_);
			g_value_set_string (&_vala_val, _tmp50_);
			_g_object_unref0 (_tmp49_);
			break;
		}
		case GITG_COMMIT_MODEL_COLUMNS_AUTHOR_EMAIL:
		{
			GitgCommit* _tmp51_;
			GgitSignature* _tmp52_;
			GgitSignature* _tmp53_;
			const gchar* _tmp54_;
			_tmp51_ = commit;
			_tmp52_ = ggit_commit_get_author ((GgitCommit*) _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = ggit_signature_get_email (_tmp53_);
			g_value_set_string (&_vala_val, _tmp54_);
			_g_object_unref0 (_tmp53_);
			break;
		}
		case GITG_COMMIT_MODEL_COLUMNS_AUTHOR_DATE:
		{
			GitgCommit* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp55_ = commit;
			_tmp56_ = gitg_commit_get_author_date_for_display (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = _tmp57_;
			g_value_set_string (&_vala_val, _tmp58_);
			_g_free0 (_tmp58_);
			break;
		}
		case GITG_COMMIT_MODEL_COLUMNS_COMMIT:
		{
			GitgCommit* _tmp59_;
			_tmp59_ = commit;
			g_value_set_object (&_vala_val, (GObject*) _tmp59_);
			break;
		}
		default:
		break;
	}
	_g_object_unref0 (commit);
	if (val) {
		*val = _vala_val;
	} else {
		G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
	}
}

GitgCommit*
gitg_commit_model_commit_from_iter (GitgCommitModel* self,
                                    GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	guint idx = 0U;
	GtkTreeIter _tmp1_;
	void* _tmp2_;
	GitgCommit* _tmp3_;
	GitgCommit* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	g_return_val_if_fail (_tmp0_.stamp == self->priv->d_stamp, NULL);
	_tmp1_ = *iter;
	_tmp2_ = _tmp1_.user_data;
	idx = (guint) ((gulong) _tmp2_);
	_tmp3_ = gitg_commit_model_get (self, idx);
	result = _tmp3_;
	return result;
}

GtkTreePath*
gitg_commit_model_path_from_commit (GitgCommitModel* self,
                                    GitgCommit* commit)
{
	GError* _inner_error0_ = NULL;
	GtkTreePath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (commit != NULL, NULL);
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->d_id_hash;
		g_rec_mutex_lock (&self->priv->__lock_d_id_hash);
		{
			GgitOId* id = NULL;
			GgitOId* _tmp1_;
			GeeHashMap* _tmp2_;
			GgitOId* _tmp3_;
			GeeHashMap* _tmp5_;
			GgitOId* _tmp6_;
			GgitOId* _tmp7_;
			gpointer _tmp8_;
			GtkTreePath* _tmp9_;
			GtkTreePath* _tmp10_;
			_tmp1_ = ggit_object_get_id ((GgitObject*) commit);
			id = _tmp1_;
			_tmp2_ = self->priv->d_id_hash;
			_tmp3_ = id;
			if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_)) {
				result = NULL;
				__vala_GgitOId_free0 (id);
				{
					GeeHashMap* _tmp4_;
					_tmp4_ = self->priv->d_id_hash;
					g_rec_mutex_unlock (&self->priv->__lock_d_id_hash);
				}
				return result;
			}
			_tmp5_ = self->priv->d_id_hash;
			_tmp6_ = ggit_object_get_id ((GgitObject*) commit);
			_tmp7_ = _tmp6_;
			_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp7_);
			_tmp9_ = gtk_tree_path_new_from_indices ((gint) ((gintptr) _tmp8_), -1);
			_tmp10_ = _tmp9_;
			__vala_GgitOId_free0 (_tmp7_);
			result = _tmp10_;
			__vala_GgitOId_free0 (id);
			{
				GeeHashMap* _tmp11_;
				_tmp11_ = self->priv->d_id_hash;
				g_rec_mutex_unlock (&self->priv->__lock_d_id_hash);
			}
			return result;
		}
		__finally0:
		{
			GeeHashMap* _tmp12_;
			_tmp12_ = self->priv->d_id_hash;
			g_rec_mutex_unlock (&self->priv->__lock_d_id_hash);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gint*
_vala_array_dup9 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

GitgCommit*
gitg_commit_model_commit_from_path (GitgCommitModel* self,
                                    GtkTreePath* path)
{
	gint* indices = NULL;
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint indices_length1;
	gint _indices_size_;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	GitgCommit* _tmp6_;
	GitgCommit* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp1_ = gtk_tree_path_get_indices_with_depth (path, &_tmp0_);
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup9 (_tmp1_, _tmp0_) : _tmp1_;
	_tmp2__length1 = _tmp0_;
	indices = _tmp2_;
	indices_length1 = _tmp2__length1;
	_indices_size_ = indices_length1;
	_tmp3_ = indices;
	_tmp3__length1 = indices_length1;
	if (_tmp3__length1 != 1) {
		result = NULL;
		indices = (g_free (indices), NULL);
		return result;
	}
	_tmp4_ = indices;
	_tmp4__length1 = indices_length1;
	_tmp5_ = _tmp4_[0];
	_tmp6_ = gitg_commit_model_get (self, (guint) _tmp5_);
	result = _tmp6_;
	indices = (g_free (indices), NULL);
	return result;
}

static gboolean
gitg_commit_model_real_iter_children (GtkTreeModel* base,
                                      GtkTreeIter* iter,
                                      GtkTreeIter* parent)
{
	GitgCommitModel * self;
	GtkTreeIter _vala_iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean result;
	self = (GitgCommitModel*) base;
	_vala_iter = _tmp0_;
	if (parent == NULL) {
		_vala_iter.user_data = (void*) ((gulong) 0);
		_vala_iter.stamp = self->priv->d_stamp;
		result = TRUE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	} else {
		g_return_val_if_fail ((*parent).stamp == self->priv->d_stamp, FALSE);
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
}

static gboolean
gitg_commit_model_real_iter_has_child (GtkTreeModel* base,
                                       GtkTreeIter* iter)
{
	GitgCommitModel * self;
	gboolean result;
	self = (GitgCommitModel*) base;
	g_return_val_if_fail (iter != NULL, FALSE);
	result = FALSE;
	return result;
}

static gint
gitg_commit_model_real_iter_n_children (GtkTreeModel* base,
                                        GtkTreeIter* iter)
{
	GitgCommitModel * self;
	gint result;
	self = (GitgCommitModel*) base;
	if (iter == NULL) {
		result = (gint) self->priv->d_size;
		return result;
	} else {
		g_return_val_if_fail ((*iter).stamp == self->priv->d_stamp, 0);
		result = 0;
		return result;
	}
}

static gboolean
gitg_commit_model_real_iter_next (GtkTreeModel* base,
                                  GtkTreeIter* iter)
{
	GitgCommitModel * self;
	GtkTreeIter _tmp0_;
	guint index = 0U;
	GtkTreeIter _tmp1_;
	void* _tmp2_;
	guint _tmp3_;
	gboolean result;
	self = (GitgCommitModel*) base;
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	g_return_val_if_fail (_tmp0_.stamp == self->priv->d_stamp, FALSE);
	_tmp1_ = *iter;
	_tmp2_ = _tmp1_.user_data;
	index = (guint) ((gulong) _tmp2_);
	index = index + 1;
	_tmp3_ = index;
	if (index >= self->priv->d_size) {
		result = FALSE;
		return result;
	} else {
		(*iter).user_data = (void*) ((gulong) index);
		result = TRUE;
		return result;
	}
}

static gboolean
gitg_commit_model_real_iter_nth_child (GtkTreeModel* base,
                                       GtkTreeIter* iter,
                                       GtkTreeIter* parent,
                                       gint n)
{
	GitgCommitModel * self;
	GtkTreeIter _vala_iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gboolean result;
	self = (GitgCommitModel*) base;
	_vala_iter = _tmp0_;
	if (parent != NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = ((guint) n) >= self->priv->d_size;
	}
	if (_tmp1_) {
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_vala_iter.user_data = (void*) ((gulong) n);
	_vala_iter.stamp = self->priv->d_stamp;
	result = TRUE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gboolean
gitg_commit_model_real_iter_parent (GtkTreeModel* base,
                                    GtkTreeIter* parent,
                                    GtkTreeIter* iter)
{
	GitgCommitModel * self;
	GtkTreeIter _vala_parent = {0};
	GtkTreeIter _tmp0_ = {0};
	GtkTreeIter _tmp1_;
	gboolean result;
	self = (GitgCommitModel*) base;
	g_return_val_if_fail (iter != NULL, FALSE);
	_vala_parent = _tmp0_;
	_tmp1_ = *iter;
	g_return_val_if_fail (_tmp1_.stamp == self->priv->d_stamp, FALSE);
	result = FALSE;
	if (parent) {
		*parent = _vala_parent;
	}
	return result;
}

guint
gitg_commit_model_get_limit (GitgCommitModel* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_limit;
	return result;
}

void
gitg_commit_model_set_limit (GitgCommitModel* self,
                             guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_commit_model_get_limit (self);
	if (old_value != value) {
		self->priv->_limit = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_commit_model_properties[GITG_COMMIT_MODEL_LIMIT_PROPERTY]);
	}
}

GgitSortMode
gitg_commit_model_get_sort_mode (GitgCommitModel* self)
{
	GgitSortMode result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->d_sortmode;
	return result;
}

void
gitg_commit_model_set_sort_mode (GitgCommitModel* self,
                                 GgitSortMode value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->d_sortmode != value) {
		self->priv->d_sortmode = value;
		gitg_commit_model_reload (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_model_properties[GITG_COMMIT_MODEL_SORT_MODE_PROPERTY]);
}

GitgRepository*
gitg_commit_model_get_repository (GitgCommitModel* self)
{
	GitgRepository* result;
	GitgRepository* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_repository;
	result = _tmp0_;
	return result;
}

void
gitg_commit_model_set_repository (GitgCommitModel* self,
                                  GitgRepository* value)
{
	GitgRepository* _tmp0_;
	GitgRepository* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_repository;
	if (_tmp0_ == value) {
		return;
	}
	gitg_commit_model_cancel (self);
	_g_object_unref0 (self->priv->d_walker);
	self->priv->d_walker = NULL;
	_tmp1_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->d_repository);
	self->priv->d_repository = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, gitg_commit_model_properties[GITG_COMMIT_MODEL_REPOSITORY_PROPERTY]);
}

static GObject *
gitg_commit_model_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgCommitModel * self;
	GitgLanes* _tmp0_;
	parent_class = G_OBJECT_CLASS (gitg_commit_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_COMMIT_MODEL, GitgCommitModel);
	_tmp0_ = gitg_lanes_new ();
	_g_object_unref0 (self->priv->d_lanes);
	self->priv->d_lanes = _tmp0_;
	self->priv->d_sortmode = GGIT_SORT_TOPOLOGICAL | GGIT_SORT_TIME;
	return obj;
}

static void
gitg_commit_model_class_init (GitgCommitModelClass * klass,
                              gpointer klass_data)
{
	gitg_commit_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgCommitModel_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gitg_commit_model_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_commit_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_commit_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_commit_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_commit_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_MODEL_LIMIT_PROPERTY, gitg_commit_model_properties[GITG_COMMIT_MODEL_LIMIT_PROPERTY] = g_param_spec_uint ("limit", "limit", "limit", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_MODEL_SORT_MODE_PROPERTY, gitg_commit_model_properties[GITG_COMMIT_MODEL_SORT_MODE_PROPERTY] = g_param_spec_flags ("sort-mode", "sort-mode", "sort-mode", ggit_sort_mode_get_type (), 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_MODEL_REPOSITORY_PROPERTY, gitg_commit_model_properties[GITG_COMMIT_MODEL_REPOSITORY_PROPERTY] = g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gitg_commit_model_signals[GITG_COMMIT_MODEL_STARTED_SIGNAL] = g_signal_new ("started", GITG_TYPE_COMMIT_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gitg_commit_model_signals[GITG_COMMIT_MODEL_UPDATE_SIGNAL] = g_signal_new ("update", GITG_TYPE_COMMIT_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	gitg_commit_model_signals[GITG_COMMIT_MODEL_FINISHED_SIGNAL] = g_signal_new ("finished", GITG_TYPE_COMMIT_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gitg_commit_model_signals[GITG_COMMIT_MODEL_BEGIN_CLEAR_SIGNAL] = g_signal_new ("begin-clear", GITG_TYPE_COMMIT_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gitg_commit_model_signals[GITG_COMMIT_MODEL_END_CLEAR_SIGNAL] = g_signal_new ("end-clear", GITG_TYPE_COMMIT_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gitg_commit_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface,
                                                 gpointer iface_data)
{
	gitg_commit_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_column_type = (GType (*) (GtkTreeModel*, gint)) gitg_commit_model_real_get_column_type;
	iface->get_flags = (GtkTreeModelFlags (*) (GtkTreeModel*)) gitg_commit_model_real_get_flags;
	iface->get_iter = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreePath*)) gitg_commit_model_real_get_iter;
	iface->get_n_columns = (gint (*) (GtkTreeModel*)) gitg_commit_model_real_get_n_columns;
	iface->get_path = (GtkTreePath* (*) (GtkTreeModel*, GtkTreeIter*)) gitg_commit_model_real_get_path;
	iface->get_value = (void (*) (GtkTreeModel*, GtkTreeIter*, gint, GValue*)) gitg_commit_model_real_get_value;
	iface->iter_children = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) gitg_commit_model_real_iter_children;
	iface->iter_has_child = (gboolean (*) (GtkTreeModel*, GtkTreeIter*)) gitg_commit_model_real_iter_has_child;
	iface->iter_n_children = (gint (*) (GtkTreeModel*, GtkTreeIter*)) gitg_commit_model_real_iter_n_children;
	iface->iter_next = (gboolean (*) (GtkTreeModel*, GtkTreeIter*)) gitg_commit_model_real_iter_next;
	iface->iter_nth_child = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*, gint)) gitg_commit_model_real_iter_nth_child;
	iface->iter_parent = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) gitg_commit_model_real_iter_parent;
}

static void
gitg_commit_model_instance_init (GitgCommitModel * self,
                                 gpointer klass)
{
	self->priv = gitg_commit_model_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_d_ids);
	g_rec_mutex_init (&self->priv->__lock_d_idleid);
	g_rec_mutex_init (&self->priv->__lock_d_id_hash);
}

static void
gitg_commit_model_finalize (GObject * obj)
{
	GitgCommitModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_COMMIT_MODEL, GitgCommitModel);
	_g_object_unref0 (self->priv->d_repository);
	_g_object_unref0 (self->priv->d_cancellable);
	g_rec_mutex_clear (&self->priv->__lock_d_ids);
	self->priv->d_ids = (_vala_array_free (self->priv->d_ids, self->priv->d_ids_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_hidden_ids = (_vala_array_free (self->priv->d_hidden_ids, self->priv->d_hidden_ids_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_thread_unref0 (self->priv->d_thread);
	_g_object_unref0 (self->priv->d_walker);
	g_rec_mutex_clear (&self->priv->__lock_d_idleid);
	_g_object_unref0 (self->priv->d_lanes);
	g_rec_mutex_clear (&self->priv->__lock_d_id_hash);
	_g_object_unref0 (self->priv->d_id_hash);
	self->priv->d_include = (_vala_array_free (self->priv->d_include, self->priv->d_include_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
	self->priv->d_exclude = (_vala_array_free (self->priv->d_exclude, self->priv->d_exclude_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
	self->priv->_permanent_lanes = (_vala_array_free (self->priv->_permanent_lanes, self->priv->_permanent_lanes_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
	G_OBJECT_CLASS (gitg_commit_model_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_commit_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgCommitModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_commit_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCommitModel), 0, (GInstanceInitFunc) gitg_commit_model_instance_init, NULL };
	static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) gitg_commit_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_commit_model_type_id;
	gitg_commit_model_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgCommitModel", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_commit_model_type_id, gtk_tree_model_get_type (), &gtk_tree_model_info);
	GitgCommitModel_private_offset = g_type_add_instance_private (gitg_commit_model_type_id, sizeof (GitgCommitModelPrivate));
	return gitg_commit_model_type_id;
}

GType
gitg_commit_model_get_type (void)
{
	static gsize gitg_commit_model_type_id__once = 0;
	if (g_once_init_enter (&gitg_commit_model_type_id__once)) {
		GType gitg_commit_model_type_id;
		gitg_commit_model_type_id = gitg_commit_model_get_type_once ();
		g_once_init_leave (&gitg_commit_model_type_id__once, gitg_commit_model_type_id);
	}
	return gitg_commit_model_type_id__once;
}

static void
_vala_gitg_commit_model_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GitgCommitModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_COMMIT_MODEL, GitgCommitModel);
	switch (property_id) {
		case GITG_COMMIT_MODEL_LIMIT_PROPERTY:
		g_value_set_uint (value, gitg_commit_model_get_limit (self));
		break;
		case GITG_COMMIT_MODEL_SORT_MODE_PROPERTY:
		g_value_set_flags (value, gitg_commit_model_get_sort_mode (self));
		break;
		case GITG_COMMIT_MODEL_REPOSITORY_PROPERTY:
		g_value_set_object (value, gitg_commit_model_get_repository (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_commit_model_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GitgCommitModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_COMMIT_MODEL, GitgCommitModel);
	switch (property_id) {
		case GITG_COMMIT_MODEL_LIMIT_PROPERTY:
		gitg_commit_model_set_limit (self, g_value_get_uint (value));
		break;
		case GITG_COMMIT_MODEL_SORT_MODE_PROPERTY:
		gitg_commit_model_set_sort_mode (self, g_value_get_flags (value));
		break;
		case GITG_COMMIT_MODEL_REPOSITORY_PROPERTY:
		gitg_commit_model_set_repository (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

